/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import ij.ImagePlus;
import java.util.Arrays;
import java.util.Stack;

class TurboRegMask
implements Runnable {
    private final Stack<float[]> pyramid = new Stack();
    private Thread t = new Thread(this);
    private float[] mask;
    private int width;
    private int height;
    private int pyramidDepth;

    @Override
    public void run() {
        this.buildPyramid();
    }

    public TurboRegMask(ImagePlus imp) {
        this.t.setDaemon(true);
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        int k = 0;
        this.mask = new float[this.width * this.height];
        switch (imp.getType()) {
            case 0: {
                byte[] pixels = (byte[])imp.getProcessor().getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = pixels[k];
                        ++x;
                        ++k;
                    }
                }
                break;
            }
            case 1: {
                short[] pixels = (short[])imp.getProcessor().getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = pixels[k];
                        ++x;
                        ++k;
                    }
                }
                break;
            }
            case 2: {
                float[] pixels = (float[])imp.getProcessor().getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.mask[k] = pixels[k];
                        ++x;
                        ++k;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void clearMask() {
        Arrays.fill(this.mask, 1.0f);
    }

    public float[] getMask() {
        return this.mask;
    }

    public Stack<float[]> getPyramid() {
        return this.pyramid;
    }

    public Thread getThread() {
        return this.t;
    }

    public void setPyramidDepth(int pyramidDepth) {
        this.pyramidDepth = pyramidDepth;
    }

    private void buildPyramid() {
        float[] fullMask = this.mask;
        int halfWidth = this.width;
        int halfHeight = this.height;
        for (int depth = 1; depth < this.pyramidDepth && !this.t.isInterrupted(); ++depth) {
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            halfWidth >>= 1;
            halfHeight >>= 1;
            float[] halfMask = this.getHalfMask2D(fullMask, fullWidth, fullHeight);
            this.pyramid.push(halfMask);
            fullMask = halfMask;
        }
    }

    private float[] getHalfMask2D(float[] fullMask, int fullWidth, int fullHeight) {
        int x;
        int halfWidth = fullWidth >> 1;
        int halfHeight = fullHeight >> 1;
        boolean oddWidth = halfWidth << 1 != fullWidth;
        float[] halfMask = new float[halfWidth * halfHeight];
        int hwm1 = halfWidth - 1;
        int hhm1 = halfHeight - 1;
        int k = 0;
        for (int y = 0; y < halfHeight; ++y) {
            for (x = 0; x < halfWidth; ++x) {
                halfMask[k++] = 0.0f;
            }
        }
        k = 0;
        int n = 0;
        for (int y = 0; y < hhm1; ++y) {
            int x2;
            for (x2 = 0; x2 < hwm1; ++x2) {
                int n2 = k;
                halfMask[n2] = halfMask[n2] + Math.abs(fullMask[n++]);
                int n3 = k++;
                halfMask[n3] = halfMask[n3] + Math.abs(fullMask[n]);
                int n4 = k;
                halfMask[n4] = halfMask[n4] + Math.abs(fullMask[n++]);
            }
            int n5 = k;
            halfMask[n5] = halfMask[n5] + Math.abs(fullMask[n++]);
            int n6 = k++;
            halfMask[n6] = halfMask[n6] + Math.abs(fullMask[n++]);
            if (oddWidth) {
                ++n;
            }
            for (x2 = 0; x2 < hwm1; ++x2) {
                int n7 = k - halfWidth;
                halfMask[n7] = halfMask[n7] + Math.abs(fullMask[n]);
                int n8 = k;
                halfMask[n8] = halfMask[n8] + Math.abs(fullMask[n++]);
                int n9 = k - halfWidth;
                halfMask[n9] = halfMask[n9] + Math.abs(fullMask[n]);
                int n10 = k - halfWidth + 1;
                halfMask[n10] = halfMask[n10] + Math.abs(fullMask[n]);
                int n11 = k++;
                halfMask[n11] = halfMask[n11] + Math.abs(fullMask[n]);
                int n12 = k;
                halfMask[n12] = halfMask[n12] + Math.abs(fullMask[n++]);
            }
            int n13 = k - halfWidth;
            halfMask[n13] = halfMask[n13] + Math.abs(fullMask[n]);
            int n14 = k;
            halfMask[n14] = halfMask[n14] + Math.abs(fullMask[n++]);
            int n15 = k - halfWidth;
            halfMask[n15] = halfMask[n15] + Math.abs(fullMask[n]);
            int n16 = k++;
            halfMask[n16] = halfMask[n16] + Math.abs(fullMask[n++]);
            if (oddWidth) {
                ++n;
            }
            k -= halfWidth;
        }
        for (x = 0; x < hwm1; ++x) {
            int n17 = k;
            halfMask[n17] = halfMask[n17] + Math.abs(fullMask[n++]);
            int n18 = k++;
            halfMask[n18] = halfMask[n18] + Math.abs(fullMask[n]);
            int n19 = k;
            halfMask[n19] = halfMask[n19] + Math.abs(fullMask[n++]);
        }
        int n20 = k;
        halfMask[n20] = halfMask[n20] + Math.abs(fullMask[n++]);
        int n21 = k++;
        halfMask[n21] = halfMask[n21] + Math.abs(fullMask[n++]);
        if (oddWidth) {
            ++n;
        }
        k -= halfWidth;
        for (x = 0; x < hwm1; ++x) {
            int n22 = k;
            halfMask[n22] = halfMask[n22] + Math.abs(fullMask[n++]);
            int n23 = k++;
            halfMask[n23] = halfMask[n23] + Math.abs(fullMask[n]);
            int n24 = k;
            halfMask[n24] = halfMask[n24] + Math.abs(fullMask[n++]);
        }
        int n25 = k;
        halfMask[n25] = halfMask[n25] + Math.abs(fullMask[n++]);
        int n26 = k;
        halfMask[n26] = halfMask[n26] + Math.abs(fullMask[n]);
        return halfMask;
    }
}

