/*
 * Decompiled with CFR 0.152.
 */
package registration.turboreg;

import arrayTiTi.ArrayArithmetic;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import java.util.Arrays;
import java.util.Stack;
import mathematics.Maths;
import registration.turboreg.TurboRegImage;
import registration.turboreg.TurboRegMask;

class TurboRegTransform {
    public static final int AFFINE = 6;
    public static final int GENERIC_TRANSFORMATION = -1;
    public static final int BILINEAR = 8;
    public static final int BLUE = 3;
    public static final int BLACK = 0;
    public static final int GREEN = 2;
    public static final int MIN_SIZE = 12;
    public static final int RED = 1;
    public static final int RIGID_BODY = 3;
    public static final int SCALED_ROTATION = 4;
    public static final int TRANSLATION = 2;
    private static final int FEW_ITERATIONS = 5;
    private static final double FIRST_LAMBDA = 1.0;
    private static final double LAMBDA_MAGSTEP = 4.0;
    private static final int MANY_ITERATIONS = 10;
    private static final double PIXEL_HIGH_PRECISION = 0.001;
    private static final double PIXEL_LOW_PRECISION = 0.1;
    private static final int ITERATION_PROGRESSION = 2;
    private final double TwoThird = 0.6666666666666666;
    private final double FourThird = 1.3333333333333333;
    private boolean accelerated;
    private double pixelPrecision;
    private double targetJacobian;
    private float[] inImg;
    private float[] inMsk;
    private float[] outImg;
    private float[] outMsk;
    private float[] xGradient;
    private float[] yGradient;
    private int inNx;
    private int inNy;
    private int iterationPower;
    private final int maxIterations;
    private int outNx;
    private int outNy;
    private int pyramidDepth;
    private int transformation;
    private int twiceInNx;
    private int twiceInNy;
    private TurboRegImage sourceImg;
    private TurboRegImage targetImg;
    private final TurboRegMask sourceMsk;
    private final TurboRegMask targetMsk;
    private final int nbCPU;
    private final int SizeCPU = 5;
    private int nbFreeAMSThreads = 0;
    private AffineMeanSquaresThread[] amsthreads = null;
    private int nbFreeAffineTransformThreads = 0;
    private AffineTransformThread[] afthreads = null;
    private int nbFreeAMS2Threads = 0;
    private AffineMeanSquares2Thread[] ams2threads = null;

    public TurboRegTransform(TurboRegImage sourceImg, TurboRegMask sourceMsk, TurboRegImage targetImg, TurboRegMask targetMsk, int transformation, boolean accelerated, int MaxThread) {
        this.sourceImg = sourceImg;
        this.sourceMsk = sourceMsk;
        this.targetImg = targetImg;
        this.targetMsk = targetMsk;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.nbCPU = Math.min(MaxThread, Runtime.getRuntime().availableProcessors());
        if (accelerated) {
            this.pixelPrecision = 0.1;
            this.maxIterations = 5;
        } else {
            this.pixelPrecision = 0.001;
            this.maxIterations = 10;
        }
    }

    public void Kill() {
        int i;
        if (this.amsthreads != null) {
            for (i = 0; i < this.amsthreads.length; ++i) {
                this.amsthreads[i].Kill();
                this.amsthreads[i] = null;
            }
        }
        this.amsthreads = null;
        if (this.ams2threads != null) {
            for (i = 0; i < this.ams2threads.length; ++i) {
                this.ams2threads[i].Kill();
                this.ams2threads[i] = null;
            }
        }
        this.ams2threads = null;
        if (this.afthreads != null) {
            for (i = 0; i < this.afthreads.length; ++i) {
                this.afthreads[i].Kill();
                this.afthreads[i] = null;
            }
        }
        this.afthreads = null;
        this.yGradient = null;
        this.xGradient = null;
        this.outMsk = null;
        this.outImg = null;
        this.inMsk = null;
        this.inImg = null;
    }

    public void doBatchFinalTransform(float[] pixels, double[][] sourcePoint, double[][] targetPoint) {
        this.inImg = this.accelerated ? this.sourceImg.getImage() : this.sourceImg.getCoefficient();
        this.inNx = this.sourceImg.getWidth();
        this.inNy = this.sourceImg.getHeight();
        this.twiceInNx = this.inNx << 1;
        this.twiceInNy = this.inNy << 1;
        this.outImg = pixels;
        this.outNx = this.targetImg.getWidth();
        this.outNy = this.targetImg.getHeight();
        double[][] matrix = this.getTransformationMatrix(targetPoint, sourcePoint);
        switch (this.transformation) {
            case 2: {
                this.translationTransform(matrix);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.affineTransform(matrix);
                break;
            }
            case 8: {
                this.bilinearTransform(matrix);
            }
        }
    }

    public ImagePlus doFinalTransform(int width, int height, double[][] sourcePoint, double[][] targetPoint) {
        return this.doFinalTransform(width, height, this.getTransformationMatrix(targetPoint, sourcePoint));
    }

    public ImagePlus doFinalTransform(int width, int height, double[][] matrix) {
        this.inImg = this.accelerated ? this.sourceImg.getImage() : this.sourceImg.getCoefficient();
        this.inMsk = this.sourceMsk.getMask();
        this.inNx = this.sourceImg.getWidth();
        this.inNy = this.sourceImg.getHeight();
        this.twiceInNx = this.inNx << 1;
        this.twiceInNy = this.inNy << 1;
        ImageStack is = new ImageStack(width, height);
        FloatProcessor dataFp = new FloatProcessor(width, height);
        is.addSlice("Data", dataFp);
        FloatProcessor maskFp = new FloatProcessor(width, height);
        is.addSlice("Mask", maskFp);
        ImagePlus imp = new ImagePlus("Output", is);
        imp.setSlice(1);
        this.outImg = (float[])dataFp.getPixels();
        imp.setSlice(2);
        float[] outMsk = (float[])maskFp.getPixels();
        this.outNx = imp.getWidth();
        this.outNy = imp.getHeight();
        switch (this.transformation) {
            case 2: {
                this.translationTransform(matrix, outMsk);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.affineTransform(matrix, outMsk);
                break;
            }
            case 8: {
                this.bilinearTransform(matrix, outMsk);
            }
        }
        imp.setSlice(1);
        imp.getProcessor().resetMinAndMax();
        return imp;
    }

    public float[] doFinalTransform(TurboRegImage sourceImg, TurboRegImage targetImg, int transformation, double[][] sourcePoint, double[][] targetPoint, boolean accelerated) {
        this.sourceImg = sourceImg;
        this.targetImg = targetImg;
        this.transformation = transformation;
        this.accelerated = accelerated;
        this.inImg = accelerated ? sourceImg.getImage() : sourceImg.getCoefficient();
        this.inNx = sourceImg.getWidth();
        this.inNy = sourceImg.getHeight();
        this.twiceInNx = this.inNx << 1;
        this.twiceInNy = this.inNy << 1;
        this.outNx = targetImg.getWidth();
        this.outNy = targetImg.getHeight();
        this.outImg = new float[this.outNx * this.outNy];
        double[][] matrix = this.getTransformationMatrix(targetPoint, sourcePoint);
        switch (transformation) {
            case 2: {
                this.translationTransform(matrix);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                this.affineTransform(matrix);
                break;
            }
            case 8: {
                this.bilinearTransform(matrix);
            }
        }
        return this.outImg;
    }

    public void doRegistration(double[][] sourcePoint, double[][] targetPoint) {
        Stack targetMskPyramid;
        Stack<Object> targetImgPyramid;
        Stack<float[]> sourceMskPyramid;
        Stack<Object> sourceImgPyramid;
        if (this.sourceMsk == null) {
            sourceImgPyramid = this.sourceImg.getPyramid();
            sourceMskPyramid = null;
            targetImgPyramid = (Stack<Object>)this.targetImg.getPyramid().clone();
            targetMskPyramid = (Stack)this.targetMsk.getPyramid().clone();
        } else {
            sourceImgPyramid = this.sourceImg.getPyramid();
            sourceMskPyramid = this.sourceMsk.getPyramid();
            targetImgPyramid = this.targetImg.getPyramid();
            targetMskPyramid = this.targetMsk.getPyramid();
        }
        this.pyramidDepth = this.targetImg.getPyramidDepth();
        this.iterationPower = Maths.Power(2, this.pyramidDepth);
        this.scaleBottomDownLandmarks(sourcePoint, targetPoint);
        while (!targetImgPyramid.isEmpty()) {
            this.iterationPower /= 2;
            if (this.transformation == 8) {
                this.inNx = (Integer)sourceImgPyramid.pop();
                this.inNy = (Integer)sourceImgPyramid.pop();
                this.inImg = (float[])sourceImgPyramid.pop();
                this.inMsk = (float[])(sourceMskPyramid == null ? null : sourceMskPyramid.pop());
                this.outNx = (Integer)targetImgPyramid.pop();
                this.outNy = (Integer)targetImgPyramid.pop();
                this.outImg = (float[])targetImgPyramid.pop();
                this.outMsk = (float[])targetMskPyramid.pop();
            } else {
                this.inNx = (Integer)targetImgPyramid.pop();
                this.inNy = (Integer)targetImgPyramid.pop();
                this.inImg = (float[])targetImgPyramid.pop();
                this.inMsk = (float[])targetMskPyramid.pop();
                this.outNx = (Integer)sourceImgPyramid.pop();
                this.outNy = (Integer)sourceImgPyramid.pop();
                this.outImg = (float[])sourceImgPyramid.pop();
                this.xGradient = (float[])sourceImgPyramid.pop();
                this.yGradient = (float[])sourceImgPyramid.pop();
                this.outMsk = (float[])(sourceMskPyramid == null ? null : sourceMskPyramid.pop());
            }
            this.twiceInNx = this.inNx << 1;
            this.twiceInNy = this.inNy << 1;
            switch (this.transformation) {
                case 2: {
                    this.targetJacobian = 1.0;
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 3: {
                    this.inverseMarquardtLevenbergRigidBodyOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 4: {
                    this.targetJacobian = (targetPoint[0][0] - targetPoint[1][0]) * (targetPoint[0][0] - targetPoint[1][0]) + (targetPoint[0][1] - targetPoint[1][1]) * (targetPoint[0][1] - targetPoint[1][1]);
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 6: {
                    this.targetJacobian = (targetPoint[1][0] - targetPoint[2][0]) * targetPoint[0][1] + (targetPoint[2][0] - targetPoint[0][0]) * targetPoint[1][1] + (targetPoint[0][0] - targetPoint[1][0]) * targetPoint[2][1];
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 8: {
                    this.marquardtLevenbergOptimization(sourcePoint, targetPoint);
                }
            }
            this.scaleUpLandmarks(sourcePoint, targetPoint);
        }
        this.iterationPower /= 2;
        if (this.transformation == 8) {
            this.inNx = this.sourceImg.getWidth();
            this.inNy = this.sourceImg.getHeight();
            this.inImg = this.sourceImg.getCoefficient();
            this.inMsk = (float[])(this.sourceMsk == null ? null : this.sourceMsk.getMask());
            this.outNx = this.targetImg.getWidth();
            this.outNy = this.targetImg.getHeight();
            this.outImg = this.targetImg.getImage();
            this.outMsk = this.targetMsk.getMask();
        } else {
            this.inNx = this.targetImg.getWidth();
            this.inNy = this.targetImg.getHeight();
            this.inImg = this.targetImg.getCoefficient();
            this.inMsk = this.targetMsk.getMask();
            this.outNx = this.sourceImg.getWidth();
            this.outNy = this.sourceImg.getHeight();
            this.outImg = this.sourceImg.getImage();
            this.xGradient = this.sourceImg.getXGradient();
            this.yGradient = this.sourceImg.getYGradient();
            this.outMsk = (float[])(this.sourceMsk == null ? null : this.sourceMsk.getMask());
        }
        this.twiceInNx = this.inNx << 1;
        this.twiceInNy = this.inNy << 1;
        if (!this.accelerated) {
            switch (this.transformation) {
                case 3: {
                    this.inverseMarquardtLevenbergRigidBodyOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 8: {
                    this.marquardtLevenbergOptimization(sourcePoint, targetPoint);
                }
            }
        }
        this.iterationPower = Maths.Power(2, this.pyramidDepth);
    }

    public void doRegistrationStochastic(double[][] sourcePoint, double[][] targetPoint) {
        Stack targetMskPyramid;
        Stack<Object> targetImgPyramid;
        Stack<float[]> sourceMskPyramid;
        Stack<Object> sourceImgPyramid;
        if (this.sourceMsk == null) {
            sourceImgPyramid = this.sourceImg.getPyramid();
            sourceMskPyramid = null;
            targetImgPyramid = (Stack<Object>)this.targetImg.getPyramid().clone();
            targetMskPyramid = (Stack)this.targetMsk.getPyramid().clone();
        } else {
            sourceImgPyramid = this.sourceImg.getPyramid();
            sourceMskPyramid = this.sourceMsk.getPyramid();
            targetImgPyramid = this.targetImg.getPyramid();
            targetMskPyramid = this.targetMsk.getPyramid();
        }
        this.pyramidDepth = this.targetImg.getPyramidDepth();
        this.iterationPower = Maths.Power(2, this.pyramidDepth);
        this.scaleBottomDownLandmarks(sourcePoint, targetPoint);
        int srcimpos = sourceImgPyramid.size() - 1;
        int srcmskpos = sourceMskPyramid.size() - 1;
        int tarimpos = targetImgPyramid.size() - 1;
        int tarmskpos = targetMskPyramid.size() - 1;
        while (0 <= tarimpos) {
            this.iterationPower /= 2;
            if (this.transformation == 8) {
                this.inNx = (Integer)sourceImgPyramid.get(srcimpos--);
                this.inNy = (Integer)sourceImgPyramid.get(srcimpos--);
                this.inImg = (float[])sourceImgPyramid.get(srcimpos--);
                this.inMsk = (float[])(sourceMskPyramid == null ? null : (float[])sourceMskPyramid.get(srcmskpos--));
                this.outNx = (Integer)targetImgPyramid.get(tarimpos--);
                this.outNy = (Integer)targetImgPyramid.get(tarimpos--);
                this.outImg = (float[])targetImgPyramid.get(tarimpos--);
                this.outMsk = (float[])targetMskPyramid.get(tarmskpos--);
            } else {
                this.inNx = (Integer)targetImgPyramid.get(tarimpos--);
                this.inNy = (Integer)targetImgPyramid.get(tarimpos--);
                this.inImg = (float[])targetImgPyramid.get(tarimpos--);
                this.inMsk = (float[])targetMskPyramid.get(tarmskpos--);
                this.outNx = (Integer)sourceImgPyramid.get(srcimpos--);
                this.outNy = (Integer)sourceImgPyramid.get(srcimpos--);
                this.outImg = (float[])sourceImgPyramid.get(srcimpos--);
                this.xGradient = (float[])sourceImgPyramid.get(srcimpos--);
                this.yGradient = (float[])sourceImgPyramid.get(srcimpos--);
                this.outMsk = (float[])(sourceMskPyramid == null ? null : (float[])sourceMskPyramid.get(srcmskpos--));
            }
            this.twiceInNx = 2 * this.inNx;
            this.twiceInNy = 2 * this.inNy;
            switch (this.transformation) {
                case 2: {
                    this.targetJacobian = 1.0;
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 3: {
                    this.inverseMarquardtLevenbergRigidBodyOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 4: {
                    this.targetJacobian = (targetPoint[0][0] - targetPoint[1][0]) * (targetPoint[0][0] - targetPoint[1][0]) + (targetPoint[0][1] - targetPoint[1][1]) * (targetPoint[0][1] - targetPoint[1][1]);
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 6: {
                    this.targetJacobian = (targetPoint[1][0] - targetPoint[2][0]) * targetPoint[0][1] + (targetPoint[2][0] - targetPoint[0][0]) * targetPoint[1][1] + (targetPoint[0][0] - targetPoint[1][0]) * targetPoint[2][1];
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 8: {
                    this.marquardtLevenbergOptimization(sourcePoint, targetPoint);
                }
            }
            this.scaleUpLandmarks(sourcePoint, targetPoint);
        }
        this.iterationPower /= 2;
        if (this.transformation == 8) {
            this.inNx = this.sourceImg.getWidth();
            this.inNy = this.sourceImg.getHeight();
            this.inImg = this.sourceImg.getCoefficient();
            this.inMsk = (float[])(this.sourceMsk == null ? null : this.sourceMsk.getMask());
            this.outNx = this.targetImg.getWidth();
            this.outNy = this.targetImg.getHeight();
            this.outImg = this.targetImg.getImage();
            this.outMsk = this.targetMsk.getMask();
        } else {
            this.inNx = this.targetImg.getWidth();
            this.inNy = this.targetImg.getHeight();
            this.inImg = this.targetImg.getCoefficient();
            this.inMsk = this.targetMsk.getMask();
            this.outNx = this.sourceImg.getWidth();
            this.outNy = this.sourceImg.getHeight();
            this.outImg = this.sourceImg.getImage();
            this.xGradient = this.sourceImg.getXGradient();
            this.yGradient = this.sourceImg.getYGradient();
            this.outMsk = (float[])(this.sourceMsk == null ? null : this.sourceMsk.getMask());
        }
        this.twiceInNx = 2 * this.inNx;
        this.twiceInNy = 2 * this.inNy;
        if (!this.accelerated) {
            switch (this.transformation) {
                case 3: {
                    this.inverseMarquardtLevenbergRigidBodyOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.inverseMarquardtLevenbergOptimization(sourcePoint, targetPoint);
                    break;
                }
                case 8: {
                    this.marquardtLevenbergOptimization(sourcePoint, targetPoint);
                }
            }
        }
        this.iterationPower = Maths.Power(2, this.pyramidDepth);
    }

    private void affineTransform(double[][] matrix) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        int k = 0;
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                double x = x0;
                double y = y0;
                int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k++] = this.inImg[xMsk];
                    } else {
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        this.outImg[k++] = (float)this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                    }
                } else {
                    this.outImg[k++] = 0.0f;
                }
                x0 += matrix[0][1];
                y0 += matrix[1][1];
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void affineTransform(double[][] matrix, float[] outMsk) {
        Object object;
        int i;
        if (this.afthreads == null) {
            this.nbFreeAffineTransformThreads = 0;
            this.afthreads = new AffineTransformThread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.afthreads[i2] = new AffineTransformThread();
                this.afthreads[i2].start();
            }
            TurboRegTransform i2 = this;
            synchronized (i2) {
                while (this.nbFreeAffineTransformThreads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int nbcpu = Math.max(this.nbCPU << 5 < this.inNy ? this.nbCPU : this.inNy >> 5, 1);
        int step = this.inNy / nbcpu;
        this.nbFreeAffineTransformThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.afthreads[i].setConditions(i * step, (i + 1) * step, matrix, outMsk);
            object = this.afthreads[i].lock;
            synchronized (object) {
                this.afthreads[i].lock.notify();
                continue;
            }
        }
        this.afthreads[i].setConditions(i * step, this.inNy, matrix, outMsk);
        object = this.afthreads[i].lock;
        synchronized (object) {
            this.afthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeAffineTransformThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void bilinearTransform(double[][] matrix) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        int k = 0;
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        double yxy = 0.0;
        double yyy = 0.0;
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                double x = x0;
                double y = y0;
                int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k++] = this.inImg[xMsk];
                    } else {
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        this.outImg[k++] = (float)this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                    }
                } else {
                    this.outImg[k++] = 0.0f;
                }
                x0 += matrix[0][1] + yxy;
                y0 += matrix[1][1] + yyy;
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
            yxy += matrix[0][3];
            yyy += matrix[1][3];
        }
    }

    private void bilinearTransform(double[][] matrix, float[] outMsk) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        int k = 0;
        double yx = matrix[0][0];
        double yy = matrix[1][0];
        double yxy = 0.0;
        double yyy = 0.0;
        for (int v = 0; v < this.outNy; ++v) {
            double x0 = yx;
            double y0 = yy;
            for (int u = 0; u < this.outNx; ++u) {
                int yMsk;
                double x = x0;
                double y = y0;
                int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                    xMsk += yMsk * this.inNx;
                    if (this.accelerated) {
                        this.outImg[k] = this.inImg[xMsk];
                    } else {
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        this.outImg[k] = (float)this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                    }
                    outMsk[k++] = this.inMsk[xMsk];
                } else {
                    this.outImg[k] = 0.0f;
                    outMsk[k++] = 0.0f;
                }
                x0 += matrix[0][1] + yxy;
                y0 += matrix[1][1] + yyy;
            }
            yx += matrix[0][2];
            yy += matrix[1][2];
            yxy += matrix[0][3];
            yyy += matrix[1][3];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAffineMeanSquares(double[][] sourcePoint, double[][] matrix) {
        Object object;
        int i;
        if (this.ams2threads == null) {
            this.nbFreeAMS2Threads = 0;
            this.ams2threads = new AffineMeanSquares2Thread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.ams2threads[i2] = new AffineMeanSquares2Thread();
                this.ams2threads[i2].start();
            }
            TurboRegTransform i2 = this;
            synchronized (i2) {
                while (this.nbFreeAMS2Threads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int nbcpu = Math.max(this.nbCPU << 5 < this.inNy ? this.nbCPU : this.inNy >> 5, 1);
        int step = this.inNy / nbcpu;
        this.nbFreeAMS2Threads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.ams2threads[i].setConditions(i * step, (i + 1) * step, matrix);
            object = this.ams2threads[i].lock;
            synchronized (object) {
                this.ams2threads[i].lock.notify();
                continue;
            }
        }
        this.ams2threads[i].setConditions(i * step, this.inNy, matrix);
        object = this.ams2threads[i].lock;
        synchronized (object) {
            this.ams2threads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeAMS2Threads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double u3 = sourcePoint[2][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double v3 = sourcePoint[2][1];
        double uv32 = u3 * v2 - u2 * v3;
        double uv21 = u2 * v1 - u1 * v2;
        double uv13 = u1 * v3 - u3 * v1;
        double det = uv32 + uv21 + uv13;
        double meanSquares = 0.0;
        long area = 0L;
        for (i = 0; i < nbcpu; ++i) {
            area += this.ams2threads[i].area;
            meanSquares += this.ams2threads[i].meanSquares;
        }
        return meanSquares / ((double)area * Math.abs(det / this.targetJacobian));
    }

    private double getAffineMeanSquares(double[][] sourcePoint, double[][] matrix, double[] gradient) {
        int v;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double u3 = sourcePoint[2][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double v3 = sourcePoint[2][1];
        double uv32 = u3 * v2 - u2 * v3;
        double uv21 = u2 * v1 - u1 * v2;
        double uv13 = u1 * v3 - u3 * v1;
        double det = uv32 + uv21 + uv13;
        double u12 = (u1 - u2) / det;
        double u23 = (u2 - u3) / det;
        double u31 = (u3 - u1) / det;
        double v12 = (v1 - v2) / det;
        double v23 = (v2 - v3) / det;
        double v31 = (v3 - v1) / det;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        uv32 /= det;
        uv21 /= det;
        uv13 /= det;
        for (int i = 0; i < this.transformation; ++i) {
            gradient[i] = 0.0;
        }
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        double g0 = u23 * (double)v - v23 * (double)u + uv32;
                        double g1 = u31 * (double)v - v31 * (double)u + uv13;
                        double g2 = u12 * (double)v - v12 * (double)u + uv21;
                        double dx0 = (double)this.xGradient[k] * g0;
                        double dy0 = (double)this.yGradient[k] * g0;
                        double dx1 = (double)this.xGradient[k] * g1;
                        double dy1 = (double)this.yGradient[k] * g1;
                        double dx2 = (double)this.xGradient[k] * g2;
                        double dy2 = (double)this.yGradient[k] * g2;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        double g0 = u23 * (double)v - v23 * (double)u + uv32;
                        double g1 = u31 * (double)v - v31 * (double)u + uv13;
                        double g2 = u12 * (double)v - v12 * (double)u + uv21;
                        double dx0 = (double)this.xGradient[k] * g0;
                        double dy0 = (double)this.yGradient[k] * g0;
                        double dx1 = (double)this.xGradient[k] * g1;
                        double dy1 = (double)this.yGradient[k] * g1;
                        double dx2 = (double)this.xGradient[k] * g2;
                        double dy2 = (double)this.yGradient[k] * g2;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * Math.abs(det / this.targetJacobian));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAffineMeanSquares(double[][] sourcePoint, double[][] matrix, double[][] hessian, double[] gradient) {
        Object object;
        int i;
        if (this.amsthreads == null) {
            this.nbFreeAMSThreads = 0;
            this.amsthreads = new AffineMeanSquaresThread[this.nbCPU];
            for (int i2 = 0; i2 < this.nbCPU; ++i2) {
                this.amsthreads[i2] = new AffineMeanSquaresThread();
                this.amsthreads[i2].start();
            }
            TurboRegTransform i2 = this;
            synchronized (i2) {
                while (this.nbFreeAMSThreads != this.nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (int i3 = 0; i3 < this.transformation; ++i3) {
            gradient[i3] = 0.0;
            Arrays.fill(hessian[i3], 0, this.transformation, 0.0);
        }
        int nbcpu = Math.max(this.nbCPU << 5 < this.inNy ? this.nbCPU : this.inNy >> 5, 1);
        int step = this.inNy / nbcpu;
        this.nbFreeAMSThreads = 0;
        for (i = 0; i < nbcpu - 1; ++i) {
            this.amsthreads[i].setConditions(i * step, (i + 1) * step, sourcePoint, matrix, hessian, gradient);
            object = this.amsthreads[i].lock;
            synchronized (object) {
                this.amsthreads[i].lock.notify();
                continue;
            }
        }
        this.amsthreads[i].setConditions(i * step, this.inNy, sourcePoint, matrix, hessian, gradient);
        object = this.amsthreads[i].lock;
        synchronized (object) {
            this.amsthreads[i].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeAMSThreads != nbcpu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        double meanSquares = 0.0;
        long area = 0L;
        for (i = 0; i < nbcpu; ++i) {
            area += this.amsthreads[i].area;
            meanSquares += this.amsthreads[i].meanSquares;
            ArrayArithmetic.Add(this.amsthreads[i].hessian, hessian, hessian);
            ArrayArithmetic.Add(this.amsthreads[i].gradient, gradient, gradient);
        }
        for (i = 1; i < this.transformation; ++i) {
            for (int j = 0; j < i; ++j) {
                hessian[i][j] = hessian[j][i];
            }
        }
        return meanSquares / ((double)area * this.amsthreads[0].den);
    }

    private double getBilinearMeanSquares(double[][] matrix) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.inMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            double yxy = 0.0;
            double yyy = 0.0;
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    if (this.outMsk[k] != 0.0f) {
                        int yMsk;
                        double x = x0;
                        double y = y0;
                        int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                            this.xIndexes(x, xIndex);
                            this.yIndexes(y, yIndex);
                            ++area;
                            double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                            this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                            this.xyWeights(y -= d, yWeight);
                            double difference = this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight) - (double)this.outImg[k];
                            meanSquares += difference * difference;
                        }
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            double yxy = 0.0;
            double yyy = 0.0;
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[xMsk += yMsk * this.inNx] != 0.0f) {
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        ++area;
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight) - (double)this.outImg[k];
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        }
        return meanSquares / (double)area;
    }

    private double getBilinearMeanSquares(double[][] matrix, double[][] hessian, double[] gradient, double[][] sourcePoint, double[][] targetPoint) {
        double dy3;
        double dx3;
        double dy2;
        double dx2;
        double dy1;
        double dx1;
        double dy0;
        double dx0;
        double g3;
        double g2;
        double g1;
        double g0;
        double uv;
        double yGradient;
        double xGradient;
        double difference;
        int yMsk;
        int xMsk;
        double y;
        double x;
        int u;
        double y0;
        double x0;
        int v;
        double yyy;
        double yxy;
        double yy;
        double yx;
        int i;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        double[] dxWeight = new double[4];
        double[] dyWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        double u1 = targetPoint[0][0];
        double u2 = targetPoint[1][0];
        double u3 = targetPoint[2][0];
        double u4 = targetPoint[3][0];
        double v1 = targetPoint[0][1];
        double v2 = targetPoint[1][1];
        double v3 = targetPoint[2][1];
        double v4 = targetPoint[3][1];
        double v12 = v1 - v2;
        double v13 = v1 - v3;
        double v14 = v1 - v4;
        double v23 = v2 - v3;
        double v24 = v2 - v4;
        double v34 = v3 - v4;
        double uv12 = u1 * u2 * v12;
        double uv13 = u1 * u3 * v13;
        double uv14 = u1 * u4 * v14;
        double uv23 = u2 * u3 * v23;
        double uv24 = u2 * u4 * v24;
        double uv34 = u3 * u4 * v34;
        double det = uv12 * v34 - uv13 * v24 + uv14 * v23 + uv23 * v14 - uv24 * v13 + uv34 * v12;
        double c0 = (-uv34 * v2 + uv24 * v3 - uv23 * v4) / det;
        double c0u = (u3 * v3 * v24 - u2 * v2 * v34 - u4 * v4 * v23) / det;
        double c0v = (uv23 - uv24 + uv34) / det;
        double c0uv = (u4 * v23 - u3 * v24 + u2 * v34) / det;
        double c1 = (uv34 * v1 - uv14 * v3 + uv13 * v4) / det;
        double c1u = (-u3 * v3 * v14 + u1 * v1 * v34 + u4 * v4 * v13) / det;
        double c1v = (-uv13 + uv14 - uv34) / det;
        double c1uv = (-u4 * v13 + u3 * v14 - u1 * v34) / det;
        double c2 = (-uv24 * v1 + uv14 * v2 - uv12 * v4) / det;
        double c2u = (u2 * v2 * v14 - u1 * v1 * v24 - u4 * v4 * v12) / det;
        double c2v = (uv12 - uv14 + uv24) / det;
        double c2uv = (u4 * v12 - u2 * v14 + u1 * v24) / det;
        double c3 = (uv23 * v1 - uv13 * v2 + uv12 * v3) / det;
        double c3u = (-u2 * v2 * v13 + u1 * v1 * v23 + u3 * v3 * v12) / det;
        double c3v = (-uv12 + uv13 - uv23) / det;
        double c3uv = (-u3 * v1 + u2 * v13 + u3 * v2 - u1 * v23) / det;
        for (i = 0; i < this.transformation; ++i) {
            gradient[i] = 0.0;
            Arrays.fill(hessian[i], 0, this.transformation, 0.0);
        }
        if (this.inMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            yxy = 0.0;
            yyy = 0.0;
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    if (this.outMsk[k] != 0.0f) {
                        x = x0;
                        y = y0;
                        xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy) {
                            ++area;
                            this.xIndexes(x, xIndex);
                            this.yIndexes(y, yIndex);
                            double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                            this.xyDxyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight, dxWeight);
                            this.xyDxyWeights(y -= d, yWeight, dyWeight);
                            difference = this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight) - (double)this.outImg[k];
                            meanSquares += difference * difference;
                            xGradient = this.InterpolateDx(this.inImg, xIndex, yIndex, yWeight, dxWeight);
                            yGradient = this.InterpolateDy(this.inImg, xIndex, yIndex, xWeight, dyWeight);
                            uv = (double)u * (double)v;
                            g0 = c0uv * uv + c0u * (double)u + c0v * (double)v + c0;
                            g1 = c1uv * uv + c1u * (double)u + c1v * (double)v + c1;
                            g2 = c2uv * uv + c2u * (double)u + c2v * (double)v + c2;
                            g3 = c3uv * uv + c3u * (double)u + c3v * (double)v + c3;
                            dx0 = xGradient * g0;
                            dy0 = yGradient * g0;
                            dx1 = xGradient * g1;
                            dy1 = yGradient * g1;
                            dx2 = xGradient * g2;
                            dy2 = yGradient * g2;
                            dx3 = xGradient * g3;
                            dy3 = yGradient * g3;
                            gradient[0] = gradient[0] + difference * dx0;
                            gradient[1] = gradient[1] + difference * dy0;
                            gradient[2] = gradient[2] + difference * dx1;
                            gradient[3] = gradient[3] + difference * dy1;
                            gradient[4] = gradient[4] + difference * dx2;
                            gradient[5] = gradient[5] + difference * dy2;
                            gradient[6] = gradient[6] + difference * dx3;
                            gradient[7] = gradient[7] + difference * dy3;
                            double[] dArray = hessian[0];
                            dArray[0] = dArray[0] + dx0 * dx0;
                            double[] dArray2 = hessian[0];
                            dArray2[1] = dArray2[1] + dx0 * dy0;
                            double[] dArray3 = hessian[0];
                            dArray3[2] = dArray3[2] + dx0 * dx1;
                            double[] dArray4 = hessian[0];
                            dArray4[3] = dArray4[3] + dx0 * dy1;
                            double[] dArray5 = hessian[0];
                            dArray5[4] = dArray5[4] + dx0 * dx2;
                            double[] dArray6 = hessian[0];
                            dArray6[5] = dArray6[5] + dx0 * dy2;
                            double[] dArray7 = hessian[0];
                            dArray7[6] = dArray7[6] + dx0 * dx3;
                            double[] dArray8 = hessian[0];
                            dArray8[7] = dArray8[7] + dx0 * dy3;
                            double[] dArray9 = hessian[1];
                            dArray9[1] = dArray9[1] + dy0 * dy0;
                            double[] dArray10 = hessian[1];
                            dArray10[2] = dArray10[2] + dy0 * dx1;
                            double[] dArray11 = hessian[1];
                            dArray11[3] = dArray11[3] + dy0 * dy1;
                            double[] dArray12 = hessian[1];
                            dArray12[4] = dArray12[4] + dy0 * dx2;
                            double[] dArray13 = hessian[1];
                            dArray13[5] = dArray13[5] + dy0 * dy2;
                            double[] dArray14 = hessian[1];
                            dArray14[6] = dArray14[6] + dy0 * dx3;
                            double[] dArray15 = hessian[1];
                            dArray15[7] = dArray15[7] + dy0 * dy3;
                            double[] dArray16 = hessian[2];
                            dArray16[2] = dArray16[2] + dx1 * dx1;
                            double[] dArray17 = hessian[2];
                            dArray17[3] = dArray17[3] + dx1 * dy1;
                            double[] dArray18 = hessian[2];
                            dArray18[4] = dArray18[4] + dx1 * dx2;
                            double[] dArray19 = hessian[2];
                            dArray19[5] = dArray19[5] + dx1 * dy2;
                            double[] dArray20 = hessian[2];
                            dArray20[6] = dArray20[6] + dx1 * dx3;
                            double[] dArray21 = hessian[2];
                            dArray21[7] = dArray21[7] + dx1 * dy3;
                            double[] dArray22 = hessian[3];
                            dArray22[3] = dArray22[3] + dy1 * dy1;
                            double[] dArray23 = hessian[3];
                            dArray23[4] = dArray23[4] + dy1 * dx2;
                            double[] dArray24 = hessian[3];
                            dArray24[5] = dArray24[5] + dy1 * dy2;
                            double[] dArray25 = hessian[3];
                            dArray25[6] = dArray25[6] + dy1 * dx3;
                            double[] dArray26 = hessian[3];
                            dArray26[7] = dArray26[7] + dy1 * dy3;
                            double[] dArray27 = hessian[4];
                            dArray27[4] = dArray27[4] + dx2 * dx2;
                            double[] dArray28 = hessian[4];
                            dArray28[5] = dArray28[5] + dx2 * dy2;
                            double[] dArray29 = hessian[4];
                            dArray29[6] = dArray29[6] + dx2 * dx3;
                            double[] dArray30 = hessian[4];
                            dArray30[7] = dArray30[7] + dx2 * dy3;
                            double[] dArray31 = hessian[5];
                            dArray31[5] = dArray31[5] + dy2 * dy2;
                            double[] dArray32 = hessian[5];
                            dArray32[6] = dArray32[6] + dy2 * dx3;
                            double[] dArray33 = hessian[5];
                            dArray33[7] = dArray33[7] + dy2 * dy3;
                            double[] dArray34 = hessian[6];
                            dArray34[6] = dArray34[6] + dx3 * dx3;
                            double[] dArray35 = hessian[6];
                            dArray35[7] = dArray35[7] + dx3 * dy3;
                            double[] dArray36 = hessian[7];
                            dArray36[7] = dArray36[7] + dy3 * dy3;
                        }
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            yxy = 0.0;
            yyy = 0.0;
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    x = x0;
                    y = y0;
                    xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[xMsk += yMsk * this.inNx] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyDxyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight, dxWeight);
                        this.xyDxyWeights(y -= d, yWeight, dyWeight);
                        difference = this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight) - (double)this.outImg[k];
                        meanSquares += difference * difference;
                        xGradient = this.InterpolateDx(this.inImg, xIndex, yIndex, yWeight, dxWeight);
                        yGradient = this.InterpolateDy(this.inImg, xIndex, yIndex, xWeight, dyWeight);
                        uv = (double)u * (double)v;
                        g0 = c0uv * uv + c0u * (double)u + c0v * (double)v + c0;
                        g1 = c1uv * uv + c1u * (double)u + c1v * (double)v + c1;
                        g2 = c2uv * uv + c2u * (double)u + c2v * (double)v + c2;
                        g3 = c3uv * uv + c3u * (double)u + c3v * (double)v + c3;
                        dx0 = xGradient * g0;
                        dy0 = yGradient * g0;
                        dx1 = xGradient * g1;
                        dy1 = yGradient * g1;
                        dx2 = xGradient * g2;
                        dy2 = yGradient * g2;
                        dx3 = xGradient * g3;
                        dy3 = yGradient * g3;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        gradient[4] = gradient[4] + difference * dx2;
                        gradient[5] = gradient[5] + difference * dy2;
                        gradient[6] = gradient[6] + difference * dx3;
                        gradient[7] = gradient[7] + difference * dy3;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray37 = hessian[0];
                        dArray37[1] = dArray37[1] + dx0 * dy0;
                        double[] dArray38 = hessian[0];
                        dArray38[2] = dArray38[2] + dx0 * dx1;
                        double[] dArray39 = hessian[0];
                        dArray39[3] = dArray39[3] + dx0 * dy1;
                        double[] dArray40 = hessian[0];
                        dArray40[4] = dArray40[4] + dx0 * dx2;
                        double[] dArray41 = hessian[0];
                        dArray41[5] = dArray41[5] + dx0 * dy2;
                        double[] dArray42 = hessian[0];
                        dArray42[6] = dArray42[6] + dx0 * dx3;
                        double[] dArray43 = hessian[0];
                        dArray43[7] = dArray43[7] + dx0 * dy3;
                        double[] dArray44 = hessian[1];
                        dArray44[1] = dArray44[1] + dy0 * dy0;
                        double[] dArray45 = hessian[1];
                        dArray45[2] = dArray45[2] + dy0 * dx1;
                        double[] dArray46 = hessian[1];
                        dArray46[3] = dArray46[3] + dy0 * dy1;
                        double[] dArray47 = hessian[1];
                        dArray47[4] = dArray47[4] + dy0 * dx2;
                        double[] dArray48 = hessian[1];
                        dArray48[5] = dArray48[5] + dy0 * dy2;
                        double[] dArray49 = hessian[1];
                        dArray49[6] = dArray49[6] + dy0 * dx3;
                        double[] dArray50 = hessian[1];
                        dArray50[7] = dArray50[7] + dy0 * dy3;
                        double[] dArray51 = hessian[2];
                        dArray51[2] = dArray51[2] + dx1 * dx1;
                        double[] dArray52 = hessian[2];
                        dArray52[3] = dArray52[3] + dx1 * dy1;
                        double[] dArray53 = hessian[2];
                        dArray53[4] = dArray53[4] + dx1 * dx2;
                        double[] dArray54 = hessian[2];
                        dArray54[5] = dArray54[5] + dx1 * dy2;
                        double[] dArray55 = hessian[2];
                        dArray55[6] = dArray55[6] + dx1 * dx3;
                        double[] dArray56 = hessian[2];
                        dArray56[7] = dArray56[7] + dx1 * dy3;
                        double[] dArray57 = hessian[3];
                        dArray57[3] = dArray57[3] + dy1 * dy1;
                        double[] dArray58 = hessian[3];
                        dArray58[4] = dArray58[4] + dy1 * dx2;
                        double[] dArray59 = hessian[3];
                        dArray59[5] = dArray59[5] + dy1 * dy2;
                        double[] dArray60 = hessian[3];
                        dArray60[6] = dArray60[6] + dy1 * dx3;
                        double[] dArray61 = hessian[3];
                        dArray61[7] = dArray61[7] + dy1 * dy3;
                        double[] dArray62 = hessian[4];
                        dArray62[4] = dArray62[4] + dx2 * dx2;
                        double[] dArray63 = hessian[4];
                        dArray63[5] = dArray63[5] + dx2 * dy2;
                        double[] dArray64 = hessian[4];
                        dArray64[6] = dArray64[6] + dx2 * dx3;
                        double[] dArray65 = hessian[4];
                        dArray65[7] = dArray65[7] + dx2 * dy3;
                        double[] dArray66 = hessian[5];
                        dArray66[5] = dArray66[5] + dy2 * dy2;
                        double[] dArray67 = hessian[5];
                        dArray67[6] = dArray67[6] + dy2 * dx3;
                        double[] dArray68 = hessian[5];
                        dArray68[7] = dArray68[7] + dy2 * dy3;
                        double[] dArray69 = hessian[6];
                        dArray69[6] = dArray69[6] + dx3 * dx3;
                        double[] dArray70 = hessian[6];
                        dArray70[7] = dArray70[7] + dx3 * dy3;
                        double[] dArray71 = hessian[7];
                        dArray71[7] = dArray71[7] + dy3 * dy3;
                    }
                    x0 += matrix[0][1] + yxy;
                    y0 += matrix[1][1] + yyy;
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
                yxy += matrix[0][3];
                yyy += matrix[1][3];
            }
        }
        for (i = 1; i < this.transformation; ++i) {
            for (int j = 0; j < i; ++j) {
                hessian[i][j] = hessian[j][i];
            }
        }
        return meanSquares / (double)area;
    }

    private double getRigidBodyMeanSquares(double[][] matrix) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / (double)area;
    }

    private double getRigidBodyMeanSquares(double[][] matrix, double[] gradient) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        Arrays.fill(gradient, 0, this.transformation, 0.0);
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        gradient[0] = gradient[0] + difference * ((double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v);
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        gradient[0] = gradient[0] + difference * ((double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v);
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / (double)area;
    }

    private double getRigidBodyMeanSquares(double[][] matrix, double[][] hessian, double[] gradient) {
        double dTheta;
        double difference;
        int yMsk;
        int xMsk;
        double y;
        double x;
        int u;
        double y0;
        double x0;
        int v;
        double yy;
        double yx;
        int i;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (i = 0; i < this.transformation; ++i) {
            gradient[i] = 0.0;
            Arrays.fill(hessian[i], 0, this.transformation, 0.0);
        }
        if (this.outMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    x = x0;
                    y = y0;
                    xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        dTheta = (double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v;
                        gradient[0] = gradient[0] + difference * dTheta;
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dTheta * dTheta;
                        double[] dArray2 = hessian[0];
                        dArray2[1] = dArray2[1] + dTheta * (double)this.xGradient[k];
                        double[] dArray3 = hessian[0];
                        dArray3[2] = dArray3[2] + dTheta * (double)this.yGradient[k];
                        double[] dArray4 = hessian[1];
                        dArray4[1] = dArray4[1] + (double)(this.xGradient[k] * this.xGradient[k]);
                        double[] dArray5 = hessian[1];
                        dArray5[2] = dArray5[2] + (double)(this.xGradient[k] * this.yGradient[k]);
                        double[] dArray6 = hessian[2];
                        dArray6[2] = dArray6[2] + (double)(this.yGradient[k] * this.yGradient[k]);
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    x = x0;
                    y = y0;
                    xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        dTheta = (double)this.yGradient[k] * (double)u - (double)this.xGradient[k] * (double)v;
                        gradient[0] = gradient[0] + difference * dTheta;
                        gradient[1] = gradient[1] + difference * (double)this.xGradient[k];
                        gradient[2] = gradient[2] + difference * (double)this.yGradient[k];
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dTheta * dTheta;
                        double[] dArray7 = hessian[0];
                        dArray7[1] = dArray7[1] + dTheta * (double)this.xGradient[k];
                        double[] dArray8 = hessian[0];
                        dArray8[2] = dArray8[2] + dTheta * (double)this.yGradient[k];
                        double[] dArray9 = hessian[1];
                        dArray9[1] = dArray9[1] + (double)(this.xGradient[k] * this.xGradient[k]);
                        double[] dArray10 = hessian[1];
                        dArray10[2] = dArray10[2] + (double)(this.xGradient[k] * this.yGradient[k]);
                        double[] dArray11 = hessian[2];
                        dArray11[2] = dArray11[2] + (double)(this.yGradient[k] * this.yGradient[k]);
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        for (i = 1; i < this.transformation; ++i) {
            for (int j = 0; j < i; ++j) {
                hessian[i][j] = hessian[j][i];
            }
        }
        return meanSquares / (double)area;
    }

    private double getScaledRotationMeanSquares(double[][] sourcePoint, double[][] matrix) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double u12 = u1 - u2;
        double v12 = v1 - v2;
        double uv2 = u12 * u12 + v12 * v12;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * uv2 / this.targetJacobian);
    }

    private double getScaledRotationMeanSquares(double[][] sourcePoint, double[][] matrix, double[] gradient) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double u12 = u1 - u2;
        double v12 = v1 - v2;
        double uv2 = u12 * u12 + v12 * v12;
        double c = 0.5 * (u2 * v1 - u1 * v2) / uv2;
        double c1 = u12 / uv2;
        double c2 = v12 / uv2;
        double c3 = (uv2 - u12 * v12) / uv2;
        double c4 = (uv2 + u12 * v12) / uv2;
        double c5 = c + u1 * c1 + u2 * c2;
        double c6 = c * (u12 * u12 - v12 * v12) / uv2;
        double c7 = c1 * c4;
        double c8 = c1 - c2 - c1 * c2 * v12;
        double c9 = c1 + c2 - c1 * c2 * u12;
        double c0 = c2 * c3;
        double dgxx0 = c1 * u2 + c2 * v2;
        double dgyx0 = 2.0 * c;
        double dgxx1 = c5 + c6;
        double dgyy1 = c5 - c6;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        Arrays.fill(gradient, 0, this.transformation, 0.0);
        if (this.outMsk == null) {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        double gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        double gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        double gxy0 = -gyx0;
                        double gyy0 = gxx0;
                        double gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        double gyx1 = -c3 * gyx0;
                        double gxy1 = c4 * gyx0;
                        double gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        double dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        double dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        double dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        double dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            double yx = matrix[0][0];
            double yy = matrix[1][0];
            for (int v = 0; v < this.outNy; ++v) {
                double x0 = yx;
                double y0 = yy;
                int u = 0;
                while (u < this.outNx) {
                    int yMsk;
                    double x = x0;
                    double y = y0;
                    int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        double gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        double gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        double gxy0 = -gyx0;
                        double gyy0 = gxx0;
                        double gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        double gyx1 = -c3 * gyx0;
                        double gxy1 = c4 * gyx0;
                        double gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        double dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        double dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        double dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        double dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        return meanSquares / ((double)area * uv2 / this.targetJacobian);
    }

    private double getScaledRotationMeanSquares(double[][] sourcePoint, double[][] matrix, double[][] hessian, double[] gradient) {
        double dy1;
        double dx1;
        double dy0;
        double dx0;
        double gyy1;
        double gxy1;
        double gyx1;
        double gxx1;
        double gyy0;
        double gxy0;
        double gyx0;
        double gxx0;
        double difference;
        int yMsk;
        int xMsk;
        double y;
        double x;
        int u;
        double y0;
        double x0;
        int v;
        double yy;
        double yx;
        int i;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double u1 = sourcePoint[0][0];
        double u2 = sourcePoint[1][0];
        double v1 = sourcePoint[0][1];
        double v2 = sourcePoint[1][1];
        double u12 = u1 - u2;
        double v12 = v1 - v2;
        double uv2 = u12 * u12 + v12 * v12;
        double c = 0.5 * (u2 * v1 - u1 * v2) / uv2;
        double c1 = u12 / uv2;
        double c2 = v12 / uv2;
        double c3 = (uv2 - u12 * v12) / uv2;
        double c4 = (uv2 + u12 * v12) / uv2;
        double c5 = c + u1 * c1 + u2 * c2;
        double c6 = c * (u12 * u12 - v12 * v12) / uv2;
        double c7 = c1 * c4;
        double c8 = c1 - c2 - c1 * c2 * v12;
        double c9 = c1 + c2 - c1 * c2 * u12;
        double c0 = c2 * c3;
        double dgxx0 = c1 * u2 + c2 * v2;
        double dgyx0 = 2.0 * c;
        double dgxx1 = c5 + c6;
        double dgyy1 = c5 - c6;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (i = 0; i < this.transformation; ++i) {
            gradient[i] = 0.0;
            Arrays.fill(hessian[i], 0, this.transformation, 0.0);
        }
        if (this.outMsk == null) {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    x = x0;
                    y = y0;
                    xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        gxy0 = -gyx0;
                        gyy0 = gxx0;
                        gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        gyx1 = -c3 * gyx0;
                        gxy1 = c4 * gyx0;
                        gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray2 = hessian[0];
                        dArray2[1] = dArray2[1] + dx0 * dy0;
                        double[] dArray3 = hessian[0];
                        dArray3[2] = dArray3[2] + dx0 * dx1;
                        double[] dArray4 = hessian[0];
                        dArray4[3] = dArray4[3] + dx0 * dy1;
                        double[] dArray5 = hessian[1];
                        dArray5[1] = dArray5[1] + dy0 * dy0;
                        double[] dArray6 = hessian[1];
                        dArray6[2] = dArray6[2] + dy0 * dx1;
                        double[] dArray7 = hessian[1];
                        dArray7[3] = dArray7[3] + dy0 * dy1;
                        double[] dArray8 = hessian[2];
                        dArray8[2] = dArray8[2] + dx1 * dx1;
                        double[] dArray9 = hessian[2];
                        dArray9[3] = dArray9[3] + dx1 * dy1;
                        double[] dArray10 = hessian[3];
                        dArray10[3] = dArray10[3] + dy1 * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        } else {
            yx = matrix[0][0];
            yy = matrix[1][0];
            for (v = 0; v < this.outNy; ++v) {
                x0 = yx;
                y0 = yy;
                u = 0;
                while (u < this.outNx) {
                    x = x0;
                    y = y0;
                    xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx && 0 <= yMsk && yMsk < this.inNy && this.outMsk[k] * this.inMsk[yMsk * this.inNx + xMsk] != 0.0f) {
                        ++area;
                        this.xIndexes(x, xIndex);
                        this.yIndexes(y, yIndex);
                        double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                        this.xyWeights(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                        this.xyWeights(y -= d, yWeight);
                        difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        meanSquares += difference * difference;
                        gxx0 = (double)u * c1 + (double)v * c2 - dgxx0;
                        gyx0 = (double)v * c1 - (double)u * c2 + dgyx0;
                        gxy0 = -gyx0;
                        gyy0 = gxx0;
                        gxx1 = (double)v * c8 - (double)u * c7 + dgxx1;
                        gyx1 = -c3 * gyx0;
                        gxy1 = c4 * gyx0;
                        gyy1 = dgyy1 - (double)u * c9 - (double)v * c0;
                        dx0 = (double)this.xGradient[k] * gxx0 + (double)this.yGradient[k] * gyx0;
                        dy0 = (double)this.xGradient[k] * gxy0 + (double)this.yGradient[k] * gyy0;
                        dx1 = (double)this.xGradient[k] * gxx1 + (double)this.yGradient[k] * gyx1;
                        dy1 = (double)this.xGradient[k] * gxy1 + (double)this.yGradient[k] * gyy1;
                        gradient[0] = gradient[0] + difference * dx0;
                        gradient[1] = gradient[1] + difference * dy0;
                        gradient[2] = gradient[2] + difference * dx1;
                        gradient[3] = gradient[3] + difference * dy1;
                        double[] dArray = hessian[0];
                        dArray[0] = dArray[0] + dx0 * dx0;
                        double[] dArray11 = hessian[0];
                        dArray11[1] = dArray11[1] + dx0 * dy0;
                        double[] dArray12 = hessian[0];
                        dArray12[2] = dArray12[2] + dx0 * dx1;
                        double[] dArray13 = hessian[0];
                        dArray13[3] = dArray13[3] + dx0 * dy1;
                        double[] dArray14 = hessian[1];
                        dArray14[1] = dArray14[1] + dy0 * dy0;
                        double[] dArray15 = hessian[1];
                        dArray15[2] = dArray15[2] + dy0 * dx1;
                        double[] dArray16 = hessian[1];
                        dArray16[3] = dArray16[3] + dy0 * dy1;
                        double[] dArray17 = hessian[2];
                        dArray17[2] = dArray17[2] + dx1 * dx1;
                        double[] dArray18 = hessian[2];
                        dArray18[3] = dArray18[3] + dx1 * dy1;
                        double[] dArray19 = hessian[3];
                        dArray19[3] = dArray19[3] + dy1 * dy1;
                    }
                    x0 += matrix[0][1];
                    y0 += matrix[1][1];
                    ++u;
                    ++k;
                }
                yx += matrix[0][2];
                yy += matrix[1][2];
            }
        }
        for (i = 1; i < this.transformation; ++i) {
            for (int j = 0; j < i; ++j) {
                hessian[i][j] = hessian[j][i];
            }
        }
        return meanSquares / ((double)area * uv2 / this.targetJacobian);
    }

    public double[][] getTransformationMatrix(double[][] fromCoord, double[][] toCoord) {
        double[][] matrix = null;
        double[][] a = null;
        double[] v = null;
        switch (this.transformation) {
            case 2: {
                matrix = new double[2][1];
                matrix[0][0] = toCoord[0][0] - fromCoord[0][0];
                matrix[1][0] = toCoord[0][1] - fromCoord[0][1];
                break;
            }
            case 3: {
                double angle = Math.atan2(fromCoord[2][0] - fromCoord[1][0], fromCoord[2][1] - fromCoord[1][1]) - Math.atan2(toCoord[2][0] - toCoord[1][0], toCoord[2][1] - toCoord[1][1]);
                double c = Math.cos(angle);
                double s = Math.sin(angle);
                matrix = new double[2][3];
                matrix[0][0] = toCoord[0][0] - c * fromCoord[0][0] + s * fromCoord[0][1];
                matrix[0][1] = c;
                matrix[0][2] = -s;
                matrix[1][0] = toCoord[0][1] - s * fromCoord[0][0] - c * fromCoord[0][1];
                matrix[1][1] = s;
                matrix[1][2] = c;
                break;
            }
            case 4: {
                int j;
                int i;
                matrix = new double[2][3];
                a = new double[3][3];
                v = new double[3];
                a[0][0] = 1.0;
                a[0][1] = fromCoord[0][0];
                a[0][2] = fromCoord[0][1];
                a[1][0] = 1.0;
                a[1][1] = fromCoord[1][0];
                a[1][2] = fromCoord[1][1];
                a[2][0] = 1.0;
                a[2][1] = fromCoord[0][1] - fromCoord[1][1] + fromCoord[1][0];
                a[2][2] = fromCoord[1][0] + fromCoord[1][1] - fromCoord[0][0];
                this.invertGauss(a);
                v[0] = toCoord[0][0];
                v[1] = toCoord[1][0];
                v[2] = toCoord[0][1] - toCoord[1][1] + toCoord[1][0];
                for (i = 0; i < 3; ++i) {
                    matrix[0][i] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[0];
                        int n = i;
                        dArray[n] = dArray[n] + a[i][j] * v[j];
                    }
                }
                v[0] = toCoord[0][1];
                v[1] = toCoord[1][1];
                v[2] = toCoord[1][0] + toCoord[1][1] - toCoord[0][0];
                for (i = 0; i < 3; ++i) {
                    matrix[1][i] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[1];
                        int n = i;
                        dArray[n] = dArray[n] + a[i][j] * v[j];
                    }
                }
                break;
            }
            case 6: {
                int j;
                int i;
                matrix = new double[2][3];
                a = new double[3][3];
                v = new double[3];
                a[0][0] = 1.0;
                a[0][1] = fromCoord[0][0];
                a[0][2] = fromCoord[0][1];
                a[1][0] = 1.0;
                a[1][1] = fromCoord[1][0];
                a[1][2] = fromCoord[1][1];
                a[2][0] = 1.0;
                a[2][1] = fromCoord[2][0];
                a[2][2] = fromCoord[2][1];
                this.invertGauss(a);
                v[0] = toCoord[0][0];
                v[1] = toCoord[1][0];
                v[2] = toCoord[2][0];
                for (i = 0; i < 3; ++i) {
                    matrix[0][i] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[0];
                        int n = i;
                        dArray[n] = dArray[n] + a[i][j] * v[j];
                    }
                }
                v[0] = toCoord[0][1];
                v[1] = toCoord[1][1];
                v[2] = toCoord[2][1];
                for (i = 0; i < 3; ++i) {
                    matrix[1][i] = 0.0;
                    for (j = 0; j < 3; ++j) {
                        double[] dArray = matrix[1];
                        int n = i;
                        dArray[n] = dArray[n] + a[i][j] * v[j];
                    }
                }
                break;
            }
            case 8: {
                int j;
                int i;
                matrix = new double[2][4];
                a = new double[4][4];
                v = new double[4];
                a[0][0] = 1.0;
                a[0][1] = fromCoord[0][0];
                a[0][2] = fromCoord[0][1];
                a[0][3] = fromCoord[0][0] * fromCoord[0][1];
                a[1][0] = 1.0;
                a[1][1] = fromCoord[1][0];
                a[1][2] = fromCoord[1][1];
                a[1][3] = fromCoord[1][0] * fromCoord[1][1];
                a[2][0] = 1.0;
                a[2][1] = fromCoord[2][0];
                a[2][2] = fromCoord[2][1];
                a[2][3] = fromCoord[2][0] * fromCoord[2][1];
                a[3][0] = 1.0;
                a[3][1] = fromCoord[3][0];
                a[3][2] = fromCoord[3][1];
                a[3][3] = fromCoord[3][0] * fromCoord[3][1];
                this.invertGauss(a);
                v[0] = toCoord[0][0];
                v[1] = toCoord[1][0];
                v[2] = toCoord[2][0];
                v[3] = toCoord[3][0];
                for (i = 0; i < 4; ++i) {
                    matrix[0][i] = 0.0;
                    for (j = 0; j < 4; ++j) {
                        double[] dArray = matrix[0];
                        int n = i;
                        dArray[n] = dArray[n] + a[i][j] * v[j];
                    }
                }
                v[0] = toCoord[0][1];
                v[1] = toCoord[1][1];
                v[2] = toCoord[2][1];
                v[3] = toCoord[3][1];
                for (i = 0; i < 4; ++i) {
                    matrix[1][i] = 0.0;
                    for (j = 0; j < 4; ++j) {
                        double[] dArray = matrix[1];
                        int n = i;
                        dArray[n] = dArray[n] + a[i][j] * v[j];
                    }
                }
                break;
            }
        }
        return matrix;
    }

    private double getTranslationMeanSquares(double[][] matrix) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        double x = dx - Math.floor(dx);
        double y = dy - Math.floor(dy);
        this.xyWeights(x, xWeight);
        this.xyWeights(y, yWeight);
        if (this.outMsk == null) {
            for (int v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes(y, yIndex);
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        int n2 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.inMsk[yMsk + xMsk] != 0.0f) {
                            this.xIndexes(x, xIndex);
                            ++area;
                            double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                            meanSquares += difference * difference;
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        } else {
            for (int v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes(y, yIndex);
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        int n3 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.outMsk[k] * this.inMsk[yMsk + xMsk] != 0.0f) {
                            this.xIndexes(x, xIndex);
                            ++area;
                            double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                            meanSquares += difference * difference;
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        }
        return meanSquares / (double)area;
    }

    private double getTranslationMeanSquares(double[][] matrix, double[] gradient) {
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        Arrays.fill(gradient, 0, this.transformation, 0.0);
        double x = dx - Math.floor(dx);
        double y = dy - Math.floor(dy);
        this.xyWeights(x, xWeight);
        this.xyWeights(y, yWeight);
        if (this.outMsk == null) {
            for (int v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes(y, yIndex);
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        int n2 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes(x, xIndex);
                            double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        } else {
            for (int v = 0; v < this.outNy; ++v) {
                int yMsk;
                dy += 1.0;
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes(y, yIndex);
                    dx = dx0;
                    int u = 0;
                    while (u < this.outNx) {
                        int xMsk;
                        dx += 1.0;
                        int n3 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.outMsk[k] * this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes(x, xIndex);
                            double difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        }
        return meanSquares / (double)area;
    }

    private double getTranslationMeanSquares(double[][] matrix, double[][] hessian, double[] gradient) {
        double difference;
        int xMsk;
        int u;
        int yMsk;
        int v;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double meanSquares = 0.0;
        long area = 0L;
        int k = 0;
        for (int i = 0; i < this.transformation; ++i) {
            gradient[i] = 0.0;
            Arrays.fill(hessian[i], 0, this.transformation, 0.0);
        }
        double x = dx - Math.floor(dx);
        double y = dy - Math.floor(dy);
        this.xyWeights(x, xWeight);
        this.xyWeights(y, yWeight);
        if (this.outMsk == null) {
            for (v = 0; v < this.outNy; ++v) {
                dy += 1.0;
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes(y, yIndex);
                    dx = dx0;
                    u = 0;
                    while (u < this.outNx) {
                        dx += 1.0;
                        int n2 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes(x, xIndex);
                            difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                            double[] dArray = hessian[0];
                            dArray[0] = dArray[0] + (double)(this.xGradient[k] * this.xGradient[k]);
                            double[] dArray2 = hessian[0];
                            dArray2[1] = dArray2[1] + (double)(this.xGradient[k] * this.yGradient[k]);
                            double[] dArray3 = hessian[1];
                            dArray3[1] = dArray3[1] + (double)(this.yGradient[k] * this.yGradient[k]);
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        } else {
            for (v = 0; v < this.outNy; ++v) {
                dy += 1.0;
                int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                if (0 <= yMsk && yMsk < this.inNy) {
                    yMsk *= this.inNx;
                    this.yIndexes(y, yIndex);
                    dx = dx0;
                    u = 0;
                    while (u < this.outNx) {
                        dx += 1.0;
                        int n3 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        if (0 <= xMsk && xMsk < this.inNx && this.outMsk[k] * this.inMsk[yMsk + xMsk] != 0.0f) {
                            ++area;
                            this.xIndexes(x, xIndex);
                            difference = (double)this.outImg[k] - this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                            meanSquares += difference * difference;
                            gradient[0] = gradient[0] + difference * (double)this.xGradient[k];
                            gradient[1] = gradient[1] + difference * (double)this.yGradient[k];
                            double[] dArray = hessian[0];
                            dArray[0] = dArray[0] + (double)(this.xGradient[k] * this.xGradient[k]);
                            double[] dArray4 = hessian[0];
                            dArray4[1] = dArray4[1] + (double)(this.xGradient[k] * this.yGradient[k]);
                            double[] dArray5 = hessian[1];
                            dArray5[1] = dArray5[1] + (double)(this.yGradient[k] * this.yGradient[k]);
                        }
                        ++u;
                        ++k;
                    }
                    continue;
                }
                k += this.outNx;
            }
        }
        for (int i = 1; i < this.transformation; ++i) {
            for (int j = 0; j < i; ++j) {
                hessian[i][j] = hessian[j][i];
            }
        }
        return meanSquares / (double)area;
    }

    private double Interpolate(float[] inImg, int[] xIndex, int[] yIndex, double[] xWeight, double[] yWeight) {
        double t = 0.0;
        for (int j = 0; j < 4; ++j) {
            double s = 0.0;
            int p = yIndex[j];
            for (int i = 0; i < 4; ++i) {
                s += xWeight[i] * (double)inImg[p + xIndex[i]];
            }
            t += yWeight[j] * s;
        }
        return t;
    }

    private double InterpolateDx(float[] inImg, int[] xIndex, int[] yIndex, double[] yWeight, double[] dxWeight) {
        double t = 0.0;
        for (int j = 0; j < 4; ++j) {
            double s = 0.0;
            int p = yIndex[j];
            for (int i = 0; i < 4; ++i) {
                s += dxWeight[i] * (double)inImg[p + xIndex[i]];
            }
            t += yWeight[j] * s;
        }
        return t;
    }

    private double InterpolateDy(float[] inImg, int[] xIndex, int[] yIndex, double[] xWeight, double[] dyWeight) {
        double t = 0.0;
        for (int j = 0; j < 4; ++j) {
            double s = 0.0;
            int p = yIndex[j];
            for (int i = 0; i < 4; ++i) {
                s += xWeight[i] * (double)inImg[p + xIndex[i]];
            }
            t += dyWeight[j] * s;
        }
        return t;
    }

    private void inverseMarquardtLevenbergOptimization(double[][] sourcePoint, double[][] targetPoint) {
        int k;
        double displacement;
        double[][] attempt = new double[this.transformation >> 1][2];
        double[][] hessian = new double[this.transformation][this.transformation];
        double[][] pseudoHessian = new double[this.transformation][this.transformation];
        double[] gradient = new double[this.transformation];
        double[][] matrix = this.getTransformationMatrix(sourcePoint, targetPoint);
        double[] update = new double[this.transformation];
        double bestMeanSquares = 0.0;
        double meanSquares = 0.0;
        double lambda = 1.0;
        int iteration = 0;
        int t2 = this.transformation >> 1;
        switch (this.transformation) {
            case 2: {
                bestMeanSquares = this.getTranslationMeanSquares(matrix, hessian, gradient);
                break;
            }
            case 4: {
                bestMeanSquares = this.getScaledRotationMeanSquares(sourcePoint, matrix, hessian, gradient);
                break;
            }
            case 6: {
                bestMeanSquares = this.getAffineMeanSquares(sourcePoint, matrix, hessian, gradient);
            }
        }
        ++iteration;
        do {
            for (k = 0; k < this.transformation; ++k) {
                pseudoHessian[k][k] = (1.0 + lambda) * hessian[k][k];
            }
            this.invertGauss(pseudoHessian);
            update = this.matrixMultiply(pseudoHessian, gradient);
            displacement = 0.0;
            for (k = 0; k < t2; ++k) {
                attempt[k][0] = sourcePoint[k][0] - update[2 * k];
                attempt[k][1] = sourcePoint[k][1] - update[2 * k + 1];
                displacement += Math.sqrt(update[2 * k] * update[2 * k] + update[2 * k + 1] * update[2 * k + 1]);
            }
            displacement /= 0.5 * (double)this.transformation;
            matrix = this.getTransformationMatrix(attempt, targetPoint);
            switch (this.transformation) {
                case 2: {
                    if (this.accelerated) {
                        meanSquares = this.getTranslationMeanSquares(matrix, gradient);
                        break;
                    }
                    meanSquares = this.getTranslationMeanSquares(matrix, hessian, gradient);
                    break;
                }
                case 4: {
                    if (this.accelerated) {
                        meanSquares = this.getScaledRotationMeanSquares(attempt, matrix, gradient);
                        break;
                    }
                    meanSquares = this.getScaledRotationMeanSquares(attempt, matrix, hessian, gradient);
                    break;
                }
                case 6: {
                    meanSquares = this.accelerated ? this.getAffineMeanSquares(attempt, matrix, gradient) : this.getAffineMeanSquares(attempt, matrix, hessian, gradient);
                }
            }
            ++iteration;
            if (meanSquares < bestMeanSquares) {
                bestMeanSquares = meanSquares;
                for (k = 0; k < t2; ++k) {
                    sourcePoint[k][0] = attempt[k][0];
                    sourcePoint[k][1] = attempt[k][1];
                }
                lambda /= 4.0;
                continue;
            }
            lambda *= 4.0;
        } while (iteration < this.maxIterations * this.iterationPower - 1 && this.pixelPrecision <= displacement);
        this.invertGauss(hessian);
        update = this.matrixMultiply(hessian, gradient);
        for (k = 0; k < t2; ++k) {
            attempt[k][0] = sourcePoint[k][0] - update[k << 1];
            attempt[k][1] = sourcePoint[k][1] - update[(k << 1) + 1];
        }
        matrix = this.getTransformationMatrix(attempt, targetPoint);
        switch (this.transformation) {
            case 2: {
                meanSquares = this.getTranslationMeanSquares(matrix);
                break;
            }
            case 4: {
                meanSquares = this.getScaledRotationMeanSquares(attempt, matrix);
                break;
            }
            case 6: {
                meanSquares = this.getAffineMeanSquares(attempt, matrix);
            }
        }
        ++iteration;
        if (meanSquares < bestMeanSquares) {
            for (k = 0; k < t2; ++k) {
                sourcePoint[k][0] = attempt[k][0];
                sourcePoint[k][1] = attempt[k][1];
            }
        }
    }

    private void inverseMarquardtLevenbergRigidBodyOptimization(double[][] sourcePoint, double[][] targetPoint) {
        int i;
        double s;
        double c;
        double angle;
        double displacement;
        int k;
        double[][] attempt = new double[2][3];
        double[][] hessian = new double[this.transformation][this.transformation];
        double[][] pseudoHessian = new double[this.transformation][this.transformation];
        double[] gradient = new double[this.transformation];
        double[][] matrix = this.getTransformationMatrix(targetPoint, sourcePoint);
        double[] update = new double[this.transformation];
        double bestMeanSquares = 0.0;
        double meanSquares = 0.0;
        double lambda = 1.0;
        int iteration = 0;
        for (k = 0; k < this.transformation; ++k) {
            sourcePoint[k][0] = matrix[0][0] + targetPoint[k][0] * matrix[0][1] + targetPoint[k][1] * matrix[0][2];
            sourcePoint[k][1] = matrix[1][0] + targetPoint[k][0] * matrix[1][1] + targetPoint[k][1] * matrix[1][2];
        }
        matrix = this.getTransformationMatrix(sourcePoint, targetPoint);
        bestMeanSquares = this.getRigidBodyMeanSquares(matrix, hessian, gradient);
        ++iteration;
        do {
            for (k = 0; k < this.transformation; ++k) {
                pseudoHessian[k][k] = (1.0 + lambda) * hessian[k][k];
            }
            this.invertGauss(pseudoHessian);
            update = this.matrixMultiply(pseudoHessian, gradient);
            angle = Math.atan2(matrix[0][2], matrix[0][1]) - update[0];
            attempt[0][1] = Math.cos(angle);
            attempt[0][2] = Math.sin(angle);
            attempt[1][1] = -attempt[0][2];
            attempt[1][2] = attempt[0][1];
            c = Math.cos(update[0]);
            s = Math.sin(update[0]);
            attempt[0][0] = (matrix[0][0] + update[1]) * c - (matrix[1][0] + update[2]) * s;
            attempt[1][0] = (matrix[0][0] + update[1]) * s + (matrix[1][0] + update[2]) * c;
            displacement = Math.sqrt(update[1] * update[1] + update[2] * update[2]) + 0.25 * Math.sqrt((double)(this.inNx * this.inNx) + (double)(this.inNy * this.inNy)) * Math.abs(update[0]);
            meanSquares = this.accelerated ? this.getRigidBodyMeanSquares(attempt, gradient) : this.getRigidBodyMeanSquares(attempt, hessian, gradient);
            ++iteration;
            if (meanSquares < bestMeanSquares) {
                bestMeanSquares = meanSquares;
                for (i = 0; i < 2; ++i) {
                    System.arraycopy(attempt[i], 0, matrix[i], 0, 3);
                }
                lambda /= 4.0;
                continue;
            }
            lambda *= 4.0;
        } while (iteration < this.maxIterations * this.iterationPower - 1 && this.pixelPrecision <= displacement);
        this.invertGauss(hessian);
        update = this.matrixMultiply(hessian, gradient);
        angle = Math.atan2(matrix[0][2], matrix[0][1]) - update[0];
        attempt[0][1] = Math.cos(angle);
        attempt[0][2] = Math.sin(angle);
        attempt[1][1] = -attempt[0][2];
        attempt[1][2] = attempt[0][1];
        c = Math.cos(update[0]);
        s = Math.sin(update[0]);
        attempt[0][0] = (matrix[0][0] + update[1]) * c - (matrix[1][0] + update[2]) * s;
        attempt[1][0] = (matrix[0][0] + update[1]) * s + (matrix[1][0] + update[2]) * c;
        meanSquares = this.getRigidBodyMeanSquares(attempt);
        ++iteration;
        if (meanSquares < bestMeanSquares) {
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    matrix[i][j] = attempt[i][j];
                }
            }
        }
        for (k = 0; k < this.transformation; ++k) {
            sourcePoint[k][0] = (targetPoint[k][0] - matrix[0][0]) * matrix[0][1] + (targetPoint[k][1] - matrix[1][0]) * matrix[1][1];
            sourcePoint[k][1] = (targetPoint[k][0] - matrix[0][0]) * matrix[0][2] + (targetPoint[k][1] - matrix[1][0]) * matrix[1][2];
        }
    }

    private void invertGauss(double[][] matrix) {
        int j;
        double absMax;
        double max;
        int i;
        int n = matrix.length;
        double[][] inverse = new double[n][n];
        for (i = 0; i < n; ++i) {
            int j2;
            max = matrix[i][0];
            absMax = Math.abs(max);
            for (j2 = 0; j2 < n; ++j2) {
                inverse[i][j2] = 0.0;
                if (!(absMax < Math.abs(matrix[i][j2]))) continue;
                max = matrix[i][j2];
                absMax = Math.abs(max);
            }
            inverse[i][i] = 1.0 / max;
            j2 = 0;
            while (j2 < n) {
                double[] dArray = matrix[i];
                int n2 = j2++;
                dArray[n2] = dArray[n2] / max;
            }
        }
        for (j = 0; j < n; ++j) {
            int i2;
            max = matrix[j][j];
            absMax = Math.abs(max);
            int k = j;
            for (i2 = j + 1; i2 < n; ++i2) {
                if (!(absMax < Math.abs(matrix[i2][j]))) continue;
                max = matrix[i2][j];
                absMax = Math.abs(max);
                k = i2;
            }
            if (k != j) {
                double[] partialLine = new double[n - j];
                double[] fullLine = new double[n];
                System.arraycopy(matrix[j], j, partialLine, 0, n - j);
                System.arraycopy(matrix[k], j, matrix[j], j, n - j);
                System.arraycopy(partialLine, 0, matrix[k], j, n - j);
                System.arraycopy(inverse[j], 0, fullLine, 0, n);
                System.arraycopy(inverse[k], 0, inverse[j], 0, n);
                System.arraycopy(fullLine, 0, inverse[k], 0, n);
            }
            k = 0;
            while (k <= j) {
                double[] dArray = inverse[j];
                int n3 = k++;
                dArray[n3] = dArray[n3] / max;
            }
            k = j + 1;
            while (k < n) {
                double[] dArray = matrix[j];
                int n4 = k;
                dArray[n4] = dArray[n4] / max;
                double[] dArray2 = inverse[j];
                int n5 = k++;
                dArray2[n5] = dArray2[n5] / max;
            }
            for (i2 = j + 1; i2 < n; ++i2) {
                for (k = 0; k <= j; ++k) {
                    double[] dArray = inverse[i2];
                    int n6 = k;
                    dArray[n6] = dArray[n6] - matrix[i2][j] * inverse[j][k];
                }
                for (k = j + 1; k < n; ++k) {
                    double[] dArray = matrix[i2];
                    int n7 = k;
                    dArray[n7] = dArray[n7] - matrix[i2][j] * matrix[j][k];
                    double[] dArray3 = inverse[i2];
                    int n8 = k;
                    dArray3[n8] = dArray3[n8] - matrix[i2][j] * inverse[j][k];
                }
            }
        }
        for (j = n - 1; 1 <= j; --j) {
            for (int i3 = j - 1; 0 <= i3; --i3) {
                int k;
                for (k = 0; k <= j; ++k) {
                    double[] dArray = inverse[i3];
                    int n9 = k;
                    dArray[n9] = dArray[n9] - matrix[i3][j] * inverse[j][k];
                }
                for (k = j + 1; k < n; ++k) {
                    double[] dArray = matrix[i3];
                    int n10 = k;
                    dArray[n10] = dArray[n10] - matrix[i3][j] * matrix[j][k];
                    double[] dArray4 = inverse[i3];
                    int n11 = k;
                    dArray4[n11] = dArray4[n11] - matrix[i3][j] * inverse[j][k];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            System.arraycopy(inverse[i], 0, matrix[i], 0, n);
        }
    }

    private void marquardtLevenbergOptimization(double[][] sourcePoint, double[][] targetPoint) {
        int k;
        double displacement;
        int t2 = this.transformation >> 1;
        double[][] attempt = new double[t2][2];
        double[][] hessian = new double[this.transformation][this.transformation];
        double[][] pseudoHessian = new double[this.transformation][this.transformation];
        double[] gradient = new double[this.transformation];
        double[][] matrix = this.getTransformationMatrix(targetPoint, sourcePoint);
        double[] update = new double[this.transformation];
        double bestMeanSquares = 0.0;
        double meanSquares = 0.0;
        double lambda = 1.0;
        int iteration = 1;
        bestMeanSquares = this.getBilinearMeanSquares(matrix, hessian, gradient, sourcePoint, targetPoint);
        do {
            for (k = 0; k < this.transformation; ++k) {
                pseudoHessian[k][k] = (1.0 + lambda) * hessian[k][k];
            }
            this.invertGauss(pseudoHessian);
            update = this.matrixMultiply(pseudoHessian, gradient);
            displacement = 0.0;
            k = 0;
            int k2 = 0;
            while (k < t2) {
                attempt[k][0] = sourcePoint[k][0] - update[k2];
                attempt[k][1] = sourcePoint[k][1] - update[k2 + 1];
                displacement += Math.sqrt(update[k2] * update[k2] + update[k2 + 1] * update[k2 + 1]);
                ++k;
                k2 += 2;
            }
            displacement /= 0.5 * (double)this.transformation;
            matrix = this.getTransformationMatrix(targetPoint, attempt);
            meanSquares = this.getBilinearMeanSquares(matrix, hessian, gradient, sourcePoint, targetPoint);
            ++iteration;
            if (meanSquares < bestMeanSquares) {
                bestMeanSquares = meanSquares;
                for (k = 0; k < t2; ++k) {
                    sourcePoint[k][0] = attempt[k][0];
                    sourcePoint[k][1] = attempt[k][1];
                }
                lambda /= 4.0;
                continue;
            }
            lambda *= 4.0;
        } while (iteration < this.maxIterations * this.iterationPower - 1 && this.pixelPrecision <= displacement);
        this.invertGauss(hessian);
        update = this.matrixMultiply(hessian, gradient);
        for (k = 0; k < t2; ++k) {
            attempt[k][0] = sourcePoint[k][0] - update[k << 1];
            attempt[k][1] = sourcePoint[k][1] - update[(k << 1) + 1];
        }
        matrix = this.getTransformationMatrix(targetPoint, attempt);
        meanSquares = this.getBilinearMeanSquares(matrix);
        ++iteration;
        if (meanSquares < bestMeanSquares) {
            for (k = 0; k < t2; ++k) {
                sourcePoint[k][0] = attempt[k][0];
                sourcePoint[k][1] = attempt[k][1];
            }
        }
    }

    private double[] matrixMultiply(double[][] matrix, double[] vector) {
        double[] result = new double[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            result[i] = 0.0;
            for (int j = 0; j < vector.length; ++j) {
                int n = i;
                result[n] = result[n] + matrix[i][j] * vector[j];
            }
        }
        return result;
    }

    private void scaleBottomDownLandmarks(double[][] sourcePoint, double[][] targetPoint) {
        for (int depth = 1; depth < this.pyramidDepth; ++depth) {
            if (this.transformation == 3) {
                for (int n = 0; n < this.transformation; ++n) {
                    double[] dArray = sourcePoint[n];
                    dArray[0] = dArray[0] * 0.5;
                    double[] dArray2 = sourcePoint[n];
                    dArray2[1] = dArray2[1] * 0.5;
                    double[] dArray3 = targetPoint[n];
                    dArray3[0] = dArray3[0] * 0.5;
                    double[] dArray4 = targetPoint[n];
                    dArray4[1] = dArray4[1] * 0.5;
                }
                continue;
            }
            int t2 = this.transformation >> 1;
            for (int n = 0; n < t2; ++n) {
                double[] dArray = sourcePoint[n];
                dArray[0] = dArray[0] * 0.5;
                double[] dArray5 = sourcePoint[n];
                dArray5[1] = dArray5[1] * 0.5;
                double[] dArray6 = targetPoint[n];
                dArray6[0] = dArray6[0] * 0.5;
                double[] dArray7 = targetPoint[n];
                dArray7[1] = dArray7[1] * 0.5;
            }
        }
    }

    private void scaleUpLandmarks(double[][] sourcePoint, double[][] targetPoint) {
        if (this.transformation == 3) {
            for (int n = 0; n < this.transformation; ++n) {
                double[] dArray = sourcePoint[n];
                dArray[0] = dArray[0] * 2.0;
                double[] dArray2 = sourcePoint[n];
                dArray2[1] = dArray2[1] * 2.0;
                double[] dArray3 = targetPoint[n];
                dArray3[0] = dArray3[0] * 2.0;
                double[] dArray4 = targetPoint[n];
                dArray4[1] = dArray4[1] * 2.0;
            }
        } else {
            int t2 = this.transformation >> 1;
            for (int n = 0; n < t2; ++n) {
                double[] dArray = sourcePoint[n];
                dArray[0] = dArray[0] * 2.0;
                double[] dArray5 = sourcePoint[n];
                dArray5[1] = dArray5[1] * 2.0;
                double[] dArray6 = targetPoint[n];
                dArray6[0] = dArray6[0] * 2.0;
                double[] dArray7 = targetPoint[n];
                dArray7[1] = dArray7[1] * 2.0;
            }
        }
    }

    private void translationTransform(double[][] matrix) {
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double x = dx - Math.floor(dx);
        double y = dy - Math.floor(dy);
        if (!this.accelerated) {
            this.xyWeights(x, xWeight);
            this.xyWeights(y, yWeight);
        }
        int k = 0;
        for (int v = 0; v < this.outNy; ++v) {
            int u;
            int yMsk;
            dy += 1.0;
            int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
            if (0 <= yMsk && yMsk < this.inNy) {
                yMsk *= this.inNx;
                if (!this.accelerated) {
                    this.yIndexes(y, yIndex);
                }
                dx = dx0;
                for (u = 0; u < this.outNx; ++u) {
                    int xMsk;
                    dx += 1.0;
                    int n2 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx) {
                        xMsk += yMsk;
                        if (this.accelerated) {
                            this.outImg[k++] = this.inImg[xMsk];
                            continue;
                        }
                        this.xIndexes(x, xIndex);
                        this.outImg[k++] = (float)this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        continue;
                    }
                    this.outImg[k++] = 0.0f;
                }
                continue;
            }
            for (u = 0; u < this.outNx; ++u) {
                this.outImg[k++] = 0.0f;
            }
        }
    }

    private void translationTransform(double[][] matrix, float[] outMsk) {
        double dx = matrix[0][0];
        double dy = matrix[1][0];
        double dx0 = dx;
        double[] xWeight = new double[4];
        double[] yWeight = new double[4];
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double x = dx - Math.floor(dx);
        double y = dy - Math.floor(dy);
        if (!this.accelerated) {
            this.xyWeights(x, xWeight);
            this.xyWeights(y, yWeight);
        }
        int k = 0;
        for (int v = 0; v < this.outNy; ++v) {
            int u;
            int yMsk;
            dy += 1.0;
            int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
            if (0 <= yMsk && yMsk < this.inNy) {
                yMsk *= this.inNx;
                if (!this.accelerated) {
                    this.yIndexes(y, yIndex);
                }
                dx = dx0;
                u = 0;
                while (u < this.outNx) {
                    int xMsk;
                    dx += 1.0;
                    int n2 = xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                    if (0 <= xMsk && xMsk < this.inNx) {
                        xMsk += yMsk;
                        if (this.accelerated) {
                            this.outImg[k] = this.inImg[xMsk];
                        } else {
                            this.xIndexes(x, xIndex);
                            this.outImg[k] = (float)this.Interpolate(this.inImg, xIndex, yIndex, xWeight, yWeight);
                        }
                        outMsk[k] = this.inMsk[xMsk];
                    } else {
                        this.outImg[k] = 0.0f;
                        outMsk[k] = 0.0f;
                    }
                    ++u;
                    ++k;
                }
                continue;
            }
            u = 0;
            while (u < this.outNx) {
                this.outImg[k] = 0.0f;
                outMsk[k] = 0.0f;
                ++u;
                ++k;
            }
        }
    }

    private void xyDxyWeights(double x, double[] Weight, double[] dWeight) {
        double s = 1.0 - x;
        dWeight[0] = 0.5 * x * x;
        Weight[0] = x * dWeight[0] / 3.0;
        dWeight[3] = -0.5 * s * s;
        Weight[3] = s * dWeight[3] / -3.0;
        dWeight[1] = 1.0 - 2.0 * dWeight[0] + dWeight[3];
        Weight[1] = 0.6666666666666666 + (1.0 + x) * dWeight[3];
        dWeight[2] = 1.5 * x * (x - 1.3333333333333333);
        Weight[2] = 0.6666666666666666 - (2.0 - x) * dWeight[0];
    }

    private void xIndexes(double x, int[] Index) {
        int p = 0.0 <= x ? (int)x + 2 : (int)x + 1;
        for (int k = 0; k < 4; ++k) {
            int q;
            int n = q = p < 0 ? -1 - p : p;
            if (this.twiceInNx <= q) {
                q -= this.twiceInNx * (q / this.twiceInNx);
            }
            Index[k] = this.inNx <= q ? this.twiceInNx - 1 - q : q;
            --p;
        }
    }

    private void yIndexes(double y, int[] Index) {
        int p = 0.0 <= y ? (int)y + 2 : (int)y + 1;
        for (int k = 0; k < 4; ++k) {
            int q;
            int n = q = p < 0 ? -1 - p : p;
            if (this.twiceInNy <= q) {
                q -= this.twiceInNy * (q / this.twiceInNy);
            }
            Index[k] = this.inNy <= q ? (this.twiceInNy - 1 - q) * this.inNx : q * this.inNx;
            --p;
        }
    }

    private void xyWeights(double x, double[] Weight) {
        double s = 1.0 - x;
        Weight[3] = s * s * s / 6.0;
        s = x * x;
        Weight[2] = 0.6666666666666666 - 0.5 * s * (2.0 - x);
        Weight[0] = s * x / 6.0;
        Weight[1] = 1.0 - Weight[0] - Weight[2] - Weight[3];
    }

    protected synchronized void addFreeAffineTransformThread() {
        ++this.nbFreeAffineTransformThreads;
        this.notify();
    }

    protected synchronized void addFreeAffineMeanSquaresThread() {
        ++this.nbFreeAMSThreads;
        this.notify();
    }

    protected synchronized void addFreeAffineMeanSquares2Thread() {
        ++this.nbFreeAMS2Threads;
        this.notify();
    }

    private class AffineMeanSquares2Thread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private int min;
        private int max;
        private double[][] matrix;
        public double meanSquares;
        public long area;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.matrix = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max, double[][] matrix) {
            this.min = min;
            this.max = max;
            this.matrix = matrix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double[] xWeight = new double[4];
            double[] yWeight = new double[4];
            int[] xIndex = new int[4];
            int[] yIndex = new int[4];
            int k = 0;
            while (!this.isInterrupted()) {
                double difference;
                int yMsk;
                int xMsk;
                double y;
                double x;
                int u;
                double y0;
                double x0;
                int v;
                double yy;
                double yx;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegTransform.this.addFreeAffineMeanSquares2Thread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                float[] inimg = TurboRegTransform.this.inImg;
                int innx = TurboRegTransform.this.inNx;
                int inny = TurboRegTransform.this.inNy;
                float[] outimg = TurboRegTransform.this.outImg;
                int outnx = TurboRegTransform.this.outNx;
                float[] inmsk = TurboRegTransform.this.inMsk;
                float[] outmsk = TurboRegTransform.this.outMsk;
                double mat00 = this.matrix[0][0];
                double mat01 = this.matrix[0][1];
                double mat02 = this.matrix[0][2];
                double mat10 = this.matrix[1][0];
                double mat11 = this.matrix[1][1];
                double mat12 = this.matrix[1][2];
                this.meanSquares = 0.0;
                this.area = 0L;
                if (outmsk == null) {
                    yx = mat00 + (double)this.min * mat02;
                    yy = mat10 + (double)this.min * mat12;
                    k = this.min * innx;
                    for (v = this.min; v < this.max; ++v) {
                        x0 = yx;
                        y0 = yy;
                        u = 0;
                        while (u < outnx) {
                            x = x0;
                            y = y0;
                            xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                            int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                            if (0 <= xMsk && xMsk < innx && 0 <= yMsk && yMsk < inny && inmsk[yMsk * innx + xMsk] != 0.0f) {
                                ++this.area;
                                this.xIndexesIn(x, xIndex);
                                this.yIndexesIn(y, yIndex);
                                double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                                this.xyWeightsIn(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                                this.xyWeightsIn(y -= d, yWeight);
                                difference = (double)outimg[k] - this.InterpolateIn(inimg, xIndex, yIndex, xWeight, yWeight);
                                this.meanSquares += difference * difference;
                            }
                            x0 += mat01;
                            y0 += mat11;
                            ++u;
                            ++k;
                        }
                        yx += mat02;
                        yy += mat12;
                    }
                } else {
                    yx = mat00 + (double)this.min * mat02;
                    yy = mat10 + (double)this.min * mat12;
                    k = this.min * innx;
                    for (v = this.min; v < this.max; ++v) {
                        x0 = yx;
                        y0 = yy;
                        u = 0;
                        while (u < outnx) {
                            x = x0;
                            y = y0;
                            xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                            int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                            if (0 <= xMsk && xMsk < innx && 0 <= yMsk && yMsk < inny && outmsk[k] * inmsk[yMsk * innx + xMsk] != 0.0f) {
                                ++this.area;
                                this.xIndexesIn(x, xIndex);
                                this.yIndexesIn(y, yIndex);
                                double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                                this.xyWeightsIn(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                                this.xyWeightsIn(y -= d, yWeight);
                                difference = (double)outimg[k] - this.InterpolateIn(inimg, xIndex, yIndex, xWeight, yWeight);
                                this.meanSquares += difference * difference;
                            }
                            x0 += mat01;
                            y0 += mat11;
                            ++u;
                            ++k;
                        }
                        yx += mat02;
                        yy += mat12;
                    }
                }
                outmsk = null;
                inmsk = null;
                outimg = null;
                inimg = null;
            }
        }

        private void xIndexesIn(double x, int[] Index) {
            int p = 0.0 <= x ? (int)x + 2 : (int)x + 1;
            for (int k = 0; k < 4; ++k) {
                int q;
                int n = q = p < 0 ? -1 - p : p;
                if (TurboRegTransform.this.twiceInNx <= q) {
                    q -= TurboRegTransform.this.twiceInNx * (q / TurboRegTransform.this.twiceInNx);
                }
                Index[k] = TurboRegTransform.this.inNx <= q ? TurboRegTransform.this.twiceInNx - 1 - q : q;
                --p;
            }
        }

        private void yIndexesIn(double y, int[] Index) {
            int p = 0.0 <= y ? (int)y + 2 : (int)y + 1;
            for (int k = 0; k < 4; ++k) {
                int q;
                int n = q = p < 0 ? -1 - p : p;
                if (TurboRegTransform.this.twiceInNy <= q) {
                    q -= TurboRegTransform.this.twiceInNy * (q / TurboRegTransform.this.twiceInNy);
                }
                Index[k] = TurboRegTransform.this.inNy <= q ? (TurboRegTransform.this.twiceInNy - 1 - q) * TurboRegTransform.this.inNx : q * TurboRegTransform.this.inNx;
                --p;
            }
        }

        private void xyWeightsIn(double x, double[] Weight) {
            double s = 1.0 - x;
            Weight[3] = s * s * s / 6.0;
            s = x * x;
            Weight[2] = 0.6666666666666666 - 0.5 * s * (2.0 - x);
            Weight[0] = s * x / 6.0;
            Weight[1] = 1.0 - Weight[0] - Weight[2] - Weight[3];
        }

        private double InterpolateIn(float[] inImg, int[] xIndex, int[] yIndex, double[] xWeight, double[] yWeight) {
            double t = 0.0;
            for (int j = 0; j < 4; ++j) {
                double s = 0.0;
                int p = yIndex[j];
                for (int i = 0; i < 4; ++i) {
                    s += xWeight[i] * (double)inImg[p + xIndex[i]];
                }
                t += yWeight[j] * s;
            }
            return t;
        }
    }

    private class AffineMeanSquaresThread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private int min;
        private int max;
        private double[][] sourcePoint;
        private double[][] matrix;
        private double[][] hessian;
        private double[] gradient;
        public double meanSquares;
        public long area;
        public double den;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.hessian = null;
            this.matrix = null;
            this.sourcePoint = null;
            this.gradient = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max, double[][] sourcePoint, double[][] matrix, double[][] hessian, double[] gradient) {
            this.min = min;
            this.max = max;
            this.sourcePoint = sourcePoint;
            this.matrix = matrix;
            if (this.hessian == null || this.hessian.length != hessian.length || this.hessian[0].length != hessian[0].length) {
                this.hessian = new double[hessian.length][hessian[0].length];
            }
            if (this.gradient == null || this.gradient.length != gradient.length) {
                this.gradient = new double[gradient.length];
            }
            for (int i = 0; i < TurboRegTransform.this.transformation; ++i) {
                Arrays.fill(this.hessian[i], 0, TurboRegTransform.this.transformation, 0.0);
            }
            Arrays.fill(this.gradient, 0.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double[] xWeight = new double[4];
            double[] yWeight = new double[4];
            int[] xIndex = new int[4];
            int[] yIndex = new int[4];
            while (!this.isInterrupted()) {
                double dy2;
                double dx2;
                double dy1;
                double dx1;
                double dy0;
                double dx0;
                double g2;
                double g1;
                double g0;
                double difference;
                int yMsk;
                int xMsk;
                double y;
                double x;
                int u;
                double y0;
                double x0;
                int v;
                int k;
                double yy;
                double yx;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegTransform.this.addFreeAffineMeanSquaresThread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                float[] inimg = TurboRegTransform.this.inImg;
                int innx = TurboRegTransform.this.inNx;
                int inny = TurboRegTransform.this.inNy;
                float[] outimg = TurboRegTransform.this.outImg;
                int outnx = TurboRegTransform.this.outNx;
                float[] inmsk = TurboRegTransform.this.inMsk;
                float[] outmsk = TurboRegTransform.this.outMsk;
                double mat00 = this.matrix[0][0];
                double mat01 = this.matrix[0][1];
                double mat02 = this.matrix[0][2];
                double mat10 = this.matrix[1][0];
                double mat11 = this.matrix[1][1];
                double mat12 = this.matrix[1][2];
                double u1 = this.sourcePoint[0][0];
                double u2 = this.sourcePoint[1][0];
                double u3 = this.sourcePoint[2][0];
                double v1 = this.sourcePoint[0][1];
                double v2 = this.sourcePoint[1][1];
                double v3 = this.sourcePoint[2][1];
                double uv32 = u3 * v2 - u2 * v3;
                double uv21 = u2 * v1 - u1 * v2;
                double uv13 = u1 * v3 - u3 * v1;
                double det = uv32 + uv21 + uv13;
                double u12 = (u1 - u2) / det;
                double u23 = (u2 - u3) / det;
                double u31 = (u3 - u1) / det;
                double v12 = (v1 - v2) / det;
                double v23 = (v2 - v3) / det;
                double v31 = (v3 - v1) / det;
                uv32 /= det;
                uv21 /= det;
                uv13 /= det;
                this.meanSquares = 0.0;
                this.area = 0L;
                if (outmsk == null) {
                    yx = mat00 + (double)this.min * mat02;
                    yy = mat10 + (double)this.min * mat12;
                    k = this.min * innx;
                    for (v = this.min; v < this.max; ++v) {
                        x0 = yx;
                        y0 = yy;
                        u = 0;
                        while (u < outnx) {
                            x = x0;
                            y = y0;
                            xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                            int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                            if (0 <= xMsk && xMsk < innx && 0 <= yMsk && yMsk < inny && inmsk[yMsk * innx + xMsk] != 0.0f) {
                                ++this.area;
                                this.xIndexesIn(x, xIndex);
                                this.yIndexesIn(y, yIndex);
                                double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                                this.xyWeightsIn(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                                this.xyWeightsIn(y -= d, yWeight);
                                difference = (double)outimg[k] - this.InterpolateIn(inimg, xIndex, yIndex, xWeight, yWeight);
                                this.meanSquares += difference * difference;
                                g0 = u23 * (double)v - v23 * (double)u + uv32;
                                g1 = u31 * (double)v - v31 * (double)u + uv13;
                                g2 = u12 * (double)v - v12 * (double)u + uv21;
                                dx0 = (double)TurboRegTransform.this.xGradient[k] * g0;
                                dy0 = (double)TurboRegTransform.this.yGradient[k] * g0;
                                dx1 = (double)TurboRegTransform.this.xGradient[k] * g1;
                                dy1 = (double)TurboRegTransform.this.yGradient[k] * g1;
                                dx2 = (double)TurboRegTransform.this.xGradient[k] * g2;
                                dy2 = (double)TurboRegTransform.this.yGradient[k] * g2;
                                this.gradient[0] = this.gradient[0] + difference * dx0;
                                this.gradient[1] = this.gradient[1] + difference * dy0;
                                this.gradient[2] = this.gradient[2] + difference * dx1;
                                this.gradient[3] = this.gradient[3] + difference * dy1;
                                this.gradient[4] = this.gradient[4] + difference * dx2;
                                this.gradient[5] = this.gradient[5] + difference * dy2;
                                double[] dArray = this.hessian[0];
                                dArray[0] = dArray[0] + dx0 * dx0;
                                double[] dArray2 = this.hessian[0];
                                dArray2[1] = dArray2[1] + dx0 * dy0;
                                double[] dArray3 = this.hessian[0];
                                dArray3[2] = dArray3[2] + dx0 * dx1;
                                double[] dArray4 = this.hessian[0];
                                dArray4[3] = dArray4[3] + dx0 * dy1;
                                double[] dArray5 = this.hessian[0];
                                dArray5[4] = dArray5[4] + dx0 * dx2;
                                double[] dArray6 = this.hessian[0];
                                dArray6[5] = dArray6[5] + dx0 * dy2;
                                double[] dArray7 = this.hessian[1];
                                dArray7[1] = dArray7[1] + dy0 * dy0;
                                double[] dArray8 = this.hessian[1];
                                dArray8[2] = dArray8[2] + dy0 * dx1;
                                double[] dArray9 = this.hessian[1];
                                dArray9[3] = dArray9[3] + dy0 * dy1;
                                double[] dArray10 = this.hessian[1];
                                dArray10[4] = dArray10[4] + dy0 * dx2;
                                double[] dArray11 = this.hessian[1];
                                dArray11[5] = dArray11[5] + dy0 * dy2;
                                double[] dArray12 = this.hessian[2];
                                dArray12[2] = dArray12[2] + dx1 * dx1;
                                double[] dArray13 = this.hessian[2];
                                dArray13[3] = dArray13[3] + dx1 * dy1;
                                double[] dArray14 = this.hessian[2];
                                dArray14[4] = dArray14[4] + dx1 * dx2;
                                double[] dArray15 = this.hessian[2];
                                dArray15[5] = dArray15[5] + dx1 * dy2;
                                double[] dArray16 = this.hessian[3];
                                dArray16[3] = dArray16[3] + dy1 * dy1;
                                double[] dArray17 = this.hessian[3];
                                dArray17[4] = dArray17[4] + dy1 * dx2;
                                double[] dArray18 = this.hessian[3];
                                dArray18[5] = dArray18[5] + dy1 * dy2;
                                double[] dArray19 = this.hessian[4];
                                dArray19[4] = dArray19[4] + dx2 * dx2;
                                double[] dArray20 = this.hessian[4];
                                dArray20[5] = dArray20[5] + dx2 * dy2;
                                double[] dArray21 = this.hessian[5];
                                dArray21[5] = dArray21[5] + dy2 * dy2;
                            }
                            x0 += mat01;
                            y0 += mat11;
                            ++u;
                            ++k;
                        }
                        yx += mat02;
                        yy += mat12;
                    }
                } else {
                    yx = mat00 + (double)this.min * mat02;
                    yy = mat10 + (double)this.min * mat12;
                    k = this.min * innx;
                    for (v = this.min; v < this.max; ++v) {
                        x0 = yx;
                        y0 = yy;
                        u = 0;
                        while (u < outnx) {
                            x = x0;
                            y = y0;
                            xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                            int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                            if (0 <= xMsk && xMsk < innx && 0 <= yMsk && yMsk < inny && outmsk[k] * inmsk[yMsk * innx + xMsk] != 0.0f) {
                                ++this.area;
                                this.xIndexesIn(x, xIndex);
                                this.yIndexesIn(y, yIndex);
                                double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                                this.xyWeightsIn(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                                this.xyWeightsIn(y -= d, yWeight);
                                difference = (double)outimg[k] - this.InterpolateIn(inimg, xIndex, yIndex, xWeight, yWeight);
                                this.meanSquares += difference * difference;
                                g0 = u23 * (double)v - v23 * (double)u + uv32;
                                g1 = u31 * (double)v - v31 * (double)u + uv13;
                                g2 = u12 * (double)v - v12 * (double)u + uv21;
                                dx0 = (double)TurboRegTransform.this.xGradient[k] * g0;
                                dy0 = (double)TurboRegTransform.this.yGradient[k] * g0;
                                dx1 = (double)TurboRegTransform.this.xGradient[k] * g1;
                                dy1 = (double)TurboRegTransform.this.yGradient[k] * g1;
                                dx2 = (double)TurboRegTransform.this.xGradient[k] * g2;
                                dy2 = (double)TurboRegTransform.this.yGradient[k] * g2;
                                this.gradient[0] = this.gradient[0] + difference * dx0;
                                this.gradient[1] = this.gradient[1] + difference * dy0;
                                this.gradient[2] = this.gradient[2] + difference * dx1;
                                this.gradient[3] = this.gradient[3] + difference * dy1;
                                this.gradient[4] = this.gradient[4] + difference * dx2;
                                this.gradient[5] = this.gradient[5] + difference * dy2;
                                double[] dArray = this.hessian[0];
                                dArray[0] = dArray[0] + dx0 * dx0;
                                double[] dArray22 = this.hessian[0];
                                dArray22[1] = dArray22[1] + dx0 * dy0;
                                double[] dArray23 = this.hessian[0];
                                dArray23[2] = dArray23[2] + dx0 * dx1;
                                double[] dArray24 = this.hessian[0];
                                dArray24[3] = dArray24[3] + dx0 * dy1;
                                double[] dArray25 = this.hessian[0];
                                dArray25[4] = dArray25[4] + dx0 * dx2;
                                double[] dArray26 = this.hessian[0];
                                dArray26[5] = dArray26[5] + dx0 * dy2;
                                double[] dArray27 = this.hessian[1];
                                dArray27[1] = dArray27[1] + dy0 * dy0;
                                double[] dArray28 = this.hessian[1];
                                dArray28[2] = dArray28[2] + dy0 * dx1;
                                double[] dArray29 = this.hessian[1];
                                dArray29[3] = dArray29[3] + dy0 * dy1;
                                double[] dArray30 = this.hessian[1];
                                dArray30[4] = dArray30[4] + dy0 * dx2;
                                double[] dArray31 = this.hessian[1];
                                dArray31[5] = dArray31[5] + dy0 * dy2;
                                double[] dArray32 = this.hessian[2];
                                dArray32[2] = dArray32[2] + dx1 * dx1;
                                double[] dArray33 = this.hessian[2];
                                dArray33[3] = dArray33[3] + dx1 * dy1;
                                double[] dArray34 = this.hessian[2];
                                dArray34[4] = dArray34[4] + dx1 * dx2;
                                double[] dArray35 = this.hessian[2];
                                dArray35[5] = dArray35[5] + dx1 * dy2;
                                double[] dArray36 = this.hessian[3];
                                dArray36[3] = dArray36[3] + dy1 * dy1;
                                double[] dArray37 = this.hessian[3];
                                dArray37[4] = dArray37[4] + dy1 * dx2;
                                double[] dArray38 = this.hessian[3];
                                dArray38[5] = dArray38[5] + dy1 * dy2;
                                double[] dArray39 = this.hessian[4];
                                dArray39[4] = dArray39[4] + dx2 * dx2;
                                double[] dArray40 = this.hessian[4];
                                dArray40[5] = dArray40[5] + dx2 * dy2;
                                double[] dArray41 = this.hessian[5];
                                dArray41[5] = dArray41[5] + dy2 * dy2;
                            }
                            x0 += mat01;
                            y0 += mat11;
                            ++u;
                            ++k;
                        }
                        yx += mat02;
                        yy += mat12;
                    }
                }
                this.den = Math.abs(det / TurboRegTransform.this.targetJacobian);
                outmsk = null;
                inmsk = null;
                outimg = null;
                inimg = null;
            }
        }

        private void xIndexesIn(double x, int[] Index) {
            int p = 0.0 <= x ? (int)x + 2 : (int)x + 1;
            for (int k = 0; k < 4; ++k) {
                int q;
                int n = q = p < 0 ? -1 - p : p;
                if (TurboRegTransform.this.twiceInNx <= q) {
                    q -= TurboRegTransform.this.twiceInNx * (q / TurboRegTransform.this.twiceInNx);
                }
                Index[k] = TurboRegTransform.this.inNx <= q ? TurboRegTransform.this.twiceInNx - 1 - q : q;
                --p;
            }
        }

        private void yIndexesIn(double y, int[] Index) {
            int p = 0.0 <= y ? (int)y + 2 : (int)y + 1;
            for (int k = 0; k < 4; ++k) {
                int q;
                int n = q = p < 0 ? -1 - p : p;
                if (TurboRegTransform.this.twiceInNy <= q) {
                    q -= TurboRegTransform.this.twiceInNy * (q / TurboRegTransform.this.twiceInNy);
                }
                Index[k] = TurboRegTransform.this.inNy <= q ? (TurboRegTransform.this.twiceInNy - 1 - q) * TurboRegTransform.this.inNx : q * TurboRegTransform.this.inNx;
                --p;
            }
        }

        private void xyWeightsIn(double x, double[] Weight) {
            double s = 1.0 - x;
            Weight[3] = s * s * s / 6.0;
            s = x * x;
            Weight[2] = 0.6666666666666666 - 0.5 * s * (2.0 - x);
            Weight[0] = s * x / 6.0;
            Weight[1] = 1.0 - Weight[0] - Weight[2] - Weight[3];
        }

        private double InterpolateIn(float[] inImg, int[] xIndex, int[] yIndex, double[] xWeight, double[] yWeight) {
            double t = 0.0;
            for (int j = 0; j < 4; ++j) {
                double s = 0.0;
                int p = yIndex[j];
                for (int i = 0; i < 4; ++i) {
                    s += xWeight[i] * (double)inImg[p + xIndex[i]];
                }
                t += yWeight[j] * s;
            }
            return t;
        }
    }

    private class AffineTransformThread
    extends Thread {
        public Object lock = new Object();
        private boolean Kill = false;
        private float[] outmask = null;
        private int min;
        private int max;
        private double[][] matrix;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            this.matrix = null;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(int min, int max, double[][] matrix, float[] outmask) {
            this.min = min;
            this.max = max;
            this.matrix = matrix;
            this.outmask = outmask;
            if (matrix == null) {
                throw new Error("matrix == null");
            }
            if (outmask == null) {
                throw new Error("outmask == null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double[] xWeight = new double[4];
            double[] yWeight = new double[4];
            int[] xIndex = new int[4];
            int[] yIndex = new int[4];
            int k = 0;
            while (!this.isInterrupted()) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        TurboRegTransform.this.addFreeAffineTransformThread();
                        this.lock.wait();
                        if (this.Kill) {
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                float[] inimg = TurboRegTransform.this.inImg;
                int innx = TurboRegTransform.this.inNx;
                int inny = TurboRegTransform.this.inNy;
                float[] outimg = TurboRegTransform.this.outImg;
                int outnx = TurboRegTransform.this.outNx;
                float[] inmsk = TurboRegTransform.this.inMsk;
                if (inimg == null) {
                    throw new Error("inimg == null");
                }
                if (inmsk == null) {
                    throw new Error("inmsk == null");
                }
                if (outimg == null) {
                    throw new Error("outimg == null");
                }
                double mat00 = this.matrix[0][0];
                double mat01 = this.matrix[0][1];
                double mat02 = this.matrix[0][2];
                double mat10 = this.matrix[1][0];
                double mat11 = this.matrix[1][1];
                double mat12 = this.matrix[1][2];
                double yx = mat00 + (double)this.min * mat02;
                double yy = mat10 + (double)this.min * mat12;
                k = this.min * innx;
                for (int v = this.min; v < this.max; ++v) {
                    double x0 = yx;
                    double y0 = yy;
                    for (int u = 0; u < outnx; ++u) {
                        int yMsk;
                        double x = x0;
                        double y = y0;
                        int xMsk = 0.0 <= x ? (int)(x + 0.5) : (int)(x - 0.5);
                        int n = yMsk = 0.0 <= y ? (int)(y + 0.5) : (int)(y - 0.5);
                        if (0 <= xMsk && xMsk < innx && 0 <= yMsk && yMsk < inny) {
                            xMsk += yMsk * innx;
                            if (TurboRegTransform.this.accelerated) {
                                outimg[k] = inimg[xMsk];
                            } else {
                                this.xIndexesIn(x, xIndex);
                                this.yIndexesIn(y, yIndex);
                                double d = 0.0 <= y ? (double)((int)y) : (double)((int)y - 1);
                                this.xyWeightsIn(x -= 0.0 <= x ? (double)((int)x) : (double)((int)x - 1), xWeight);
                                TurboRegTransform.this.xyWeights(y -= d, yWeight);
                                outimg[k] = (float)this.InterpolateIn(inimg, xIndex, yIndex, xWeight, yWeight);
                            }
                            this.outmask[k++] = inmsk[xMsk];
                        } else {
                            outimg[k] = 0.0f;
                            this.outmask[k++] = 0.0f;
                        }
                        x0 += mat01;
                        y0 += mat11;
                    }
                    yx += mat02;
                    yy += mat12;
                }
                inmsk = null;
                outimg = null;
                inimg = null;
            }
        }

        private void xIndexesIn(double x, int[] Index) {
            int p = 0.0 <= x ? (int)x + 2 : (int)x + 1;
            for (int k = 0; k < 4; ++k) {
                int q;
                int n = q = p < 0 ? -1 - p : p;
                if (TurboRegTransform.this.twiceInNx <= q) {
                    q -= TurboRegTransform.this.twiceInNx * (q / TurboRegTransform.this.twiceInNx);
                }
                Index[k] = TurboRegTransform.this.inNx <= q ? TurboRegTransform.this.twiceInNx - 1 - q : q;
                --p;
            }
        }

        private void yIndexesIn(double y, int[] Index) {
            int p = 0.0 <= y ? (int)y + 2 : (int)y + 1;
            for (int k = 0; k < 4; ++k) {
                int q;
                int n = q = p < 0 ? -1 - p : p;
                if (TurboRegTransform.this.twiceInNy <= q) {
                    q -= TurboRegTransform.this.twiceInNy * (q / TurboRegTransform.this.twiceInNy);
                }
                Index[k] = TurboRegTransform.this.inNy <= q ? (TurboRegTransform.this.twiceInNy - 1 - q) * TurboRegTransform.this.inNx : q * TurboRegTransform.this.inNx;
                --p;
            }
        }

        private void xyWeightsIn(double x, double[] Weight) {
            double s = 1.0 - x;
            Weight[3] = s * s * s / 6.0;
            s = x * x;
            Weight[2] = 0.6666666666666666 - 0.5 * s * (2.0 - x);
            Weight[0] = s * x / 6.0;
            Weight[1] = 1.0 - Weight[0] - Weight[2] - Weight[3];
        }

        private double InterpolateIn(float[] inImg, int[] xIndex, int[] yIndex, double[] xWeight, double[] yWeight) {
            double t = 0.0;
            for (int j = 0; j < 4; ++j) {
                double s = 0.0;
                int p = yIndex[j];
                for (int i = 0; i < 4; ++i) {
                    s += xWeight[i] * (double)inImg[p + xIndex[i]];
                }
                t += yWeight[j] * s;
            }
            return t;
        }
    }
}

