/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;

final class MlibTransposeOpImage
extends GeometricOpImage {
    protected int type;
    protected int src_width;
    protected int src_height;
    protected Rectangle sourceBounds;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int n) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        int n2 = renderedImage.getMinX();
        int n3 = renderedImage.getMinY();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        int n6 = n2 + n4 - 1;
        int n7 = n3 + n5 - 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        switch (n) {
            case 0: {
                n8 = n2;
                n9 = n5 - n7 - 1;
                n10 = n6;
                n11 = n5 - n3 - 1;
                break;
            }
            case 1: {
                n8 = n4 - n6 - 1;
                n9 = n3;
                n10 = n4 - n2 - 1;
                n11 = n7;
                break;
            }
            case 2: {
                n8 = n3;
                n9 = n2;
                n10 = n7;
                n11 = n6;
                break;
            }
            case 3: {
                n8 = n5 - n7 - 1;
                n9 = n4 - n6 - 1;
                n10 = n5 - n3 - 1;
                n11 = n4 - n2 - 1;
                break;
            }
            case 4: {
                n8 = n5 - n7 - 1;
                n9 = n2;
                n10 = n5 - n3 - 1;
                n11 = n6;
                break;
            }
            case 5: {
                n8 = n4 - n6 - 1;
                n9 = n5 - n7 - 1;
                n10 = n4 - n2 - 1;
                n11 = n5 - n3 - 1;
                break;
            }
            case 6: {
                n8 = n3;
                n9 = n4 - n6 - 1;
                n10 = n7;
                n11 = n4 - n2 - 1;
            }
        }
        imageLayout2.setMinX(n8);
        imageLayout2.setMinY(n9);
        imageLayout2.setWidth(n10 - n8 + 1);
        imageLayout2.setHeight(n11 - n9 + 1);
        return imageLayout2;
    }

    public MlibTransposeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n) {
        super(MlibTransposeOpImage.vectorize(renderedImage), MlibTransposeOpImage.layoutHelper(imageLayout, renderedImage, n), map, true, null, null, null);
        this.type = n;
        this.src_width = renderedImage.getWidth();
        this.src_height = renderedImage.getHeight();
        this.sourceBounds = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        return MlibTransposeOpImage.mapRect(rectangle, this.sourceBounds, this.type, true);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = n2 + rectangle.width - 1;
        int n5 = n3 + rectangle.height - 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        switch (this.type) {
            case 0: {
                n6 = n2;
                n7 = this.src_height - n5 - 1;
                n8 = n4;
                n9 = this.src_height - n3 - 1;
                break;
            }
            case 1: {
                n6 = this.src_width - n4 - 1;
                n7 = n3;
                n8 = this.src_width - n2 - 1;
                n9 = n5;
                break;
            }
            case 2: {
                n6 = n3;
                n7 = n2;
                n8 = n5;
                n9 = n4;
                break;
            }
            case 3: {
                n6 = this.src_width - n5 - 1;
                n7 = this.src_height - n4 - 1;
                n8 = this.src_width - n3 - 1;
                n9 = this.src_height - n2 - 1;
                break;
            }
            case 4: {
                n6 = n3;
                n7 = this.src_height - n4 - 1;
                n8 = n5;
                n9 = this.src_height - n2 - 1;
                break;
            }
            case 5: {
                n6 = this.src_width - n4 - 1;
                n7 = this.src_height - n5 - 1;
                n8 = this.src_width - n2 - 1;
                n9 = this.src_height - n3 - 1;
                break;
            }
            case 6: {
                n6 = this.src_width - n5 - 1;
                n7 = n2;
                n8 = this.src_width - n3 - 1;
                n9 = n4;
            }
        }
        return new Rectangle(n6, n7, n8 - n6 + 1, n9 - n7 + 1);
    }

    protected static void mapPoint(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = -1;
        int n9 = -1;
        switch (n5) {
            case 0: {
                n8 = n6;
                n9 = n2 + n4 - n7;
                break;
            }
            case 1: {
                n8 = n + n3 - n6;
                n9 = n7;
                break;
            }
            case 2: {
                n8 = n - n2 + n7;
                n9 = n2 - n + n6;
                break;
            }
            case 3: {
                if (bl) {
                    n8 = n + n4 - n7;
                    n9 = n2 + n3 - n6;
                    break;
                }
                n8 = n2 + n3 - n7;
                n9 = n + n4 - n6;
                break;
            }
            case 4: {
                if (bl) {
                    n8 = n + n4 - n7;
                    n9 = n2 - n + n6;
                    break;
                }
                n8 = n - n2 + n7;
                n9 = n + n4 - n6;
                break;
            }
            case 5: {
                n8 = n + n3 - n6;
                n9 = n2 + n4 - n7;
                break;
            }
            case 6: {
                if (bl) {
                    n8 = n - n2 + n7;
                    n9 = n3 + n2 - n6;
                    break;
                }
                n8 = n3 + n2 - n7;
                n9 = n2 - n + n6;
            }
        }
        nArray[0] = n8;
        nArray[1] = n9;
    }

    private static Rectangle mapRect(Rectangle rectangle, Rectangle rectangle2, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = rectangle2.x;
        int n5 = rectangle2.y;
        int n6 = n4 + rectangle2.width - 1;
        int n7 = n5 + rectangle2.height - 1;
        int[] nArray = new int[]{rectangle.x, rectangle.y};
        MlibTransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        int n8 = n3 = nArray[0];
        int n9 = n2 = nArray[1];
        nArray[0] = rectangle.x + rectangle.width - 1;
        nArray[1] = rectangle.y;
        MlibTransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        n8 = Math.min(n8, nArray[0]);
        n9 = Math.min(n9, nArray[1]);
        n3 = Math.max(n3, nArray[0]);
        n2 = Math.max(n2, nArray[1]);
        nArray[0] = rectangle.x;
        nArray[1] = rectangle.y + rectangle.height - 1;
        MlibTransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        n8 = Math.min(n8, nArray[0]);
        n9 = Math.min(n9, nArray[1]);
        n3 = Math.max(n3, nArray[0]);
        n2 = Math.max(n2, nArray[1]);
        nArray[0] = rectangle.x + rectangle.width - 1;
        nArray[1] = rectangle.y + rectangle.height - 1;
        MlibTransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        n8 = Math.min(n8, nArray[0]);
        n9 = Math.min(n9, nArray[1]);
        n3 = Math.max(n3, nArray[0]);
        n2 = Math.max(n2, nArray[1]);
        return new Rectangle(n8, n9, n3 - n8 + 1, n2 - n9 + 1);
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        PlanarImage planarImage = this.getSourceImage(0);
        Raster[] rasterArray = new Raster[]{planarImage.getData(rectangle3)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        if (planarImage.overlapsMultipleTiles(rectangle3)) {
            this.recycleTile(rasterArray[0]);
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        int n5 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n5);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n5);
        int n6 = this.getSampleModel().getNumBands();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
                switch (this.type) {
                    case 0: {
                        Image.FlipX((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 1: {
                        Image.FlipY((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 2: {
                        Image.FlipMainDiag((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 3: {
                        Image.FlipAntiDiag((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 4: {
                        Image.Rotate90((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 5: {
                        Image.Rotate180((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 6: {
                        Image.Rotate270((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor2.getMediaLibImages();
                switch (this.type) {
                    case 0: {
                        Image.FlipX_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 1: {
                        Image.FlipY_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 2: {
                        Image.FlipMainDiag_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 3: {
                        Image.FlipAntiDiag_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 4: {
                        Image.Rotate90_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 5: {
                        Image.Rotate180_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 6: {
                        Image.Rotate270_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

