/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class PolarToComplexOpImage
extends PointOpImage {
    private double phaseGain = 1.0;
    private double phaseBias = 0.0;

    public PolarToComplexOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        int n = 2 * Math.min(renderedImage.getSampleModel().getNumBands(), renderedImage2.getSampleModel().getNumBands());
        if (this.sampleModel.getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        switch (renderedImage2.getSampleModel().getTransferType()) {
            case 0: {
                this.phaseGain = 0.024639942381096416;
                this.phaseBias = -Math.PI;
                break;
            }
            case 2: {
                this.phaseGain = 1.9175345033660654E-4;
                this.phaseBias = -Math.PI;
                break;
            }
            case 1: {
                this.phaseGain = 9.587526218325454E-5;
                this.phaseBias = -Math.PI;
                break;
            }
            case 3: {
                this.phaseGain = 2.925836159896768E-9;
                this.phaseBias = -Math.PI;
                break;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("PolarToComplexOpImage0"));
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            double[] dArray = rasterAccessor3.getDoubleDataArray(n10);
            double[] dArray2 = rasterAccessor3.getDoubleDataArray(n11);
            double[] dArray3 = rasterAccessor.getDoubleDataArray(i);
            double[] dArray4 = rasterAccessor2.getDoubleDataArray(i);
            int n12 = rasterAccessor3.getBandOffset(n10);
            int n13 = rasterAccessor3.getBandOffset(n11);
            int n14 = rasterAccessor.getBandOffset(i);
            int n15 = rasterAccessor2.getBandOffset(i);
            int n16 = n12;
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            for (int j = 0; j < n; ++j) {
                int n20 = n16;
                int n21 = n17;
                int n22 = n18;
                int n23 = n19;
                for (int k = 0; k < n2; ++k) {
                    double d = dArray3[n22];
                    double d2 = dArray4[n23] * this.phaseGain + this.phaseBias;
                    dArray[n20] = d * Math.cos(d2);
                    dArray2[n21] = d * Math.sin(d2);
                    n20 += n3;
                    n21 += n3;
                    n22 += n5;
                    n23 += n7;
                }
                n16 += n4;
                n17 += n4;
                n18 += n6;
                n19 += n8;
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            float[] fArray = rasterAccessor3.getFloatDataArray(n10);
            float[] fArray2 = rasterAccessor3.getFloatDataArray(n11);
            float[] fArray3 = rasterAccessor.getFloatDataArray(i);
            float[] fArray4 = rasterAccessor2.getFloatDataArray(i);
            int n12 = rasterAccessor3.getBandOffset(n10);
            int n13 = rasterAccessor3.getBandOffset(n11);
            int n14 = rasterAccessor.getBandOffset(i);
            int n15 = rasterAccessor2.getBandOffset(i);
            int n16 = n12;
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            for (int j = 0; j < n; ++j) {
                int n20 = n16;
                int n21 = n17;
                int n22 = n18;
                int n23 = n19;
                for (int k = 0; k < n2; ++k) {
                    double d = fArray3[n22];
                    double d2 = (double)fArray4[n23] * this.phaseGain + this.phaseBias;
                    fArray[n20] = ImageUtil.clampFloat(d * Math.cos(d2));
                    fArray2[n21] = ImageUtil.clampFloat(d * Math.sin(d2));
                    n20 += n3;
                    n21 += n3;
                    n22 += n5;
                    n23 += n7;
                }
                n16 += n4;
                n17 += n4;
                n18 += n6;
                n19 += n8;
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            int[] nArray = rasterAccessor3.getIntDataArray(n10);
            int[] nArray2 = rasterAccessor3.getIntDataArray(n11);
            int[] nArray3 = rasterAccessor.getIntDataArray(i);
            int[] nArray4 = rasterAccessor2.getIntDataArray(i);
            int n12 = rasterAccessor3.getBandOffset(n10);
            int n13 = rasterAccessor3.getBandOffset(n11);
            int n14 = rasterAccessor.getBandOffset(i);
            int n15 = rasterAccessor2.getBandOffset(i);
            int n16 = n12;
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            for (int j = 0; j < n; ++j) {
                int n20 = n16;
                int n21 = n17;
                int n22 = n18;
                int n23 = n19;
                for (int k = 0; k < n2; ++k) {
                    double d = nArray3[n22];
                    double d2 = (double)nArray4[n23] * this.phaseGain + this.phaseBias;
                    nArray[n20] = ImageUtil.clampRoundInt(d * Math.cos(d2));
                    nArray2[n21] = ImageUtil.clampRoundInt(d * Math.sin(d2));
                    n20 += n3;
                    n21 += n3;
                    n22 += n5;
                    n23 += n7;
                }
                n16 += n4;
                n17 += n4;
                n18 += n6;
                n19 += n8;
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            short[] sArray = rasterAccessor3.getShortDataArray(n10);
            short[] sArray2 = rasterAccessor3.getShortDataArray(n11);
            short[] sArray3 = rasterAccessor.getShortDataArray(i);
            short[] sArray4 = rasterAccessor2.getShortDataArray(i);
            int n12 = rasterAccessor3.getBandOffset(n10);
            int n13 = rasterAccessor3.getBandOffset(n11);
            int n14 = rasterAccessor.getBandOffset(i);
            int n15 = rasterAccessor2.getBandOffset(i);
            int n16 = n12;
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            for (int j = 0; j < n; ++j) {
                int n20 = n16;
                int n21 = n17;
                int n22 = n18;
                int n23 = n19;
                for (int k = 0; k < n2; ++k) {
                    double d = sArray3[n22] & 0xFFFF;
                    double d2 = (double)(sArray4[n23] & 0xFFFF) * this.phaseGain + this.phaseBias;
                    sArray[n20] = ImageUtil.clampRoundUShort(d * Math.cos(d2));
                    sArray2[n21] = ImageUtil.clampRoundUShort(d * Math.sin(d2));
                    n20 += n3;
                    n21 += n3;
                    n22 += n5;
                    n23 += n7;
                }
                n16 += n4;
                n17 += n4;
                n18 += n6;
                n19 += n8;
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            short[] sArray = rasterAccessor3.getShortDataArray(n10);
            short[] sArray2 = rasterAccessor3.getShortDataArray(n11);
            short[] sArray3 = rasterAccessor.getShortDataArray(i);
            short[] sArray4 = rasterAccessor2.getShortDataArray(i);
            int n12 = rasterAccessor3.getBandOffset(n10);
            int n13 = rasterAccessor3.getBandOffset(n11);
            int n14 = rasterAccessor.getBandOffset(i);
            int n15 = rasterAccessor2.getBandOffset(i);
            int n16 = n12;
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            for (int j = 0; j < n; ++j) {
                int n20 = n16;
                int n21 = n17;
                int n22 = n18;
                int n23 = n19;
                for (int k = 0; k < n2; ++k) {
                    double d = sArray3[n22];
                    double d2 = (double)sArray4[n23] * this.phaseGain + this.phaseBias;
                    sArray[n20] = ImageUtil.clampRoundShort(d * Math.cos(d2));
                    sArray2[n21] = ImageUtil.clampRoundShort(d * Math.sin(d2));
                    n20 += n3;
                    n21 += n3;
                    n22 += n5;
                    n23 += n7;
                }
                n16 += n4;
                n17 += n4;
                n18 += n6;
                n19 += n8;
            }
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            byte[] byArray = rasterAccessor3.getByteDataArray(n10);
            byte[] byArray2 = rasterAccessor3.getByteDataArray(n11);
            byte[] byArray3 = rasterAccessor.getByteDataArray(i);
            byte[] byArray4 = rasterAccessor2.getByteDataArray(i);
            int n12 = rasterAccessor3.getBandOffset(n10);
            int n13 = rasterAccessor3.getBandOffset(n11);
            int n14 = rasterAccessor.getBandOffset(i);
            int n15 = rasterAccessor2.getBandOffset(i);
            int n16 = n12;
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            for (int j = 0; j < n; ++j) {
                int n20 = n16;
                int n21 = n17;
                int n22 = n18;
                int n23 = n19;
                for (int k = 0; k < n2; ++k) {
                    double d = byArray3[n22] & 0xFF;
                    double d2 = (double)(byArray4[n23] & 0xFF) * this.phaseGain + this.phaseBias;
                    byArray[n20] = ImageUtil.clampRoundByte(d * Math.cos(d2));
                    byArray2[n21] = ImageUtil.clampRoundByte(d * Math.sin(d2));
                    n20 += n3;
                    n21 += n3;
                    n22 += n5;
                    n23 += n7;
                }
                n16 += n4;
                n17 += n4;
                n18 += n6;
                n19 += n8;
            }
        }
    }
}

