/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.ScaleOpImage;

final class ScaleNearestBinaryOpImage
extends ScaleOpImage {
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int[] nArray = new int[n5];
        long l = n3;
        long l2 = 1L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l = 2L * l + (l2 *= this.transXRationalDenom);
        l2 *= 2L;
        int n7 = Rational.floor(l *= this.invScaleXRationalNum, l2 *= this.invScaleXRationalDenom);
        long l3 = l % l2;
        if (n7 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleXRationalDenom;
        l3 *= this.invScaleXRationalDenom;
        long l5 = this.invScaleXFrac * l2;
        for (int i = 0; i < n5; ++i) {
            nArray[i] = n7;
            n7 = (int)((long)n7 + this.invScaleXInt);
            if ((l3 += l5) < l4) continue;
            ++n7;
            l3 -= l4;
        }
        int[] nArray2 = new int[n6];
        long l6 = n4;
        long l7 = 1L;
        l6 = l6 * this.transYRationalDenom - this.transYRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transYRationalDenom);
        l7 *= 2L;
        int n8 = Rational.floor(l6 *= this.invScaleYRationalNum, l7 *= this.invScaleYRationalDenom);
        long l8 = l6 % l7;
        if (n8 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleYRationalDenom;
        l8 *= this.invScaleYRationalDenom;
        long l10 = this.invScaleYFrac * l7;
        for (int i = 0; i < n6; ++i) {
            nArray2[i] = n8;
            n8 = (int)((long)n8 + this.invScaleYInt);
            if ((l8 += l10) < l9) continue;
            ++n8;
            l8 -= l9;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle, nArray, nArray2);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle, nArray, nArray2);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle, nArray, nArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n18 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n19 = dataBufferByte2.getOffset();
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = nArray[n3];
            n = n10 + (n2 - n8);
            nArray3[n3] = n >> 3;
            nArray4[n3] = 7 - (n & 7);
        }
        for (n3 = 0; n3 < n7; ++n3) {
            int n20;
            int n21;
            int n22;
            int n23;
            byte by;
            int n24;
            n2 = nArray2[n3];
            n = (n2 - n9) * n11 + n18;
            int n25 = (n3 + n5 - n15) * n17 + n19;
            int n26 = n16 + (n4 - n14);
            for (n24 = 0; n24 < n6 && (n26 & 7) != 0; ++n24) {
                by = byArray[n + nArray3[n24]];
                n23 = by >> nArray4[n24] & 1;
                n22 = n25 + (n26 >> 3);
                n21 = 7 - (n26 & 7);
                n20 = byArray2[n22];
                byArray2[n22] = (byte)(n20 |= n23 << n21);
                ++n26;
            }
            n22 = n25 + (n26 >> 3);
            int n27 = n6 - n24 + 1 >> 3;
            if (n27 > 0 && n3 > 0 && n2 == nArray2[n3 - 1]) {
                System.arraycopy(byArray2, n22 - n17, byArray2, n22, n27);
                n24 += n27 * 8;
                n26 += n27 * 8;
            } else {
                while (n24 < n6 - 7) {
                    by = byArray[n + nArray3[n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 = n23 << 7;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 |= n23 << 6;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 |= n23 << 5;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 |= n23 << 4;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 |= n23 << 3;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 |= n23 << 2;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    n20 |= n23 << 1;
                    by = byArray[n + nArray3[++n24]];
                    n23 = by >> nArray4[n24] & 1;
                    ++n24;
                    byArray2[n22++] = (byte)(n20 |= n23);
                    n26 += 8;
                }
            }
            if (n24 >= n6) continue;
            n22 = n25 + (n26 >> 3);
            n20 = byArray2[n22];
            while (n24 < n6) {
                by = byArray[n + nArray3[n24]];
                n23 = by >> nArray4[n24] & 1;
                n21 = 7 - (n26 & 7);
                n20 |= n23 << n21;
                ++n26;
                ++n24;
            }
            byArray2[n22] = (byte)n20;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n18 = dataBufferUShort.getOffset();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray2 = dataBufferUShort2.getData();
        int n19 = dataBufferUShort2.getOffset();
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = nArray[n3];
            n = n10 + (n2 - n8);
            nArray3[n3] = n >> 4;
            nArray4[n3] = 15 - (n & 0xF);
        }
        for (n3 = 0; n3 < n7; ++n3) {
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            short s;
            int n25;
            n2 = nArray2[n3];
            n = (n2 - n9) * n11 + n18;
            int n26 = (n3 + n5 - n15) * n17 + n19;
            int n27 = n16 + (n4 - n14);
            for (n25 = 0; n25 < n6 && (n27 & 0xF) != 0; ++n25) {
                s = sArray[n + nArray3[n25]];
                n24 = s >> nArray4[n25] & 1;
                n23 = n26 + (n27 >> 4);
                n22 = 15 - (n27 & 0xF);
                n21 = sArray2[n23];
                sArray2[n23] = (short)(n21 |= n24 << n22);
                ++n27;
            }
            n23 = n26 + (n27 >> 4);
            int n28 = n6 - n25 >> 4;
            if (n28 > 0 && n3 > 0 && n2 == nArray2[n3 - 1]) {
                n20 = n26 + (n27 >> 4);
                System.arraycopy(sArray2, n20 - n17, sArray2, n20, n28);
                n25 += n28 >> 4;
                n27 += n28 >> 4;
            } else {
                while (n25 < n6 - 15) {
                    n21 = 0;
                    for (n20 = 15; n20 >= 0; --n20) {
                        s = sArray[n + nArray3[n25]];
                        n24 = s >> nArray4[n25] & 1;
                        n21 |= n24 << n20;
                        ++n25;
                    }
                    sArray2[n23++] = (short)n21;
                    n27 += 16;
                }
            }
            if (n25 >= n6) continue;
            n23 = n26 + (n27 >> 4);
            n21 = sArray2[n23];
            while (n25 < n6) {
                s = sArray[n + nArray3[n25]];
                n24 = s >> nArray4[n25] & 1;
                n22 = 15 - (n27 & 0xF);
                n21 |= n24 << n22;
                ++n27;
                ++n25;
            }
            sArray2[n23] = (short)n21;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray3 = dataBufferInt.getData();
        int n18 = dataBufferInt.getOffset();
        int[] nArray4 = dataBufferInt2.getData();
        int n19 = dataBufferInt2.getOffset();
        int[] nArray5 = new int[n6];
        int[] nArray6 = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = nArray[n3];
            n = n10 + (n2 - n8);
            nArray5[n3] = n >> 5;
            nArray6[n3] = 31 - (n & 0x1F);
        }
        for (n3 = 0; n3 < n7; ++n3) {
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            int n26;
            n2 = nArray2[n3];
            n = (n2 - n9) * n11 + n18;
            int n27 = (n3 + n5 - n15) * n17 + n19;
            int n28 = n16 + (n4 - n14);
            for (n26 = 0; n26 < n6 && (n28 & 0x1F) != 0; ++n26) {
                n25 = nArray3[n + nArray5[n26]];
                n24 = n25 >> nArray6[n26] & 1;
                n23 = n27 + (n28 >> 5);
                n22 = 31 - (n28 & 0x1F);
                n21 = nArray4[n23];
                nArray4[n23] = n21 |= n24 << n22;
                ++n28;
            }
            n23 = n27 + (n28 >> 5);
            int n29 = n6 - n26 >> 5;
            if (n29 > 0 && n3 > 0 && n2 == nArray2[n3 - 1]) {
                n20 = n27 + (n28 >> 5);
                System.arraycopy(nArray4, n20 - n17, nArray4, n20, n29);
                n26 += n29 >> 5;
                n28 += n29 >> 5;
            } else {
                while (n26 < n6 - 31) {
                    n21 = 0;
                    for (n20 = 31; n20 >= 0; --n20) {
                        n25 = nArray3[n + nArray5[n26]];
                        n24 = n25 >> nArray6[n26] & 1;
                        n21 |= n24 << n20;
                        ++n26;
                    }
                    nArray4[n23++] = n21;
                    n28 += 32;
                }
            }
            if (n26 >= n6) continue;
            n23 = n27 + (n28 >> 5);
            n21 = nArray4[n23];
            while (n26 < n6) {
                n25 = nArray3[n + nArray5[n26]];
                n24 = n25 >> nArray6[n26] & 1;
                n22 = 31 - (n28 & 0x1F);
                n21 |= n24 << n22;
                ++n28;
                ++n26;
            }
            nArray4[n23] = n21;
        }
    }
}

