/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

public class SubsampleBinaryToGrayOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float invScaleX;
    protected float invScaleY;
    private float floatTol;
    private int blockX;
    private int blockY;
    private int dWidth;
    private int dHeight;
    private int[] xValues;
    private int[] yValues;
    private int[] lut = new int[256];
    protected byte[] lutGray;

    static ImageLayout layoutHelper(RenderedImage renderedImage, float f, float f2, ImageLayout imageLayout, Map map) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        float f3 = f * (float)n;
        float f4 = f2 * (float)n2;
        float f5 = 0.1f * Math.min(f / (f3 + 1.0f), f2 / (f4 + 1.0f));
        int n3 = (int)f3;
        int n4 = (int)f4;
        if (Math.abs((float)Math.round(f3) - f3) < f5) {
            n3 = Math.round(f3);
        }
        if (Math.abs((float)Math.round(f4) - f4) < f5) {
            n4 = Math.round(f4);
        }
        imageLayout2.setMinX((int)(f * (float)renderedImage.getMinX()));
        imageLayout2.setMinY((int)(f2 * (float)renderedImage.getMinY()));
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        SampleModel sampleModel = imageLayout2.getSampleModel(null);
        if (sampleModel == null || sampleModel.getDataType() != 0 || !(sampleModel instanceof PixelInterleavedSampleModel) && (!(sampleModel instanceof SinglePixelPackedSampleModel) || sampleModel.getNumBands() != 1)) {
            sampleModel = new PixelInterleavedSampleModel(0, 1, 1, 1, 1, new int[]{0});
        }
        imageLayout2.setSampleModel(sampleModel);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public SubsampleBinaryToGrayOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, float f, float f2) {
        super(SubsampleBinaryToGrayOpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, f, f2, imageLayout, map), SubsampleBinaryToGrayOpImage.configHelper(map), true, null, null, null);
        this.scaleX = f;
        this.scaleY = f2;
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        this.computeDestInfo(n3, n4);
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
        this.computeXYValues(n3, n4, n, n2);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / (double)this.scaleX, point2D.getY() / (double)this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * (double)this.scaleX, point2D.getY() * (double)this.scaleY);
        return point2D2;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        int n2;
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x - this.blockX + 1;
        int n4 = rectangle.y - this.blockY + 1;
        n3 = n3 < 0 ? 0 : n3;
        n4 = n4 < 0 ? 0 : n4;
        int n5 = (int)((float)n4 * this.scaleY);
        for (n2 = (int)((float)n3 * this.scaleX); this.xValues[n2] > n3 && n2 > 0; --n2) {
        }
        while (this.yValues[n5] > n4 && n5 > 0) {
            --n5;
        }
        int n6 = rectangle.x + rectangle.width - 1;
        int n7 = rectangle.y + rectangle.height - 1;
        int n8 = Math.round((float)n6 * this.scaleX);
        int n9 = Math.round((float)n7 * this.scaleY);
        int n10 = n9 = n9 >= this.dHeight ? this.dHeight - 1 : n9;
        for (n8 = n8 >= this.dWidth ? this.dWidth - 1 : n8; this.xValues[n8] < n6 && n8 < this.dWidth - 1; ++n8) {
        }
        while (this.yValues[n9] < n7 && n9 < this.dHeight - 1) {
            ++n9;
        }
        return new Rectangle(n2 += this.minX, n5 += this.minY, (n8 += this.minX) - n2 + 1, (n9 += this.minY) - n5 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = this.xValues[rectangle.x - this.minX];
        int n3 = this.yValues[rectangle.y - this.minY];
        int n4 = this.xValues[rectangle.x - this.minX + rectangle.width - 1];
        int n5 = this.yValues[rectangle.y - this.minY + rectangle.height - 1];
        return new Rectangle(n2, n3, n4 - n2 + this.blockX, n5 - n3 + this.blockY);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n4 = packedImageData.offset;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = packedImageData.rect.x;
        int n10 = packedImageData.rect.y;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n14 = dataBufferByte.getOffset();
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = this.xValues[n5 + n3 - this.minX];
            n = packedImageData.bitOffset + (n2 - n9);
            nArray[n3] = n >> 3;
            nArray2[n3] = n % 8;
        }
        for (n3 = 0; n3 < n8; ++n3) {
            for (n2 = 0; n2 < n7; ++n2) {
                nArray3[n2] = 0;
            }
            for (n2 = this.yValues[n6 + n3 - this.minY]; n2 < this.yValues[n6 + n3 - this.minY] + this.blockY; ++n2) {
                n = (n2 - n10) * packedImageData.lineStride + n4;
                int n15 = 0;
                int n16 = 0;
                while (n16 < n7) {
                    n15 = 0;
                    int n17 = nArray2[n16] + this.blockX - 1;
                    int n18 = nArray[n16] + (n17 >> 3);
                    n17 %= 8;
                    int n19 = 0xFF & byArray[n + nArray[n16]];
                    if (nArray[n16] == n18) {
                        n19 <<= 24 + nArray2[n16];
                        n15 += this.lut[n19 >>>= 31 - n17 + nArray2[n16]];
                    } else {
                        n19 <<= 24 + nArray2[n16];
                        n15 += this.lut[n19 >>>= 24];
                        for (int i = nArray[n16] + 1; i < n18; ++i) {
                            n19 = 0xFF & byArray[n + i];
                            n15 += this.lut[n19];
                        }
                        n19 = 0xFF & byArray[n + n18];
                        n15 += this.lut[n19 >>>= 7 - n17];
                    }
                    int n20 = n16++;
                    nArray3[n20] = nArray3[n20] + n15;
                }
            }
            n2 = (n3 + n6 - n12) * n13 + n14;
            n2 += n5 - n11;
            for (n = 0; n < n7; ++n) {
                byArray2[n2 + n] = this.lutGray[nArray3[n]];
            }
        }
    }

    private void computeDestInfo(int n, int n2) {
        this.invScaleX = 1.0f / this.scaleX;
        this.invScaleY = 1.0f / this.scaleY;
        this.blockX = (int)Math.ceil(this.invScaleX);
        this.blockY = (int)Math.ceil(this.invScaleY);
        float f = this.scaleX * (float)n;
        float f2 = this.scaleY * (float)n2;
        this.floatTol = 0.1f * Math.min(this.scaleX / (f + 1.0f), this.scaleY / (f2 + 1.0f));
        this.dWidth = (int)f;
        this.dHeight = (int)f2;
        if (Math.abs((float)Math.round(f) - f) < this.floatTol) {
            this.dWidth = Math.round(f);
        }
        if (Math.abs((float)Math.round(f2) - f2) < this.floatTol) {
            this.dHeight = Math.round(f2);
        }
        if (Math.abs((float)Math.round(this.invScaleX) - this.invScaleX) < this.floatTol) {
            this.invScaleX = Math.round(this.invScaleX);
            this.blockX = (int)this.invScaleX;
        }
        if (Math.abs((float)Math.round(this.invScaleY) - this.invScaleY) < this.floatTol) {
            this.invScaleY = Math.round(this.invScaleY);
            this.blockY = (int)this.invScaleY;
        }
    }

    private final void buildLookupTables() {
        int n;
        this.lut[0] = 0;
        this.lut[1] = 1;
        this.lut[2] = 1;
        this.lut[3] = 2;
        this.lut[4] = 1;
        this.lut[5] = 2;
        this.lut[6] = 2;
        this.lut[7] = 3;
        this.lut[8] = 1;
        this.lut[9] = 2;
        this.lut[10] = 2;
        this.lut[11] = 3;
        this.lut[12] = 2;
        this.lut[13] = 3;
        this.lut[14] = 3;
        this.lut[15] = 4;
        for (n = 16; n < 256; ++n) {
            this.lut[n] = this.lut[n & 0xF] + this.lut[n >> 4 & 0xF];
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        for (n = 0; n < this.lutGray.length; ++n) {
            int n2 = Math.round(255.0f * (float)n / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n] = (byte)(n2 > 255 ? -1 : (byte)n2);
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            for (n = 0; n < this.lutGray.length; ++n) {
                this.lutGray[n] = (byte)(255 - (0xFF & this.lutGray[n]));
            }
        }
    }

    private void computeXYValues(int n, int n2, int n3, int n4) {
        float f;
        int n5;
        if (this.xValues == null || this.yValues == null) {
            this.xValues = new int[this.dWidth];
            this.yValues = new int[this.dHeight];
        }
        for (n5 = 0; n5 < this.dWidth; ++n5) {
            f = this.invScaleX * (float)n5;
            this.xValues[n5] = Math.round(f);
        }
        if (this.xValues[this.dWidth - 1] + this.blockX > n) {
            int n6 = this.dWidth - 1;
            this.xValues[n6] = this.xValues[n6] - 1;
        }
        for (n5 = 0; n5 < this.dHeight; ++n5) {
            f = this.invScaleY * (float)n5;
            this.yValues[n5] = Math.round(f);
        }
        if (this.yValues[this.dHeight - 1] + this.blockY > n2) {
            int n7 = this.dHeight - 1;
            this.yValues[n7] = this.yValues[n7] - 1;
        }
        if (n3 != 0) {
            n5 = 0;
            while (n5 < this.dWidth) {
                int n8 = n5++;
                this.xValues[n8] = this.xValues[n8] + n3;
            }
        }
        if (n4 != 0) {
            n5 = 0;
            while (n5 < this.dHeight) {
                int n9 = n5++;
                this.yValues[n9] = this.yValues[n9] + n4;
            }
        }
    }

    static boolean isMinWhite(ColorModel colorModel) {
        if (colorModel == null || !(colorModel instanceof IndexColorModel)) {
            return false;
        }
        byte[] byArray = new byte[256];
        ((IndexColorModel)colorModel).getReds(byArray);
        return byArray[0] == -1;
    }
}

