/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class GeometricOpImage
extends OpImage {
    protected Interpolation interp;
    protected BorderExtender extender = null;
    protected Rectangle computableBounds;
    protected boolean setBackground;
    protected double[] backgroundValues;
    protected int[] intBackgroundValues;

    public GeometricOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation) {
        this(vector, imageLayout, map, bl, borderExtender, interpolation, null);
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = new RenderingHints(null);
                renderingHints.putAll((Map<?, ?>)map);
                map2 = renderingHints;
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return map2;
    }

    public GeometricOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, double[] dArray) {
        super(vector, imageLayout, GeometricOpImage.configHelper(map), bl);
        int n;
        int n2;
        this.extender = borderExtender;
        Interpolation interpolation2 = this.interp = interpolation != null ? interpolation : new InterpolationNearest();
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        this.setBackground = false;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (dArray[n2] == 0.0) continue;
            this.setBackground = true;
        }
        this.backgroundValues = dArray;
        n2 = this.getSampleModel().getNumBands();
        if (dArray.length < n2) {
            this.backgroundValues = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.backgroundValues[n] = dArray[0];
            }
        }
        if (this.sampleModel.getDataType() <= 3) {
            n = this.backgroundValues.length;
            this.intBackgroundValues = new int[n];
            for (int i = 0; i < n; ++i) {
                this.intBackgroundValues[i] = (int)this.backgroundValues[i];
            }
        }
        this.computableBounds = this.getBounds();
    }

    public Interpolation getInterpolation() {
        return this.interp;
    }

    public BorderExtender getBorderExtender() {
        return this.extender;
    }

    public Point2D mapDestPoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1);
        Rectangle rectangle2 = this.backwardMapRect(rectangle, n);
        if (rectangle2 == null) {
            return null;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)rectangle2.x + ((double)rectangle2.width - 1.0) / 2.0, (double)rectangle2.y + ((double)rectangle2.height - 1.0) / 2.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1);
        Rectangle rectangle2 = this.forwardMapRect(rectangle, n);
        if (rectangle2 == null) {
            return null;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)rectangle2.x + ((double)rectangle2.width - 1.0) / 2.0, (double)rectangle2.y + ((double)rectangle2.height - 1.0) / 2.0);
        return point2D2;
    }

    protected abstract Rectangle forwardMapRect(Rectangle var1, int var2);

    protected abstract Rectangle backwardMapRect(Rectangle var1, int var2);

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = this.interp.getLeftPadding();
        int n3 = this.interp.getTopPadding();
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        rectangle2.x += n2;
        rectangle2.y += n3;
        rectangle2.width -= n2 + this.interp.getRightPadding();
        rectangle2.height -= n3 + this.interp.getBottomPadding();
        Rectangle rectangle3 = this.forwardMapRect(rectangle2, n);
        return rectangle3 == null ? this.getBounds() : rectangle3;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle2 = this.backwardMapRect(rectangle, n);
        if (rectangle2 == null) {
            return this.getSource(n).getBounds();
        }
        int n2 = this.interp.getLeftPadding();
        int n3 = this.interp.getTopPadding();
        return new Rectangle(rectangle2.x - n2, rectangle2.y - n3, rectangle2.width + n2 + this.interp.getRightPadding(), rectangle2.height + n3 + this.interp.getBottomPadding());
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getTileRect(n, n2).intersection(this.getBounds());
        if (rectangle.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            }
            return writableRaster;
        }
        int n3 = this.getNumSources();
        if (this.cobbleSources) {
            Object object;
            Object object2;
            int n4;
            Raster[] rasterArray = new Raster[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                object2 = this.getSource(n4);
                object = this.mapDestRect(rectangle, n4);
                if (object == null) {
                    object = ((PlanarImage)object2).getBounds();
                } else if (!((Rectangle)object).intersects(((PlanarImage)object2).getBounds())) {
                    if (this.setBackground) {
                        ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
                    }
                    return writableRaster;
                }
                rasterArray[n4] = this.extender != null ? ((PlanarImage)object2).getExtendedData((Rectangle)object, this.extender) : ((PlanarImage)object2).getData((Rectangle)object);
            }
            this.computeRect(rasterArray, writableRaster, rectangle);
            for (n4 = 0; n4 < n3; ++n4) {
                object2 = rasterArray[n4];
                if (object2 == null || !((PlanarImage)(object = this.getSourceImage(n4))).overlapsMultipleTiles(((Raster)object2).getBounds())) continue;
                this.recycleTile((Raster)object2);
            }
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[n3];
            for (int i = 0; i < n3; ++i) {
                planarImageArray[i] = this.getSource(i);
            }
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }
}

