/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImagingListenerImpl;
import com.sun.media.jai.util.SunTileCache;
import com.sun.media.jai.util.SunTileScheduler;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionOp;
import javax.media.jai.ColorModelFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.RecyclingTileFactory;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRecycler;
import javax.media.jai.TileScheduler;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.util.ImagingListener;

public final class JAI {
    private static final int HINT_IMAGE_LAYOUT = 101;
    private static final int HINT_INTERPOLATION = 102;
    private static final int HINT_OPERATION_REGISTRY = 103;
    private static final int HINT_OPERATION_BOUND = 104;
    private static final int HINT_BORDER_EXTENDER = 105;
    private static final int HINT_TILE_CACHE = 106;
    private static final int HINT_TILE_SCHEDULER = 107;
    private static final int HINT_DEFAULT_COLOR_MODEL_ENABLED = 108;
    private static final int HINT_DEFAULT_COLOR_MODEL_METHOD = 109;
    private static final int HINT_TILE_CACHE_METRIC = 110;
    private static final int HINT_SERIALIZE_DEEP_COPY = 111;
    private static final int HINT_TILE_CODEC_FORMAT = 112;
    private static final int HINT_TILE_ENCODING_PARAM = 113;
    private static final int HINT_TILE_DECODING_PARAM = 114;
    private static final int HINT_RETRY_INTERVAL = 115;
    private static final int HINT_NUM_RETRIES = 116;
    private static final int HINT_NEGOTIATION_PREFERENCES = 117;
    private static final int HINT_DEFAULT_RENDERING_SIZE = 118;
    private static final int HINT_COLOR_MODEL_FACTORY = 119;
    private static final int HINT_REPLACE_INDEX_COLOR_MODEL = 120;
    private static final int HINT_TILE_FACTORY = 121;
    private static final int HINT_TILE_RECYCLER = 122;
    private static final int HINT_CACHED_TILE_RECYCLING_ENABLED = 123;
    private static final int HINT_TRANSFORM_ON_COLORMAP = 124;
    private static final int HINT_IMAGING_LISTENER = 125;
    public static RenderingHints.Key KEY_IMAGE_LAYOUT = new RenderingKey(101, ImageLayout.class);
    public static RenderingHints.Key KEY_INTERPOLATION = new RenderingKey(102, Interpolation.class);
    public static RenderingHints.Key KEY_OPERATION_REGISTRY = new RenderingKey(103, OperationRegistry.class);
    public static RenderingHints.Key KEY_OPERATION_BOUND = new RenderingKey(104, Integer.class);
    public static RenderingHints.Key KEY_BORDER_EXTENDER = new RenderingKey(105, BorderExtender.class);
    public static RenderingHints.Key KEY_TILE_CACHE = new RenderingKey(106, TileCache.class);
    public static RenderingHints.Key KEY_TILE_CACHE_METRIC = new RenderingKey(110, Object.class);
    public static RenderingHints.Key KEY_TILE_SCHEDULER = new RenderingKey(107, TileScheduler.class);
    public static RenderingHints.Key KEY_DEFAULT_COLOR_MODEL_ENABLED = new RenderingKey(108, Boolean.class);
    public static RenderingHints.Key KEY_DEFAULT_COLOR_MODEL_METHOD = new RenderingKey(109, Method.class);
    public static final RenderingHints.Key KEY_DEFAULT_RENDERING_SIZE = new RenderingKey(118, Dimension.class);
    public static RenderingHints.Key KEY_COLOR_MODEL_FACTORY = new RenderingKey(119, ColorModelFactory.class);
    public static RenderingHints.Key KEY_REPLACE_INDEX_COLOR_MODEL = new RenderingKey(120, Boolean.class);
    public static RenderingHints.Key KEY_TILE_FACTORY = new RenderingKey(121, TileFactory.class);
    public static RenderingHints.Key KEY_TILE_RECYCLER = new RenderingKey(122, TileRecycler.class);
    public static RenderingHints.Key KEY_CACHED_TILE_RECYCLING_ENABLED = new RenderingKey(123, Boolean.class);
    public static RenderingHints.Key KEY_SERIALIZE_DEEP_COPY = new RenderingKey(111, Boolean.class);
    public static RenderingHints.Key KEY_TILE_CODEC_FORMAT = new RenderingKey(112, String.class);
    public static RenderingHints.Key KEY_TILE_ENCODING_PARAM = new RenderingKey(113, TileCodecParameterList.class);
    public static RenderingHints.Key KEY_TILE_DECODING_PARAM = new RenderingKey(114, TileCodecParameterList.class);
    public static RenderingHints.Key KEY_RETRY_INTERVAL = new RenderingKey(115, Integer.class);
    public static RenderingHints.Key KEY_NUM_RETRIES = new RenderingKey(116, Integer.class);
    public static RenderingHints.Key KEY_NEGOTIATION_PREFERENCES = new RenderingKey(117, NegotiableCapabilitySet.class);
    public static RenderingHints.Key KEY_TRANSFORM_ON_COLORMAP = new RenderingKey(124, Boolean.class);
    public static RenderingHints.Key KEY_IMAGING_LISTENER = new RenderingKey(125, ImagingListener.class);
    private static final int DEFAULT_TILE_SIZE = 512;
    private static Dimension defaultTileSize = new Dimension(512, 512);
    private static Dimension defaultRenderingSize = new Dimension(0, 512);
    private OperationRegistry operationRegistry;
    private TileScheduler tileScheduler;
    private TileCache tileCache;
    private RenderingHints renderingHints;
    private ImagingListener imagingListener = ImagingListenerImpl.getInstance();
    private static JAI defaultInstance = new JAI(OperationRegistry.initializeRegistry(), new SunTileScheduler(), new SunTileCache(), new RenderingHints(null));

    private JAI(OperationRegistry operationRegistry, TileScheduler tileScheduler, TileCache tileCache, RenderingHints renderingHints) {
        this.operationRegistry = operationRegistry;
        this.tileScheduler = tileScheduler;
        this.tileCache = tileCache;
        this.renderingHints = renderingHints;
        this.renderingHints.put(KEY_OPERATION_REGISTRY, operationRegistry);
        this.renderingHints.put(KEY_TILE_CACHE, tileCache);
        this.renderingHints.put(KEY_TILE_SCHEDULER, tileScheduler);
        RecyclingTileFactory recyclingTileFactory = new RecyclingTileFactory();
        this.renderingHints.put(KEY_TILE_FACTORY, recyclingTileFactory);
        this.renderingHints.put(KEY_TILE_RECYCLER, recyclingTileFactory);
        this.renderingHints.put(KEY_CACHED_TILE_RECYCLING_ENABLED, Boolean.FALSE);
        this.renderingHints.put(KEY_IMAGING_LISTENER, this.imagingListener);
    }

    public static final String getBuildVersion() {
        try {
            String string;
            InputStream inputStream = JAI.class.getResourceAsStream("buildVersion");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(string);
                bl = true;
            }
            bufferedWriter.close();
            return stringWriter.getBuffer().toString();
        }
        catch (Exception exception) {
            return JaiI18N.getString("JAI13");
        }
    }

    public static final void disableDefaultTileCache() {
        TileCache tileCache = defaultInstance.getTileCache();
        if (tileCache != null) {
            tileCache.flush();
        }
        JAI.defaultInstance.renderingHints.remove(KEY_TILE_CACHE);
    }

    public static final void enableDefaultTileCache() {
        JAI.defaultInstance.renderingHints.put(KEY_TILE_CACHE, defaultInstance.getTileCache());
    }

    public static final void setDefaultTileSize(Dimension dimension) {
        if (dimension != null && (dimension.width <= 0 || dimension.height <= 0)) {
            throw new IllegalArgumentException();
        }
        defaultTileSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    public static final Dimension getDefaultTileSize() {
        return defaultTileSize != null ? (Dimension)defaultTileSize.clone() : null;
    }

    public static final void setDefaultRenderingSize(Dimension dimension) {
        if (dimension != null && dimension.width <= 0 && dimension.height <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI8"));
        }
        defaultRenderingSize = dimension == null ? null : new Dimension(dimension);
    }

    public static final Dimension getDefaultRenderingSize() {
        return defaultRenderingSize == null ? null : new Dimension(defaultRenderingSize);
    }

    public static JAI getDefaultInstance() {
        return defaultInstance;
    }

    static RenderingHints mergeRenderingHints(RenderingHints renderingHints, RenderingHints renderingHints2) {
        RenderingHints renderingHints3;
        if (renderingHints2 == null || renderingHints2.isEmpty()) {
            renderingHints3 = renderingHints;
        } else if (renderingHints == null || renderingHints.isEmpty()) {
            renderingHints3 = renderingHints2;
        } else {
            renderingHints3 = new RenderingHints(renderingHints);
            renderingHints3.add(renderingHints2);
        }
        return renderingHints3;
    }

    public JAI() {
        this.operationRegistry = JAI.defaultInstance.operationRegistry;
        this.tileScheduler = JAI.defaultInstance.tileScheduler;
        this.tileCache = JAI.defaultInstance.tileCache;
        this.renderingHints = (RenderingHints)JAI.defaultInstance.renderingHints.clone();
    }

    public OperationRegistry getOperationRegistry() {
        return this.operationRegistry;
    }

    public void setOperationRegistry(OperationRegistry operationRegistry) {
        if (operationRegistry == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.operationRegistry = operationRegistry;
        this.renderingHints.put(KEY_OPERATION_REGISTRY, operationRegistry);
    }

    public TileScheduler getTileScheduler() {
        return this.tileScheduler;
    }

    public void setTileScheduler(TileScheduler tileScheduler) {
        if (tileScheduler == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.tileScheduler = tileScheduler;
        this.renderingHints.put(KEY_TILE_SCHEDULER, tileScheduler);
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(TileCache tileCache) {
        if (tileCache == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.tileCache = tileCache;
        this.renderingHints.put(KEY_TILE_CACHE, tileCache);
    }

    public static TileCache createTileCache(int n, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI10"));
        }
        return new SunTileCache(l);
    }

    public static TileCache createTileCache(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI10"));
        }
        return new SunTileCache(l);
    }

    public static TileCache createTileCache() {
        return new SunTileCache();
    }

    public static TileScheduler createTileScheduler() {
        return new SunTileScheduler();
    }

    public static RenderedOp create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createNS(string, parameterBlock, renderingHints);
    }

    public RenderedOp createNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "rendered";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!RenderedImage.class.isAssignableFrom(operationDescriptor.getDestClass(string2))) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI2"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments(string2, parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        RenderingHints renderingHints2 = JAI.mergeRenderingHints(this.renderingHints, renderingHints);
        RenderedOp renderedOp = new RenderedOp(this.operationRegistry, string, parameterBlock, renderingHints2);
        if (operationDescriptor.isImmediate()) {
            PlanarImage planarImage = null;
            planarImage = renderedOp.getRendering();
            if (planarImage == null) {
                return null;
            }
        }
        return renderedOp;
    }

    public static Collection createCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createCollectionNS(string, parameterBlock, renderingHints);
    }

    public Collection createCollectionNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Object object;
        Class clazz;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "collection";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!RenderedImage.class.isAssignableFrom(clazz = operationDescriptor.getDestClass(string2)) && !CollectionImage.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI5"));
        }
        RenderingHints renderingHints2 = JAI.mergeRenderingHints(this.renderingHints, renderingHints);
        StringBuffer stringBuffer = new StringBuffer();
        if (operationDescriptor.validateArguments(string2, parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            if (RenderedImage.class.isAssignableFrom(clazz)) {
                Vector<RenderedOp> vector = new Vector<RenderedOp>(1);
                vector.add(new RenderedOp(this.operationRegistry, string, parameterBlock, renderingHints2));
                return vector;
            }
            CollectionOp collectionOp = new CollectionOp(this.operationRegistry, string, parameterBlock, renderingHints2);
            if (operationDescriptor.isImmediate()) {
                Collection collection = null;
                collection = collectionOp.getCollection();
                if (collection == null) {
                    return null;
                }
            }
            return collectionOp;
        }
        int n = operationDescriptor.getNumSources();
        Vector<Object> vector = parameterBlock.getSources();
        Iterator[] iteratorArray = new Iterator[n];
        Iterator iterator = null;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Object object2 = vector.elementAt(i);
            if (!(object2 instanceof Collection)) continue;
            iteratorArray[i] = ((Collection)object2).iterator();
            if (iterator != null && ((Collection)object2).size() >= n2) continue;
            iterator = iteratorArray[i];
            n2 = ((Collection)object2).size();
        }
        if (iterator == null) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        Collection<Collection> collection = null;
        for (int i = 0; i < n; ++i) {
            object = vector.elementAt(i);
            if (!(object instanceof Collection)) continue;
            try {
                collection = (Collection)object.getClass().newInstance();
                break;
            }
            catch (Exception exception) {
                this.sendExceptionToListener(JaiI18N.getString("JAI16") + object.getClass().getName(), exception);
            }
        }
        if (collection == null) {
            collection = new Vector();
        }
        Class[] classArray = operationDescriptor.getSourceClasses(string2);
        while (iterator.hasNext()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).setParameters(parameterBlock.getParameters());
            for (int i = 0; i < n; ++i) {
                Object object3 = null;
                object3 = iteratorArray[i] == null ? vector.elementAt(i) : iteratorArray[i].next();
                if (!classArray[i].isAssignableFrom(object3.getClass()) && !(object3 instanceof Collection)) {
                    throw new IllegalArgumentException(stringBuffer.toString());
                }
                ((ParameterBlock)object).addSource(object3);
            }
            Collection collection2 = this.createCollectionNS(string, (ParameterBlock)object, renderingHints2);
            if (collection2 instanceof Vector && collection2.size() == 1 && ((Vector)collection2).elementAt(0) instanceof RenderedOp) {
                collection.add((Collection)((Vector)collection2).elementAt(0));
                continue;
            }
            collection.add(collection2);
        }
        return collection;
    }

    public static RenderedOp create(String string, ParameterBlock parameterBlock) {
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(n);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2, Object object3) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, int n, int n2, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Object object, int n, Object object2, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(object);
        parameterBlock.add(n);
        parameterBlock.add(object2);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, Collection collection) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(collection);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, float f) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(f);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(n3);
        parameterBlock.add(n4);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, float f3, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4, Object object5) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        parameterBlock.add(object5);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, float f2, float f3, float f4, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(f4);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, float f, int n, float f2, float f3, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f);
        parameterBlock.add(n);
        parameterBlock.add(f2);
        parameterBlock.add(f3);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        parameterBlock.add(object5);
        parameterBlock.add(object6);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, Object object) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(n);
        parameterBlock.add(n2);
        parameterBlock.add(n3);
        parameterBlock.add(n4);
        parameterBlock.add(n5);
        parameterBlock.add(object);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, RenderedImage renderedImage2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        return JAI.create(string, parameterBlock, null);
    }

    public static RenderedOp create(String string, RenderedImage renderedImage, RenderedImage renderedImage2, Object object, Object object2, Object object3, Object object4) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        parameterBlock.add(object);
        parameterBlock.add(object2);
        parameterBlock.add(object3);
        parameterBlock.add(object4);
        return JAI.create(string, parameterBlock, null);
    }

    public static Collection createCollection(String string, ParameterBlock parameterBlock) {
        return JAI.createCollection(string, parameterBlock, null);
    }

    public static RenderableOp createRenderable(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createRenderableNS(string, parameterBlock, renderingHints);
    }

    public static RenderableOp createRenderable(String string, ParameterBlock parameterBlock) {
        return defaultInstance.createRenderableNS(string, parameterBlock, null);
    }

    public RenderableOp createRenderableNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "renderable";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!RenderableImage.class.isAssignableFrom(operationDescriptor.getDestClass(string2))) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI4"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments(string2, parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        RenderableOp renderableOp = new RenderableOp(this.operationRegistry, string, parameterBlock, JAI.mergeRenderingHints(this.renderingHints, renderingHints));
        return renderableOp;
    }

    public RenderableOp createRenderableNS(String string, ParameterBlock parameterBlock) {
        return this.createRenderableNS(string, parameterBlock, null);
    }

    public static Collection createRenderableCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return defaultInstance.createRenderableCollectionNS(string, parameterBlock, renderingHints);
    }

    public static Collection createRenderableCollection(String string, ParameterBlock parameterBlock) {
        return defaultInstance.createRenderableCollectionNS(string, parameterBlock, null);
    }

    public Collection createRenderableCollectionNS(String string, ParameterBlock parameterBlock) {
        return this.createRenderableCollectionNS(string, parameterBlock, null);
    }

    public Collection createRenderableCollectionNS(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        Object object;
        Class clazz;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI14"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI15"));
        }
        String string2 = "renderableCollection";
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.operationRegistry.getDescriptor(string2, string);
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI0"));
        }
        if (!RenderableImage.class.isAssignableFrom(clazz = operationDescriptor.getDestClass(string2)) && !CollectionImage.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(string + ": " + JaiI18N.getString("JAI6"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        parameterBlock = (ParameterBlock)parameterBlock.clone();
        RenderingHints renderingHints2 = JAI.mergeRenderingHints(this.renderingHints, renderingHints);
        if (operationDescriptor.validateArguments(string2, parameterBlock, stringBuffer)) {
            if (RenderableImage.class.isAssignableFrom(clazz)) {
                Vector<RenderableOp> vector = new Vector<RenderableOp>(1);
                RenderableOp renderableOp = new RenderableOp(this.operationRegistry, string, parameterBlock, renderingHints2);
                vector.add(renderableOp);
                return vector;
            }
            CollectionOp collectionOp = new CollectionOp(this.operationRegistry, string, parameterBlock, renderingHints2, true);
            if (operationDescriptor.isImmediate()) {
                Collection collection = null;
                collection = collectionOp.getCollection();
                if (collection == null) {
                    return null;
                }
            }
            return collectionOp;
        }
        int n = operationDescriptor.getNumSources();
        Vector<Object> vector = parameterBlock.getSources();
        Iterator[] iteratorArray = new Iterator[n];
        Iterator iterator = null;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Object object2 = vector.elementAt(i);
            if (!(object2 instanceof Collection)) continue;
            iteratorArray[i] = ((Collection)object2).iterator();
            if (iterator != null && ((Collection)object2).size() >= n2) continue;
            iterator = iteratorArray[i];
            n2 = ((Collection)object2).size();
        }
        if (iterator == null) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        Collection<Collection> collection = null;
        for (int i = 0; i < n; ++i) {
            object = vector.elementAt(i);
            if (!(object instanceof Collection)) continue;
            try {
                collection = (Collection)object.getClass().newInstance();
                break;
            }
            catch (Exception exception) {
                this.sendExceptionToListener(JaiI18N.getString("JAI16") + object.getClass().getName(), exception);
            }
        }
        if (collection == null) {
            collection = new Vector();
        }
        Class[] classArray = operationDescriptor.getSourceClasses(string2);
        while (iterator.hasNext()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).setParameters(parameterBlock.getParameters());
            for (int i = 0; i < n; ++i) {
                Object object3 = null;
                object3 = iteratorArray[i] == null ? vector.elementAt(i) : iteratorArray[i].next();
                if (!classArray[i].isAssignableFrom(object3.getClass()) && !(object3 instanceof Collection)) {
                    throw new IllegalArgumentException(stringBuffer.toString());
                }
                ((ParameterBlock)object).addSource(object3);
            }
            Collection collection2 = this.createRenderableCollectionNS(string, (ParameterBlock)object, renderingHints2);
            if (collection2 instanceof Vector && collection2.size() == 1 && ((Vector)collection2).elementAt(0) instanceof RenderableOp) {
                collection.add((Collection)((Vector)collection2).elementAt(0));
                continue;
            }
            collection.add(collection2);
        }
        return collection;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.renderingHints = renderingHints;
    }

    public void clearRenderingHints() {
        this.renderingHints = new RenderingHints(null);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI7"));
        }
        return this.renderingHints.get(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI7"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JAI9"));
        }
        try {
            this.renderingHints.put(key, object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public void removeRenderingHint(RenderingHints.Key key) {
        this.renderingHints.remove(key);
    }

    public void setImagingListener(ImagingListener imagingListener) {
        if (imagingListener == null) {
            imagingListener = ImagingListenerImpl.getInstance();
        }
        this.renderingHints.put(KEY_IMAGING_LISTENER, imagingListener);
        this.imagingListener = imagingListener;
    }

    public ImagingListener getImagingListener() {
        return this.imagingListener;
    }

    private void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = this.getImagingListener();
        imagingListener.errorOccurred(string, exception, this, false);
    }

    static class RenderingKey
    extends RenderingHints.Key {
        private static Class JAIclass = class$javax$media$jai$JAI == null ? (class$javax$media$jai$JAI = JAI.class$("javax.media.jai.JAI")) : class$javax$media$jai$JAI;
        private Class objectClass;

        RenderingKey(int n, Class clazz) {
            super(n);
            this.objectClass = clazz;
        }

        public boolean isCompatibleValue(Object object) {
            return this.objectClass.isInstance(object);
        }
    }
}

