/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class FilteredSubsampleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "FilteredSubsample"}, {"LocalName", "FilteredSubsample"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("FilteredSubsampleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/FilteredSubsampleDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "The X subsample factor."}, {"arg1Desc", "The Y subsample factor."}, {"arg2Desc", "Symmetric filter coefficients."}, {"arg3Desc", "Interpolation object."}};
    private static final Class[] paramClasses = new Class[]{Integer.class, Integer.class, [F.class, Interpolation.class};
    private static final String[] paramNames = new String[]{"scaleX", "scaleY", "qsFilterArray", "interpolation"};
    private static final Object[] paramDefaults = new Object[]{new Integer(2), new Integer(2), null, Interpolation.getInstance(0)};
    private static final String[] supportedModes = new String[]{"rendered"};

    public FilteredSubsampleDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        Interpolation interpolation;
        if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
            return false;
        }
        int n = parameterBlock.getIntParameter(0);
        int n2 = parameterBlock.getIntParameter(1);
        if (n < 1 || n2 < 1) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("FilteredSubsampleDescriptor1"));
            return false;
        }
        float[] fArray = (float[])parameterBlock.getObjectParameter(2);
        if (fArray == null) {
            int n3;
            int n4;
            int n5 = n4 = n > n2 ? n : n2;
            if ((n4 & 1) == 0) {
                ++n4;
            }
            double d = (double)(n4 - 1) / 6.0;
            if (n4 == 1) {
                d = 1.0;
            }
            fArray = new float[n4 / 2 + 1];
            float f = 0.0f;
            for (n3 = 0; n3 < fArray.length; ++n3) {
                fArray[n3] = (float)this.gaussian(n3, d);
                if (n3 == 0) {
                    f += fArray[n3];
                    continue;
                }
                f += fArray[n3] * 2.0f;
            }
            n3 = 0;
            while (n3 < fArray.length) {
                int n6 = n3++;
                fArray[n6] = fArray[n6] / f;
            }
            parameterBlock.set(fArray, 2);
        }
        if (!((interpolation = (Interpolation)parameterBlock.getObjectParameter(3)) instanceof InterpolationNearest || interpolation instanceof InterpolationBilinear || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("FilteredSubsampleDescriptor2"));
            return false;
        }
        return true;
    }

    private double gaussian(double d, double d2) {
        return Math.exp(-d * d / (2.0 * d2 * d2)) / d2 / Math.sqrt(Math.PI * 2);
    }

    public static RenderedOp create(RenderedImage renderedImage, Integer n, Integer n2, float[] fArray, Interpolation interpolation, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("FilteredSubsample", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("scaleX", n);
        parameterBlockJAI.setParameter("scaleY", n2);
        parameterBlockJAI.setParameter("qsFilterArray", fArray);
        parameterBlockJAI.setParameter("interpolation", interpolation);
        return JAI.create("FilteredSubsample", parameterBlockJAI, renderingHints);
    }
}

