/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class MatchCDFDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "MatchCDF"}, {"LocalName", "MatchCDF"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("MatchCDFDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/MatchCDFDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", "The desired Cumulative Distribution Function."}};
    private static final Class[] paramClasses = new Class[]{[[F.class};
    private static final String[] paramNames = new String[]{"CDF"};
    private static final Object[] paramDefaults = new Object[]{null};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public MatchCDFDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        int n;
        int n2;
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Object object = (float[][])parameterBlock.getObjectParameter(0);
        Object object2 = renderedImage.getProperty("histogram");
        if (object2 == null || object2.equals(Image.UndefinedProperty)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor1"));
            return false;
        }
        if (!(object2 instanceof Histogram)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor2"));
            return false;
        }
        Histogram histogram = (Histogram)object2;
        int n3 = histogram.getNumBands();
        if (object == null) {
            int[] nArray = histogram.getNumBins();
            object = new float[n3][];
            for (int i = 0; i < n3; ++i) {
                object[i] = new float[nArray[i]];
                for (n2 = 0; n2 < nArray[i]; ++n2) {
                    object[i][n2] = (n2 + 1) / nArray[i];
                }
            }
        }
        if (((float[][])object).length != n3) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor3"));
            return false;
        }
        for (n = 0; n < n3; ++n) {
            if (object[n].length == histogram.getNumBins(n)) continue;
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor4"));
            return false;
        }
        for (n = 0; n < n3; ++n) {
            float[] fArray = object[n];
            n2 = fArray.length;
            if ((double)fArray[n2 - 1] != 1.0) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor7"));
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                if (fArray[i] < 0.0f) {
                    stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor5"));
                    return false;
                }
                if (i == 0 || !(fArray[i] < fArray[i - 1])) continue;
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor6"));
                return false;
            }
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, float[][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("MatchCDF", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("CDF", fArray);
        return JAI.create("MatchCDF", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, float[][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("MatchCDF", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("CDF", fArray);
        return JAI.createRenderable("MatchCDF", parameterBlockJAI, renderingHints);
    }
}

