/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;
import javax.media.jai.operator.SubsampleBinaryToGrayPropertyGenerator;

public class SubsampleBinaryToGrayDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "SubsampleBinaryToGray"}, {"LocalName", "SubsampleBinaryToGray"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("SubsampleBinaryToGray0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/SubsampleBinaryToGrayDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("SubsampleBinaryToGray1")}, {"arg1Desc", JaiI18N.getString("SubsampleBinaryToGray2")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class};
    private static final String[] paramNames = new String[]{"xScale", "yScale"};
    private static final Object[] paramDefaults = new Object[]{new Float(1.0f), new Float(1.0f)};

    public SubsampleBinaryToGrayDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] propertyGeneratorArray = new PropertyGenerator[]{new SubsampleBinaryToGrayPropertyGenerator()};
        return propertyGeneratorArray;
    }

    protected boolean validateParameters(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateParameters(parameterBlock, stringBuffer)) {
            return false;
        }
        RenderedImage renderedImage = (RenderedImage)parameterBlock.getSource(0);
        PixelAccessor pixelAccessor = new PixelAccessor(renderedImage);
        if (!pixelAccessor.isPacked || !pixelAccessor.isMultiPixelPackedSM) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("SubsampleBinaryToGray3"));
            return false;
        }
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        if (f <= 0.0f || f2 <= 0.0f || f > 1.0f || f2 > 1.0f) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("SubsampleBinaryToGray1") + " or " + JaiI18N.getString("SubsampleBinaryToGray2"));
            return false;
        }
        return true;
    }

    public Number getParamMinValue(int n) {
        if (n == 0 || n == 1) {
            return new Float(0.0f);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static RenderedOp create(RenderedImage renderedImage, Float f, Float f2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("SubsampleBinaryToGray", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("xScale", f);
        parameterBlockJAI.setParameter("yScale", f2);
        return JAI.create("SubsampleBinaryToGray", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, Float f, Float f2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("SubsampleBinaryToGray", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("xScale", f);
        parameterBlockJAI.setParameter("yScale", f2);
        return JAI.createRenderable("SubsampleBinaryToGray", parameterBlockJAI, renderingHints);
    }
}

