/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;

public class HDF5OpaqueWriter
extends HDF5OpaqueReader
implements IHDF5OpaqueWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5OpaqueWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void writeArray(String objectPath, String tag, byte[] data) {
        this.writeArray(objectPath, tag, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final String tag, final byte[] data, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (tag != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataTypeId = HDF5OpaqueWriter.this.getOrCreateOpaqueTypeId(tag);
                long dataSetId = HDF5OpaqueWriter.this.baseWriter.getOrCreateDataSetId(objectPath, dataTypeId, new long[]{data.length}, 1, features, registry);
                H5.H5Dwrite(dataSetId, dataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public HDF5OpaqueType createArray(String objectPath, String tag, int size) {
        return this.createArray(objectPath, tag, size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public HDF5OpaqueType createArray(String objectPath, String tag, long size, int blockSize) {
        return this.createArray(objectPath, tag, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public HDF5OpaqueType createArray(final String objectPath, String tag, final int size, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (tag != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        final long dataTypeId = this.getOrCreateOpaqueTypeId(tag);
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5OpaqueWriter.this.baseWriter.createDataSet(objectPath, dataTypeId, features, new long[1], new long[]{size}, 1, registry);
                } else {
                    HDF5OpaqueWriter.this.baseWriter.createDataSet(objectPath, dataTypeId, features, new long[]{size}, null, 1, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
        return new HDF5OpaqueType(this.baseWriter.fileId, dataTypeId, tag, (HDF5BaseReader)this.baseWriter);
    }

    @Override
    public HDF5OpaqueType createArray(final String objectPath, String tag, final long size, final int blockSize, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (tag != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        final long dataTypeId = this.getOrCreateOpaqueTypeId(tag);
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5OpaqueWriter.this.baseWriter.createDataSet(objectPath, dataTypeId, features, new long[]{size}, new long[]{blockSize}, 1, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
        return new HDF5OpaqueType(this.baseWriter.fileId, dataTypeId, tag, (HDF5BaseReader)this.baseWriter);
    }

    @Override
    public void writeArrayBlock(final String objectPath, final HDF5OpaqueType dataType, final byte[] data, final long blockNumber) {
        assert (objectPath != null);
        assert (dataType != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        dataType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{data.length};
                long[] slabStartOrNull = new long[]{(long)data.length * blockNumber};
                long dataSetId = ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.fileId, objectPath, ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.fileFormat, new long[]{(long)data.length * (blockNumber + 1L)}, false, registry);
                long dataSpaceId = ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                long memorySpaceId = ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, dataType.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final HDF5OpaqueType dataType, final byte[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (dataType != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        dataType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                long dataSetId = ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.fileId, objectPath, ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, false, registry);
                long dataSpaceId = ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                long memorySpaceId = ((HDF5OpaqueWriter)HDF5OpaqueWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, dataType.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    private long getOrCreateOpaqueTypeId(String tag) {
        String dataTypePath = HDF5Utils.createDataTypePath("Opaque_", this.baseWriter.houseKeepingNameSuffix, tag);
        long dataTypeId = this.baseWriter.getDataTypeId(dataTypePath);
        if (dataTypeId < 0L) {
            dataTypeId = this.baseWriter.h5.createDataTypeOpaque(1, tag, this.baseWriter.fileRegistry);
            this.baseWriter.commitDataType(dataTypePath, dataTypeId);
        }
        return dataTypeId;
    }
}

