/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

final class Utils {
    static final long MILLIS_PER_SECOND = 1000L;
    static final int UNKNOWN = -1;
    static final short UNKNOWN_S = -1;
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Utils() {
    }

    static String crc32ToString(int checksum) {
        char[] buf = new char[8];
        int w = checksum;
        int i = 0;
        int x = 7;
        while (i < 4) {
            buf[x--] = HEX_CHARACTERS[w & 0xF];
            buf[x--] = HEX_CHARACTERS[w >>> 4 & 0xF];
            w >>= 8;
            ++i;
        }
        return new String(buf);
    }

    static String permissionsToString(int permissions, boolean directory, boolean numeric) {
        if (numeric) {
            return Integer.toString(permissions, 8);
        }
        short perms = (short)permissions;
        StringBuilder b = new StringBuilder();
        b.append(directory ? (char)'d' : '-');
        b.append((perms & 0x100) != 0 ? (char)'r' : '-');
        b.append((perms & 0x80) != 0 ? (char)'w' : '-');
        b.append((perms & 0x40) != 0 ? ((perms & 0x800) != 0 ? (char)'s' : 'x') : ((perms & 0x800) != 0 ? (char)'S' : '-'));
        b.append((perms & 0x20) != 0 ? (char)'r' : '-');
        b.append((perms & 0x10) != 0 ? (char)'w' : '-');
        b.append((perms & 8) != 0 ? ((perms & 0x400) != 0 ? (char)'s' : 'x') : ((perms & 0x400) != 0 ? (char)'S' : '-'));
        b.append((perms & 4) != 0 ? (char)'r' : '-');
        b.append((perms & 2) != 0 ? (char)'w' : '-');
        b.append((perms & 1) != 0 ? ((perms & 0x200) != 0 ? (char)'t' : 'x') : ((perms & 0x200) != 0 ? (char)'T' : '-'));
        return b.toString();
    }

    static String getParentPath(String normalizedPath) {
        int lastSlashIdx = normalizedPath.lastIndexOf(47);
        if (lastSlashIdx <= 0) {
            return normalizedPath.length() <= 1 ? "" : "/";
        }
        return normalizedPath.substring(0, lastSlashIdx);
    }

    static String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static String normalizeToUnix(String unixOrWindowsPath) {
        String pathToNormalize = OSUtilities.isWindows() ? unixOrWindowsPath.replace('/', '\\') : unixOrWindowsPath;
        String normalized = FilenameUtils.normalize(pathToNormalize);
        return OSUtilities.isWindows() && normalized != null ? normalized.replace('\\', '/') : normalized;
    }

    static String normalizePath(String hdf5ObjectPath) {
        String prenormalizedPath = Utils.normalizeToUnix(hdf5ObjectPath);
        if (prenormalizedPath == null && (prenormalizedPath = Utils.normalizeToUnix(hdf5ObjectPath.replace("//", "/"))) == null) {
            prenormalizedPath = hdf5ObjectPath.replace("//", "/");
        }
        String pathStartingWithSlash = prenormalizedPath.startsWith("/") ? prenormalizedPath : "/" + prenormalizedPath;
        return pathStartingWithSlash.length() > 1 && pathStartingWithSlash.endsWith("/") ? pathStartingWithSlash.substring(0, pathStartingWithSlash.length() - 1) : pathStartingWithSlash;
    }

    static File normalizePath(File path) {
        return new File(FilenameUtils.normalizeNoEndSeparator(path.getAbsolutePath()));
    }

    static String concatLink(String parentDirectory, String name) {
        return parentDirectory.endsWith("/") ? String.valueOf(parentDirectory) + name : String.valueOf(parentDirectory) + "/" + name;
    }

    static ArchiveEntry tryToArchiveEntry(String dir, String path, LinkRecord linkOrNull, IdCache idCache) {
        return linkOrNull != null ? new ArchiveEntry(dir, path, linkOrNull, idCache) : null;
    }

    static int getCurrentUid() {
        if (Unix.isOperational()) {
            return Unix.getUid();
        }
        return -1;
    }

    static int getCurrentGid() {
        if (Unix.isOperational()) {
            return Unix.getGid();
        }
        return -1;
    }

    static FileLinkType translateType(HDF5ObjectType hdf5Type) {
        switch (hdf5Type) {
            case DATASET: {
                return FileLinkType.REGULAR_FILE;
            }
            case GROUP: {
                return FileLinkType.DIRECTORY;
            }
            case SOFT_LINK: {
                return FileLinkType.SYMLINK;
            }
        }
        return FileLinkType.OTHER;
    }
}

