/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ReaderWrapper;
import loci.formats.WrappedReader;
import loci.formats.meta.MetadataStore;

public class FilePatternReader
extends WrappedReader {
    private FileStitcher helper;

    public FilePatternReader() {
        super("File pattern", new String[]{"pattern"});
        ClassList<IFormatReader> classes = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] classArray = classes.getClasses();
        ClassList<IFormatReader> newClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (Class<IFormatReader> c : classArray) {
            if (c.equals(FilePatternReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helper = new FileStitcher(new ImageReader(newClasses));
        this.suffixSufficient = true;
    }

    @Override
    protected ReaderWrapper getHelper() {
        return this.helper;
    }

    @Override
    public void setGroupFiles(boolean group) {
        this.getHelper().setGroupFiles(group);
    }

    @Override
    public boolean isGroupFiles() {
        return this.getHelper().isGroupFiles();
    }

    @Override
    public void setNormalized(boolean normalize) {
        this.getHelper().setNormalized(normalize);
    }

    @Override
    public boolean isNormalized() {
        return this.getHelper().isNormalized();
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        this.getHelper().setOriginalMetadataPopulated(populate);
    }

    @Override
    public boolean isOriginalMetadataPopulated() {
        return this.getHelper().isOriginalMetadataPopulated();
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        this.getHelper().setMetadataFiltered(filter);
    }

    @Override
    public boolean isMetadataFiltered() {
        return this.getHelper().isMetadataFiltered();
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        this.getHelper().setMetadataStore(store);
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.getHelper().getMetadataStore();
    }

    @Override
    public boolean hasFlattenedResolutions() {
        return this.getHelper().hasFlattenedResolutions();
    }

    @Override
    public void setFlattenedResolutions(boolean flattened) {
        this.getHelper().setFlattenedResolutions(flattened);
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.getCurrentFile() == null) {
            return null;
        }
        return this.helper.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.getCurrentFile() == null) {
            return null;
        }
        return this.helper.get16BitLookupTable();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] helperFiles = this.helper.getSeriesUsedFiles(noPixels);
        String[] allFiles = new String[helperFiles.length + 1];
        allFiles[0] = this.currentId;
        System.arraycopy(helperFiles, 0, allFiles, 1, helperFiles.length);
        return allFiles;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] helperFiles = this.helper.getUsedFiles(noPixels);
        String[] allFiles = new String[helperFiles.length + 1];
        allFiles[0] = this.currentId;
        System.arraycopy(helperFiles, 0, allFiles, 1, helperFiles.length);
        return allFiles;
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        List<CoreMetadata> oldcore = this.helper.getCoreMetadataList();
        ArrayList<CoreMetadata> newcore = new ArrayList<CoreMetadata>();
        for (int s2 = 0; s2 < oldcore.size(); ++s2) {
            CoreMetadata newMeta = oldcore.get(s2).clone(this, s2);
            newMeta.resolutionCount = oldcore.get((int)s2).resolutionCount;
            newcore.add(newMeta);
        }
        return newcore;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean hasCompanionFiles() {
        return true;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        this.currentId = new Location(id).getAbsolutePath();
        String pattern = DataTools.readFile(id).trim();
        String dir = new Location(id).getAbsoluteFile().getParent();
        if (new Location(pattern).getParent() == null) {
            pattern = dir + File.separator + pattern;
        }
        this.helper.setUsingPatternIds(true);
        this.helper.setCanChangePattern(false);
        this.helper.setId(pattern);
        this.core = this.helper.getCoreMetadataList();
        if (this.getEffectiveSizeC() > 1) {
            MetadataStore store = this.makeFilterMetadata();
            String[][] elements = this.helper.getFilePattern().getElements();
            int[] axisTypes = this.helper.getAxisTypes();
            int nextChannel = 0;
            for (int i = 0; i < axisTypes.length; ++i) {
                if (axisTypes[i] != 3) continue;
                for (int c = 0; c < elements[i].length; ++c) {
                    if (nextChannel >= this.getEffectiveSizeC()) continue;
                    store.setChannelName(elements[i][c], 0, nextChannel++);
                }
            }
        }
    }
}

