/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.util.Optional;

public class CatalogRef
extends Dataset {
    private final String xlink;
    private boolean isRead;
    private Catalog proxy;

    public CatalogRef(DatasetNode parent, String name, String xlink, Map<String, Object> flds, List<AccessBuilder> accessBuilders, List<DatasetBuilder> datasetBuilders) {
        super(parent, name, flds, accessBuilders, datasetBuilders);
        this.xlink = xlink;
    }

    public String getXlinkHref() {
        return this.xlink;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    public Boolean useRemoteCatalogService() {
        return (Boolean)this.flds.get("UseRemoteCatalogService");
    }

    public URI getURI() {
        try {
            Catalog parent = this.getParentCatalog();
            if (parent != null) {
                return parent.resolveUri(this.xlink);
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
        return null;
    }

    protected String translatePathToReletiveLocation(String dsPath, String configPath) {
        if (dsPath == null) {
            return null;
        }
        if (dsPath.isEmpty()) {
            return null;
        }
        if (dsPath.startsWith("/")) {
            dsPath = dsPath.substring(1);
        }
        if (!dsPath.startsWith(configPath)) {
            return null;
        }
        String dataDir = dsPath.substring(configPath.length());
        if (dataDir.startsWith("/")) {
            dataDir = dataDir.substring(1);
        }
        return dataDir;
    }

    @Override
    public boolean hasNestedDatasets() {
        return true;
    }

    @Override
    public List<Dataset> getDatasets() {
        if (this.proxy != null) {
            return this.proxy.getDatasets();
        }
        return super.getDatasets();
    }

    @Override
    public List<Dataset> getDatasetsLogical() {
        Optional<DatasetNode> opt = this.readCatref();
        if (!opt.isPresent()) {
            throw new RuntimeException(opt.getErrorMessage());
        }
        DatasetNode proxy = opt.get();
        return proxy.getDatasets();
    }

    public synchronized Optional<DatasetNode> readCatref() {
        if (this.proxy != null) {
            return Optional.of(this.proxy);
        }
        CatalogBuilder builder = new CatalogBuilder();
        Catalog cat = builder.buildFromCatref(this);
        if (builder.hasFatalError() || cat == null) {
            return Optional.empty("Error reading catref " + this.getURI() + " err=" + builder.getErrorMessage());
        }
        this.proxy = cat;
        return Optional.of(this.proxy);
    }
}

