/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.unidata.geoloc.projection.UtmProjection;

public class UTM
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "universal_transverse_mercator";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double zoned = this.readAttributeDouble(ctv, "utm_zone_number", Double.NaN);
        if (Double.isNaN(zoned)) {
            zoned = this.readAttributeDouble(ctv, "UTM_zone", Double.NaN);
        }
        if (Double.isNaN(zoned)) {
            throw new IllegalArgumentException("No zone was specified");
        }
        int zone = (int)zoned;
        boolean isNorth = zone > 0;
        zone = Math.abs(zone);
        double axis = 0.0;
        double f = 0.0;
        Attribute a = ctv.findAttribute("semimajor_axis");
        if (null != a) {
            axis = a.getNumericValue().doubleValue();
        }
        if (null != (a = ctv.findAttribute("inverse_flattening"))) {
            f = a.getNumericValue().doubleValue();
        }
        UtmProjection proj = axis != 0.0 ? new UtmProjection(axis, f, zone, isNorth) : new UtmProjection(zone, isNorth);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

