#!/usr/bin/env python
# -*- coding: utf-8 -*-

class ObjectClasses:
    Pedestrian = "pedestrian"
    Bicycle = "bicycle"
    Motorbike = "motorbike"
    Car = "car"
    Bus = "bus"
    Truck = "truck"
    Dog = "dog"
    Kickboard = "kickboard"
    Standard = [Pedestrian, Bicycle, Motorbike, Car, Bus, Truck]
    All = [Pedestrian, Bicycle, Motorbike, Car, Bus, Truck, Dog, Kickboard]


class ObjectClassesPlural:
    Pedestrians = "pedestrians"
    Bicycles = "bicycles"
    Motorbikes = "motorbikes"
    Cars = "cars"
    Buses = "buses"
    Trucks = "trucks"
    Dogs = "dogs"
    Kickboards = "kickboards"


OBJECT_CLASS_PLURALIZATION_MAP = {
    ObjectClasses.Pedestrian: ObjectClassesPlural.Pedestrians,
    ObjectClasses.Bicycle: ObjectClassesPlural.Bicycles,
    ObjectClasses.Motorbike: ObjectClassesPlural.Motorbikes,
    ObjectClasses.Car: ObjectClassesPlural.Cars,
    ObjectClasses.Bus: ObjectClassesPlural.Buses,
    ObjectClasses.Truck: ObjectClassesPlural.Trucks,
    ObjectClasses.Dog: ObjectClassesPlural.Dogs,
    ObjectClasses.Kickboard: ObjectClassesPlural.Kickboards
}


class ObjectClassesColorDefinitions:
    Pedestrian = "#3DB07C"
    Bicycle = "#00B2FF"
    Motorbike = "#FF66FF"
    Car = "#F66A4D"
    Bus = "#F8D022"
    Truck = "#B90038"
    Dog = "#6a0dad"
    Kickboard = "A67BE6"


ALL_OBJECT_CLASSES = [
    ObjectClasses.Pedestrian,
    ObjectClasses.Bicycle,
    ObjectClasses.Motorbike,
    ObjectClasses.Car,
    ObjectClasses.Bus,
    ObjectClasses.Truck,
    ObjectClasses.Dog,
    ObjectClasses.Kickboard
]


OBJECT_CLASSES_COLOR_MAP = {
    obj_class: getattr(ObjectClassesColorDefinitions, obj_class.capitalize())
    for obj_class in ALL_OBJECT_CLASSES
}


class CommonIntervals:
    # https://github.com/numina/numina-graph/blob/1fbd20f0a55077621d1d95b7da21a054167b51ae/api/src/analytics_queries/athena_filters.py#L174
    FifteenMinutes = "15m"
    ThirtyMinutes = "30m"
    OneHour = "1h"
    ThreeHours = "3h"
    SixHours = "6h"
    TwelveHours = "12h"
    OneDay = "1d"
    OneWeek = "1w"
    OneMinute = "1m"


ATHENA_STAGING_BUCKET = "s3://autogenerated-athena-api-query-results/"
NUMINA_GRAPH_URL = "https://api.numina.co/graphql"
SAMPLE_IMAGE_BUCKET_AND_DIR = "s3://numina-branding-assets/sample-data/default-images/"
SAMPLE_IMAGE_BUCKET = "numina-branding-assets"
