# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['yara_scanner']
install_requires = \
['plyara>=2.1.1,<3.0.0',
 'progress>=1.5,<2.0',
 'psutil>=5.6.7,<6.0.0',
 'yara-python>=4.0.2,<5.0.0']

entry_points = \
{'console_scripts': ['scan = yara_scanner:main',
                     'ysc = ysc:main',
                     'yss = yss:main']}

setup_kwargs = {
    'name': 'yara-scanner',
    'version': '1.9.10',
    'description': 'A Python wrapper library for libyara and a local server for fully utilizing the CPUs of the system to scan with yara.',
    'long_description': '# Yara Scanner\n\n[![ace-ecosystem](https://circleci.com/gh/ace-ecosystem/yara_scanner.svg?style=svg)](https://circleci.com/gh/ace-ecosystem/yara_scanner)\n\nA wrapper around the [yara-python](https://github.com/VirusTotal/yara-python) project the provides the following capabilities.\n\n- Change tracking of yara files, directories of yara files, or git repositories of yara files.\n- File and data scanning with the ability to filter based on meta data matching.\n- Distributed scanning processes that maximize the use of multi-core systems.\n- Command line interface.\n\n## Python Examples\n\nLoading a single yara file and then scanning data.\n\n```python\nfrom pprint import pprint\nfrom yara_scanner import YaraScanner\n\nscanner = YaraScanner()\n# tells the scanner to start tracking this yara file\nscanner.track_yara_file(\'my_rules.yar\')\nscanner.load_rules()\nif scanner.scan(\'/path/to/scan_target.txt\'):\n   pprint(scanner.scan_results)\n   \n# this returns True if any tracked yara files have changed\nif scanner.check_rules():\n   scanner.load_rules()\n```\n\n## Installation Instructions\n\n### From PyPi\n```bash\npip install yara-scanner\n```\n\n### From Github\n```\ngit clone https://github.com/ace-ecosystem/yara_scanner\ncd yara_scanner\npip install -r requirements.txt\n```\n\n## Yara Signature Locations\n\nThe default global pattern for loading rules is \n\n```\n/opt/signatures/*/*.yar\n```\n\nYou can use the `-d` option to specified a different default location, or, you can use the `-y`, `-Y`, `-G`, and `-z` options to specify specific locations.\n\n## Command Line Options\n\n   ```\n   usage: scan [-h] [-r] [--from-stdin] [-v] [-j] [-t] [--test-rule TEST_RULE] [--test-strings] [--test-strings-if] [--test-strings-threshold TEST_STRINGS_THRESHOLD] [--test-data TEST_DATA] [--csv CSV]\n            [--performance-csv PERFORMANCE_CSV] [--failure-csv FAILURE_CSV] [--string-performance-csv STRING_PERFORMANCE_CSV] [--string-failure-csv STRING_FAILURE_CSV] [-y YARA_RULES] [-Y YARA_DIRS] [-G YARA_REPOS]\n            [-z COMPILED_YARA_RULES] [-c] [-C COMPILE_TO] [-b BLACKLISTED_RULES] [-B BLACKLISTED_RULES_PATH] [-a] [--auto-compiled-rules-dir AUTO_COMPILED_RULES_DIR] [-d SIGNATURE_DIR]\n            [PATHS [PATHS ...]]\n\nScan the given file with yara using all available rulesets.\n\npositional arguments:\n  PATHS                 One or more files or directories to scan with yara.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -r, --recursive       Recursively scan directories.\n  --from-stdin          Read the list of files to scan from stdin.\n  -v, --verbose         Increase verbosity. Can specify multiple times for more verbose output\n  -j, --dump-json       Dump JSON details of matches. Otherwise just list the rules that hit.\n  -t, --test            Test each yara file separately against different types of buffers for performance issues.\n  --test-rule TEST_RULE\n                        Tests a specific rule.\n  --test-strings        Tests the performance all the strings individually in the selected yara rules.\n  --test-strings-if     Tests the performance all the strings individually in rules that take longer than N seconds to complete or rules that fail for any reason.\n  --test-strings-threshold TEST_STRINGS_THRESHOLD\n                        The threshold (in seconds) for the --test-strings-if option. Defaults to 0.1 seconds.\n  --test-data TEST_DATA\n                        Use the given file as the buffer of random data for the test data.\n  --csv CSV             Write performance results to the given CSV file.\n  --performance-csv PERFORMANCE_CSV\n                        Write the performance results of string testing to the given csv formatted file. Defaults to stdout.\n  --failure-csv FAILURE_CSV\n                        Write the failure results of string testing to the given csv formatted file. Defaults to stdout.\n  --string-performance-csv STRING_PERFORMANCE_CSV\n                        Write the performance results of string testing to the given csv formatted file. Defaults to stdout.\n  --string-failure-csv STRING_FAILURE_CSV\n                        Write the failure results of string testing to the given csv formatted file. Defaults to stdout.\n  -y YARA_RULES, --yara-rules YARA_RULES\n                        One yara rule to load. You can specify more than one of these.\n  -Y YARA_DIRS, --yara-dirs YARA_DIRS\n                        One directory containing yara rules to load. You can specify more than one of these.\n  -G YARA_REPOS, --yara-repos YARA_REPOS\n                        One directory that is a git repository that contains yara rules to load. You can specify more than one of these.\n  -z COMPILED_YARA_RULES, --compiled-yara-rules COMPILED_YARA_RULES\n                        Load compiled yara rules from the specified files. This option cannot be combined with -y, -Y, or -G\n  -c, --compile-only    Compile the rules and exit.\n  -C COMPILE_TO, --compile-to COMPILE_TO\n                        Compile the rules into the given file path.\n  -b BLACKLISTED_RULES, --blacklist BLACKLISTED_RULES\n                        A rule to blacklist (remove from the results.) You can specify more than one of these options.\n  -B BLACKLISTED_RULES_PATH, --blacklist-path BLACKLISTED_RULES_PATH\n                        Path to a file that contains a list of rules to blacklist, one per line.\n  -a, --auto-compile-rules\n                        Automatically saved the compiled yara rules to disk. Automatically loads pre-compiled rules based on MD5 hash of rule content.\n  --auto-compiled-rules-dir AUTO_COMPILED_RULES_DIR\n                        Specifies the directory to use to store automatically compiled yara rules. Defaults to the system temp dir.\n  -d SIGNATURE_DIR, --signature-dir SIGNATURE_DIR\n                        DEPRECATED: Use a different signature directory than the default.\n   ```\n\n## Command Line Examples\n\nscan a single file using the default rules\n   ```bash\n   scan ms0day.ppsx\n   ```\n\nscan a single file and generate JSON output with default rules\n   ```bash\n   scan -j ms0day.ppsx\n   scan -j ms0day.ppsx | json_pp\n   ```  \n\nscan multiple files with default rules\n   ```bash\n   scan file1 file2 file3\n   ```\n\nscan all files in a directory and all sub-directories with default rules\n   ```bash\n   scan -r dir\n   ```\n\nscan a list of files passed in on standard input with default rules\n   ``` bash\n   find dridex -type f | scan --from-stdin\n   ```\n\nscan a single file with a single yara rule\n   ```bash\n   scan -y myrule.yar target_file\n   ```\n\nscan a single file with all rules in a given directory\n  ```bash\n  scan -Y my_rule_dir target_file\n  ```\n\ncheck the syntax of all the rules in a given directory\n   ```bash\n   scan -c -Y my_rule_dir\n   ```\n\n## Filtering Rule Results\n\nThe scan tool also supports filtering out specific rules **before they are loaded**. These are specified by using the -b and -B command line options. This is useful for tuning open source repositories of yara rules.\n\n## Rule Output Selection\n\nYou can specify when a rule match should (or should not) be reported. This allows you to prevent some rules from matching against certain kinds of files, or for a rule to be matched against only one specific file.\n\nThe rules are specified as metadata name and value pairs. (example rule syntax)\n\n```yara\nrule html_rule: odd html\n{\nmeta:\n   mime_type = "text/html"\nstrings:\n   ...\ncondition:\n   ...\n}\n```\n\n### Metadata Names and Descriptions\n\n```\nfile_ext   | Matches everything past the first period in the file name.\nfile_name  | Matches the full name of the file (not including the path.)\nfull_path  | Matches against the full path of the file, if one was specified.\nmime_type  | Matches against the output of file -b --mime-type.\n```\n\nThe value of the metadata variable is a **comma separated list** of values to match. By default the library matches as is, but special modifiers can be used to perform sub string matching and regular expressions. **Special modifiers are applied to all comma separated values in the string.**\n\n### Matching Modifiers\n\n```\n!     | negation    | Negates the match. This can be placed before other modifiers.\nsub:  | sub-search  | Match if this string appears anywhere.\nre:   | regex       | Match if the regular expression is satisfied.\n```\n\nValues can be a comma separated list of values, regardless of the modifiers. Therefor, commas cannot be used in the patterns.\n\n### Rule Selection Examples\n\nOnly match files the end with the .exe extension.\n\n``` \nfile_ext = "exe"\n```\n\nOnly match files that end with .exe, .dll or .ocx extension.\n\n```\nfile_ext = "exe, dll, ocx"\n```\n\nOnly match files that do not end with .exe, .dll or .ocx extension.\n\n```\nfile_ext = "!exe, dll, ocx"\n```\n\nOnly matches files that do not end with .bmp.\n\n```\nfile_ext = "!bmp"\n```\n\nOnly match files identified as PDF despite the file name.\n\n```\nmime_type = "application/pdf"\n```\n\nOnly match files not identified as images.\n\n```\nmime_type = "!sub:image/"\n```\n\nOnly match files that look like an invoice phish.\n\n```\nfile_name = "re:invoice[0-9]+\\\\.doc$"\n```\n\nOnly match files in a subdirectory called /ole.\n\n```\nfull_path = "sub:/ole/"\n```\n\n## Yara Rule Performance Testing\n\nIt\'s often useful to know not only what rules have poor performance, but also what strings inside of those rules are causing the issue. This library has special support for this.\n\n### How Performance Testing Works\n\nEach yara rule is extracted and tested on its own against the following sets of data.\n\n- random data (either a 1MB random sequence of bytes or the contents of a file specified by the `--test-data` option.)\n- repeating byte patterns (1MB of repeating bytes of the same value.)\n\nIn total there are 256 buffers to test against for each test (one random and 255 repeating byte buffers.)\n\nYou can optionally also extract each regular expression from specified rules and test them by themselves against the same buffers. This allows you to determine which string is causing the issue.\n\n## Executing Performance Tests\n\nTesting all rules but not strings.\n\n```bash\nscan -t\n```\n\nTesting all rules and the strings of rules that take longer than 0.1 seconds to scan any buffer.\n\n```bash\nscan -t --test-strings-if --test-strings-threshold 0.1\n```\n\nTest a specific rule and all the strings inside of it.\n\n```bash\nscan -t --test-rule MyYaraRule --test-strings\n```\n\nTest all rules against the file `sample.dat`.\n\n```bash\nscan -t --test-data sample.dat\n```\n\n## CSV Output\n\nThe output of the test can be saved to CSV files using the following options.\n\n`--csv` saves all performance data to the given file.\n\n`--performance-csv` saves the performance data of entire yara files.\n\n`--failure-csv` saves any rules that fail under performance testing.\n\n`--string-performance-csv` saves the performance data of individual yara strings.\n\n`--string-failure-csv` save any strings that fail under performance testing.\n\nNote that if you do not specify these options the output is sent to standard out.\n\n## Output Format (Performance Data)\n\nPerformance data has the following format.\n\n`buffer_name, file_path, rule_name, total_seconds`\n\n`buffer_name` a description of the buffer that was used by the test, either **random** for random (or file) data, or **chr(*n*)** where *n* is the byte that was used for the buffer.\n\n`file_path` the path to the file that contains the yara rule.\n\n`rule_name` the name of the yara rule.\n\n`total_seconds` the total amount of time it took the yara rule to scan the given buffer.\n\nString performance data is similar but contains two additional fields.\n\n`buffer_name, file_path, rule_name, string_name, result_count, total_seconds`\n\n`string_name` is the name of the string inside the yara rule.\n\n`result_count` is the total number of times the string matched inside the buffer.\n\n## Output Format (Error Data)\n\nError data has a format that is similar to the performance data but inside of **total_seconds** you will see the error message that occurred when the given yara rule or string was used to scan the given buffer.\n\n## Error 30\n\nIf you see "Error 30" it means your rule, or strings inside of a rule, matched too many times.\n',
    'author': 'John Davison',
    'author_email': 'unixfreak0037@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ace-ecosystem/yara_scanner',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
