import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `CfnGeofenceCollection`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html
 */
export interface CfnGeofenceCollectionProps {
    /**
     * The name for the geofence collection.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-collectionname
     */
    readonly collectionName: string;
    /**
     * Specifies the pricing plan for the geofence collection.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplan
     */
    readonly pricingPlan: string;
    /**
     * An optional description for the geofence collection.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-description
     */
    readonly description?: string;
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) . Enter a key ID, key ARN, alias name, or alias ARN.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * Specifies the data provider for the geofence collection.
     *
     * - Required value for the following pricing plans: `MobileAssetTracking` | `MobileAssetManagement`
     *
     * For more information about [Data Providers](https://docs.aws.amazon.com/location/data-providers/) , and [Pricing plans](https://docs.aws.amazon.com/location/pricing/) , see the Amazon Location Service product page.
     *
     * > Amazon Location Service only uses `PricingPlanDataSource` to calculate billing for your geofence collection. Your data will not be shared with the data provider, and will remain in your AWS account or region unless you move it.
     *
     * Valid Values: `Esri` | `Here`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplandatasource
     */
    readonly pricingPlanDataSource?: string;
}
/**
 * A CloudFormation `AWS::Location::GeofenceCollection`.
 *
 * The `AWS::Location::GeofenceCollection` resource specifies the ability to detect and act when a tracked device enters or exits a defined geographical boundary known as a geofence.
 *
 * @external
 * @cloudformationResource AWS::Location::GeofenceCollection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html
 */
export declare class CfnGeofenceCollection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Location::GeofenceCollection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGeofenceCollection;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CollectionArn
     */
    readonly attrCollectionArn: string;
    /**
     * @external
     * @cloudformationAttribute CreateTime
     */
    readonly attrCreateTime: string;
    /**
     * @external
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * The name for the geofence collection.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-collectionname
     */
    collectionName: string;
    /**
     * Specifies the pricing plan for the geofence collection.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplan
     */
    pricingPlan: string;
    /**
     * An optional description for the geofence collection.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-description
     */
    description: string | undefined;
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) . Enter a key ID, key ARN, alias name, or alias ARN.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * Specifies the data provider for the geofence collection.
     *
     * - Required value for the following pricing plans: `MobileAssetTracking` | `MobileAssetManagement`
     *
     * For more information about [Data Providers](https://docs.aws.amazon.com/location/data-providers/) , and [Pricing plans](https://docs.aws.amazon.com/location/pricing/) , see the Amazon Location Service product page.
     *
     * > Amazon Location Service only uses `PricingPlanDataSource` to calculate billing for your geofence collection. Your data will not be shared with the data provider, and will remain in your AWS account or region unless you move it.
     *
     * Valid Values: `Esri` | `Here`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplandatasource
     */
    pricingPlanDataSource: string | undefined;
    /**
     * Create a new `AWS::Location::GeofenceCollection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGeofenceCollectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnMap`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html
 */
export interface CfnMapProps {
    /**
     * Specifies the map style selected from an available data provider.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-configuration
     */
    readonly configuration: CfnMap.MapConfigurationProperty | cdk.IResolvable;
    /**
     * The name for the map resource.
     *
     * Requirements:
     *
     * - Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * - Must be a unique map resource name.
     * - No spaces allowed. For example, `ExampleMap` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-mapname
     */
    readonly mapName: string;
    /**
     * Specifies the pricing plan for your map resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-pricingplan
     */
    readonly pricingPlan: string;
    /**
     * An optional description for the map resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::Location::Map`.
 *
 * The `AWS::Location::Map` resource specifies a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
 *
 * @external
 * @cloudformationResource AWS::Location::Map
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html
 */
export declare class CfnMap extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Location::Map";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMap;
    /**
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS .
     *
     * - Format example: `arn:aws:geo:region:account-id:maps/ExampleMap`
     *
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreateTime
     */
    readonly attrCreateTime: string;
    /**
     * @external
     * @cloudformationAttribute DataSource
     */
    readonly attrDataSource: string;
    /**
     * @external
     * @cloudformationAttribute MapArn
     */
    readonly attrMapArn: string;
    /**
     * @external
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * Specifies the map style selected from an available data provider.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-configuration
     */
    configuration: CfnMap.MapConfigurationProperty | cdk.IResolvable;
    /**
     * The name for the map resource.
     *
     * Requirements:
     *
     * - Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * - Must be a unique map resource name.
     * - No spaces allowed. For example, `ExampleMap` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-mapname
     */
    mapName: string;
    /**
     * Specifies the pricing plan for your map resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-pricingplan
     */
    pricingPlan: string;
    /**
     * An optional description for the map resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::Location::Map`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMapProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Location::Map`.
 *
 * The `AWS::Location::Map` resource specifies a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
 *
 * @external
 * @cloudformationResource AWS::Location::Map
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html
 */
export declare namespace CfnMap {
    /**
     * Specifies the map tile style selected from an available provider.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-map-mapconfiguration.html
     */
    interface MapConfigurationProperty {
        /**
         * Specifies the map style selected from an available data provider.
         *
         * Valid styles: `VectorEsriStreets` , `VectorEsriTopographic` , `VectorEsriNavigation` , `VectorEsriDarkGrayCanvas` , `VectorEsriLightGrayCanvas` , `VectorHereBerlin` .
         *
         * > When using HERE as your data provider, and selecting the Style `VectorHereBerlin` , you may not use HERE Maps for Asset Management. See the [AWS Service Terms](https://docs.aws.amazon.com/service-terms/) for Amazon Location Service.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-map-mapconfiguration.html#cfn-location-map-mapconfiguration-style
         */
        readonly style: string;
    }
}
/**
 * Properties for defining a `CfnPlaceIndex`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html
 */
export interface CfnPlaceIndexProps {
    /**
     * Specifies the data provider of geospatial data.
     *
     * > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` will return an error.
     *
     * Valid values include:
     *
     * - `Esri`
     * - `Here`
     *
     * > Place index resources using HERE as a data provider can't be used to [store](https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html) results for locations in Japan. For more information, see the [AWS Service Terms](https://docs.aws.amazon.com/service-terms/) for Amazon Location Service.
     *
     * For additional details on data providers, see the [Amazon Location Service data providers page](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-datasource
     */
    readonly dataSource: string;
    /**
     * The name of the place index resource.
     *
     * Requirements:
     *
     * - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * - Must be a unique place index resource name.
     * - No spaces allowed. For example, `ExamplePlaceIndex` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-indexname
     */
    readonly indexName: string;
    /**
     * Specifies the pricing plan for your place index resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-pricingplan
     */
    readonly pricingPlan: string;
    /**
     * Specifies the data storage option for requesting Places.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-datasourceconfiguration
     */
    readonly dataSourceConfiguration?: CfnPlaceIndex.DataSourceConfigurationProperty | cdk.IResolvable;
    /**
     * The optional description for the place index resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::Location::PlaceIndex`.
 *
 * The `AWS::Location::PlaceIndex` resource specifies a place index resource in your AWS account, which supports Places functions with geospatial data sourced from your chosen data provider.
 *
 * @external
 * @cloudformationResource AWS::Location::PlaceIndex
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html
 */
export declare class CfnPlaceIndex extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Location::PlaceIndex";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPlaceIndex;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreateTime
     */
    readonly attrCreateTime: string;
    /**
     * @external
     * @cloudformationAttribute IndexArn
     */
    readonly attrIndexArn: string;
    /**
     * @external
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * Specifies the data provider of geospatial data.
     *
     * > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` will return an error.
     *
     * Valid values include:
     *
     * - `Esri`
     * - `Here`
     *
     * > Place index resources using HERE as a data provider can't be used to [store](https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html) results for locations in Japan. For more information, see the [AWS Service Terms](https://docs.aws.amazon.com/service-terms/) for Amazon Location Service.
     *
     * For additional details on data providers, see the [Amazon Location Service data providers page](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-datasource
     */
    dataSource: string;
    /**
     * The name of the place index resource.
     *
     * Requirements:
     *
     * - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * - Must be a unique place index resource name.
     * - No spaces allowed. For example, `ExamplePlaceIndex` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-indexname
     */
    indexName: string;
    /**
     * Specifies the pricing plan for your place index resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-pricingplan
     */
    pricingPlan: string;
    /**
     * Specifies the data storage option for requesting Places.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-datasourceconfiguration
     */
    dataSourceConfiguration: CfnPlaceIndex.DataSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * The optional description for the place index resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html#cfn-location-placeindex-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::Location::PlaceIndex`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPlaceIndexProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Location::PlaceIndex`.
 *
 * The `AWS::Location::PlaceIndex` resource specifies a place index resource in your AWS account, which supports Places functions with geospatial data sourced from your chosen data provider.
 *
 * @external
 * @cloudformationResource AWS::Location::PlaceIndex
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html
 */
export declare namespace CfnPlaceIndex {
    /**
     * Specifies the data storage option for requesting Places.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-placeindex-datasourceconfiguration.html
     */
    interface DataSourceConfigurationProperty {
        /**
         * Specifies how the results of an operation will be stored by the caller.
         *
         * Valid values include:
         *
         * - `SingleUse` specifies that the results won't be stored.
         * - `Storage` specifies that the result can be cached or stored in a database.
         *
         * > Place index resources using HERE as a data provider can't be configured to store results for locations in Japan when choosing `Storage` for the `IntendedUse` parameter.
         *
         * Default value: `SingleUse`
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-location-placeindex-datasourceconfiguration.html#cfn-location-placeindex-datasourceconfiguration-intendeduse
         */
        readonly intendedUse?: string;
    }
}
/**
 * Properties for defining a `CfnRouteCalculator`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html
 */
export interface CfnRouteCalculatorProps {
    /**
     * The name of the route calculator resource.
     *
     * Requirements:
     *
     * - Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
     * - Must be a unique route calculator resource name.
     * - No spaces allowed. For example, `ExampleRouteCalculator` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-calculatorname
     */
    readonly calculatorName: string;
    /**
     * Specifies the data provider of traffic and road network data.
     *
     * > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error.
     *
     * Valid values include:
     *
     * - `Esri`
     * - `Here`
     *
     * For more information about data providers, see the [Amazon Location Service data providers page](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-datasource
     */
    readonly dataSource: string;
    /**
     * Specifies the pricing plan for your route calculator resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-pricingplan
     */
    readonly pricingPlan: string;
    /**
     * The optional description for the route calculator resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::Location::RouteCalculator`.
 *
 * The `AWS::Location::RouteCalculator` resource specifies a route calculator resource in your AWS account.
 *
 * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
 *
 * @external
 * @cloudformationResource AWS::Location::RouteCalculator
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html
 */
export declare class CfnRouteCalculator extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Location::RouteCalculator";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRouteCalculator;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CalculatorArn
     */
    readonly attrCalculatorArn: string;
    /**
     * @external
     * @cloudformationAttribute CreateTime
     */
    readonly attrCreateTime: string;
    /**
     * @external
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * The name of the route calculator resource.
     *
     * Requirements:
     *
     * - Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
     * - Must be a unique route calculator resource name.
     * - No spaces allowed. For example, `ExampleRouteCalculator` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-calculatorname
     */
    calculatorName: string;
    /**
     * Specifies the data provider of traffic and road network data.
     *
     * > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error.
     *
     * Valid values include:
     *
     * - `Esri`
     * - `Here`
     *
     * For more information about data providers, see the [Amazon Location Service data providers page](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-datasource
     */
    dataSource: string;
    /**
     * Specifies the pricing plan for your route calculator resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-pricingplan
     */
    pricingPlan: string;
    /**
     * The optional description for the route calculator resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html#cfn-location-routecalculator-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::Location::RouteCalculator`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteCalculatorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnTracker`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html
 */
export interface CfnTrackerProps {
    /**
     * Specifies the pricing plan for the tracker resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplan
     */
    readonly pricingPlan: string;
    /**
     * The name for the tracker resource.
     *
     * Requirements:
     *
     * - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * - Must be a unique tracker resource name.
     * - No spaces allowed. For example, `ExampleTracker` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-trackername
     */
    readonly trackerName: string;
    /**
     * An optional description for the tracker resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-description
     */
    readonly description?: string;
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) . Enter a key ID, key ARN, alias name, or alias ARN.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * Specifies the position filtering for the tracker resource.
     *
     * Valid values:
     *
     * - `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     * - `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
     *
     * This field is optional. If not specified, the default value is `TimeBased` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-positionfiltering
     */
    readonly positionFiltering?: string;
    /**
     * Specifies the data provider for the tracker resource.
     *
     * - Required value for the following pricing plans: `MobileAssetTracking` | `MobileAssetManagement`
     *
     * For more information about [Data Providers](https://docs.aws.amazon.com/location/data-providers/) , and [Pricing plans](https://docs.aws.amazon.com/location/pricing/) , see the Amazon Location Service product page.
     *
     * > Amazon Location Service only uses `PricingPlanDataSource` to calculate billing for your tracker resource. Your data will not be shared with the data provider, and will remain in your AWS account or region unless you move it.
     *
     * Valid Values: `Esri` | `Here`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplandatasource
     */
    readonly pricingPlanDataSource?: string;
}
/**
 * A CloudFormation `AWS::Location::Tracker`.
 *
 * The `AWS::Location::Tracker` resource specifies a tracker resource in your AWS account , which lets you receive current and historical location of devices.
 *
 * @external
 * @cloudformationResource AWS::Location::Tracker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html
 */
export declare class CfnTracker extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Location::Tracker";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTracker;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreateTime
     */
    readonly attrCreateTime: string;
    /**
     * @external
     * @cloudformationAttribute TrackerArn
     */
    readonly attrTrackerArn: string;
    /**
     * @external
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * Specifies the pricing plan for the tracker resource.
     *
     * For additional details and restrictions on each pricing plan option, see the [Amazon Location Service pricing page](https://docs.aws.amazon.com/location/pricing/) .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplan
     */
    pricingPlan: string;
    /**
     * The name for the tracker resource.
     *
     * Requirements:
     *
     * - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * - Must be a unique tracker resource name.
     * - No spaces allowed. For example, `ExampleTracker` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-trackername
     */
    trackerName: string;
    /**
     * An optional description for the tracker resource.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-description
     */
    description: string | undefined;
    /**
     * A key identifier for an [AWS KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) . Enter a key ID, key ARN, alias name, or alias ARN.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * Specifies the position filtering for the tracker resource.
     *
     * Valid values:
     *
     * - `TimeBased` - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     * - `DistanceBased` - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
     *
     * This field is optional. If not specified, the default value is `TimeBased` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-positionfiltering
     */
    positionFiltering: string | undefined;
    /**
     * Specifies the data provider for the tracker resource.
     *
     * - Required value for the following pricing plans: `MobileAssetTracking` | `MobileAssetManagement`
     *
     * For more information about [Data Providers](https://docs.aws.amazon.com/location/data-providers/) , and [Pricing plans](https://docs.aws.amazon.com/location/pricing/) , see the Amazon Location Service product page.
     *
     * > Amazon Location Service only uses `PricingPlanDataSource` to calculate billing for your tracker resource. Your data will not be shared with the data provider, and will remain in your AWS account or region unless you move it.
     *
     * Valid Values: `Esri` | `Here`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplandatasource
     */
    pricingPlanDataSource: string | undefined;
    /**
     * Create a new `AWS::Location::Tracker`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrackerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnTrackerConsumer`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html
 */
export interface CfnTrackerConsumerProps {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource.
     *
     * Used when you need to specify a resource across all AWS .
     *
     * - Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-consumerarn
     */
    readonly consumerArn: string;
    /**
     * The name for the tracker resource.
     *
     * Requirements:
     *
     * - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * - Must be a unique tracker resource name.
     * - No spaces allowed. For example, `ExampleTracker` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-trackername
     */
    readonly trackerName: string;
}
/**
 * A CloudFormation `AWS::Location::TrackerConsumer`.
 *
 * The `AWS::Location::TrackerConsumer` resource specifies an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
 *
 * > Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
 *
 * @external
 * @cloudformationResource AWS::Location::TrackerConsumer
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html
 */
export declare class CfnTrackerConsumer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Location::TrackerConsumer";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrackerConsumer;
    /**
     * The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource.
     *
     * Used when you need to specify a resource across all AWS .
     *
     * - Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-consumerarn
     */
    consumerArn: string;
    /**
     * The name for the tracker resource.
     *
     * Requirements:
     *
     * - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
     * - Must be a unique tracker resource name.
     * - No spaces allowed. For example, `ExampleTracker` .
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html#cfn-location-trackerconsumer-trackername
     */
    trackerName: string;
    /**
     * Create a new `AWS::Location::TrackerConsumer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrackerConsumerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
