#ifndef __KSGOLDQUOTMARKETDATAAPI__H__
#define __KSGOLDQUOTMARKETDATAAPI__H__

#ifdef KSGOLDQUOTMARKETDATAAPI_EXPORTS
#define KSGOLDQUOTMARKETDATAAPI_API __declspec(dllexport)
#else
#ifdef WIN32
#define KSGOLDQUOTMARKETDATAAPI_API __declspec(dllimport)
#else 
#define KSGOLDQUOTMARKETDATAAPI_API
#endif
#endif

#include "KSGoldUserApiStructEx.h"

namespace KSGoldTradeAPI
{
class CKSGoldQuoSpi
{
public:
	///ͻ뽻׺̨ͨʱ÷á
	///ֶʱҲô˷
	///@param nResult ؽ
	///        0x1001 
	///        0x1002 ɹ
	virtual void OnFrontConnected(int nResult){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};
	
	///¼Ӧ
	virtual void OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ǳӦ
	virtual void OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///Ӧ
	virtual void OnRspError(CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///Ӧ
	virtual void OnRspSubMarketData(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ȡӦ
	virtual void OnRspUnSubMarketData(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///֪ͨ
	virtual void OnRtnDepthMarketData(CThostFtdcDepthMarketDataField *pDepthMarketData) {};

};

class KSGOLDQUOTMARKETDATAAPI_API CKSGoldQuotApi
{
public:
	///QutoApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	///@param bIsKlg ĬϴKLG־
	///@return UserApi    
	static CKSGoldQuotApi *CreateGoldQutoApi(const char *pszFlowPath = "");
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual bool Init() = 0;
	
	///ȴӿ߳̽
	///@return ߳˳
	virtual int Join() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CKSGoldQuoSpi *pSpi) = 0;
	
	///顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int SubscribeMarketData(char *ppInstrumentID[], int nCount, int nRequestID) = 0;
	
	///˶顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int UnSubscribeMarketData(char *ppInstrumentID[], int nCount, int nRequestID) = 0;
	
	///û¼
	virtual int ReqUserLogin(CThostFtdcReqUserLoginField *pReqUserLoginField, int nRequestID) = 0;
	
	///ǳ
	virtual int ReqUserLogout(CThostFtdcUserLogoutField *pUserLogout, int nRequestID) = 0;
protected:
	~CKSGoldQuotApi(){};
}; 

}  //end of KSGoldTradeAPI

#endif  //__KSGOLDQUOTMARKETDATAAPI__H__

