# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class SecurityPolicy(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    An optional description of this security policy. Max size is 2048.
    """
    fingerprint: pulumi.Output[str]
    """
    Fingerprint of this resource.
    """
    name: pulumi.Output[str]
    """
    The name of the security policy.
    """
    project: pulumi.Output[str]
    """
    The project in which the resource belongs. If it
    is not provided, the provider project is used.
    """
    rules: pulumi.Output[list]
    """
    The set of rules that belong to this policy. There must always be a default
    rule (rule with priority 2147483647 and match "\*"). If no rules are provided when creating a
    security policy, a default rule with action "allow" will be added. Structure is documented below.

      * `action` (`str`)
      * `description` (`str`) - An optional description of this security policy. Max size is 2048.
      * `match` (`dict`)
        * `config` (`dict`)
          * `srcIpRanges` (`list`)

        * `expr` (`dict`)
          * `expression` (`str`)

        * `versionedExpr` (`str`)

      * `preview` (`bool`)
      * `priority` (`float`)
    """
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    def __init__(__self__, resource_name, opts=None, description=None, name=None, project=None, rules=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a SecurityPolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[str] name: The name of the security policy.
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[list] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.

        The **rules** object supports the following:

          * `action` (`pulumi.Input[str]`)
          * `description` (`pulumi.Input[str]`) - An optional description of this security policy. Max size is 2048.
          * `match` (`pulumi.Input[dict]`)
            * `config` (`pulumi.Input[dict]`)
              * `srcIpRanges` (`pulumi.Input[list]`)

            * `expr` (`pulumi.Input[dict]`)
              * `expression` (`pulumi.Input[str]`)

            * `versionedExpr` (`pulumi.Input[str]`)

          * `preview` (`pulumi.Input[bool]`)
          * `priority` (`pulumi.Input[float]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['name'] = name
            __props__['project'] = project
            __props__['rules'] = rules
            __props__['fingerprint'] = None
            __props__['self_link'] = None
        super(SecurityPolicy, __self__).__init__(
            'gcp:compute/securityPolicy:SecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, fingerprint=None, name=None, project=None, rules=None, self_link=None):
        """
        Get an existing SecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this security policy. Max size is 2048.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource.
        :param pulumi.Input[str] name: The name of the security policy.
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[list] rules: The set of rules that belong to this policy. There must always be a default
               rule (rule with priority 2147483647 and match "\*"). If no rules are provided when creating a
               security policy, a default rule with action "allow" will be added. Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.

        The **rules** object supports the following:

          * `action` (`pulumi.Input[str]`)
          * `description` (`pulumi.Input[str]`) - An optional description of this security policy. Max size is 2048.
          * `match` (`pulumi.Input[dict]`)
            * `config` (`pulumi.Input[dict]`)
              * `srcIpRanges` (`pulumi.Input[list]`)

            * `expr` (`pulumi.Input[dict]`)
              * `expression` (`pulumi.Input[str]`)

            * `versionedExpr` (`pulumi.Input[str]`)

          * `preview` (`pulumi.Input[bool]`)
          * `priority` (`pulumi.Input[float]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["fingerprint"] = fingerprint
        __props__["name"] = name
        __props__["project"] = project
        __props__["rules"] = rules
        __props__["self_link"] = self_link
        return SecurityPolicy(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

