# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Cluster(pulumi.CustomResource):
    addons_config: pulumi.Output[dict]
    """
    The configuration for addons supported by GKE.
    Structure is documented below.

      * `cloudrunConfig` (`dict`)
        * `disabled` (`bool`)

      * `horizontalPodAutoscaling` (`dict`)
        * `disabled` (`bool`)

      * `httpLoadBalancing` (`dict`)
        * `disabled` (`bool`)

      * `istioConfig` (`dict`)
        * `auth` (`str`)
        * `disabled` (`bool`)

      * `networkPolicyConfig` (`dict`)
        * `disabled` (`bool`)
    """
    authenticator_groups_config: pulumi.Output[dict]
    """
    Configuration for the
    [Google Groups for GKE](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control#groups-setup-gsuite) feature.
    Structure is documented below.

      * `securityGroup` (`str`)
    """
    cluster_autoscaling: pulumi.Output[dict]
    """
    )
    Per-cluster configuration of Node Auto-Provisioning with Cluster Autoscaler to
    automatically adjust the size of the cluster and create/delete node pools based
    on the current needs of the cluster's workload. See the
    [guide to using Node Auto-Provisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
    for more details. Structure is documented below.

      * `autoProvisioningDefaults` (`dict`)
        * `oauthScopes` (`list`)
        * `service_account` (`str`)

      * `autoscalingProfile` (`str`)
      * `enabled` (`bool`)
      * `resourceLimits` (`list`)
        * `maximum` (`float`)
        * `minimum` (`float`)
        * `resourceType` (`str`)
    """
    cluster_ipv4_cidr: pulumi.Output[str]
    """
    The IP address range of the Kubernetes pods
    in this cluster in CIDR notation (e.g. `10.96.0.0/14`). Leave blank to have one
    automatically chosen or specify a `/14` block in `10.0.0.0/8`. This field will
    only work for routes-based clusters, where `ip_allocation_policy` is not defined.
    """
    database_encryption: pulumi.Output[dict]
    """
    ).
    Structure is documented below.

      * `keyName` (`str`)
      * `state` (`str`)
    """
    default_max_pods_per_node: pulumi.Output[float]
    """
    The default maximum number of pods
    per node in this cluster. This doesn't work on "routes-based" clusters, clusters
    that don't have IP Aliasing enabled. See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
    for more information.
    """
    description: pulumi.Output[str]
    """
    Description of the cluster.
    """
    enable_binary_authorization: pulumi.Output[bool]
    """
    Enable Binary Authorization for this cluster.
    If enabled, all container images will be validated by Google Binary Authorization.
    """
    enable_intranode_visibility: pulumi.Output[bool]
    """
    )
    Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
    """
    enable_kubernetes_alpha: pulumi.Output[bool]
    """
    Whether to enable Kubernetes Alpha features for
    this cluster. Note that when this option is enabled, the cluster cannot be upgraded
    and will be automatically deleted after 30 days.
    """
    enable_legacy_abac: pulumi.Output[bool]
    """
    Whether the ABAC authorizer is enabled for this cluster.
    When enabled, identities in the system, including service accounts, nodes, and controllers,
    will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
    Defaults to `false`
    """
    enable_shielded_nodes: pulumi.Output[bool]
    """
    ) Enable Shielded Nodes features on all nodes in this cluster.  Defaults to `false`.
    """
    enable_tpu: pulumi.Output[bool]
    """
    ) Whether to enable Cloud TPU resources in this cluster.
    See the [official documentation](https://cloud.google.com/tpu/docs/kubernetes-engine-setup).
    """
    endpoint: pulumi.Output[str]
    """
    The IP address of this cluster's Kubernetes master.
    """
    initial_node_count: pulumi.Output[float]
    """
    The number of nodes to create in this
    cluster's default node pool. In regional or multi-zonal clusters, this is the
    number of nodes per zone. Must be set if `node_pool` is not set. If you're using
    `container.NodePool` objects with no default node pool, you'll need to
    set this to a value of at least `1`, alongside setting
    `remove_default_node_pool` to `true`.
    """
    instance_group_urls: pulumi.Output[list]
    """
    List of instance group URLs which have been assigned
    to the cluster.
    """
    ip_allocation_policy: pulumi.Output[dict]
    """
    Configuration of cluster IP allocation for
    VPC-native clusters. Adding this block enables [IP aliasing](https://cloud.google.com/kubernetes-engine/docs/how-to/ip-aliases),
    making the cluster VPC-native instead of routes-based. Structure is documented
    below.

      * `clusterIpv4CidrBlock` (`str`)
      * `clusterSecondaryRangeName` (`str`)
      * `servicesIpv4CidrBlock` (`str`)
      * `servicesSecondaryRangeName` (`str`)
    """
    label_fingerprint: pulumi.Output[str]
    """
    The fingerprint of the set of labels for this cluster.
    """
    location: pulumi.Output[str]
    """
    The location (region or zone) in which the cluster
    master will be created, as well as the default node location. If you specify a
    zone (such as `us-central1-a`), the cluster will be a zonal cluster with a
    single cluster master. If you specify a region (such as `us-west1`), the
    cluster will be a regional cluster with multiple masters spread across zones in
    the region, and with default node locations in those zones as well
    """
    logging_service: pulumi.Output[str]
    """
    The logging service that the cluster should
    write logs to. Available options include `logging.googleapis.com`(Legacy Stackdriver),
    `logging.googleapis.com/kubernetes`(Stackdriver Kubernetes Engine Logging), and `none`. Defaults to `logging.googleapis.com/kubernetes`
    """
    maintenance_policy: pulumi.Output[dict]
    """
    The maintenance policy to use for the cluster. Structure is
    documented below.

      * `dailyMaintenanceWindow` (`dict`)
        * `duration` (`str`)
        * `startTime` (`str`)

      * `recurringWindow` (`dict`)
        * `endTime` (`str`)
        * `recurrence` (`str`)
        * `startTime` (`str`)
    """
    master_auth: pulumi.Output[dict]
    """
    The authentication information for accessing the
    Kubernetes master. Some values in this block are only returned by the API if
    your service account has permission to get credentials for your GKE cluster. If
    you see an unexpected diff removing a username/password or unsetting your client
    cert, ensure you have the `container.clusters.getCredentials` permission.
    Structure is documented below.

      * `clientCertificate` (`str`)
      * `clientCertificateConfig` (`dict`)
        * `issueClientCertificate` (`bool`)

      * `clientKey` (`str`)
      * `clusterCaCertificate` (`str`)
      * `password` (`str`)
      * `username` (`str`)
    """
    master_authorized_networks_config: pulumi.Output[dict]
    """
    The desired configuration options
    for master authorized networks. Omit the nested `cidr_blocks` attribute to disallow
    external access (except the cluster node IPs, which GKE automatically whitelists).

      * `cidrBlocks` (`list`)
        * `cidr_block` (`str`)
        * `display_name` (`str`)
    """
    master_version: pulumi.Output[str]
    """
    The current version of the master in the cluster. This may
    be different than the `min_master_version` set in the config if the master
    has been updated by GKE.
    """
    min_master_version: pulumi.Output[str]
    """
    The minimum version of the master. GKE
    will auto-update the master to new versions, so this does not guarantee the
    current master version--use the read-only `master_version` field to obtain that.
    If unset, the cluster's version will be set by GKE to the version of the most recent
    official release (which is not necessarily the latest version).  Most users will find
    the `container.getEngineVersions` data source useful - it indicates which versions
    are available, and can be use to approximate fuzzy versions. If you intend to specify versions manually,
    [the docs](https://cloud.google.com/kubernetes-engine/versioning-and-upgrades#specifying_cluster_version)
    describe the various acceptable formats for this field.
    """
    monitoring_service: pulumi.Output[str]
    """
    The monitoring service that the cluster
    should write metrics to.
    Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API.
    VM metrics will be collected by Google Compute Engine regardless of this setting
    Available options include
    `monitoring.googleapis.com`(Legacy Stackdriver), `monitoring.googleapis.com/kubernetes`(Stackdriver Kubernetes Engine Monitoring), and `none`.
    Defaults to `monitoring.googleapis.com/kubernetes`
    """
    name: pulumi.Output[str]
    """
    The name of the cluster, unique within the project and
    location.
    """
    network: pulumi.Output[str]
    """
    The name or self_link of the Google Compute Engine
    network to which the cluster is connected. For Shared VPC, set this to the self link of the
    shared network.
    """
    network_policy: pulumi.Output[dict]
    """
    Configuration options for the
    [NetworkPolicy](https://kubernetes.io/docs/concepts/services-networking/networkpolicies/)
    feature. Structure is documented below.

      * `enabled` (`bool`)
      * `provider` (`str`)
    """
    node_config: pulumi.Output[dict]
    """
    Parameters used in creating the default node pool.
    Generally, this field should not be used at the same time as a
    `container.NodePool` or a `node_pool` block; this configuration
    manages the default node pool, which isn't recommended to be used with
    this provider. Structure is documented below.

      * `bootDiskKmsKey` (`str`)
      * `disk_size_gb` (`float`)
      * `diskType` (`str`)
      * `guest_accelerators` (`list`)
        * `count` (`float`)
        * `type` (`str`)

      * `imageType` (`str`)
      * `labels` (`dict`)
      * `localSsdCount` (`float`)
      * `machine_type` (`str`)
      * `metadata` (`dict`)
      * `min_cpu_platform` (`str`)
      * `oauthScopes` (`list`)
      * `preemptible` (`bool`)
      * `sandboxConfig` (`dict`)
        * `sandboxType` (`str`)

      * `service_account` (`str`)
      * `shielded_instance_config` (`dict`)
        * `enableIntegrityMonitoring` (`bool`)
        * `enableSecureBoot` (`bool`)

      * `tags` (`list`)
      * `taints` (`list`)
        * `effect` (`str`)
        * `key` (`str`)
        * `value` (`str`)

      * `workloadMetadataConfig` (`dict`)
        * `nodeMetadata` (`str`)
    """
    node_locations: pulumi.Output[list]
    """
    The list of zones in which the cluster's nodes
    are located. Nodes must be in the region of their regional cluster or in the
    same region as their cluster's zone for zonal clusters. If this is specified for
    a zonal cluster, omit the cluster's zone.
    """
    node_pools: pulumi.Output[list]
    """
    List of node pools associated with this cluster.
    See container.NodePool for schema.
    **Warning:** node pools defined inside a cluster can't be changed (or added/removed) after
    cluster creation without deleting and recreating the entire cluster. Unless you absolutely need the ability
    to say "these are the _only_ node pools associated with this cluster", use the
    container.NodePool resource instead of this property.

      * `autoscaling` (`dict`)
        * `maxNodeCount` (`float`)
        * `minNodeCount` (`float`)

      * `initial_node_count` (`float`) - The number of nodes to create in this
        cluster's default node pool. In regional or multi-zonal clusters, this is the
        number of nodes per zone. Must be set if `node_pool` is not set. If you're using
        `container.NodePool` objects with no default node pool, you'll need to
        set this to a value of at least `1`, alongside setting
        `remove_default_node_pool` to `true`.
      * `instance_group_urls` (`list`) - List of instance group URLs which have been assigned
        to the cluster.
      * `management` (`dict`)
        * `autoRepair` (`bool`)
        * `autoUpgrade` (`bool`)

      * `max_pods_per_node` (`float`)
      * `name` (`str`) - The name of the cluster, unique within the project and
        location.
      * `name_prefix` (`str`)
      * `node_config` (`dict`) - Parameters used in creating the default node pool.
        Generally, this field should not be used at the same time as a
        `container.NodePool` or a `node_pool` block; this configuration
        manages the default node pool, which isn't recommended to be used with
        this provider. Structure is documented below.
        * `bootDiskKmsKey` (`str`)
        * `disk_size_gb` (`float`)
        * `diskType` (`str`)
        * `guest_accelerators` (`list`)
          * `count` (`float`)
          * `type` (`str`)

        * `imageType` (`str`)
        * `labels` (`dict`)
        * `localSsdCount` (`float`)
        * `machine_type` (`str`)
        * `metadata` (`dict`)
        * `min_cpu_platform` (`str`)
        * `oauthScopes` (`list`)
        * `preemptible` (`bool`)
        * `sandboxConfig` (`dict`)
          * `sandboxType` (`str`)

        * `service_account` (`str`)
        * `shielded_instance_config` (`dict`)
          * `enableIntegrityMonitoring` (`bool`)
          * `enableSecureBoot` (`bool`)

        * `tags` (`list`)
        * `taints` (`list`)
          * `effect` (`str`)
          * `key` (`str`)
          * `value` (`str`)

        * `workloadMetadataConfig` (`dict`)
          * `nodeMetadata` (`str`)

      * `node_count` (`float`)
      * `node_locations` (`list`) - The list of zones in which the cluster's nodes
        are located. Nodes must be in the region of their regional cluster or in the
        same region as their cluster's zone for zonal clusters. If this is specified for
        a zonal cluster, omit the cluster's zone.
      * `upgrade_settings` (`dict`)
        * `maxSurge` (`float`)
        * `maxUnavailable` (`float`)

      * `version` (`str`)
    """
    node_version: pulumi.Output[str]
    """
    The Kubernetes version on the nodes. Must either be unset
    or set to the same value as `min_master_version` on create. Defaults to the default
    version set by GKE which is not necessarily the latest version. This only affects
    nodes in the default node pool. While a fuzzy version can be specified, it's
    recommended that you specify explicit versions as this provider will see spurious diffs
    when fuzzy versions are used. See the `container.getEngineVersions` data source's
    `version_prefix` field to approximate fuzzy versions.
    To update nodes in other node pools, use the `version` attribute on the node pool.
    """
    operation: pulumi.Output[str]
    pod_security_policy_config: pulumi.Output[dict]
    """
    ) Configuration for the
    [PodSecurityPolicy](https://cloud.google.com/kubernetes-engine/docs/how-to/pod-security-policies) feature.
    Structure is documented below.

      * `enabled` (`bool`)
    """
    private_cluster_config: pulumi.Output[dict]
    """
    Configuration for [private clusters](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters),
    clusters with private nodes. Structure is documented below.

      * `enablePrivateEndpoint` (`bool`)
      * `enablePrivateNodes` (`bool`)
      * `masterIpv4CidrBlock` (`str`)
      * `peeringName` (`str`)
      * `privateEndpoint` (`str`)
      * `publicEndpoint` (`str`)
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs. If it
    is not provided, the provider project is used.
    """
    release_channel: pulumi.Output[dict]
    """
    ) Configuration options for the
    [Release channel](https://cloud.google.com/kubernetes-engine/docs/concepts/release-channels)
    feature, which provide more control over automatic upgrades of your GKE clusters. Structure is documented below.

      * `channel` (`str`)
    """
    remove_default_node_pool: pulumi.Output[bool]
    """
    If `true`, deletes the default node
    pool upon cluster creation. If you're using `container.NodePool`
    resources with no default node pool, this should be set to `true`, alongside
    setting `initial_node_count` to at least `1`.
    """
    resource_labels: pulumi.Output[dict]
    """
    The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
    """
    resource_usage_export_config: pulumi.Output[dict]
    """
    ) Configuration for the
    [ResourceUsageExportConfig](https://cloud.google.com/kubernetes-engine/docs/how-to/cluster-usage-metering) feature.
    Structure is documented below.

      * `bigqueryDestination` (`dict`)
        * `dataset_id` (`str`)

      * `enableNetworkEgressMetering` (`bool`)
    """
    services_ipv4_cidr: pulumi.Output[str]
    """
    The IP address range of the Kubernetes services in this
    cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
    notation (e.g. `1.2.3.4/29`). Service addresses are typically put in the last
    `/16` from the container CIDR.
    """
    subnetwork: pulumi.Output[str]
    """
    The name or self_link of the Google Compute Engine
    subnetwork in which the cluster's instances are launched.
    """
    tpu_ipv4_cidr_block: pulumi.Output[str]
    vertical_pod_autoscaling: pulumi.Output[dict]
    """
    )
    Vertical Pod Autoscaling automatically adjusts the resources of pods controlled by it.
    Structure is documented below.

      * `enabled` (`bool`)
    """
    workload_identity_config: pulumi.Output[dict]
    """
    )
    Workload Identity allows Kubernetes service accounts to act as a user-managed
    [Google IAM Service Account](https://cloud.google.com/iam/docs/service-accounts#user-managed_service_accounts).
    Structure is documented below.

      * `identityNamespace` (`str`)
    """
    def __init__(__self__, resource_name, opts=None, addons_config=None, authenticator_groups_config=None, cluster_autoscaling=None, cluster_ipv4_cidr=None, database_encryption=None, default_max_pods_per_node=None, description=None, enable_binary_authorization=None, enable_intranode_visibility=None, enable_kubernetes_alpha=None, enable_legacy_abac=None, enable_shielded_nodes=None, enable_tpu=None, initial_node_count=None, ip_allocation_policy=None, location=None, logging_service=None, maintenance_policy=None, master_auth=None, master_authorized_networks_config=None, min_master_version=None, monitoring_service=None, name=None, network=None, network_policy=None, node_config=None, node_locations=None, node_pools=None, node_version=None, pod_security_policy_config=None, private_cluster_config=None, project=None, release_channel=None, remove_default_node_pool=None, resource_labels=None, resource_usage_export_config=None, subnetwork=None, vertical_pod_autoscaling=None, workload_identity_config=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a Google Kubernetes Engine (GKE) cluster. For more information see
        [the official documentation](https://cloud.google.com/container-engine/docs/clusters)
        and [the API reference](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters).

        > **Note:** All arguments and attributes, including basic auth username and
        passwords as well as certificate outputs will be stored in the raw state as
        plaintext. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/container_cluster.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] addons_config: The configuration for addons supported by GKE.
               Structure is documented below.
        :param pulumi.Input[dict] authenticator_groups_config: Configuration for the
               [Google Groups for GKE](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control#groups-setup-gsuite) feature.
               Structure is documented below.
        :param pulumi.Input[dict] cluster_autoscaling: )
               Per-cluster configuration of Node Auto-Provisioning with Cluster Autoscaler to
               automatically adjust the size of the cluster and create/delete node pools based
               on the current needs of the cluster's workload. See the
               [guide to using Node Auto-Provisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
               for more details. Structure is documented below.
        :param pulumi.Input[str] cluster_ipv4_cidr: The IP address range of the Kubernetes pods
               in this cluster in CIDR notation (e.g. `10.96.0.0/14`). Leave blank to have one
               automatically chosen or specify a `/14` block in `10.0.0.0/8`. This field will
               only work for routes-based clusters, where `ip_allocation_policy` is not defined.
        :param pulumi.Input[dict] database_encryption: ).
               Structure is documented below.
        :param pulumi.Input[float] default_max_pods_per_node: The default maximum number of pods
               per node in this cluster. This doesn't work on "routes-based" clusters, clusters
               that don't have IP Aliasing enabled. See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
               for more information.
        :param pulumi.Input[str] description: Description of the cluster.
        :param pulumi.Input[bool] enable_binary_authorization: Enable Binary Authorization for this cluster.
               If enabled, all container images will be validated by Google Binary Authorization.
        :param pulumi.Input[bool] enable_intranode_visibility: )
               Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        :param pulumi.Input[bool] enable_kubernetes_alpha: Whether to enable Kubernetes Alpha features for
               this cluster. Note that when this option is enabled, the cluster cannot be upgraded
               and will be automatically deleted after 30 days.
        :param pulumi.Input[bool] enable_legacy_abac: Whether the ABAC authorizer is enabled for this cluster.
               When enabled, identities in the system, including service accounts, nodes, and controllers,
               will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
               Defaults to `false`
        :param pulumi.Input[bool] enable_shielded_nodes: ) Enable Shielded Nodes features on all nodes in this cluster.  Defaults to `false`.
        :param pulumi.Input[bool] enable_tpu: ) Whether to enable Cloud TPU resources in this cluster.
               See the [official documentation](https://cloud.google.com/tpu/docs/kubernetes-engine-setup).
        :param pulumi.Input[float] initial_node_count: The number of nodes to create in this
               cluster's default node pool. In regional or multi-zonal clusters, this is the
               number of nodes per zone. Must be set if `node_pool` is not set. If you're using
               `container.NodePool` objects with no default node pool, you'll need to
               set this to a value of at least `1`, alongside setting
               `remove_default_node_pool` to `true`.
        :param pulumi.Input[dict] ip_allocation_policy: Configuration of cluster IP allocation for
               VPC-native clusters. Adding this block enables [IP aliasing](https://cloud.google.com/kubernetes-engine/docs/how-to/ip-aliases),
               making the cluster VPC-native instead of routes-based. Structure is documented
               below.
        :param pulumi.Input[str] location: The location (region or zone) in which the cluster
               master will be created, as well as the default node location. If you specify a
               zone (such as `us-central1-a`), the cluster will be a zonal cluster with a
               single cluster master. If you specify a region (such as `us-west1`), the
               cluster will be a regional cluster with multiple masters spread across zones in
               the region, and with default node locations in those zones as well
        :param pulumi.Input[str] logging_service: The logging service that the cluster should
               write logs to. Available options include `logging.googleapis.com`(Legacy Stackdriver),
               `logging.googleapis.com/kubernetes`(Stackdriver Kubernetes Engine Logging), and `none`. Defaults to `logging.googleapis.com/kubernetes`
        :param pulumi.Input[dict] maintenance_policy: The maintenance policy to use for the cluster. Structure is
               documented below.
        :param pulumi.Input[dict] master_auth: The authentication information for accessing the
               Kubernetes master. Some values in this block are only returned by the API if
               your service account has permission to get credentials for your GKE cluster. If
               you see an unexpected diff removing a username/password or unsetting your client
               cert, ensure you have the `container.clusters.getCredentials` permission.
               Structure is documented below.
        :param pulumi.Input[dict] master_authorized_networks_config: The desired configuration options
               for master authorized networks. Omit the nested `cidr_blocks` attribute to disallow
               external access (except the cluster node IPs, which GKE automatically whitelists).
        :param pulumi.Input[str] min_master_version: The minimum version of the master. GKE
               will auto-update the master to new versions, so this does not guarantee the
               current master version--use the read-only `master_version` field to obtain that.
               If unset, the cluster's version will be set by GKE to the version of the most recent
               official release (which is not necessarily the latest version).  Most users will find
               the `container.getEngineVersions` data source useful - it indicates which versions
               are available, and can be use to approximate fuzzy versions. If you intend to specify versions manually,
               [the docs](https://cloud.google.com/kubernetes-engine/versioning-and-upgrades#specifying_cluster_version)
               describe the various acceptable formats for this field.
        :param pulumi.Input[str] monitoring_service: The monitoring service that the cluster
               should write metrics to.
               Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API.
               VM metrics will be collected by Google Compute Engine regardless of this setting
               Available options include
               `monitoring.googleapis.com`(Legacy Stackdriver), `monitoring.googleapis.com/kubernetes`(Stackdriver Kubernetes Engine Monitoring), and `none`.
               Defaults to `monitoring.googleapis.com/kubernetes`
        :param pulumi.Input[str] name: The name of the cluster, unique within the project and
               location.
        :param pulumi.Input[str] network: The name or self_link of the Google Compute Engine
               network to which the cluster is connected. For Shared VPC, set this to the self link of the
               shared network.
        :param pulumi.Input[dict] network_policy: Configuration options for the
               [NetworkPolicy](https://kubernetes.io/docs/concepts/services-networking/networkpolicies/)
               feature. Structure is documented below.
        :param pulumi.Input[dict] node_config: Parameters used in creating the default node pool.
               Generally, this field should not be used at the same time as a
               `container.NodePool` or a `node_pool` block; this configuration
               manages the default node pool, which isn't recommended to be used with
               this provider. Structure is documented below.
        :param pulumi.Input[list] node_locations: The list of zones in which the cluster's nodes
               are located. Nodes must be in the region of their regional cluster or in the
               same region as their cluster's zone for zonal clusters. If this is specified for
               a zonal cluster, omit the cluster's zone.
        :param pulumi.Input[list] node_pools: List of node pools associated with this cluster.
               See container.NodePool for schema.
               **Warning:** node pools defined inside a cluster can't be changed (or added/removed) after
               cluster creation without deleting and recreating the entire cluster. Unless you absolutely need the ability
               to say "these are the _only_ node pools associated with this cluster", use the
               container.NodePool resource instead of this property.
        :param pulumi.Input[str] node_version: The Kubernetes version on the nodes. Must either be unset
               or set to the same value as `min_master_version` on create. Defaults to the default
               version set by GKE which is not necessarily the latest version. This only affects
               nodes in the default node pool. While a fuzzy version can be specified, it's
               recommended that you specify explicit versions as this provider will see spurious diffs
               when fuzzy versions are used. See the `container.getEngineVersions` data source's
               `version_prefix` field to approximate fuzzy versions.
               To update nodes in other node pools, use the `version` attribute on the node pool.
        :param pulumi.Input[dict] pod_security_policy_config: ) Configuration for the
               [PodSecurityPolicy](https://cloud.google.com/kubernetes-engine/docs/how-to/pod-security-policies) feature.
               Structure is documented below.
        :param pulumi.Input[dict] private_cluster_config: Configuration for [private clusters](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters),
               clusters with private nodes. Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[dict] release_channel: ) Configuration options for the
               [Release channel](https://cloud.google.com/kubernetes-engine/docs/concepts/release-channels)
               feature, which provide more control over automatic upgrades of your GKE clusters. Structure is documented below.
        :param pulumi.Input[bool] remove_default_node_pool: If `true`, deletes the default node
               pool upon cluster creation. If you're using `container.NodePool`
               resources with no default node pool, this should be set to `true`, alongside
               setting `initial_node_count` to at least `1`.
        :param pulumi.Input[dict] resource_labels: The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
        :param pulumi.Input[dict] resource_usage_export_config: ) Configuration for the
               [ResourceUsageExportConfig](https://cloud.google.com/kubernetes-engine/docs/how-to/cluster-usage-metering) feature.
               Structure is documented below.
        :param pulumi.Input[str] subnetwork: The name or self_link of the Google Compute Engine
               subnetwork in which the cluster's instances are launched.
        :param pulumi.Input[dict] vertical_pod_autoscaling: )
               Vertical Pod Autoscaling automatically adjusts the resources of pods controlled by it.
               Structure is documented below.
        :param pulumi.Input[dict] workload_identity_config: )
               Workload Identity allows Kubernetes service accounts to act as a user-managed
               [Google IAM Service Account](https://cloud.google.com/iam/docs/service-accounts#user-managed_service_accounts).
               Structure is documented below.

        The **addons_config** object supports the following:

          * `cloudrunConfig` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `horizontalPodAutoscaling` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `httpLoadBalancing` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `istioConfig` (`pulumi.Input[dict]`)
            * `auth` (`pulumi.Input[str]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `networkPolicyConfig` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

        The **authenticator_groups_config** object supports the following:

          * `securityGroup` (`pulumi.Input[str]`)

        The **cluster_autoscaling** object supports the following:

          * `autoProvisioningDefaults` (`pulumi.Input[dict]`)
            * `oauthScopes` (`pulumi.Input[list]`)
            * `service_account` (`pulumi.Input[str]`)

          * `autoscalingProfile` (`pulumi.Input[str]`)
          * `enabled` (`pulumi.Input[bool]`)
          * `resourceLimits` (`pulumi.Input[list]`)
            * `maximum` (`pulumi.Input[float]`)
            * `minimum` (`pulumi.Input[float]`)
            * `resourceType` (`pulumi.Input[str]`)

        The **database_encryption** object supports the following:

          * `keyName` (`pulumi.Input[str]`)
          * `state` (`pulumi.Input[str]`)

        The **ip_allocation_policy** object supports the following:

          * `clusterIpv4CidrBlock` (`pulumi.Input[str]`)
          * `clusterSecondaryRangeName` (`pulumi.Input[str]`)
          * `servicesIpv4CidrBlock` (`pulumi.Input[str]`)
          * `servicesSecondaryRangeName` (`pulumi.Input[str]`)

        The **maintenance_policy** object supports the following:

          * `dailyMaintenanceWindow` (`pulumi.Input[dict]`)
            * `duration` (`pulumi.Input[str]`)
            * `startTime` (`pulumi.Input[str]`)

          * `recurringWindow` (`pulumi.Input[dict]`)
            * `endTime` (`pulumi.Input[str]`)
            * `recurrence` (`pulumi.Input[str]`)
            * `startTime` (`pulumi.Input[str]`)

        The **master_auth** object supports the following:

          * `clientCertificate` (`pulumi.Input[str]`)
          * `clientCertificateConfig` (`pulumi.Input[dict]`)
            * `issueClientCertificate` (`pulumi.Input[bool]`)

          * `clientKey` (`pulumi.Input[str]`)
          * `clusterCaCertificate` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `username` (`pulumi.Input[str]`)

        The **master_authorized_networks_config** object supports the following:

          * `cidrBlocks` (`pulumi.Input[list]`)
            * `cidr_block` (`pulumi.Input[str]`)
            * `display_name` (`pulumi.Input[str]`)

        The **network_policy** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)
          * `provider` (`pulumi.Input[str]`)

        The **node_config** object supports the following:

          * `bootDiskKmsKey` (`pulumi.Input[str]`)
          * `disk_size_gb` (`pulumi.Input[float]`)
          * `diskType` (`pulumi.Input[str]`)
          * `guest_accelerators` (`pulumi.Input[list]`)
            * `count` (`pulumi.Input[float]`)
            * `type` (`pulumi.Input[str]`)

          * `imageType` (`pulumi.Input[str]`)
          * `labels` (`pulumi.Input[dict]`)
          * `localSsdCount` (`pulumi.Input[float]`)
          * `machine_type` (`pulumi.Input[str]`)
          * `metadata` (`pulumi.Input[dict]`)
          * `min_cpu_platform` (`pulumi.Input[str]`)
          * `oauthScopes` (`pulumi.Input[list]`)
          * `preemptible` (`pulumi.Input[bool]`)
          * `sandboxConfig` (`pulumi.Input[dict]`)
            * `sandboxType` (`pulumi.Input[str]`)

          * `service_account` (`pulumi.Input[str]`)
          * `shielded_instance_config` (`pulumi.Input[dict]`)
            * `enableIntegrityMonitoring` (`pulumi.Input[bool]`)
            * `enableSecureBoot` (`pulumi.Input[bool]`)

          * `tags` (`pulumi.Input[list]`)
          * `taints` (`pulumi.Input[list]`)
            * `effect` (`pulumi.Input[str]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `workloadMetadataConfig` (`pulumi.Input[dict]`)
            * `nodeMetadata` (`pulumi.Input[str]`)

        The **node_pools** object supports the following:

          * `autoscaling` (`pulumi.Input[dict]`)
            * `maxNodeCount` (`pulumi.Input[float]`)
            * `minNodeCount` (`pulumi.Input[float]`)

          * `initial_node_count` (`pulumi.Input[float]`) - The number of nodes to create in this
            cluster's default node pool. In regional or multi-zonal clusters, this is the
            number of nodes per zone. Must be set if `node_pool` is not set. If you're using
            `container.NodePool` objects with no default node pool, you'll need to
            set this to a value of at least `1`, alongside setting
            `remove_default_node_pool` to `true`.
          * `instance_group_urls` (`pulumi.Input[list]`) - List of instance group URLs which have been assigned
            to the cluster.
          * `management` (`pulumi.Input[dict]`)
            * `autoRepair` (`pulumi.Input[bool]`)
            * `autoUpgrade` (`pulumi.Input[bool]`)

          * `max_pods_per_node` (`pulumi.Input[float]`)
          * `name` (`pulumi.Input[str]`) - The name of the cluster, unique within the project and
            location.
          * `name_prefix` (`pulumi.Input[str]`)
          * `node_config` (`pulumi.Input[dict]`) - Parameters used in creating the default node pool.
            Generally, this field should not be used at the same time as a
            `container.NodePool` or a `node_pool` block; this configuration
            manages the default node pool, which isn't recommended to be used with
            this provider. Structure is documented below.
            * `bootDiskKmsKey` (`pulumi.Input[str]`)
            * `disk_size_gb` (`pulumi.Input[float]`)
            * `diskType` (`pulumi.Input[str]`)
            * `guest_accelerators` (`pulumi.Input[list]`)
              * `count` (`pulumi.Input[float]`)
              * `type` (`pulumi.Input[str]`)

            * `imageType` (`pulumi.Input[str]`)
            * `labels` (`pulumi.Input[dict]`)
            * `localSsdCount` (`pulumi.Input[float]`)
            * `machine_type` (`pulumi.Input[str]`)
            * `metadata` (`pulumi.Input[dict]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)
            * `oauthScopes` (`pulumi.Input[list]`)
            * `preemptible` (`pulumi.Input[bool]`)
            * `sandboxConfig` (`pulumi.Input[dict]`)
              * `sandboxType` (`pulumi.Input[str]`)

            * `service_account` (`pulumi.Input[str]`)
            * `shielded_instance_config` (`pulumi.Input[dict]`)
              * `enableIntegrityMonitoring` (`pulumi.Input[bool]`)
              * `enableSecureBoot` (`pulumi.Input[bool]`)

            * `tags` (`pulumi.Input[list]`)
            * `taints` (`pulumi.Input[list]`)
              * `effect` (`pulumi.Input[str]`)
              * `key` (`pulumi.Input[str]`)
              * `value` (`pulumi.Input[str]`)

            * `workloadMetadataConfig` (`pulumi.Input[dict]`)
              * `nodeMetadata` (`pulumi.Input[str]`)

          * `node_count` (`pulumi.Input[float]`)
          * `node_locations` (`pulumi.Input[list]`) - The list of zones in which the cluster's nodes
            are located. Nodes must be in the region of their regional cluster or in the
            same region as their cluster's zone for zonal clusters. If this is specified for
            a zonal cluster, omit the cluster's zone.
          * `upgrade_settings` (`pulumi.Input[dict]`)
            * `maxSurge` (`pulumi.Input[float]`)
            * `maxUnavailable` (`pulumi.Input[float]`)

          * `version` (`pulumi.Input[str]`)

        The **pod_security_policy_config** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)

        The **private_cluster_config** object supports the following:

          * `enablePrivateEndpoint` (`pulumi.Input[bool]`)
          * `enablePrivateNodes` (`pulumi.Input[bool]`)
          * `masterIpv4CidrBlock` (`pulumi.Input[str]`)
          * `peeringName` (`pulumi.Input[str]`)
          * `privateEndpoint` (`pulumi.Input[str]`)
          * `publicEndpoint` (`pulumi.Input[str]`)

        The **release_channel** object supports the following:

          * `channel` (`pulumi.Input[str]`)

        The **resource_usage_export_config** object supports the following:

          * `bigqueryDestination` (`pulumi.Input[dict]`)
            * `dataset_id` (`pulumi.Input[str]`)

          * `enableNetworkEgressMetering` (`pulumi.Input[bool]`)

        The **vertical_pod_autoscaling** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)

        The **workload_identity_config** object supports the following:

          * `identityNamespace` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['addons_config'] = addons_config
            __props__['authenticator_groups_config'] = authenticator_groups_config
            __props__['cluster_autoscaling'] = cluster_autoscaling
            __props__['cluster_ipv4_cidr'] = cluster_ipv4_cidr
            __props__['database_encryption'] = database_encryption
            __props__['default_max_pods_per_node'] = default_max_pods_per_node
            __props__['description'] = description
            __props__['enable_binary_authorization'] = enable_binary_authorization
            __props__['enable_intranode_visibility'] = enable_intranode_visibility
            __props__['enable_kubernetes_alpha'] = enable_kubernetes_alpha
            __props__['enable_legacy_abac'] = enable_legacy_abac
            __props__['enable_shielded_nodes'] = enable_shielded_nodes
            __props__['enable_tpu'] = enable_tpu
            __props__['initial_node_count'] = initial_node_count
            __props__['ip_allocation_policy'] = ip_allocation_policy
            __props__['location'] = location
            __props__['logging_service'] = logging_service
            __props__['maintenance_policy'] = maintenance_policy
            __props__['master_auth'] = master_auth
            __props__['master_authorized_networks_config'] = master_authorized_networks_config
            __props__['min_master_version'] = min_master_version
            __props__['monitoring_service'] = monitoring_service
            __props__['name'] = name
            __props__['network'] = network
            __props__['network_policy'] = network_policy
            __props__['node_config'] = node_config
            __props__['node_locations'] = node_locations
            __props__['node_pools'] = node_pools
            __props__['node_version'] = node_version
            __props__['pod_security_policy_config'] = pod_security_policy_config
            __props__['private_cluster_config'] = private_cluster_config
            __props__['project'] = project
            __props__['release_channel'] = release_channel
            __props__['remove_default_node_pool'] = remove_default_node_pool
            __props__['resource_labels'] = resource_labels
            __props__['resource_usage_export_config'] = resource_usage_export_config
            __props__['subnetwork'] = subnetwork
            __props__['vertical_pod_autoscaling'] = vertical_pod_autoscaling
            __props__['workload_identity_config'] = workload_identity_config
            __props__['endpoint'] = None
            __props__['instance_group_urls'] = None
            __props__['label_fingerprint'] = None
            __props__['master_version'] = None
            __props__['operation'] = None
            __props__['services_ipv4_cidr'] = None
            __props__['tpu_ipv4_cidr_block'] = None
        super(Cluster, __self__).__init__(
            'gcp:container/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, addons_config=None, authenticator_groups_config=None, cluster_autoscaling=None, cluster_ipv4_cidr=None, database_encryption=None, default_max_pods_per_node=None, description=None, enable_binary_authorization=None, enable_intranode_visibility=None, enable_kubernetes_alpha=None, enable_legacy_abac=None, enable_shielded_nodes=None, enable_tpu=None, endpoint=None, initial_node_count=None, instance_group_urls=None, ip_allocation_policy=None, label_fingerprint=None, location=None, logging_service=None, maintenance_policy=None, master_auth=None, master_authorized_networks_config=None, master_version=None, min_master_version=None, monitoring_service=None, name=None, network=None, network_policy=None, node_config=None, node_locations=None, node_pools=None, node_version=None, operation=None, pod_security_policy_config=None, private_cluster_config=None, project=None, release_channel=None, remove_default_node_pool=None, resource_labels=None, resource_usage_export_config=None, services_ipv4_cidr=None, subnetwork=None, tpu_ipv4_cidr_block=None, vertical_pod_autoscaling=None, workload_identity_config=None):
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] addons_config: The configuration for addons supported by GKE.
               Structure is documented below.
        :param pulumi.Input[dict] authenticator_groups_config: Configuration for the
               [Google Groups for GKE](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control#groups-setup-gsuite) feature.
               Structure is documented below.
        :param pulumi.Input[dict] cluster_autoscaling: )
               Per-cluster configuration of Node Auto-Provisioning with Cluster Autoscaler to
               automatically adjust the size of the cluster and create/delete node pools based
               on the current needs of the cluster's workload. See the
               [guide to using Node Auto-Provisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
               for more details. Structure is documented below.
        :param pulumi.Input[str] cluster_ipv4_cidr: The IP address range of the Kubernetes pods
               in this cluster in CIDR notation (e.g. `10.96.0.0/14`). Leave blank to have one
               automatically chosen or specify a `/14` block in `10.0.0.0/8`. This field will
               only work for routes-based clusters, where `ip_allocation_policy` is not defined.
        :param pulumi.Input[dict] database_encryption: ).
               Structure is documented below.
        :param pulumi.Input[float] default_max_pods_per_node: The default maximum number of pods
               per node in this cluster. This doesn't work on "routes-based" clusters, clusters
               that don't have IP Aliasing enabled. See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
               for more information.
        :param pulumi.Input[str] description: Description of the cluster.
        :param pulumi.Input[bool] enable_binary_authorization: Enable Binary Authorization for this cluster.
               If enabled, all container images will be validated by Google Binary Authorization.
        :param pulumi.Input[bool] enable_intranode_visibility: )
               Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        :param pulumi.Input[bool] enable_kubernetes_alpha: Whether to enable Kubernetes Alpha features for
               this cluster. Note that when this option is enabled, the cluster cannot be upgraded
               and will be automatically deleted after 30 days.
        :param pulumi.Input[bool] enable_legacy_abac: Whether the ABAC authorizer is enabled for this cluster.
               When enabled, identities in the system, including service accounts, nodes, and controllers,
               will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
               Defaults to `false`
        :param pulumi.Input[bool] enable_shielded_nodes: ) Enable Shielded Nodes features on all nodes in this cluster.  Defaults to `false`.
        :param pulumi.Input[bool] enable_tpu: ) Whether to enable Cloud TPU resources in this cluster.
               See the [official documentation](https://cloud.google.com/tpu/docs/kubernetes-engine-setup).
        :param pulumi.Input[str] endpoint: The IP address of this cluster's Kubernetes master.
        :param pulumi.Input[float] initial_node_count: The number of nodes to create in this
               cluster's default node pool. In regional or multi-zonal clusters, this is the
               number of nodes per zone. Must be set if `node_pool` is not set. If you're using
               `container.NodePool` objects with no default node pool, you'll need to
               set this to a value of at least `1`, alongside setting
               `remove_default_node_pool` to `true`.
        :param pulumi.Input[list] instance_group_urls: List of instance group URLs which have been assigned
               to the cluster.
        :param pulumi.Input[dict] ip_allocation_policy: Configuration of cluster IP allocation for
               VPC-native clusters. Adding this block enables [IP aliasing](https://cloud.google.com/kubernetes-engine/docs/how-to/ip-aliases),
               making the cluster VPC-native instead of routes-based. Structure is documented
               below.
        :param pulumi.Input[str] label_fingerprint: The fingerprint of the set of labels for this cluster.
        :param pulumi.Input[str] location: The location (region or zone) in which the cluster
               master will be created, as well as the default node location. If you specify a
               zone (such as `us-central1-a`), the cluster will be a zonal cluster with a
               single cluster master. If you specify a region (such as `us-west1`), the
               cluster will be a regional cluster with multiple masters spread across zones in
               the region, and with default node locations in those zones as well
        :param pulumi.Input[str] logging_service: The logging service that the cluster should
               write logs to. Available options include `logging.googleapis.com`(Legacy Stackdriver),
               `logging.googleapis.com/kubernetes`(Stackdriver Kubernetes Engine Logging), and `none`. Defaults to `logging.googleapis.com/kubernetes`
        :param pulumi.Input[dict] maintenance_policy: The maintenance policy to use for the cluster. Structure is
               documented below.
        :param pulumi.Input[dict] master_auth: The authentication information for accessing the
               Kubernetes master. Some values in this block are only returned by the API if
               your service account has permission to get credentials for your GKE cluster. If
               you see an unexpected diff removing a username/password or unsetting your client
               cert, ensure you have the `container.clusters.getCredentials` permission.
               Structure is documented below.
        :param pulumi.Input[dict] master_authorized_networks_config: The desired configuration options
               for master authorized networks. Omit the nested `cidr_blocks` attribute to disallow
               external access (except the cluster node IPs, which GKE automatically whitelists).
        :param pulumi.Input[str] master_version: The current version of the master in the cluster. This may
               be different than the `min_master_version` set in the config if the master
               has been updated by GKE.
        :param pulumi.Input[str] min_master_version: The minimum version of the master. GKE
               will auto-update the master to new versions, so this does not guarantee the
               current master version--use the read-only `master_version` field to obtain that.
               If unset, the cluster's version will be set by GKE to the version of the most recent
               official release (which is not necessarily the latest version).  Most users will find
               the `container.getEngineVersions` data source useful - it indicates which versions
               are available, and can be use to approximate fuzzy versions. If you intend to specify versions manually,
               [the docs](https://cloud.google.com/kubernetes-engine/versioning-and-upgrades#specifying_cluster_version)
               describe the various acceptable formats for this field.
        :param pulumi.Input[str] monitoring_service: The monitoring service that the cluster
               should write metrics to.
               Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API.
               VM metrics will be collected by Google Compute Engine regardless of this setting
               Available options include
               `monitoring.googleapis.com`(Legacy Stackdriver), `monitoring.googleapis.com/kubernetes`(Stackdriver Kubernetes Engine Monitoring), and `none`.
               Defaults to `monitoring.googleapis.com/kubernetes`
        :param pulumi.Input[str] name: The name of the cluster, unique within the project and
               location.
        :param pulumi.Input[str] network: The name or self_link of the Google Compute Engine
               network to which the cluster is connected. For Shared VPC, set this to the self link of the
               shared network.
        :param pulumi.Input[dict] network_policy: Configuration options for the
               [NetworkPolicy](https://kubernetes.io/docs/concepts/services-networking/networkpolicies/)
               feature. Structure is documented below.
        :param pulumi.Input[dict] node_config: Parameters used in creating the default node pool.
               Generally, this field should not be used at the same time as a
               `container.NodePool` or a `node_pool` block; this configuration
               manages the default node pool, which isn't recommended to be used with
               this provider. Structure is documented below.
        :param pulumi.Input[list] node_locations: The list of zones in which the cluster's nodes
               are located. Nodes must be in the region of their regional cluster or in the
               same region as their cluster's zone for zonal clusters. If this is specified for
               a zonal cluster, omit the cluster's zone.
        :param pulumi.Input[list] node_pools: List of node pools associated with this cluster.
               See container.NodePool for schema.
               **Warning:** node pools defined inside a cluster can't be changed (or added/removed) after
               cluster creation without deleting and recreating the entire cluster. Unless you absolutely need the ability
               to say "these are the _only_ node pools associated with this cluster", use the
               container.NodePool resource instead of this property.
        :param pulumi.Input[str] node_version: The Kubernetes version on the nodes. Must either be unset
               or set to the same value as `min_master_version` on create. Defaults to the default
               version set by GKE which is not necessarily the latest version. This only affects
               nodes in the default node pool. While a fuzzy version can be specified, it's
               recommended that you specify explicit versions as this provider will see spurious diffs
               when fuzzy versions are used. See the `container.getEngineVersions` data source's
               `version_prefix` field to approximate fuzzy versions.
               To update nodes in other node pools, use the `version` attribute on the node pool.
        :param pulumi.Input[dict] pod_security_policy_config: ) Configuration for the
               [PodSecurityPolicy](https://cloud.google.com/kubernetes-engine/docs/how-to/pod-security-policies) feature.
               Structure is documented below.
        :param pulumi.Input[dict] private_cluster_config: Configuration for [private clusters](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters),
               clusters with private nodes. Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[dict] release_channel: ) Configuration options for the
               [Release channel](https://cloud.google.com/kubernetes-engine/docs/concepts/release-channels)
               feature, which provide more control over automatic upgrades of your GKE clusters. Structure is documented below.
        :param pulumi.Input[bool] remove_default_node_pool: If `true`, deletes the default node
               pool upon cluster creation. If you're using `container.NodePool`
               resources with no default node pool, this should be set to `true`, alongside
               setting `initial_node_count` to at least `1`.
        :param pulumi.Input[dict] resource_labels: The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
        :param pulumi.Input[dict] resource_usage_export_config: ) Configuration for the
               [ResourceUsageExportConfig](https://cloud.google.com/kubernetes-engine/docs/how-to/cluster-usage-metering) feature.
               Structure is documented below.
        :param pulumi.Input[str] services_ipv4_cidr: The IP address range of the Kubernetes services in this
               cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
               notation (e.g. `1.2.3.4/29`). Service addresses are typically put in the last
               `/16` from the container CIDR.
        :param pulumi.Input[str] subnetwork: The name or self_link of the Google Compute Engine
               subnetwork in which the cluster's instances are launched.
        :param pulumi.Input[dict] vertical_pod_autoscaling: )
               Vertical Pod Autoscaling automatically adjusts the resources of pods controlled by it.
               Structure is documented below.
        :param pulumi.Input[dict] workload_identity_config: )
               Workload Identity allows Kubernetes service accounts to act as a user-managed
               [Google IAM Service Account](https://cloud.google.com/iam/docs/service-accounts#user-managed_service_accounts).
               Structure is documented below.

        The **addons_config** object supports the following:

          * `cloudrunConfig` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `horizontalPodAutoscaling` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `httpLoadBalancing` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `istioConfig` (`pulumi.Input[dict]`)
            * `auth` (`pulumi.Input[str]`)
            * `disabled` (`pulumi.Input[bool]`)

          * `networkPolicyConfig` (`pulumi.Input[dict]`)
            * `disabled` (`pulumi.Input[bool]`)

        The **authenticator_groups_config** object supports the following:

          * `securityGroup` (`pulumi.Input[str]`)

        The **cluster_autoscaling** object supports the following:

          * `autoProvisioningDefaults` (`pulumi.Input[dict]`)
            * `oauthScopes` (`pulumi.Input[list]`)
            * `service_account` (`pulumi.Input[str]`)

          * `autoscalingProfile` (`pulumi.Input[str]`)
          * `enabled` (`pulumi.Input[bool]`)
          * `resourceLimits` (`pulumi.Input[list]`)
            * `maximum` (`pulumi.Input[float]`)
            * `minimum` (`pulumi.Input[float]`)
            * `resourceType` (`pulumi.Input[str]`)

        The **database_encryption** object supports the following:

          * `keyName` (`pulumi.Input[str]`)
          * `state` (`pulumi.Input[str]`)

        The **ip_allocation_policy** object supports the following:

          * `clusterIpv4CidrBlock` (`pulumi.Input[str]`)
          * `clusterSecondaryRangeName` (`pulumi.Input[str]`)
          * `servicesIpv4CidrBlock` (`pulumi.Input[str]`)
          * `servicesSecondaryRangeName` (`pulumi.Input[str]`)

        The **maintenance_policy** object supports the following:

          * `dailyMaintenanceWindow` (`pulumi.Input[dict]`)
            * `duration` (`pulumi.Input[str]`)
            * `startTime` (`pulumi.Input[str]`)

          * `recurringWindow` (`pulumi.Input[dict]`)
            * `endTime` (`pulumi.Input[str]`)
            * `recurrence` (`pulumi.Input[str]`)
            * `startTime` (`pulumi.Input[str]`)

        The **master_auth** object supports the following:

          * `clientCertificate` (`pulumi.Input[str]`)
          * `clientCertificateConfig` (`pulumi.Input[dict]`)
            * `issueClientCertificate` (`pulumi.Input[bool]`)

          * `clientKey` (`pulumi.Input[str]`)
          * `clusterCaCertificate` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `username` (`pulumi.Input[str]`)

        The **master_authorized_networks_config** object supports the following:

          * `cidrBlocks` (`pulumi.Input[list]`)
            * `cidr_block` (`pulumi.Input[str]`)
            * `display_name` (`pulumi.Input[str]`)

        The **network_policy** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)
          * `provider` (`pulumi.Input[str]`)

        The **node_config** object supports the following:

          * `bootDiskKmsKey` (`pulumi.Input[str]`)
          * `disk_size_gb` (`pulumi.Input[float]`)
          * `diskType` (`pulumi.Input[str]`)
          * `guest_accelerators` (`pulumi.Input[list]`)
            * `count` (`pulumi.Input[float]`)
            * `type` (`pulumi.Input[str]`)

          * `imageType` (`pulumi.Input[str]`)
          * `labels` (`pulumi.Input[dict]`)
          * `localSsdCount` (`pulumi.Input[float]`)
          * `machine_type` (`pulumi.Input[str]`)
          * `metadata` (`pulumi.Input[dict]`)
          * `min_cpu_platform` (`pulumi.Input[str]`)
          * `oauthScopes` (`pulumi.Input[list]`)
          * `preemptible` (`pulumi.Input[bool]`)
          * `sandboxConfig` (`pulumi.Input[dict]`)
            * `sandboxType` (`pulumi.Input[str]`)

          * `service_account` (`pulumi.Input[str]`)
          * `shielded_instance_config` (`pulumi.Input[dict]`)
            * `enableIntegrityMonitoring` (`pulumi.Input[bool]`)
            * `enableSecureBoot` (`pulumi.Input[bool]`)

          * `tags` (`pulumi.Input[list]`)
          * `taints` (`pulumi.Input[list]`)
            * `effect` (`pulumi.Input[str]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `workloadMetadataConfig` (`pulumi.Input[dict]`)
            * `nodeMetadata` (`pulumi.Input[str]`)

        The **node_pools** object supports the following:

          * `autoscaling` (`pulumi.Input[dict]`)
            * `maxNodeCount` (`pulumi.Input[float]`)
            * `minNodeCount` (`pulumi.Input[float]`)

          * `initial_node_count` (`pulumi.Input[float]`) - The number of nodes to create in this
            cluster's default node pool. In regional or multi-zonal clusters, this is the
            number of nodes per zone. Must be set if `node_pool` is not set. If you're using
            `container.NodePool` objects with no default node pool, you'll need to
            set this to a value of at least `1`, alongside setting
            `remove_default_node_pool` to `true`.
          * `instance_group_urls` (`pulumi.Input[list]`) - List of instance group URLs which have been assigned
            to the cluster.
          * `management` (`pulumi.Input[dict]`)
            * `autoRepair` (`pulumi.Input[bool]`)
            * `autoUpgrade` (`pulumi.Input[bool]`)

          * `max_pods_per_node` (`pulumi.Input[float]`)
          * `name` (`pulumi.Input[str]`) - The name of the cluster, unique within the project and
            location.
          * `name_prefix` (`pulumi.Input[str]`)
          * `node_config` (`pulumi.Input[dict]`) - Parameters used in creating the default node pool.
            Generally, this field should not be used at the same time as a
            `container.NodePool` or a `node_pool` block; this configuration
            manages the default node pool, which isn't recommended to be used with
            this provider. Structure is documented below.
            * `bootDiskKmsKey` (`pulumi.Input[str]`)
            * `disk_size_gb` (`pulumi.Input[float]`)
            * `diskType` (`pulumi.Input[str]`)
            * `guest_accelerators` (`pulumi.Input[list]`)
              * `count` (`pulumi.Input[float]`)
              * `type` (`pulumi.Input[str]`)

            * `imageType` (`pulumi.Input[str]`)
            * `labels` (`pulumi.Input[dict]`)
            * `localSsdCount` (`pulumi.Input[float]`)
            * `machine_type` (`pulumi.Input[str]`)
            * `metadata` (`pulumi.Input[dict]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)
            * `oauthScopes` (`pulumi.Input[list]`)
            * `preemptible` (`pulumi.Input[bool]`)
            * `sandboxConfig` (`pulumi.Input[dict]`)
              * `sandboxType` (`pulumi.Input[str]`)

            * `service_account` (`pulumi.Input[str]`)
            * `shielded_instance_config` (`pulumi.Input[dict]`)
              * `enableIntegrityMonitoring` (`pulumi.Input[bool]`)
              * `enableSecureBoot` (`pulumi.Input[bool]`)

            * `tags` (`pulumi.Input[list]`)
            * `taints` (`pulumi.Input[list]`)
              * `effect` (`pulumi.Input[str]`)
              * `key` (`pulumi.Input[str]`)
              * `value` (`pulumi.Input[str]`)

            * `workloadMetadataConfig` (`pulumi.Input[dict]`)
              * `nodeMetadata` (`pulumi.Input[str]`)

          * `node_count` (`pulumi.Input[float]`)
          * `node_locations` (`pulumi.Input[list]`) - The list of zones in which the cluster's nodes
            are located. Nodes must be in the region of their regional cluster or in the
            same region as their cluster's zone for zonal clusters. If this is specified for
            a zonal cluster, omit the cluster's zone.
          * `upgrade_settings` (`pulumi.Input[dict]`)
            * `maxSurge` (`pulumi.Input[float]`)
            * `maxUnavailable` (`pulumi.Input[float]`)

          * `version` (`pulumi.Input[str]`)

        The **pod_security_policy_config** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)

        The **private_cluster_config** object supports the following:

          * `enablePrivateEndpoint` (`pulumi.Input[bool]`)
          * `enablePrivateNodes` (`pulumi.Input[bool]`)
          * `masterIpv4CidrBlock` (`pulumi.Input[str]`)
          * `peeringName` (`pulumi.Input[str]`)
          * `privateEndpoint` (`pulumi.Input[str]`)
          * `publicEndpoint` (`pulumi.Input[str]`)

        The **release_channel** object supports the following:

          * `channel` (`pulumi.Input[str]`)

        The **resource_usage_export_config** object supports the following:

          * `bigqueryDestination` (`pulumi.Input[dict]`)
            * `dataset_id` (`pulumi.Input[str]`)

          * `enableNetworkEgressMetering` (`pulumi.Input[bool]`)

        The **vertical_pod_autoscaling** object supports the following:

          * `enabled` (`pulumi.Input[bool]`)

        The **workload_identity_config** object supports the following:

          * `identityNamespace` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["addons_config"] = addons_config
        __props__["authenticator_groups_config"] = authenticator_groups_config
        __props__["cluster_autoscaling"] = cluster_autoscaling
        __props__["cluster_ipv4_cidr"] = cluster_ipv4_cidr
        __props__["database_encryption"] = database_encryption
        __props__["default_max_pods_per_node"] = default_max_pods_per_node
        __props__["description"] = description
        __props__["enable_binary_authorization"] = enable_binary_authorization
        __props__["enable_intranode_visibility"] = enable_intranode_visibility
        __props__["enable_kubernetes_alpha"] = enable_kubernetes_alpha
        __props__["enable_legacy_abac"] = enable_legacy_abac
        __props__["enable_shielded_nodes"] = enable_shielded_nodes
        __props__["enable_tpu"] = enable_tpu
        __props__["endpoint"] = endpoint
        __props__["initial_node_count"] = initial_node_count
        __props__["instance_group_urls"] = instance_group_urls
        __props__["ip_allocation_policy"] = ip_allocation_policy
        __props__["label_fingerprint"] = label_fingerprint
        __props__["location"] = location
        __props__["logging_service"] = logging_service
        __props__["maintenance_policy"] = maintenance_policy
        __props__["master_auth"] = master_auth
        __props__["master_authorized_networks_config"] = master_authorized_networks_config
        __props__["master_version"] = master_version
        __props__["min_master_version"] = min_master_version
        __props__["monitoring_service"] = monitoring_service
        __props__["name"] = name
        __props__["network"] = network
        __props__["network_policy"] = network_policy
        __props__["node_config"] = node_config
        __props__["node_locations"] = node_locations
        __props__["node_pools"] = node_pools
        __props__["node_version"] = node_version
        __props__["operation"] = operation
        __props__["pod_security_policy_config"] = pod_security_policy_config
        __props__["private_cluster_config"] = private_cluster_config
        __props__["project"] = project
        __props__["release_channel"] = release_channel
        __props__["remove_default_node_pool"] = remove_default_node_pool
        __props__["resource_labels"] = resource_labels
        __props__["resource_usage_export_config"] = resource_usage_export_config
        __props__["services_ipv4_cidr"] = services_ipv4_cidr
        __props__["subnetwork"] = subnetwork
        __props__["tpu_ipv4_cidr_block"] = tpu_ipv4_cidr_block
        __props__["vertical_pod_autoscaling"] = vertical_pod_autoscaling
        __props__["workload_identity_config"] = workload_identity_config
        return Cluster(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

