# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Cluster(pulumi.CustomResource):
    cluster_config: pulumi.Output[dict]
    """
    Allows you to configure various aspects of the cluster.
    Structure defined below.

      * `autoscalingConfig` (`dict`)
        * `policyUri` (`str`)

      * `bucket` (`str`)
      * `encryptionConfig` (`dict`)
        * `kms_key_name` (`str`)

      * `gceClusterConfig` (`dict`)
        * `internalIpOnly` (`bool`)
        * `metadata` (`dict`)
        * `network` (`str`)
        * `service_account` (`str`)
        * `serviceAccountScopes` (`list`)
        * `subnetwork` (`str`)
        * `tags` (`list`)
        * `zone` (`str`)

      * `initializationActions` (`list`)
        * `script` (`str`)
        * `timeout_sec` (`float`)

      * `lifecycleConfig` (`dict`)
        * `autoDeleteTime` (`str`)
        * `idleDeleteTtl` (`str`)
        * `idleStartTime` (`str`)

      * `masterConfig` (`dict`)
        * `accelerators` (`list`)
          * `acceleratorCount` (`float`)
          * `accelerator_type` (`str`)

        * `diskConfig` (`dict`)
          * `bootDiskSizeGb` (`float`)
          * `bootDiskType` (`str`)
          * `numLocalSsds` (`float`)

        * `imageUri` (`str`)
        * `instanceNames` (`list`)
        * `machine_type` (`str`)
        * `min_cpu_platform` (`str`)
        * `numInstances` (`float`)

      * `preemptibleWorkerConfig` (`dict`)
        * `diskConfig` (`dict`)
          * `bootDiskSizeGb` (`float`)
          * `bootDiskType` (`str`)
          * `numLocalSsds` (`float`)

        * `instanceNames` (`list`)
        * `numInstances` (`float`)

      * `securityConfig` (`dict`)
        * `kerberosConfig` (`dict`)
          * `crossRealmTrustAdminServer` (`str`)
          * `crossRealmTrustKdc` (`str`)
          * `crossRealmTrustRealm` (`str`)
          * `crossRealmTrustSharedPasswordUri` (`str`)
          * `enableKerberos` (`bool`)
          * `kdcDbKeyUri` (`str`)
          * `keyPasswordUri` (`str`)
          * `keystorePasswordUri` (`str`)
          * `keystoreUri` (`str`)
          * `kmsKeyUri` (`str`)
          * `realm` (`str`)
          * `rootPrincipalPasswordUri` (`str`)
          * `tgtLifetimeHours` (`float`)
          * `truststorePasswordUri` (`str`)
          * `truststoreUri` (`str`)

      * `softwareConfig` (`dict`)
        * `imageVersion` (`str`)
        * `optionalComponents` (`list`)
        * `overrideProperties` (`dict`)
        * `properties` (`dict`)

      * `stagingBucket` (`str`)
      * `worker_config` (`dict`)
        * `accelerators` (`list`)
          * `acceleratorCount` (`float`)
          * `accelerator_type` (`str`)

        * `diskConfig` (`dict`)
          * `bootDiskSizeGb` (`float`)
          * `bootDiskType` (`str`)
          * `numLocalSsds` (`float`)

        * `imageUri` (`str`)
        * `instanceNames` (`list`)
        * `machine_type` (`str`)
        * `min_cpu_platform` (`str`)
        * `numInstances` (`float`)
    """
    labels: pulumi.Output[dict]
    """
    The list of labels (key/value pairs) to be applied to
    instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
    which is the name of the cluster.
    """
    name: pulumi.Output[str]
    """
    The name of the cluster, unique within the project and
    zone.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the `cluster` will exist. If it
    is not provided, the provider project is used.
    """
    region: pulumi.Output[str]
    """
    The region in which the cluster and associated nodes will be created in.
    Defaults to `global`.
    """
    def __init__(__self__, resource_name, opts=None, cluster_config=None, labels=None, name=None, project=None, region=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a Cloud Dataproc cluster resource within GCP. For more information see
        [the official dataproc documentation](https://cloud.google.com/dataproc/).


        !> **Warning:** Due to limitations of the API, all arguments except
        `labels`,`cluster_config.worker_config.num_instances` and `cluster_config.preemptible_worker_config.num_instances` are non-updatable. Changing others will cause recreation of the
        whole cluster!

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/dataproc_cluster.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] cluster_config: Allows you to configure various aspects of the cluster.
               Structure defined below.
        :param pulumi.Input[dict] labels: The list of labels (key/value pairs) to be applied to
               instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
               which is the name of the cluster.
        :param pulumi.Input[str] name: The name of the cluster, unique within the project and
               zone.
        :param pulumi.Input[str] project: The ID of the project in which the `cluster` will exist. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region in which the cluster and associated nodes will be created in.
               Defaults to `global`.

        The **cluster_config** object supports the following:

          * `autoscalingConfig` (`pulumi.Input[dict]`)
            * `policyUri` (`pulumi.Input[str]`)

          * `bucket` (`pulumi.Input[str]`)
          * `encryptionConfig` (`pulumi.Input[dict]`)
            * `kms_key_name` (`pulumi.Input[str]`)

          * `gceClusterConfig` (`pulumi.Input[dict]`)
            * `internalIpOnly` (`pulumi.Input[bool]`)
            * `metadata` (`pulumi.Input[dict]`)
            * `network` (`pulumi.Input[str]`)
            * `service_account` (`pulumi.Input[str]`)
            * `serviceAccountScopes` (`pulumi.Input[list]`)
            * `subnetwork` (`pulumi.Input[str]`)
            * `tags` (`pulumi.Input[list]`)
            * `zone` (`pulumi.Input[str]`)

          * `initializationActions` (`pulumi.Input[list]`)
            * `script` (`pulumi.Input[str]`)
            * `timeout_sec` (`pulumi.Input[float]`)

          * `lifecycleConfig` (`pulumi.Input[dict]`)
            * `autoDeleteTime` (`pulumi.Input[str]`)
            * `idleDeleteTtl` (`pulumi.Input[str]`)
            * `idleStartTime` (`pulumi.Input[str]`)

          * `masterConfig` (`pulumi.Input[dict]`)
            * `accelerators` (`pulumi.Input[list]`)
              * `acceleratorCount` (`pulumi.Input[float]`)
              * `accelerator_type` (`pulumi.Input[str]`)

            * `diskConfig` (`pulumi.Input[dict]`)
              * `bootDiskSizeGb` (`pulumi.Input[float]`)
              * `bootDiskType` (`pulumi.Input[str]`)
              * `numLocalSsds` (`pulumi.Input[float]`)

            * `imageUri` (`pulumi.Input[str]`)
            * `instanceNames` (`pulumi.Input[list]`)
            * `machine_type` (`pulumi.Input[str]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)
            * `numInstances` (`pulumi.Input[float]`)

          * `preemptibleWorkerConfig` (`pulumi.Input[dict]`)
            * `diskConfig` (`pulumi.Input[dict]`)
              * `bootDiskSizeGb` (`pulumi.Input[float]`)
              * `bootDiskType` (`pulumi.Input[str]`)
              * `numLocalSsds` (`pulumi.Input[float]`)

            * `instanceNames` (`pulumi.Input[list]`)
            * `numInstances` (`pulumi.Input[float]`)

          * `securityConfig` (`pulumi.Input[dict]`)
            * `kerberosConfig` (`pulumi.Input[dict]`)
              * `crossRealmTrustAdminServer` (`pulumi.Input[str]`)
              * `crossRealmTrustKdc` (`pulumi.Input[str]`)
              * `crossRealmTrustRealm` (`pulumi.Input[str]`)
              * `crossRealmTrustSharedPasswordUri` (`pulumi.Input[str]`)
              * `enableKerberos` (`pulumi.Input[bool]`)
              * `kdcDbKeyUri` (`pulumi.Input[str]`)
              * `keyPasswordUri` (`pulumi.Input[str]`)
              * `keystorePasswordUri` (`pulumi.Input[str]`)
              * `keystoreUri` (`pulumi.Input[str]`)
              * `kmsKeyUri` (`pulumi.Input[str]`)
              * `realm` (`pulumi.Input[str]`)
              * `rootPrincipalPasswordUri` (`pulumi.Input[str]`)
              * `tgtLifetimeHours` (`pulumi.Input[float]`)
              * `truststorePasswordUri` (`pulumi.Input[str]`)
              * `truststoreUri` (`pulumi.Input[str]`)

          * `softwareConfig` (`pulumi.Input[dict]`)
            * `imageVersion` (`pulumi.Input[str]`)
            * `optionalComponents` (`pulumi.Input[list]`)
            * `overrideProperties` (`pulumi.Input[dict]`)
            * `properties` (`pulumi.Input[dict]`)

          * `stagingBucket` (`pulumi.Input[str]`)
          * `worker_config` (`pulumi.Input[dict]`)
            * `accelerators` (`pulumi.Input[list]`)
              * `acceleratorCount` (`pulumi.Input[float]`)
              * `accelerator_type` (`pulumi.Input[str]`)

            * `diskConfig` (`pulumi.Input[dict]`)
              * `bootDiskSizeGb` (`pulumi.Input[float]`)
              * `bootDiskType` (`pulumi.Input[str]`)
              * `numLocalSsds` (`pulumi.Input[float]`)

            * `imageUri` (`pulumi.Input[str]`)
            * `instanceNames` (`pulumi.Input[list]`)
            * `machine_type` (`pulumi.Input[str]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)
            * `numInstances` (`pulumi.Input[float]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cluster_config'] = cluster_config
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['project'] = project
            __props__['region'] = region
        super(Cluster, __self__).__init__(
            'gcp:dataproc/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, cluster_config=None, labels=None, name=None, project=None, region=None):
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] cluster_config: Allows you to configure various aspects of the cluster.
               Structure defined below.
        :param pulumi.Input[dict] labels: The list of labels (key/value pairs) to be applied to
               instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
               which is the name of the cluster.
        :param pulumi.Input[str] name: The name of the cluster, unique within the project and
               zone.
        :param pulumi.Input[str] project: The ID of the project in which the `cluster` will exist. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region in which the cluster and associated nodes will be created in.
               Defaults to `global`.

        The **cluster_config** object supports the following:

          * `autoscalingConfig` (`pulumi.Input[dict]`)
            * `policyUri` (`pulumi.Input[str]`)

          * `bucket` (`pulumi.Input[str]`)
          * `encryptionConfig` (`pulumi.Input[dict]`)
            * `kms_key_name` (`pulumi.Input[str]`)

          * `gceClusterConfig` (`pulumi.Input[dict]`)
            * `internalIpOnly` (`pulumi.Input[bool]`)
            * `metadata` (`pulumi.Input[dict]`)
            * `network` (`pulumi.Input[str]`)
            * `service_account` (`pulumi.Input[str]`)
            * `serviceAccountScopes` (`pulumi.Input[list]`)
            * `subnetwork` (`pulumi.Input[str]`)
            * `tags` (`pulumi.Input[list]`)
            * `zone` (`pulumi.Input[str]`)

          * `initializationActions` (`pulumi.Input[list]`)
            * `script` (`pulumi.Input[str]`)
            * `timeout_sec` (`pulumi.Input[float]`)

          * `lifecycleConfig` (`pulumi.Input[dict]`)
            * `autoDeleteTime` (`pulumi.Input[str]`)
            * `idleDeleteTtl` (`pulumi.Input[str]`)
            * `idleStartTime` (`pulumi.Input[str]`)

          * `masterConfig` (`pulumi.Input[dict]`)
            * `accelerators` (`pulumi.Input[list]`)
              * `acceleratorCount` (`pulumi.Input[float]`)
              * `accelerator_type` (`pulumi.Input[str]`)

            * `diskConfig` (`pulumi.Input[dict]`)
              * `bootDiskSizeGb` (`pulumi.Input[float]`)
              * `bootDiskType` (`pulumi.Input[str]`)
              * `numLocalSsds` (`pulumi.Input[float]`)

            * `imageUri` (`pulumi.Input[str]`)
            * `instanceNames` (`pulumi.Input[list]`)
            * `machine_type` (`pulumi.Input[str]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)
            * `numInstances` (`pulumi.Input[float]`)

          * `preemptibleWorkerConfig` (`pulumi.Input[dict]`)
            * `diskConfig` (`pulumi.Input[dict]`)
              * `bootDiskSizeGb` (`pulumi.Input[float]`)
              * `bootDiskType` (`pulumi.Input[str]`)
              * `numLocalSsds` (`pulumi.Input[float]`)

            * `instanceNames` (`pulumi.Input[list]`)
            * `numInstances` (`pulumi.Input[float]`)

          * `securityConfig` (`pulumi.Input[dict]`)
            * `kerberosConfig` (`pulumi.Input[dict]`)
              * `crossRealmTrustAdminServer` (`pulumi.Input[str]`)
              * `crossRealmTrustKdc` (`pulumi.Input[str]`)
              * `crossRealmTrustRealm` (`pulumi.Input[str]`)
              * `crossRealmTrustSharedPasswordUri` (`pulumi.Input[str]`)
              * `enableKerberos` (`pulumi.Input[bool]`)
              * `kdcDbKeyUri` (`pulumi.Input[str]`)
              * `keyPasswordUri` (`pulumi.Input[str]`)
              * `keystorePasswordUri` (`pulumi.Input[str]`)
              * `keystoreUri` (`pulumi.Input[str]`)
              * `kmsKeyUri` (`pulumi.Input[str]`)
              * `realm` (`pulumi.Input[str]`)
              * `rootPrincipalPasswordUri` (`pulumi.Input[str]`)
              * `tgtLifetimeHours` (`pulumi.Input[float]`)
              * `truststorePasswordUri` (`pulumi.Input[str]`)
              * `truststoreUri` (`pulumi.Input[str]`)

          * `softwareConfig` (`pulumi.Input[dict]`)
            * `imageVersion` (`pulumi.Input[str]`)
            * `optionalComponents` (`pulumi.Input[list]`)
            * `overrideProperties` (`pulumi.Input[dict]`)
            * `properties` (`pulumi.Input[dict]`)

          * `stagingBucket` (`pulumi.Input[str]`)
          * `worker_config` (`pulumi.Input[dict]`)
            * `accelerators` (`pulumi.Input[list]`)
              * `acceleratorCount` (`pulumi.Input[float]`)
              * `accelerator_type` (`pulumi.Input[str]`)

            * `diskConfig` (`pulumi.Input[dict]`)
              * `bootDiskSizeGb` (`pulumi.Input[float]`)
              * `bootDiskType` (`pulumi.Input[str]`)
              * `numLocalSsds` (`pulumi.Input[float]`)

            * `imageUri` (`pulumi.Input[str]`)
            * `instanceNames` (`pulumi.Input[list]`)
            * `machine_type` (`pulumi.Input[str]`)
            * `min_cpu_platform` (`pulumi.Input[str]`)
            * `numInstances` (`pulumi.Input[float]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cluster_config"] = cluster_config
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["project"] = project
        __props__["region"] = region
        return Cluster(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

