# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class TenantOauthIdpConfig(pulumi.CustomResource):
    client_id: pulumi.Output[str]
    """
    The client id of an OAuth client.
    """
    client_secret: pulumi.Output[str]
    """
    The client secret of the OAuth client, to enable OIDC code flow.
    """
    display_name: pulumi.Output[str]
    """
    Human friendly display name.
    """
    enabled: pulumi.Output[bool]
    """
    If this config allows users to sign in with the provider.
    """
    issuer: pulumi.Output[str]
    """
    For OIDC Idps, the issuer identifier.
    """
    name: pulumi.Output[str]
    """
    The name of the OauthIdpConfig. Must start with 'oidc.'.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    tenant: pulumi.Output[str]
    """
    The name of the tenant where this OIDC IDP configuration resource exists
    """
    def __init__(__self__, resource_name, opts=None, client_id=None, client_secret=None, display_name=None, enabled=None, issuer=None, name=None, project=None, tenant=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a TenantOauthIdpConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The client id of an OAuth client.
        :param pulumi.Input[str] client_secret: The client secret of the OAuth client, to enable OIDC code flow.
        :param pulumi.Input[str] display_name: Human friendly display name.
        :param pulumi.Input[bool] enabled: If this config allows users to sign in with the provider.
        :param pulumi.Input[str] issuer: For OIDC Idps, the issuer identifier.
        :param pulumi.Input[str] name: The name of the OauthIdpConfig. Must start with 'oidc.'.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] tenant: The name of the tenant where this OIDC IDP configuration resource exists
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if client_id is None:
                raise TypeError("Missing required property 'client_id'")
            __props__['client_id'] = client_id
            __props__['client_secret'] = client_secret
            if display_name is None:
                raise TypeError("Missing required property 'display_name'")
            __props__['display_name'] = display_name
            __props__['enabled'] = enabled
            if issuer is None:
                raise TypeError("Missing required property 'issuer'")
            __props__['issuer'] = issuer
            __props__['name'] = name
            __props__['project'] = project
            if tenant is None:
                raise TypeError("Missing required property 'tenant'")
            __props__['tenant'] = tenant
        super(TenantOauthIdpConfig, __self__).__init__(
            'gcp:identityplatform/tenantOauthIdpConfig:TenantOauthIdpConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, client_id=None, client_secret=None, display_name=None, enabled=None, issuer=None, name=None, project=None, tenant=None):
        """
        Get an existing TenantOauthIdpConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The client id of an OAuth client.
        :param pulumi.Input[str] client_secret: The client secret of the OAuth client, to enable OIDC code flow.
        :param pulumi.Input[str] display_name: Human friendly display name.
        :param pulumi.Input[bool] enabled: If this config allows users to sign in with the provider.
        :param pulumi.Input[str] issuer: For OIDC Idps, the issuer identifier.
        :param pulumi.Input[str] name: The name of the OauthIdpConfig. Must start with 'oidc.'.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] tenant: The name of the tenant where this OIDC IDP configuration resource exists
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["client_id"] = client_id
        __props__["client_secret"] = client_secret
        __props__["display_name"] = display_name
        __props__["enabled"] = enabled
        __props__["issuer"] = issuer
        __props__["name"] = name
        __props__["project"] = project
        __props__["tenant"] = tenant
        return TenantOauthIdpConfig(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

