import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for EmrModifyInstanceFleetByName
 *
 * @experimental
 */
export interface EmrModifyInstanceFleetByNameProps {
    /**
     * The ClusterId to update.
     */
    readonly clusterId: string;
    /**
     * The InstanceFleetName to update.
     */
    readonly instanceFleetName: string;
    /**
     * The target capacity of On-Demand units for the instance fleet.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     *
     * @default None
     */
    readonly targetOnDemandCapacity: number;
    /**
     * The target capacity of Spot units for the instance fleet.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     *
     * @default None
     */
    readonly targetSpotCapacity: number;
}
/**
 * A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrModifyInstanceFleetByName implements sfn.IStepFunctionsTask {
    private readonly props;
    constructor(props: EmrModifyInstanceFleetByNameProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
