"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const emr_create_cluster_1 = require("./emr-create-cluster");
const resource_arn_suffix_1 = require("./resource-arn-suffix");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceGroupByName {
    constructor(props) {
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.ServiceIntegrationPattern.FIRE_AND_FORGET),
            policyStatements: [
                new iam.PolicyStatement({
                    actions: [
                        'elasticmapreduce:ModifyInstanceGroups',
                        'elasticmapreduce:ListInstanceGroups'
                    ],
                    resources: [`arn:aws:elasticmapreduce:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:cluster/*`]
                })
            ],
            parameters: {
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup)
            }
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
(function (EmrModifyInstanceGroupByName) {
    /**
     * Render the InstanceResizePolicyProperty to JSON
     *
     * @param property
     */
    function InstanceResizePolicyPropertyToJson(property) {
        var _a;
        return {
            InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
            InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
            InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds())
        };
    }
    EmrModifyInstanceGroupByName.InstanceResizePolicyPropertyToJson = InstanceResizePolicyPropertyToJson;
    /**
     * Render the ShrinkPolicyProperty to JSON
     *
     * @param property
     */
    function ShrinkPolicyPropertyToJson(property) {
        var _a;
        return {
            DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
            InstanceResizePolicy: (property.instanceResizePolicy === undefined) ?
                property.instanceResizePolicy :
                InstanceResizePolicyPropertyToJson(property.instanceResizePolicy)
        };
    }
    EmrModifyInstanceGroupByName.ShrinkPolicyPropertyToJson = ShrinkPolicyPropertyToJson;
    /**
     * Render the InstanceGroupModifyConfigPropety to JSON
     *
     * @param property
     */
    function InstanceGroupModifyConfigPropertyToJson(property) {
        return {
            Configurations: cdk.listMapper(emr_create_cluster_1.EmrCreateCluster.ConfigurationPropertyToJson)(property.configurations),
            EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
            InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
            ShrinkPolicy: (property.shrinkPolicy === undefined) ?
                property.shrinkPolicy :
                ShrinkPolicyPropertyToJson(property.shrinkPolicy)
        };
    }
    EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
})(EmrModifyInstanceGroupByName = exports.EmrModifyInstanceGroupByName || (exports.EmrModifyInstanceGroupByName = {}));
//# sourceMappingURL=data:application/json;base64,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