"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
/**
 * A Step Functions Task to invoke a Lambda function.
 *
 * The Lambda function Arn is defined as Resource in the state machine definition.
 *
 * OUTPUT: the output of this task is the return value of the Lambda Function.
 *
 * @deprecated Use `RunLambdaTask`
 */
class InvokeFunction {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.lambdaFunction.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: [this.lambdaFunction.functionArn],
                    actions: ['lambda:InvokeFunction'],
                })],
            metricPrefixSingular: 'LambdaFunction',
            metricPrefixPlural: 'LambdaFunctions',
            metricDimensions: { LambdaFunctionArn: this.lambdaFunction.functionArn },
            parameters: this.props.payload
        };
    }
}
exports.InvokeFunction = InvokeFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52b2tlLWZ1bmN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW52b2tlLWZ1bmN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXdDO0FBb0J4Qzs7Ozs7Ozs7R0FRRztBQUNILE1BQWEsY0FBYztJQUN6QixZQUE2QixjQUFnQyxFQUFtQixRQUE2QixFQUFFO1FBQWxGLG1CQUFjLEdBQWQsY0FBYyxDQUFrQjtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUEwQjtJQUMvRyxDQUFDO0lBRU0sSUFBSSxDQUFDLEtBQWU7UUFDekIsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVc7WUFDNUMsZ0JBQWdCLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7b0JBQ3pDLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDO29CQUM1QyxPQUFPLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQztpQkFDbkMsQ0FBQyxDQUFDO1lBQ0gsb0JBQW9CLEVBQUUsZ0JBQWdCO1lBQ3RDLGtCQUFrQixFQUFFLGlCQUFpQjtZQUNyQyxnQkFBZ0IsRUFBRSxFQUFFLGlCQUFpQixFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxFQUFFO1lBQ3hFLFVBQVUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87U0FDL0IsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQWpCRCx3Q0FpQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEludm9rZUZ1bmN0aW9uXG4gKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBSdW5MYW1iZGFUYXNrYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEludm9rZUZ1bmN0aW9uUHJvcHMge1xuICAvKipcbiAgICogVGhlIEpTT04gdGhhdCB5b3Ugd2FudCB0byBwcm92aWRlIHRvIHlvdXIgTGFtYmRhIGZ1bmN0aW9uIGFzIGlucHV0LlxuICAgKlxuICAgKiBUaGlzIHBhcmFtZXRlciBpcyBuYW1lZCBhcyBwYXlsb2FkIHRvIGtlZXAgY29uc2lzdGVudCB3aXRoIFJ1bkxhbWJkYVRhc2sgY2xhc3MuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gVGhlIEpTT04gZGF0YSBpbmRpY2F0ZWQgYnkgdGhlIHRhc2sncyBJbnB1dFBhdGggaXMgdXNlZCBhcyBwYXlsb2FkXG4gICAqL1xuICByZWFkb25seSBwYXlsb2FkPzogeyBba2V5OiBzdHJpbmddOiBhbnkgfTtcbn1cblxuLyoqXG4gKiBBIFN0ZXAgRnVuY3Rpb25zIFRhc2sgdG8gaW52b2tlIGEgTGFtYmRhIGZ1bmN0aW9uLlxuICpcbiAqIFRoZSBMYW1iZGEgZnVuY3Rpb24gQXJuIGlzIGRlZmluZWQgYXMgUmVzb3VyY2UgaW4gdGhlIHN0YXRlIG1hY2hpbmUgZGVmaW5pdGlvbi5cbiAqXG4gKiBPVVRQVVQ6IHRoZSBvdXRwdXQgb2YgdGhpcyB0YXNrIGlzIHRoZSByZXR1cm4gdmFsdWUgb2YgdGhlIExhbWJkYSBGdW5jdGlvbi5cbiAqXG4gKiBAZGVwcmVjYXRlZCBVc2UgYFJ1bkxhbWJkYVRhc2tgXG4gKi9cbmV4cG9ydCBjbGFzcyBJbnZva2VGdW5jdGlvbiBpbXBsZW1lbnRzIHNmbi5JU3RlcEZ1bmN0aW9uc1Rhc2sge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBsYW1iZGEuSUZ1bmN0aW9uLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBJbnZva2VGdW5jdGlvblByb3BzID0ge30pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF90YXNrOiBzZm4uVGFzayk6IHNmbi5TdGVwRnVuY3Rpb25zVGFza0NvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHJlc291cmNlQXJuOiB0aGlzLmxhbWJkYUZ1bmN0aW9uLmZ1bmN0aW9uQXJuLFxuICAgICAgcG9saWN5U3RhdGVtZW50czogW25ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbdGhpcy5sYW1iZGFGdW5jdGlvbi5mdW5jdGlvbkFybl0sXG4gICAgICAgIGFjdGlvbnM6IFsnbGFtYmRhOkludm9rZUZ1bmN0aW9uJ10sXG4gICAgICB9KV0sXG4gICAgICBtZXRyaWNQcmVmaXhTaW5ndWxhcjogJ0xhbWJkYUZ1bmN0aW9uJyxcbiAgICAgIG1ldHJpY1ByZWZpeFBsdXJhbDogJ0xhbWJkYUZ1bmN0aW9ucycsXG4gICAgICBtZXRyaWNEaW1lbnNpb25zOiB7IExhbWJkYUZ1bmN0aW9uQXJuOiB0aGlzLmxhbWJkYUZ1bmN0aW9uLmZ1bmN0aW9uQXJuIH0sXG4gICAgICBwYXJhbWV0ZXJzOiB0aGlzLnByb3BzLnBheWxvYWRcbiAgICB9O1xuICB9XG59XG4iXX0=