import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for StartExecution
 */
export interface StartExecutionProps {
    /**
     * The JSON input for the execution, same as that of StartExecution.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     *
     * @default - No input
     */
    readonly input?: {
        [key: string]: any;
    };
    /**
     * The name of the execution, same as that of StartExecution.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     *
     * @default - None
     */
    readonly name?: string;
    /**
     * The service integration pattern indicates different ways to call StartExecution to Step Functions.
     *
     * @default FIRE_AND_FORGET
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
}
/**
 * A Step Functions Task to call StartExecution on another state machine.
 *
 * It supports three service integration patterns: FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
 */
export declare class StartExecution implements sfn.IStepFunctionsTask {
    private readonly stateMachine;
    private readonly props;
    private readonly integrationPattern;
    constructor(stateMachine: sfn.IStateMachine, props?: StartExecutionProps);
    bind(task: sfn.Task): sfn.StepFunctionsTaskConfig;
    /**
     * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
     *
     * the scoped access policy should be generated accordingly.
     *
     * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
     */
    private createScopedAccessPolicy;
}
