"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const eval_nodejs10_x_handler_1 = require("../lib/eval-nodejs10.x-handler");
test('with numbers', async () => {
    // GIVEN
    const event = {
        expression: '$.a + $.b',
        expressionAttributeValues: {
            '$.a': 4,
            '$.b': 5
        }
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe(9);
});
test('with strings', async () => {
    // GIVEN
    const event = {
        expression: '`${$.a} ${$.b}`',
        expressionAttributeValues: {
            '$.a': 'Hello',
            '$.b': 'world!'
        }
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe('Hello world!');
});
test('with lists', async () => {
    // GIVEN
    const event = {
        expression: '$.a.map(x => x * 2)',
        expressionAttributeValues: {
            '$.a': [1, 2, 3],
        }
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toEqual([2, 4, 6]);
});
//# sourceMappingURL=data:application/json;base64,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