"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../lib");
let stack;
beforeEach(() => {
    stack = new core_1.Stack();
});
test('Eval with Node.js', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EvaluateExpression({
            expression: '$.a + $.b',
        })
    });
    new sfn.StateMachine(stack, 'SM', {
        definition: task
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': [
                '',
                [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Parameters":{"expression":"$.a + $.b","expressionAttributeValues":{"$.a.$":"$.a","$.b.$":"$.b"}},"Type":"Task","Resource":"',
                    {
                        'Fn::GetAtt': [
                            'Evala0d2ce44871b4e7487a1f5e63d7c3bdc4DAC06E1',
                            'Arn'
                        ]
                    },
                    '"}}}'
                ]
            ]
        },
    });
    expect(stack).toHaveResource('AWS::Lambda::Function', {
        Runtime: 'nodejs10.x'
    });
});
test('Throws when expression does not contain paths', () => {
    // WHEN
    expect(() => new sfn.Task(stack, 'Task', {
        task: new tasks.EvaluateExpression({
            expression: '2 + 2',
        })
    })).toThrow(/No paths found in expression/);
});
//# sourceMappingURL=data:application/json;base64,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