/*  SWIG interface code generated by apiwrapper for GAMS Version 33.2.0
 *
 * GAMS - Loading mechanism for GAMS Expert-Level APIs
 *
 * Copyright (c) 2016-2020 GAMS Software GmbH <support@gams.com>
 * Copyright (c) 2016-2020 GAMS Development Corp. <support@gams.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%module(moduleimport="import $module") gamsxcc
%include cpointer.i
%include typemaps.i
%include carrays.i
%include cstring.i

%{
/* Put header files here or function declarations like below */
#define SWIG_FILE_WITH_INIT
#include "gamsxcc.h"
#include "gclgms.h"
#define gamsxHandleToPtr
#define ptrTogamsxHandle
%}

// special treatment for out int arrays
%typemap(in, numinputs=0) int Elements_out[]{
  static gdxUelIndex_t Elements;
  $1 = Elements;
}

%typemap(argout) int Elements_out[]{
    int loc_i = 0;
    PyObject *list;
    int loc_dim = GLOBAL_MAX_INDEX_DIM;
    list = PyList_New(loc_dim);
    for(loc_i=0; loc_i<loc_dim; loc_i++){
      PyList_SetItem(list, loc_i, PyInt_FromLong($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

// special treatment for out double arrays
%typemap(in, numinputs=0) double Vals_out[]{
  static gdxValues_t Vals;
  $1 = Vals;
}

%typemap(argout) double Vals_out[]{
    int loc_i = 0;
    PyObject *list = PyList_New(5);
    for(loc_i=0; loc_i<5; loc_i++){
      PyList_SetItem(list, loc_i, PyFloat_FromDouble($1[loc_i]));
    }
    $result = SWIG_Python_AppendOutput($result, list);
}

%array_class(int, intArray);
%array_class(double, doubleArray);
%pointer_functions(int, intp);
%pointer_functions(double, doublep);
%pointer_functions(gamsxHandle_t, gamsxHandle_tp);

%typemap(in) void *{
    int res = SWIG_ConvertPtr($input,SWIG_as_voidptrptr(&$1), SWIGTYPE_p_void, 0);
    if (!SWIG_IsOK(res)) {
    SWIG_exception_fail(SWIG_ArgError(res), "in method '" "$symname" "', argument " " of type '" "void *""'");
  }
}

%typemap(in) void **{
    void *$1__p;
    int res = SWIG_ConvertPtr($input,SWIG_as_voidptrptr(&$1__p), SWIGTYPE_p_void, 0);
    if (!SWIG_IsOK(res)) {
    SWIG_exception_fail(SWIG_ArgError(res), "in method '" "$symname" "', argument " " of type '" "void *""'");
    }
    $1 = &$1__p;
}

%typemap(out) gamsxHandle_t {
  resultobj = SWIG_NewPointerObj((gamsxHandle_t *)memcpy((gamsxHandle_t *)malloc(sizeof(gamsxHandle_t)),&result,sizeof(gamsxHandle_t)), SWIGTYPE_p_gamsxHandle_t, 0 |  0 );
}

%typemap(in) TBrkPCallBack1_t{
    if ($input == Py_None)
      $1 = NULL;
    else
    {
      void *argp;
      int ret = SWIG_ConvertPtr($input, &argp, SWIGTYPE_p_TBrkPCallBack1_t,  0 );
      if (!SWIG_IsOK(ret)) {
        SWIG_exception_fail(SWIG_ArgError(ret), "in method '" "$symname" "', argument " " of type '" "TBrkPCallBack1_t""'");
      }
      if (!argp) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "$symname" "', argument of type '" "TBrkPCallBack1_t""'");
      } else {
        $1 = *((TBrkPCallBack1_t *)(argp));
      }
    }
}
%typemap(in) TBrkPCallBack2_t{
    if ($input == Py_None)
      $1 = NULL;
    else
    {
      void *argp;
      int ret = SWIG_ConvertPtr($input, &argp, SWIGTYPE_p_TBrkPCallBack2_t,  0 );
      if (!SWIG_IsOK(ret)) {
        SWIG_exception_fail(SWIG_ArgError(ret), "in method '" "$symname" "', argument " " of type '" "TBrkPCallBack2_t""'");
      }
      if (!argp) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "$symname" "', argument of type '" "TBrkPCallBack2_t""'");
      } else {
        $1 = *((TBrkPCallBack2_t *)(argp));
      }
    }
}
%pointer_functions(TBrkPCallBack1_t, TBrkPCallBack1_tp);
%pointer_functions(TBrkPCallBack2_t, TBrkPCallBack2_tp);
%typemap(in, numinputs=0) char *_oss_buf() {
  $1 = (char *) malloc(sizeof(char) * (GMS_SSSIZE+1));
}

%typemap(freearg) char *_oss_buf() {
  free((char *) $1);
}


%cstring_bounded_output(char *msgBuf_out, GMS_SSSIZE);
%cstring_bounded_output(char *result_out, GMS_SSSIZE);
%cstring_bounded_output(char *Msg_out, GMS_SSSIZE);
%cstring_bounded_output(char *errorLine_out, GMS_SSSIZE);
%cstring_bounded_output(char *errorTyp_out, GMS_SSSIZE);
%cstring_bounded_output(char *gmsLine_out, GMS_SSSIZE);
%cstring_bounded_output(char *SyName_out, GMS_SSSIZE);
%cstring_bounded_output(char *SyExplTxt_out, GMS_SSSIZE);

%feature("autodoc", "0");

extern void *gamsxHandleToPtr (gamsxHandle_t pgamsx);
extern gamsxHandle_t ptrTogamsxHandle (void *vptr);
extern int gamsxGetReady (char *msgBuf_out, int msgBufSize);
extern int gamsxGetReadyD (const char *dirName, char *msgBuf_out, int msgBufSize);
extern int gamsxGetReadyL (const char *libName, char *msgBuf_out, int msgBufSize);
extern int gamsxCreate (gamsxHandle_t *pgamsx, char *msgBuf_out, int msgBufSize);
extern int gamsxCreateD (gamsxHandle_t *pgamsx, const char *dirName, char *msgBuf_out, int msgBufSize);
extern int gamsxCreateL (gamsxHandle_t *pgamsx, const char *libName, char *msgBuf_out, int msgBufSize);
extern int gamsxFree (gamsxHandle_t *pgamsx);
extern int gamsxLibraryLoaded(void);
extern int gamsxLibraryUnload(void);
extern int gamsxGetScreenIndicator(void);
extern void gamsxSetScreenIndicator(int scrind);
extern int gamsxGetExceptionIndicator(void);
extern void gamsxSetExceptionIndicator(int excind);
extern int gamsxGetExitIndicator(void);
extern void gamsxSetExitIndicator(int extind);
extern gamsxErrorCallback_t gamsxGetErrorCallback(void);
extern void gamsxSetErrorCallback(gamsxErrorCallback_t func);
extern int gamsxGetAPIErrorCount(void);
extern void gamsxSetAPIErrorCount(int ecnt);
extern void gamsxErrorHandling(const char *msg);
extern int  gamsxRunExecDLL (gamsxHandle_t pgamsx, void *optPtr, const char *sysDir, int AVerbose, char *Msg_out);
extern int  gamsxShowError (gamsxHandle_t pgamsx, const char *fNameLog, char *errorLine_out, char *errorTyp_out, char *gmsLine_out);
extern void  gamsxAddBreakPoint (gamsxHandle_t pgamsx, const char *fn, int lineNr);
extern void  gamsxClearBreakPoints (gamsxHandle_t pgamsx);
extern int  gamsxSystemInfo (gamsxHandle_t pgamsx, int *INOUT, int *INOUT);
extern int  gamsxSymbolInfo (gamsxHandle_t pgamsx, int SyNr, char *SyName_out, char *SyExplTxt_out, int *INOUT, int *INOUT, int *INOUT, int *INOUT);
extern char * gamsxUelName (gamsxHandle_t pgamsx, int uel, char *_oss_buf);
extern int  gamsxFindSymbol (gamsxHandle_t pgamsx, const char *SyName);
extern int  gamsxDataReadRawStart (gamsxHandle_t pgamsx, int SyNr, int *INOUT);
extern int  gamsxDataReadRaw (gamsxHandle_t pgamsx, int Elements_out[], double Vals_out[], int *INOUT);
extern int  gamsxDataReadDone (gamsxHandle_t pgamsx);
extern int  gamsxDataWriteRawStart (gamsxHandle_t pgamsx, int SyNr, int DoMerge);
extern int  gamsxDataWriteRaw (gamsxHandle_t pgamsx, const int Elements[], const double Vals[]);
extern int  gamsxDataWriteDone (gamsxHandle_t pgamsx);
extern void  gamsxRegisterCB1 (gamsxHandle_t pgamsx, TBrkPCallBack1_t CB1, void *userMem);
extern void  gamsxRegisterCB2 (gamsxHandle_t pgamsx, TBrkPCallBack2_t CB2, void *userMem1, void *userMem2);
extern TBrkPCallBack1_t gamsxGetCB1 (gamsxHandle_t pgamsx);
extern TBrkPCallBack2_t gamsxGetCB2 (gamsxHandle_t pgamsx);
extern void * gamsxGetCB1UM (gamsxHandle_t pgamsx);
extern void * gamsxGetCB2UM1 (gamsxHandle_t pgamsx);
extern void * gamsxGetCB2UM2 (gamsxHandle_t pgamsx);
extern void gamsxSWSet (gamsxHandle_t pgamsx, const int x);
extern int  gamsxStepThrough (gamsxHandle_t pgamsx);
extern void gamsxStepThroughSet (gamsxHandle_t pgamsx, const int x);
extern int  gamsxRunToEnd (gamsxHandle_t pgamsx);
extern void gamsxRunToEndSet (gamsxHandle_t pgamsx, const int x);
extern int  gamsxCB1Defined (gamsxHandle_t pgamsx);
extern int  gamsxCB2Defined (gamsxHandle_t pgamsx);

%include "gclgms_swig.h"
