#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2016-2018, Blue Brain Project
#                          Raphael Dumusc <raphael.dumusc@epfl.ch>
#                          Daniel Nachbaur <daniel.nachbaur@epfl.ch>
#                          Cyrille Favreau <cyrille.favreau@epfl.ch>
#
# This file is part of Brayns <https://github.com/BlueBrain/Brayns>
#
# This library is free software; you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License version 3.0 as published
# by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# All rights reserved. Do not distribute without further notice.

"""setup.py"""
import os
import pathlib
import pkg_resources
import setuptools
from setuptools import find_packages, setup

#try: # for pip >= 10
#    from pip._internal.req import parse_requirements
#    from pip._internal.download import PipSession
#except ImportError: # for pip <= 9.0.3
#    from pip.req import parse_requirements
#    from pip.download import PipSession
#from optparse import Option

BASEDIR = os.path.dirname(os.path.abspath(__file__))


#def parse_reqs(reqs_file):
#    ''' parse the requirements '''
#    options = Option("--workaround")
#    options.skip_requirements_regex = None
#    options.isolated_mode = True
#    install_reqs = parse_requirements(reqs_file, options=options, session=PipSession())
#    return [str(ir.req) for ir in install_reqs]

def parse_reqs(reqs_file):
    ''' parse the requirements '''
    install_reqs = list()
    with pathlib.Path(reqs_file).open() as requirements_txt:
      install_reqs = [  str(requirement) 
                        for requirement 
                        in pkg_resources.parse_requirements(requirements_txt)]
   
    return install_reqs

REQS = parse_reqs(os.path.join(BASEDIR, "requirements.txt"))

# read the contents of README.md
this_directory = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(this_directory, 'README.md')) as f:
    long_description = f.read()

setup(
    packages=find_packages(),
    install_requires=REQS,
    long_description=long_description,
    long_description_content_type='text/markdown'
)
