# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from fabric_cf.orchestrator.swagger_server.models.base_model_ import Model
from fabric_cf.orchestrator.swagger_server import util


class Slice(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, model: str=None, lease_start_time: str=None, lease_end_time: str=None, state: str=None, project_id: str=None, graph_id: str=None, name: str=None, slice_id: str=None):  # noqa: E501
        """Slice - a model defined in Swagger

        :param model: The model of this Slice.  # noqa: E501
        :type model: str
        :param lease_start_time: The lease_start_time of this Slice.  # noqa: E501
        :type lease_start_time: str
        :param lease_end_time: The lease_end_time of this Slice.  # noqa: E501
        :type lease_end_time: str
        :param state: The state of this Slice.  # noqa: E501
        :type state: str
        :param project_id: The project_id of this Slice.  # noqa: E501
        :type project_id: str
        :param graph_id: The graph_id of this Slice.  # noqa: E501
        :type graph_id: str
        :param name: The name of this Slice.  # noqa: E501
        :type name: str
        :param slice_id: The slice_id of this Slice.  # noqa: E501
        :type slice_id: str
        """
        self.swagger_types = {
            'model': str,
            'lease_start_time': str,
            'lease_end_time': str,
            'state': str,
            'project_id': str,
            'graph_id': str,
            'name': str,
            'slice_id': str
        }

        self.attribute_map = {
            'model': 'model',
            'lease_start_time': 'lease_start_time',
            'lease_end_time': 'lease_end_time',
            'state': 'state',
            'project_id': 'project_id',
            'graph_id': 'graph_id',
            'name': 'name',
            'slice_id': 'slice_id'
        }
        self._model = model
        self._lease_start_time = lease_start_time
        self._lease_end_time = lease_end_time
        self._state = state
        self._project_id = project_id
        self._graph_id = graph_id
        self._name = name
        self._slice_id = slice_id

    @classmethod
    def from_dict(cls, dikt) -> 'Slice':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The slice of this Slice.  # noqa: E501
        :rtype: Slice
        """
        return util.deserialize_model(dikt, cls)

    @property
    def model(self) -> str:
        """Gets the model of this Slice.


        :return: The model of this Slice.
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model: str):
        """Sets the model of this Slice.


        :param model: The model of this Slice.
        :type model: str
        """

        self._model = model

    @property
    def lease_start_time(self) -> str:
        """Gets the lease_start_time of this Slice.


        :return: The lease_start_time of this Slice.
        :rtype: str
        """
        return self._lease_start_time

    @lease_start_time.setter
    def lease_start_time(self, lease_start_time: str):
        """Sets the lease_start_time of this Slice.


        :param lease_start_time: The lease_start_time of this Slice.
        :type lease_start_time: str
        """

        self._lease_start_time = lease_start_time

    @property
    def lease_end_time(self) -> str:
        """Gets the lease_end_time of this Slice.


        :return: The lease_end_time of this Slice.
        :rtype: str
        """
        return self._lease_end_time

    @lease_end_time.setter
    def lease_end_time(self, lease_end_time: str):
        """Sets the lease_end_time of this Slice.


        :param lease_end_time: The lease_end_time of this Slice.
        :type lease_end_time: str
        """

        self._lease_end_time = lease_end_time

    @property
    def state(self) -> str:
        """Gets the state of this Slice.


        :return: The state of this Slice.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str):
        """Sets the state of this Slice.


        :param state: The state of this Slice.
        :type state: str
        """

        self._state = state

    @property
    def project_id(self) -> str:
        """Gets the project_id of this Slice.


        :return: The project_id of this Slice.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id: str):
        """Sets the project_id of this Slice.


        :param project_id: The project_id of this Slice.
        :type project_id: str
        """

        self._project_id = project_id

    @property
    def graph_id(self) -> str:
        """Gets the graph_id of this Slice.


        :return: The graph_id of this Slice.
        :rtype: str
        """
        return self._graph_id

    @graph_id.setter
    def graph_id(self, graph_id: str):
        """Sets the graph_id of this Slice.


        :param graph_id: The graph_id of this Slice.
        :type graph_id: str
        """
        if graph_id is None:
            raise ValueError("Invalid value for `graph_id`, must not be `None`")  # noqa: E501

        self._graph_id = graph_id

    @property
    def name(self) -> str:
        """Gets the name of this Slice.


        :return: The name of this Slice.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """Sets the name of this Slice.


        :param name: The name of this Slice.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def slice_id(self) -> str:
        """Gets the slice_id of this Slice.


        :return: The slice_id of this Slice.
        :rtype: str
        """
        return self._slice_id

    @slice_id.setter
    def slice_id(self, slice_id: str):
        """Sets the slice_id of this Slice.


        :param slice_id: The slice_id of this Slice.
        :type slice_id: str
        """
        if slice_id is None:
            raise ValueError("Invalid value for `slice_id`, must not be `None`")  # noqa: E501

        self._slice_id = slice_id
