# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from arthur_client.api_bindings.models.alert import Alert
from arthur_client.api_bindings.models.alert_bound import AlertBound
from arthur_client.api_bindings.models.alert_sort import AlertSort
from arthur_client.api_bindings.models.created_alerts import CreatedAlerts
from arthur_client.api_bindings.models.infinite_resource_list_alert import InfiniteResourceListAlert
from arthur_client.api_bindings.models.post_alerts import PostAlerts
from arthur_client.api_bindings.models.sort_order import SortOrder

from arthur_client.api_bindings.api_client import ApiClient, RequestSerialized
from arthur_client.api_bindings.api_response import ApiResponse
from arthur_client.api_bindings.rest import RESTResponseType


class AlertsV1Api:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_alert(
        self,
        alert_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Alert:
        """Get Alert By Id

        Returns a single alert by ID. Requires model_alert_read permission.

        :param alert_id: (required)
        :type alert_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alert_serialize(
            alert_id=alert_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Alert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_alert_with_http_info(
        self,
        alert_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Alert]:
        """Get Alert By Id

        Returns a single alert by ID. Requires model_alert_read permission.

        :param alert_id: (required)
        :type alert_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alert_serialize(
            alert_id=alert_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Alert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_alert_without_preload_content(
        self,
        alert_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Alert By Id

        Returns a single alert by ID. Requires model_alert_read permission.

        :param alert_id: (required)
        :type alert_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alert_serialize(
            alert_id=alert_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Alert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_alert_serialize(
        self,
        alert_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if alert_id is not None:
            _path_params['alert_id'] = alert_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/alerts/{alert_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_alerts_in_workspace(
        self,
        workspace_id: StrictStr,
        sort: Annotated[Optional[AlertSort], Field(description="Override the field used for sorting the returned list. Optional.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        alert_rule_ids: Annotated[Optional[List[StrictStr]], Field(description="The ID of the alert rule to filter by.")] = None,
        bound: Annotated[Optional[AlertBound], Field(description="The bound to filter by.")] = None,
        time_from: Annotated[Optional[datetime], Field(description="The start timestamp to filter by.")] = None,
        time_to: Annotated[Optional[datetime], Field(description="The end timestamp to filter by.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InfiniteResourceListAlert:
        """Get Workspace Alerts.

        Returns alerts from all models in the workspace matching the filter and sorting criteria. If multiple filters are specified, results will only be returned that match all of the specified criteria. Requires workspace_list_alerts permission.

        :param workspace_id: (required)
        :type workspace_id: str
        :param sort: Override the field used for sorting the returned list. Optional.
        :type sort: AlertSort
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param alert_rule_ids: The ID of the alert rule to filter by.
        :type alert_rule_ids: List[str]
        :param bound: The bound to filter by.
        :type bound: AlertBound
        :param time_from: The start timestamp to filter by.
        :type time_from: datetime
        :param time_to: The end timestamp to filter by.
        :type time_to: datetime
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alerts_in_workspace_serialize(
            workspace_id=workspace_id,
            sort=sort,
            order=order,
            alert_rule_ids=alert_rule_ids,
            bound=bound,
            time_from=time_from,
            time_to=time_to,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListAlert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_alerts_in_workspace_with_http_info(
        self,
        workspace_id: StrictStr,
        sort: Annotated[Optional[AlertSort], Field(description="Override the field used for sorting the returned list. Optional.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        alert_rule_ids: Annotated[Optional[List[StrictStr]], Field(description="The ID of the alert rule to filter by.")] = None,
        bound: Annotated[Optional[AlertBound], Field(description="The bound to filter by.")] = None,
        time_from: Annotated[Optional[datetime], Field(description="The start timestamp to filter by.")] = None,
        time_to: Annotated[Optional[datetime], Field(description="The end timestamp to filter by.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InfiniteResourceListAlert]:
        """Get Workspace Alerts.

        Returns alerts from all models in the workspace matching the filter and sorting criteria. If multiple filters are specified, results will only be returned that match all of the specified criteria. Requires workspace_list_alerts permission.

        :param workspace_id: (required)
        :type workspace_id: str
        :param sort: Override the field used for sorting the returned list. Optional.
        :type sort: AlertSort
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param alert_rule_ids: The ID of the alert rule to filter by.
        :type alert_rule_ids: List[str]
        :param bound: The bound to filter by.
        :type bound: AlertBound
        :param time_from: The start timestamp to filter by.
        :type time_from: datetime
        :param time_to: The end timestamp to filter by.
        :type time_to: datetime
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alerts_in_workspace_serialize(
            workspace_id=workspace_id,
            sort=sort,
            order=order,
            alert_rule_ids=alert_rule_ids,
            bound=bound,
            time_from=time_from,
            time_to=time_to,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListAlert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_alerts_in_workspace_without_preload_content(
        self,
        workspace_id: StrictStr,
        sort: Annotated[Optional[AlertSort], Field(description="Override the field used for sorting the returned list. Optional.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="Override the sort order used. Optional.")] = None,
        alert_rule_ids: Annotated[Optional[List[StrictStr]], Field(description="The ID of the alert rule to filter by.")] = None,
        bound: Annotated[Optional[AlertBound], Field(description="The bound to filter by.")] = None,
        time_from: Annotated[Optional[datetime], Field(description="The start timestamp to filter by.")] = None,
        time_to: Annotated[Optional[datetime], Field(description="The end timestamp to filter by.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Workspace Alerts.

        Returns alerts from all models in the workspace matching the filter and sorting criteria. If multiple filters are specified, results will only be returned that match all of the specified criteria. Requires workspace_list_alerts permission.

        :param workspace_id: (required)
        :type workspace_id: str
        :param sort: Override the field used for sorting the returned list. Optional.
        :type sort: AlertSort
        :param order: Override the sort order used. Optional.
        :type order: SortOrder
        :param alert_rule_ids: The ID of the alert rule to filter by.
        :type alert_rule_ids: List[str]
        :param bound: The bound to filter by.
        :type bound: AlertBound
        :param time_from: The start timestamp to filter by.
        :type time_from: datetime
        :param time_to: The end timestamp to filter by.
        :type time_to: datetime
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alerts_in_workspace_serialize(
            workspace_id=workspace_id,
            sort=sort,
            order=order,
            alert_rule_ids=alert_rule_ids,
            bound=bound,
            time_from=time_from,
            time_to=time_to,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListAlert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_alerts_in_workspace_serialize(
        self,
        workspace_id,
        sort,
        order,
        alert_rule_ids,
        bound,
        time_from,
        time_to,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'alert_rule_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspace_id'] = workspace_id
        # process the query parameters
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if order is not None:
            
            _query_params.append(('order', order.value))
            
        if alert_rule_ids is not None:
            
            _query_params.append(('alert_rule_ids', alert_rule_ids))
            
        if bound is not None:
            
            _query_params.append(('bound', bound.value))
            
        if time_from is not None:
            if isinstance(time_from, datetime):
                _query_params.append(
                    (
                        'time_from',
                        time_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('time_from', time_from))
            
        if time_to is not None:
            if isinstance(time_to, datetime):
                _query_params.append(
                    (
                        'time_to',
                        time_to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('time_to', time_to))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/workspaces/{workspace_id}/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_model_alerts(
        self,
        model_id: StrictStr,
        sort: Annotated[Optional[AlertSort], Field(description="The field to sort by.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="The order to sort by.")] = None,
        alert_rule_ids: Annotated[Optional[List[Optional[StrictStr]]], Field(description="The ID of the alert rule to filter by.")] = None,
        bound: Annotated[Optional[AlertBound], Field(description="The bound to filter by.")] = None,
        time_from: Annotated[Optional[datetime], Field(description="The start timestamp to filter by.")] = None,
        time_to: Annotated[Optional[datetime], Field(description="The end timestamp to filter by.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InfiniteResourceListAlert:
        """Get Model Alerts

        Returns a list of alerts associated with a model. Requires model_list_alerts permission.

        :param model_id: (required)
        :type model_id: str
        :param sort: The field to sort by.
        :type sort: AlertSort
        :param order: The order to sort by.
        :type order: SortOrder
        :param alert_rule_ids: The ID of the alert rule to filter by.
        :type alert_rule_ids: List[Optional[str]]
        :param bound: The bound to filter by.
        :type bound: AlertBound
        :param time_from: The start timestamp to filter by.
        :type time_from: datetime
        :param time_to: The end timestamp to filter by.
        :type time_to: datetime
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_model_alerts_serialize(
            model_id=model_id,
            sort=sort,
            order=order,
            alert_rule_ids=alert_rule_ids,
            bound=bound,
            time_from=time_from,
            time_to=time_to,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListAlert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_model_alerts_with_http_info(
        self,
        model_id: StrictStr,
        sort: Annotated[Optional[AlertSort], Field(description="The field to sort by.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="The order to sort by.")] = None,
        alert_rule_ids: Annotated[Optional[List[Optional[StrictStr]]], Field(description="The ID of the alert rule to filter by.")] = None,
        bound: Annotated[Optional[AlertBound], Field(description="The bound to filter by.")] = None,
        time_from: Annotated[Optional[datetime], Field(description="The start timestamp to filter by.")] = None,
        time_to: Annotated[Optional[datetime], Field(description="The end timestamp to filter by.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InfiniteResourceListAlert]:
        """Get Model Alerts

        Returns a list of alerts associated with a model. Requires model_list_alerts permission.

        :param model_id: (required)
        :type model_id: str
        :param sort: The field to sort by.
        :type sort: AlertSort
        :param order: The order to sort by.
        :type order: SortOrder
        :param alert_rule_ids: The ID of the alert rule to filter by.
        :type alert_rule_ids: List[Optional[str]]
        :param bound: The bound to filter by.
        :type bound: AlertBound
        :param time_from: The start timestamp to filter by.
        :type time_from: datetime
        :param time_to: The end timestamp to filter by.
        :type time_to: datetime
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_model_alerts_serialize(
            model_id=model_id,
            sort=sort,
            order=order,
            alert_rule_ids=alert_rule_ids,
            bound=bound,
            time_from=time_from,
            time_to=time_to,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListAlert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_model_alerts_without_preload_content(
        self,
        model_id: StrictStr,
        sort: Annotated[Optional[AlertSort], Field(description="The field to sort by.")] = None,
        order: Annotated[Optional[SortOrder], Field(description="The order to sort by.")] = None,
        alert_rule_ids: Annotated[Optional[List[Optional[StrictStr]]], Field(description="The ID of the alert rule to filter by.")] = None,
        bound: Annotated[Optional[AlertBound], Field(description="The bound to filter by.")] = None,
        time_from: Annotated[Optional[datetime], Field(description="The start timestamp to filter by.")] = None,
        time_to: Annotated[Optional[datetime], Field(description="The end timestamp to filter by.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The page to return starting from 1 up to total_pages.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of records per page. The max is 1000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Model Alerts

        Returns a list of alerts associated with a model. Requires model_list_alerts permission.

        :param model_id: (required)
        :type model_id: str
        :param sort: The field to sort by.
        :type sort: AlertSort
        :param order: The order to sort by.
        :type order: SortOrder
        :param alert_rule_ids: The ID of the alert rule to filter by.
        :type alert_rule_ids: List[Optional[str]]
        :param bound: The bound to filter by.
        :type bound: AlertBound
        :param time_from: The start timestamp to filter by.
        :type time_from: datetime
        :param time_to: The end timestamp to filter by.
        :type time_to: datetime
        :param page: The page to return starting from 1 up to total_pages.
        :type page: int
        :param page_size: The number of records per page. The max is 1000.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_model_alerts_serialize(
            model_id=model_id,
            sort=sort,
            order=order,
            alert_rule_ids=alert_rule_ids,
            bound=bound,
            time_from=time_from,
            time_to=time_to,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InfiniteResourceListAlert",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_model_alerts_serialize(
        self,
        model_id,
        sort,
        order,
        alert_rule_ids,
        bound,
        time_from,
        time_to,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'alert_rule_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if order is not None:
            
            _query_params.append(('order', order.value))
            
        if alert_rule_ids is not None:
            
            _query_params.append(('alert_rule_ids', alert_rule_ids))
            
        if bound is not None:
            
            _query_params.append(('bound', bound.value))
            
        if time_from is not None:
            if isinstance(time_from, datetime):
                _query_params.append(
                    (
                        'time_from',
                        time_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('time_from', time_from))
            
        if time_to is not None:
            if isinstance(time_to, datetime):
                _query_params.append(
                    (
                        'time_to',
                        time_to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('time_to', time_to))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/models/{model_id}/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_model_alerts(
        self,
        model_id: StrictStr,
        post_alerts: PostAlerts,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatedAlerts:
        """Create Model Alerts

        Creates a list of alerts associated with a model. Requires model_create_alert permission.

        :param model_id: (required)
        :type model_id: str
        :param post_alerts: (required)
        :type post_alerts: PostAlerts
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_model_alerts_serialize(
            model_id=model_id,
            post_alerts=post_alerts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatedAlerts",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '400': "BadRequestError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_model_alerts_with_http_info(
        self,
        model_id: StrictStr,
        post_alerts: PostAlerts,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatedAlerts]:
        """Create Model Alerts

        Creates a list of alerts associated with a model. Requires model_create_alert permission.

        :param model_id: (required)
        :type model_id: str
        :param post_alerts: (required)
        :type post_alerts: PostAlerts
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_model_alerts_serialize(
            model_id=model_id,
            post_alerts=post_alerts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatedAlerts",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '400': "BadRequestError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_model_alerts_without_preload_content(
        self,
        model_id: StrictStr,
        post_alerts: PostAlerts,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Model Alerts

        Creates a list of alerts associated with a model. Requires model_create_alert permission.

        :param model_id: (required)
        :type model_id: str
        :param post_alerts: (required)
        :type post_alerts: PostAlerts
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_model_alerts_serialize(
            model_id=model_id,
            post_alerts=post_alerts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatedAlerts",
            '500': "InternalServerError",
            '404': "NotFoundError",
            '400': "BadRequestError",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_model_alerts_serialize(
        self,
        model_id,
        post_alerts,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post_alerts is not None:
            _body_params = post_alerts


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2AuthorizationCode'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/models/{model_id}/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


