# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from arthur_client.api_bindings.models.anthropic_thinking_param import AnthropicThinkingParam
from arthur_client.api_bindings.models.logit_bias_item import LogitBiasItem
from arthur_client.api_bindings.models.reasoning_effort_enum import ReasoningEffortEnum
from typing import Optional, Set
from typing_extensions import Self

class LLMBaseConfigSettings(BaseModel):
    """
    LLMBaseConfigSettings
    """ # noqa: E501
    timeout: Optional[Union[StrictFloat, StrictInt]] = None
    temperature: Optional[Union[StrictFloat, StrictInt]] = None
    top_p: Optional[Union[StrictFloat, StrictInt]] = None
    max_tokens: Optional[StrictInt] = None
    stop: Optional[StrictStr] = None
    presence_penalty: Optional[Union[StrictFloat, StrictInt]] = None
    frequency_penalty: Optional[Union[StrictFloat, StrictInt]] = None
    seed: Optional[StrictInt] = None
    logprobs: Optional[StrictBool] = None
    top_logprobs: Optional[StrictInt] = None
    logit_bias: Optional[List[LogitBiasItem]] = None
    max_completion_tokens: Optional[StrictInt] = None
    reasoning_effort: Optional[ReasoningEffortEnum] = None
    thinking: Optional[AnthropicThinkingParam] = None
    __properties: ClassVar[List[str]] = ["timeout", "temperature", "top_p", "max_tokens", "stop", "presence_penalty", "frequency_penalty", "seed", "logprobs", "top_logprobs", "logit_bias", "max_completion_tokens", "reasoning_effort", "thinking"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LLMBaseConfigSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in logit_bias (list)
        _items = []
        if self.logit_bias:
            for _item_logit_bias in self.logit_bias:
                if _item_logit_bias:
                    _items.append(_item_logit_bias.to_dict())
            _dict['logit_bias'] = _items
        # override the default output from pydantic by calling `to_dict()` of thinking
        if self.thinking:
            _dict['thinking'] = self.thinking.to_dict()
        # set to None if timeout (nullable) is None
        # and model_fields_set contains the field
        if self.timeout is None and "timeout" in self.model_fields_set:
            _dict['timeout'] = None

        # set to None if temperature (nullable) is None
        # and model_fields_set contains the field
        if self.temperature is None and "temperature" in self.model_fields_set:
            _dict['temperature'] = None

        # set to None if top_p (nullable) is None
        # and model_fields_set contains the field
        if self.top_p is None and "top_p" in self.model_fields_set:
            _dict['top_p'] = None

        # set to None if max_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.max_tokens is None and "max_tokens" in self.model_fields_set:
            _dict['max_tokens'] = None

        # set to None if stop (nullable) is None
        # and model_fields_set contains the field
        if self.stop is None and "stop" in self.model_fields_set:
            _dict['stop'] = None

        # set to None if presence_penalty (nullable) is None
        # and model_fields_set contains the field
        if self.presence_penalty is None and "presence_penalty" in self.model_fields_set:
            _dict['presence_penalty'] = None

        # set to None if frequency_penalty (nullable) is None
        # and model_fields_set contains the field
        if self.frequency_penalty is None and "frequency_penalty" in self.model_fields_set:
            _dict['frequency_penalty'] = None

        # set to None if seed (nullable) is None
        # and model_fields_set contains the field
        if self.seed is None and "seed" in self.model_fields_set:
            _dict['seed'] = None

        # set to None if logprobs (nullable) is None
        # and model_fields_set contains the field
        if self.logprobs is None and "logprobs" in self.model_fields_set:
            _dict['logprobs'] = None

        # set to None if top_logprobs (nullable) is None
        # and model_fields_set contains the field
        if self.top_logprobs is None and "top_logprobs" in self.model_fields_set:
            _dict['top_logprobs'] = None

        # set to None if logit_bias (nullable) is None
        # and model_fields_set contains the field
        if self.logit_bias is None and "logit_bias" in self.model_fields_set:
            _dict['logit_bias'] = None

        # set to None if max_completion_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.max_completion_tokens is None and "max_completion_tokens" in self.model_fields_set:
            _dict['max_completion_tokens'] = None

        # set to None if reasoning_effort (nullable) is None
        # and model_fields_set contains the field
        if self.reasoning_effort is None and "reasoning_effort" in self.model_fields_set:
            _dict['reasoning_effort'] = None

        # set to None if thinking (nullable) is None
        # and model_fields_set contains the field
        if self.thinking is None and "thinking" in self.model_fields_set:
            _dict['thinking'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LLMBaseConfigSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timeout": obj.get("timeout"),
            "temperature": obj.get("temperature"),
            "top_p": obj.get("top_p"),
            "max_tokens": obj.get("max_tokens"),
            "stop": obj.get("stop"),
            "presence_penalty": obj.get("presence_penalty"),
            "frequency_penalty": obj.get("frequency_penalty"),
            "seed": obj.get("seed"),
            "logprobs": obj.get("logprobs"),
            "top_logprobs": obj.get("top_logprobs"),
            "logit_bias": [LogitBiasItem.from_dict(_item) for _item in obj["logit_bias"]] if obj.get("logit_bias") is not None else None,
            "max_completion_tokens": obj.get("max_completion_tokens"),
            "reasoning_effort": obj.get("reasoning_effort"),
            "thinking": AnthropicThinkingParam.from_dict(obj["thinking"]) if obj.get("thinking") is not None else None
        })
        return _obj


