# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.llm_base_config_settings import LLMBaseConfigSettings
from arthur_client.api_bindings.models.model_provider import ModelProvider
from typing import Optional, Set
from typing_extensions import Self

class LLMEval(BaseModel):
    """
    LLMEval
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the llm eval")
    model_name: StrictStr = Field(description="Name of the LLM model (e.g., 'gpt-4o', 'claude-3-sonnet')")
    model_provider: ModelProvider = Field(description="Provider of the LLM model (e.g., 'openai', 'anthropic', 'azure')")
    instructions: StrictStr = Field(description="Instructions for the llm eval")
    variables: Optional[List[StrictStr]] = Field(default=None, description="List of variable names for the llm eval")
    tags: Optional[List[StrictStr]] = Field(default=None, description="List of tags for this llm eval version")
    config: Optional[LLMBaseConfigSettings] = None
    created_at: datetime = Field(description="Timestamp when the llm eval was created.")
    deleted_at: Optional[datetime] = None
    version: Optional[StrictInt] = Field(default=1, description="Version of the llm eval")
    __properties: ClassVar[List[str]] = ["name", "model_name", "model_provider", "instructions", "variables", "tags", "config", "created_at", "deleted_at", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LLMEval from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deleted_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LLMEval from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "model_name": obj.get("model_name"),
            "model_provider": obj.get("model_provider"),
            "instructions": obj.get("instructions"),
            "variables": obj.get("variables"),
            "tags": obj.get("tags"),
            "config": LLMBaseConfigSettings.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "created_at": obj.get("created_at"),
            "deleted_at": obj.get("deleted_at"),
            "version": obj.get("version") if obj.get("version") is not None else 1
        })
        return _obj


