# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.custom_aggregation_version_spec_schema_aggregate_args_inner import CustomAggregationVersionSpecSchemaAggregateArgsInner
from arthur_client.api_bindings.models.metrics_arg_spec import MetricsArgSpec
from arthur_client.api_bindings.models.reported_custom_aggregation import ReportedCustomAggregation
from typing import Optional, Set
from typing_extensions import Self

class PostCustomAggregationTest(BaseModel):
    """
    PostCustomAggregationTest
    """ # noqa: E501
    reported_aggregations: List[ReportedCustomAggregation] = Field(description="Metadata for every aggregation the custom aggregation reports.")
    aggregate_args: List[CustomAggregationVersionSpecSchemaAggregateArgsInner] = Field(description="List of parameters to the custom aggregation's query function.")
    sql: StrictStr = Field(description="DuckDBSQL query for the custom aggregation.")
    name: StrictStr = Field(description="Name of the custom aggregation function.")
    description: Optional[StrictStr] = None
    aggregation_arg_configuration: List[MetricsArgSpec] = Field(description="List of argument values for the aggregation's aggregate function.")
    start_timestamp: datetime = Field(description="The start timestamp to use for fetching data.")
    end_timestamp: datetime = Field(description="The end timestamp to use for fetching data.")
    dataset_id: StrictStr = Field(description="ID of the dataset to use for the custom aggregation test.")
    __properties: ClassVar[List[str]] = ["reported_aggregations", "aggregate_args", "sql", "name", "description", "aggregation_arg_configuration", "start_timestamp", "end_timestamp", "dataset_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostCustomAggregationTest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in reported_aggregations (list)
        _items = []
        if self.reported_aggregations:
            for _item_reported_aggregations in self.reported_aggregations:
                if _item_reported_aggregations:
                    _items.append(_item_reported_aggregations.to_dict())
            _dict['reported_aggregations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aggregate_args (list)
        _items = []
        if self.aggregate_args:
            for _item_aggregate_args in self.aggregate_args:
                if _item_aggregate_args:
                    _items.append(_item_aggregate_args.to_dict())
            _dict['aggregate_args'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aggregation_arg_configuration (list)
        _items = []
        if self.aggregation_arg_configuration:
            for _item_aggregation_arg_configuration in self.aggregation_arg_configuration:
                if _item_aggregation_arg_configuration:
                    _items.append(_item_aggregation_arg_configuration.to_dict())
            _dict['aggregation_arg_configuration'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostCustomAggregationTest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "reported_aggregations": [ReportedCustomAggregation.from_dict(_item) for _item in obj["reported_aggregations"]] if obj.get("reported_aggregations") is not None else None,
            "aggregate_args": [CustomAggregationVersionSpecSchemaAggregateArgsInner.from_dict(_item) for _item in obj["aggregate_args"]] if obj.get("aggregate_args") is not None else None,
            "sql": obj.get("sql"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "aggregation_arg_configuration": [MetricsArgSpec.from_dict(_item) for _item in obj["aggregation_arg_configuration"]] if obj.get("aggregation_arg_configuration") is not None else None,
            "start_timestamp": obj.get("start_timestamp"),
            "end_timestamp": obj.get("end_timestamp"),
            "dataset_id": obj.get("dataset_id")
        })
        return _obj


