# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.data_plane_capabilities import DataPlaneCapabilities
from arthur_client.api_bindings.models.infrastructure import Infrastructure
from typing import Optional, Set
from typing_extensions import Self

class PostDataPlane(BaseModel):
    """
    PostDataPlane
    """ # noqa: E501
    name: StrictStr = Field(description="Name of data plane.")
    description: StrictStr = Field(description="Description of data plane.")
    infrastructure: Optional[Infrastructure] = Field(default=None, description="Infrastructure where the engine is running (e.g., AWS, GCP, Azure, Docker, Kubernetes).")
    capabilities: Optional[DataPlaneCapabilities] = Field(default=None, description="Capabilities for this data plane.")
    __properties: ClassVar[List[str]] = ["name", "description", "infrastructure", "capabilities"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostDataPlane from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of capabilities
        if self.capabilities:
            _dict['capabilities'] = self.capabilities.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostDataPlane from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "infrastructure": obj.get("infrastructure"),
            "capabilities": DataPlaneCapabilities.from_dict(obj["capabilities"]) if obj.get("capabilities") is not None else None
        })
        return _obj


