# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.continuous_eval_response import ContinuousEvalResponse
from arthur_client.api_bindings.models.llm_eval import LLMEval
from arthur_client.api_bindings.models.task_response import TaskResponse
from arthur_client.api_bindings.models.trace_transform_response import TraceTransformResponse
from typing import Optional, Set
from typing_extensions import Self

class TaskReadResponse(BaseModel):
    """
    TaskReadResponse
    """ # noqa: E501
    task: Optional[TaskResponse] = None
    last_synced_at: Optional[datetime] = None
    scope_model_id: StrictStr = Field(description="The ID of the corresponding scope model for this task.")
    evals: Optional[List[LLMEval]] = None
    continuous_evals: Optional[List[ContinuousEvalResponse]] = None
    transforms: Optional[List[TraceTransformResponse]] = None
    __properties: ClassVar[List[str]] = ["task", "last_synced_at", "scope_model_id", "evals", "continuous_evals", "transforms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskReadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of task
        if self.task:
            _dict['task'] = self.task.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in evals (list)
        _items = []
        if self.evals:
            for _item_evals in self.evals:
                if _item_evals:
                    _items.append(_item_evals.to_dict())
            _dict['evals'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in continuous_evals (list)
        _items = []
        if self.continuous_evals:
            for _item_continuous_evals in self.continuous_evals:
                if _item_continuous_evals:
                    _items.append(_item_continuous_evals.to_dict())
            _dict['continuous_evals'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transforms (list)
        _items = []
        if self.transforms:
            for _item_transforms in self.transforms:
                if _item_transforms:
                    _items.append(_item_transforms.to_dict())
            _dict['transforms'] = _items
        # set to None if task (nullable) is None
        # and model_fields_set contains the field
        if self.task is None and "task" in self.model_fields_set:
            _dict['task'] = None

        # set to None if last_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_synced_at is None and "last_synced_at" in self.model_fields_set:
            _dict['last_synced_at'] = None

        # set to None if evals (nullable) is None
        # and model_fields_set contains the field
        if self.evals is None and "evals" in self.model_fields_set:
            _dict['evals'] = None

        # set to None if continuous_evals (nullable) is None
        # and model_fields_set contains the field
        if self.continuous_evals is None and "continuous_evals" in self.model_fields_set:
            _dict['continuous_evals'] = None

        # set to None if transforms (nullable) is None
        # and model_fields_set contains the field
        if self.transforms is None and "transforms" in self.model_fields_set:
            _dict['transforms'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskReadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "task": TaskResponse.from_dict(obj["task"]) if obj.get("task") is not None else None,
            "last_synced_at": obj.get("last_synced_at"),
            "scope_model_id": obj.get("scope_model_id"),
            "evals": [LLMEval.from_dict(_item) for _item in obj["evals"]] if obj.get("evals") is not None else None,
            "continuous_evals": [ContinuousEvalResponse.from_dict(_item) for _item in obj["continuous_evals"]] if obj.get("continuous_evals") is not None else None,
            "transforms": [TraceTransformResponse.from_dict(_item) for _item in obj["transforms"]] if obj.get("transforms") is not None else None
        })
        return _obj


