import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Free form text representing the meaning of the tag
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/tag#description Tag#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/tag#id Tag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The value representing the tag
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/tag#name Tag#name}
    */
    readonly name: string;
    /**
    * A collection of servers that have been assigned the tag
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/tag#servers Tag#servers}
    */
    readonly servers?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/tag upcloud_tag}
*/
export declare class Tag extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/tag upcloud_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagConfig
    */
    constructor(scope: Construct, id: string, config: TagConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _servers?;
    get servers(): string[];
    set servers(value: string[]);
    resetServers(): void;
    get serversInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
