# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'AccessTokenInlineRoleArgs',
    'AccessTokenPolicyStatementArgs',
    'AuditLogSubscriptionStatementArgs',
    'CustomRolePolicyArgs',
    'CustomRolePolicyStatementArgs',
    'EnvironmentApprovalSettingArgs',
    'FeatureFlagClientSideAvailabilityArgs',
    'FeatureFlagCustomPropertyArgs',
    'FeatureFlagDefaultsArgs',
    'FeatureFlagEnvironmentFallthroughArgs',
    'FeatureFlagEnvironmentPrerequisiteArgs',
    'FeatureFlagEnvironmentRuleArgs',
    'FeatureFlagEnvironmentRuleClauseArgs',
    'FeatureFlagEnvironmentTargetArgs',
    'FeatureFlagVariationArgs',
    'FlagTriggerInstructionsArgs',
    'MetricUrlArgs',
    'ProjectDefaultClientSideAvailabilityArgs',
    'ProjectEnvironmentArgs',
    'ProjectEnvironmentApprovalSettingArgs',
    'RelayProxyConfigurationPolicyArgs',
    'SegmentRuleArgs',
    'SegmentRuleClauseArgs',
    'WebhookStatementArgs',
    'GetAuditLogSubscriptionStatementArgs',
    'GetEnvironmentApprovalSettingArgs',
    'GetFeatureFlagClientSideAvailabilityArgs',
    'GetFeatureFlagCustomPropertyArgs',
    'GetFeatureFlagDefaultsArgs',
    'GetFeatureFlagEnvironmentFallthroughArgs',
    'GetFeatureFlagEnvironmentPrerequisiteArgs',
    'GetFeatureFlagEnvironmentRuleArgs',
    'GetFeatureFlagEnvironmentRuleClauseArgs',
    'GetFeatureFlagEnvironmentTargetArgs',
    'GetFeatureFlagVariationArgs',
    'GetFlagTriggerInstructionsArgs',
    'GetMetricUrlArgs',
    'GetRelayProxyConfigurationPolicyArgs',
    'GetSegmentRuleArgs',
    'GetSegmentRuleClauseArgs',
    'GetWebhookStatementArgs',
]

@pulumi.input_type
class AccessTokenInlineRoleArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the statement applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_actions: The list of action specifiers defining the actions to which the statement does not apply.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: - The list of resource specifiers defining the resources to which the statement does not apply.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: - The list of resource specifiers defining the resources to which the statement applies.
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement applies.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply.
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the statement does not apply.
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class AccessTokenPolicyStatementArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the statement applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_actions: The list of action specifiers defining the actions to which the statement does not apply.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: - The list of resource specifiers defining the resources to which the statement does not apply.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: - The list of resource specifiers defining the resources to which the statement applies.
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement applies.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply.
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the statement does not apply.
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class AuditLogSubscriptionStatementArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] effect: Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the statement applies. For a list of available actions, read [Using actions](https://docs.launchdarkly.com/home/members/role-actions).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_actions: The list of action specifiers defining the actions to which the statement does not apply. For a list of available actions, read [Using actions](https://docs.launchdarkly.com/home/members/role-actions).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: The list of resource specifiers defining the resources to which the statement does not apply. To learn more about how to configure these, read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: The list of resource specifiers defining the resources to which the statement applies. To learn more about how to configure these, read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement applies. For a list of available actions, read [Using actions](https://docs.launchdarkly.com/home/members/role-actions).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply. For a list of available actions, read [Using actions](https://docs.launchdarkly.com/home/members/role-actions).
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of resource specifiers defining the resources to which the statement does not apply. To learn more about how to configure these, read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of resource specifiers defining the resources to which the statement applies. To learn more about how to configure these, read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class CustomRolePolicyArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 effect: pulumi.Input[str],
                 resources: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/members/role-actions#actions-reference).
        :param pulumi.Input[str] effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/members/role-resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/members/role-actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/members/role-resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class CustomRolePolicyStatementArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/members/role-actions#actions-reference).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_actions: The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/members/role-actions#actions-reference).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: - The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/members/role-resources#understanding-resource-types-and-scopes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/members/role-resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/members/role-actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/members/role-actions#actions-reference).
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/members/role-resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/members/role-resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class EnvironmentApprovalSettingArgs:
    def __init__(__self__, *,
                 can_apply_declined_changes: Optional[pulumi.Input[bool]] = None,
                 can_review_own_request: Optional[pulumi.Input[bool]] = None,
                 min_num_approvals: Optional[pulumi.Input[int]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 required_approval_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] can_apply_declined_changes: Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        :param pulumi.Input[bool] can_review_own_request: Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        :param pulumi.Input[int] min_num_approvals: The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        :param pulumi.Input[bool] required: Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_approval_tags: An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        if can_apply_declined_changes is not None:
            pulumi.set(__self__, "can_apply_declined_changes", can_apply_declined_changes)
        if can_review_own_request is not None:
            pulumi.set(__self__, "can_review_own_request", can_review_own_request)
        if min_num_approvals is not None:
            pulumi.set(__self__, "min_num_approvals", min_num_approvals)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if required_approval_tags is not None:
            pulumi.set(__self__, "required_approval_tags", required_approval_tags)

    @property
    @pulumi.getter(name="canApplyDeclinedChanges")
    def can_apply_declined_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        """
        return pulumi.get(self, "can_apply_declined_changes")

    @can_apply_declined_changes.setter
    def can_apply_declined_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_apply_declined_changes", value)

    @property
    @pulumi.getter(name="canReviewOwnRequest")
    def can_review_own_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        """
        return pulumi.get(self, "can_review_own_request")

    @can_review_own_request.setter
    def can_review_own_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_review_own_request", value)

    @property
    @pulumi.getter(name="minNumApprovals")
    def min_num_approvals(self) -> Optional[pulumi.Input[int]]:
        """
        The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        """
        return pulumi.get(self, "min_num_approvals")

    @min_num_approvals.setter
    def min_num_approvals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_num_approvals", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter(name="requiredApprovalTags")
    def required_approval_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        return pulumi.get(self, "required_approval_tags")

    @required_approval_tags.setter
    def required_approval_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_approval_tags", value)


@pulumi.input_type
class FeatureFlagClientSideAvailabilityArgs:
    def __init__(__self__, *,
                 using_environment_id: Optional[pulumi.Input[bool]] = None,
                 using_mobile_key: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] using_environment_id: Whether this flag is available to SDKs using the client-side ID.
        :param pulumi.Input[bool] using_mobile_key: Whether this flag is available to SDKs using a mobile key.
        """
        if using_environment_id is not None:
            pulumi.set(__self__, "using_environment_id", using_environment_id)
        if using_mobile_key is not None:
            pulumi.set(__self__, "using_mobile_key", using_mobile_key)

    @property
    @pulumi.getter(name="usingEnvironmentId")
    def using_environment_id(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this flag is available to SDKs using the client-side ID.
        """
        return pulumi.get(self, "using_environment_id")

    @using_environment_id.setter
    def using_environment_id(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "using_environment_id", value)

    @property
    @pulumi.getter(name="usingMobileKey")
    def using_mobile_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this flag is available to SDKs using a mobile key.
        """
        return pulumi.get(self, "using_mobile_key")

    @using_mobile_key.setter
    def using_mobile_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "using_mobile_key", value)


@pulumi.input_type
class FeatureFlagCustomPropertyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 name: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] key: The unique custom property key.
        :param pulumi.Input[str] name: The name of the custom property.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The list of custom property value strings.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The unique custom property key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of custom property value strings.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class FeatureFlagDefaultsArgs:
    def __init__(__self__, *,
                 off_variation: pulumi.Input[int],
                 on_variation: pulumi.Input[int]):
        """
        :param pulumi.Input[int] off_variation: The index of the variation the flag will default to in all new environments when off.
        :param pulumi.Input[int] on_variation: The index of the variation the flag will default to in all new environments when on.
        """
        pulumi.set(__self__, "off_variation", off_variation)
        pulumi.set(__self__, "on_variation", on_variation)

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> pulumi.Input[int]:
        """
        The index of the variation the flag will default to in all new environments when off.
        """
        return pulumi.get(self, "off_variation")

    @off_variation.setter
    def off_variation(self, value: pulumi.Input[int]):
        pulumi.set(self, "off_variation", value)

    @property
    @pulumi.getter(name="onVariation")
    def on_variation(self) -> pulumi.Input[int]:
        """
        The index of the variation the flag will default to in all new environments when on.
        """
        return pulumi.get(self, "on_variation")

    @on_variation.setter
    def on_variation(self, value: pulumi.Input[int]):
        pulumi.set(self, "on_variation", value)


@pulumi.input_type
class FeatureFlagEnvironmentFallthroughArgs:
    def __init__(__self__, *,
                 bucket_by: Optional[pulumi.Input[str]] = None,
                 rollout_weights: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 variation: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] bucket_by: Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] rollout_weights: List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000 and the number of rollout weights specified in the array must match the number of flag variations. You must specify either `variation` or `rollout_weights`.
        :param pulumi.Input[int] variation: The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[pulumi.Input[str]]:
        """
        Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        """
        return pulumi.get(self, "bucket_by")

    @bucket_by.setter
    def bucket_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_by", value)

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000 and the number of rollout weights specified in the array must match the number of flag variations. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "rollout_weights")

    @rollout_weights.setter
    def rollout_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "rollout_weights", value)

    @property
    @pulumi.getter
    def variation(self) -> Optional[pulumi.Input[int]]:
        """
        The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class FeatureFlagEnvironmentPrerequisiteArgs:
    def __init__(__self__, *,
                 flag_key: pulumi.Input[str],
                 variation: pulumi.Input[int]):
        """
        :param pulumi.Input[str] flag_key: The prerequisite feature flag's `key`.
        :param pulumi.Input[int] variation: The index of the prerequisite feature flag's variation to target.
        """
        pulumi.set(__self__, "flag_key", flag_key)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="flagKey")
    def flag_key(self) -> pulumi.Input[str]:
        """
        The prerequisite feature flag's `key`.
        """
        return pulumi.get(self, "flag_key")

    @flag_key.setter
    def flag_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "flag_key", value)

    @property
    @pulumi.getter
    def variation(self) -> pulumi.Input[int]:
        """
        The index of the prerequisite feature flag's variation to target.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: pulumi.Input[int]):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class FeatureFlagEnvironmentRuleArgs:
    def __init__(__self__, *,
                 bucket_by: Optional[pulumi.Input[str]] = None,
                 clauses: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleClauseArgs']]]] = None,
                 rollout_weights: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 variation: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] bucket_by: Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleClauseArgs']]] clauses: List of nested blocks specifying the logical clauses to evaluate. To learn more, read Nested Clauses Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] rollout_weights: List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000 and the number of rollout weights specified in the array must match the number of flag variations. You must specify either `variation` or `rollout_weights`.
        :param pulumi.Input[int] variation: The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[pulumi.Input[str]]:
        """
        Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        """
        return pulumi.get(self, "bucket_by")

    @bucket_by.setter
    def bucket_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_by", value)

    @property
    @pulumi.getter
    def clauses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleClauseArgs']]]]:
        """
        List of nested blocks specifying the logical clauses to evaluate. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @clauses.setter
    def clauses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleClauseArgs']]]]):
        pulumi.set(self, "clauses", value)

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000 and the number of rollout weights specified in the array must match the number of flag variations. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "rollout_weights")

    @rollout_weights.setter
    def rollout_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "rollout_weights", value)

    @property
    @pulumi.getter
    def variation(self) -> Optional[pulumi.Input[int]]:
        """
        The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class FeatureFlagEnvironmentRuleClauseArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[str],
                 op: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 negate: Optional[pulumi.Input[bool]] = None,
                 value_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] attribute: The user attribute to operate on.
        :param pulumi.Input[str] op: The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The list of values associated with the rule clause.
        :param pulumi.Input[bool] negate: Whether to negate the rule clause.
        :param pulumi.Input[str] value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[str]:
        """
        The user attribute to operate on.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[str]:
        """
        The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to negate the rule clause.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class FeatureFlagEnvironmentTargetArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 variation: pulumi.Input[int]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of `user` strings to target.
        :param pulumi.Input[int] variation: The index of the variation to serve is a user target value is matched.
        """
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of `user` strings to target.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def variation(self) -> pulumi.Input[int]:
        """
        The index of the variation to serve is a user target value is matched.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: pulumi.Input[int]):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class FeatureFlagVariationArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: The variation value. The value's type must correspond to the `variation_type` argument. For example: `variation_type = "boolean"` accepts only `true` or `false`. The `"number"` variation type accepts both floats and ints, but please note that any trailing zeroes on floats will be trimmed (i.e. `1.1` and `1.100` will both be converted to `1.1`).
        :param pulumi.Input[str] description: The variation's description.
        :param pulumi.Input[str] name: The name of the variation.
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The variation value. The value's type must correspond to the `variation_type` argument. For example: `variation_type = "boolean"` accepts only `true` or `false`. The `"number"` variation type accepts both floats and ints, but please note that any trailing zeroes on floats will be trimmed (i.e. `1.1` and `1.100` will both be converted to `1.1`).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The variation's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class FlagTriggerInstructionsArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str]):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class MetricUrlArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 pattern: Optional[pulumi.Input[str]] = None,
                 substring: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: The URL type. Available choices are `exact`, `canonical`, `substring` and `regex`.
        :param pulumi.Input[str] pattern: The regex pattern to match by.
        :param pulumi.Input[str] substring: The URL substring to match by.
        :param pulumi.Input[str] url: The exact or canonical URL.
        """
        pulumi.set(__self__, "kind", kind)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if substring is not None:
            pulumi.set(__self__, "substring", substring)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        The URL type. Available choices are `exact`, `canonical`, `substring` and `regex`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        The regex pattern to match by.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def substring(self) -> Optional[pulumi.Input[str]]:
        """
        The URL substring to match by.
        """
        return pulumi.get(self, "substring")

    @substring.setter
    def substring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substring", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The exact or canonical URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ProjectDefaultClientSideAvailabilityArgs:
    def __init__(__self__, *,
                 using_environment_id: pulumi.Input[bool],
                 using_mobile_key: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] using_environment_id: Whether feature flags created under the project are available to JavaScript SDKs using the client-side ID by default. Defaults to `false` when not using `default_client_side_availability`.
        :param pulumi.Input[bool] using_mobile_key: Whether feature flags created under the project are available to mobile SDKs, and other non-JavaScript SDKs, using a mobile key by default. Defaults to `true` when not using `default_client_side_availability`.
        """
        pulumi.set(__self__, "using_environment_id", using_environment_id)
        pulumi.set(__self__, "using_mobile_key", using_mobile_key)

    @property
    @pulumi.getter(name="usingEnvironmentId")
    def using_environment_id(self) -> pulumi.Input[bool]:
        """
        Whether feature flags created under the project are available to JavaScript SDKs using the client-side ID by default. Defaults to `false` when not using `default_client_side_availability`.
        """
        return pulumi.get(self, "using_environment_id")

    @using_environment_id.setter
    def using_environment_id(self, value: pulumi.Input[bool]):
        pulumi.set(self, "using_environment_id", value)

    @property
    @pulumi.getter(name="usingMobileKey")
    def using_mobile_key(self) -> pulumi.Input[bool]:
        """
        Whether feature flags created under the project are available to mobile SDKs, and other non-JavaScript SDKs, using a mobile key by default. Defaults to `true` when not using `default_client_side_availability`.
        """
        return pulumi.get(self, "using_mobile_key")

    @using_mobile_key.setter
    def using_mobile_key(self, value: pulumi.Input[bool]):
        pulumi.set(self, "using_mobile_key", value)


@pulumi.input_type
class ProjectEnvironmentArgs:
    def __init__(__self__, *,
                 color: pulumi.Input[str],
                 key: pulumi.Input[str],
                 name: pulumi.Input[str],
                 api_key: Optional[pulumi.Input[str]] = None,
                 approval_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentApprovalSettingArgs']]]] = None,
                 client_side_id: Optional[pulumi.Input[str]] = None,
                 confirm_changes: Optional[pulumi.Input[bool]] = None,
                 default_track_events: Optional[pulumi.Input[bool]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 mobile_key: Optional[pulumi.Input[str]] = None,
                 require_comments: Optional[pulumi.Input[bool]] = None,
                 secure_mode: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] color: The color swatch as an RGB hex value with no leading `#`. For example: `000000`.
        :param pulumi.Input[str] key: The project-unique key for the environment. A change in this field will force the destruction of the existing environment and the creation of a new one.
        :param pulumi.Input[str] name: The name of the environment.
        :param pulumi.Input[bool] confirm_changes: Set to `true` if this environment requires confirmation for flag and segment changes. This field will default to `false` when not set.
        :param pulumi.Input[bool] default_track_events: Set to `true` to enable data export for every flag created in this environment after you configure this argument. This field will default to `false` when not set. To learn more, read [Data Export](https://docs.launchdarkly.com/home/data-export).
        :param pulumi.Input[int] default_ttl: The TTL for the environment. This must be between 0 and 60 minutes. The TTL setting only applies to environments using the PHP SDK. This field will default to `0` when not set. To learn more, read [TTL settings](https://docs.launchdarkly.com/home/organize/environments#ttl-settings).
        :param pulumi.Input[bool] require_comments: Set to `true` if this environment requires comments for flag and segment changes. This field will default to `false` when not set.
        :param pulumi.Input[bool] secure_mode: Set to `true` to ensure a user of the client-side SDK cannot impersonate another user. This field will default to `false` when not set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags associated with the environment.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if approval_settings is not None:
            pulumi.set(__self__, "approval_settings", approval_settings)
        if client_side_id is not None:
            pulumi.set(__self__, "client_side_id", client_side_id)
        if confirm_changes is not None:
            pulumi.set(__self__, "confirm_changes", confirm_changes)
        if default_track_events is not None:
            pulumi.set(__self__, "default_track_events", default_track_events)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if mobile_key is not None:
            pulumi.set(__self__, "mobile_key", mobile_key)
        if require_comments is not None:
            pulumi.set(__self__, "require_comments", require_comments)
        if secure_mode is not None:
            pulumi.set(__self__, "secure_mode", secure_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Input[str]:
        """
        The color swatch as an RGB hex value with no leading `#`. For example: `000000`.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: pulumi.Input[str]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The project-unique key for the environment. A change in this field will force the destruction of the existing environment and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="approvalSettings")
    def approval_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentApprovalSettingArgs']]]]:
        return pulumi.get(self, "approval_settings")

    @approval_settings.setter
    def approval_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentApprovalSettingArgs']]]]):
        pulumi.set(self, "approval_settings", value)

    @property
    @pulumi.getter(name="clientSideId")
    def client_side_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_side_id")

    @client_side_id.setter
    def client_side_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_side_id", value)

    @property
    @pulumi.getter(name="confirmChanges")
    def confirm_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if this environment requires confirmation for flag and segment changes. This field will default to `false` when not set.
        """
        return pulumi.get(self, "confirm_changes")

    @confirm_changes.setter
    def confirm_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confirm_changes", value)

    @property
    @pulumi.getter(name="defaultTrackEvents")
    def default_track_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable data export for every flag created in this environment after you configure this argument. This field will default to `false` when not set. To learn more, read [Data Export](https://docs.launchdarkly.com/home/data-export).
        """
        return pulumi.get(self, "default_track_events")

    @default_track_events.setter
    def default_track_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_track_events", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL for the environment. This must be between 0 and 60 minutes. The TTL setting only applies to environments using the PHP SDK. This field will default to `0` when not set. To learn more, read [TTL settings](https://docs.launchdarkly.com/home/organize/environments#ttl-settings).
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="mobileKey")
    def mobile_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mobile_key")

    @mobile_key.setter
    def mobile_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_key", value)

    @property
    @pulumi.getter(name="requireComments")
    def require_comments(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if this environment requires comments for flag and segment changes. This field will default to `false` when not set.
        """
        return pulumi.get(self, "require_comments")

    @require_comments.setter
    def require_comments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_comments", value)

    @property
    @pulumi.getter(name="secureMode")
    def secure_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to ensure a user of the client-side SDK cannot impersonate another user. This field will default to `false` when not set.
        """
        return pulumi.get(self, "secure_mode")

    @secure_mode.setter
    def secure_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags associated with the environment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ProjectEnvironmentApprovalSettingArgs:
    def __init__(__self__, *,
                 can_apply_declined_changes: Optional[pulumi.Input[bool]] = None,
                 can_review_own_request: Optional[pulumi.Input[bool]] = None,
                 min_num_approvals: Optional[pulumi.Input[int]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 required_approval_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] can_apply_declined_changes: Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        :param pulumi.Input[bool] can_review_own_request: Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        :param pulumi.Input[int] min_num_approvals: The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        :param pulumi.Input[bool] required: Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_approval_tags: An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        if can_apply_declined_changes is not None:
            pulumi.set(__self__, "can_apply_declined_changes", can_apply_declined_changes)
        if can_review_own_request is not None:
            pulumi.set(__self__, "can_review_own_request", can_review_own_request)
        if min_num_approvals is not None:
            pulumi.set(__self__, "min_num_approvals", min_num_approvals)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if required_approval_tags is not None:
            pulumi.set(__self__, "required_approval_tags", required_approval_tags)

    @property
    @pulumi.getter(name="canApplyDeclinedChanges")
    def can_apply_declined_changes(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        """
        return pulumi.get(self, "can_apply_declined_changes")

    @can_apply_declined_changes.setter
    def can_apply_declined_changes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_apply_declined_changes", value)

    @property
    @pulumi.getter(name="canReviewOwnRequest")
    def can_review_own_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        """
        return pulumi.get(self, "can_review_own_request")

    @can_review_own_request.setter
    def can_review_own_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_review_own_request", value)

    @property
    @pulumi.getter(name="minNumApprovals")
    def min_num_approvals(self) -> Optional[pulumi.Input[int]]:
        """
        The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        """
        return pulumi.get(self, "min_num_approvals")

    @min_num_approvals.setter
    def min_num_approvals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_num_approvals", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter(name="requiredApprovalTags")
    def required_approval_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        return pulumi.get(self, "required_approval_tags")

    @required_approval_tags.setter
    def required_approval_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_approval_tags", value)


@pulumi.input_type
class RelayProxyConfigurationPolicyArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] effect: - Either `allow` or `deny`. This argument defines whether the rule policy allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the rule policy applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_actions: The list of action specifiers defining the actions to which the rule policy does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: - The list of resource specifiers defining the resources to which the rule policy does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: - The list of resource specifiers defining the resources to which the rule policy applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        - Either `allow` or `deny`. This argument defines whether the rule policy allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the rule policy applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the rule policy does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the rule policy does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - The list of resource specifiers defining the resources to which the rule policy applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class SegmentRuleArgs:
    def __init__(__self__, *,
                 bucket_by: Optional[pulumi.Input[str]] = None,
                 clauses: Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleClauseArgs']]]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] bucket_by: The attribute by which to group users together.
        :param pulumi.Input[Sequence[pulumi.Input['SegmentRuleClauseArgs']]] clauses: List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        :param pulumi.Input[int] weight: The integer weight of the rule (between 1 and 100000).
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute by which to group users together.
        """
        return pulumi.get(self, "bucket_by")

    @bucket_by.setter
    def bucket_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_by", value)

    @property
    @pulumi.getter
    def clauses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleClauseArgs']]]]:
        """
        List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @clauses.setter
    def clauses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleClauseArgs']]]]):
        pulumi.set(self, "clauses", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The integer weight of the rule (between 1 and 100000).
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class SegmentRuleClauseArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[str],
                 op: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 negate: Optional[pulumi.Input[bool]] = None,
                 value_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] attribute: The user attribute to operate on.
        :param pulumi.Input[str] op: The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The list of values associated with the rule clause.
        :param pulumi.Input[bool] negate: Whether to negate the rule clause.
        :param pulumi.Input[str] value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[str]:
        """
        The user attribute to operate on.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[str]:
        """
        The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to negate the rule clause.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class WebhookStatementArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] effect: Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] actions: The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_actions: The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class GetAuditLogSubscriptionStatementArgs:
    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] not_resources: The list of resource specifiers defining the resources to which the statement does not apply. To learn more about how to configure these, read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        :param Sequence[str] resources: The list of resource specifiers defining the resources to which the statement applies. To learn more about how to configure these read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: str):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement does not apply. To learn more about how to configure these, read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement applies. To learn more about how to configure these read [Using resources](https://docs.launchdarkly.com/home/members/role-resources).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class GetEnvironmentApprovalSettingArgs:
    def __init__(__self__, *,
                 can_apply_declined_changes: Optional[bool] = None,
                 can_review_own_request: Optional[bool] = None,
                 min_num_approvals: Optional[int] = None,
                 required: Optional[bool] = None,
                 required_approval_tags: Optional[Sequence[str]] = None):
        if can_apply_declined_changes is not None:
            pulumi.set(__self__, "can_apply_declined_changes", can_apply_declined_changes)
        if can_review_own_request is not None:
            pulumi.set(__self__, "can_review_own_request", can_review_own_request)
        if min_num_approvals is not None:
            pulumi.set(__self__, "min_num_approvals", min_num_approvals)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if required_approval_tags is not None:
            pulumi.set(__self__, "required_approval_tags", required_approval_tags)

    @property
    @pulumi.getter(name="canApplyDeclinedChanges")
    def can_apply_declined_changes(self) -> Optional[bool]:
        return pulumi.get(self, "can_apply_declined_changes")

    @can_apply_declined_changes.setter
    def can_apply_declined_changes(self, value: Optional[bool]):
        pulumi.set(self, "can_apply_declined_changes", value)

    @property
    @pulumi.getter(name="canReviewOwnRequest")
    def can_review_own_request(self) -> Optional[bool]:
        return pulumi.get(self, "can_review_own_request")

    @can_review_own_request.setter
    def can_review_own_request(self, value: Optional[bool]):
        pulumi.set(self, "can_review_own_request", value)

    @property
    @pulumi.getter(name="minNumApprovals")
    def min_num_approvals(self) -> Optional[int]:
        return pulumi.get(self, "min_num_approvals")

    @min_num_approvals.setter
    def min_num_approvals(self, value: Optional[int]):
        pulumi.set(self, "min_num_approvals", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[bool]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter(name="requiredApprovalTags")
    def required_approval_tags(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "required_approval_tags")

    @required_approval_tags.setter
    def required_approval_tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "required_approval_tags", value)


@pulumi.input_type
class GetFeatureFlagClientSideAvailabilityArgs:
    def __init__(__self__, *,
                 using_environment_id: bool,
                 using_mobile_key: Optional[bool] = None):
        """
        :param bool using_environment_id: When set to true, this flag is available to SDKs using the client-side ID.
        :param bool using_mobile_key: When set to true, this flag is available to SDKs using a mobile key.
        """
        pulumi.set(__self__, "using_environment_id", using_environment_id)
        if using_mobile_key is not None:
            pulumi.set(__self__, "using_mobile_key", using_mobile_key)

    @property
    @pulumi.getter(name="usingEnvironmentId")
    def using_environment_id(self) -> bool:
        """
        When set to true, this flag is available to SDKs using the client-side ID.
        """
        return pulumi.get(self, "using_environment_id")

    @using_environment_id.setter
    def using_environment_id(self, value: bool):
        pulumi.set(self, "using_environment_id", value)

    @property
    @pulumi.getter(name="usingMobileKey")
    def using_mobile_key(self) -> Optional[bool]:
        """
        When set to true, this flag is available to SDKs using a mobile key.
        """
        return pulumi.get(self, "using_mobile_key")

    @using_mobile_key.setter
    def using_mobile_key(self, value: Optional[bool]):
        pulumi.set(self, "using_mobile_key", value)


@pulumi.input_type
class GetFeatureFlagCustomPropertyArgs:
    def __init__(__self__, *,
                 key: str,
                 name: str,
                 values: Sequence[str]):
        """
        :param str key: The unique feature flag key that references the flag in your application code.
        :param str name: The name of the custom property.
        :param Sequence[str] values: The list of custom property value strings.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The unique feature flag key that references the flag in your application code.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of custom property value strings.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetFeatureFlagDefaultsArgs:
    def __init__(__self__, *,
                 off_variation: int,
                 on_variation: int):
        """
        :param int off_variation: (Required) The index of the variation the flag will default to in all new environments when off.
        :param int on_variation: (Required) The index of the variation the flag will default to in all new environments when on.
        """
        pulumi.set(__self__, "off_variation", off_variation)
        pulumi.set(__self__, "on_variation", on_variation)

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> int:
        """
        (Required) The index of the variation the flag will default to in all new environments when off.
        """
        return pulumi.get(self, "off_variation")

    @off_variation.setter
    def off_variation(self, value: int):
        pulumi.set(self, "off_variation", value)

    @property
    @pulumi.getter(name="onVariation")
    def on_variation(self) -> int:
        """
        (Required) The index of the variation the flag will default to in all new environments when on.
        """
        return pulumi.get(self, "on_variation")

    @on_variation.setter
    def on_variation(self, value: int):
        pulumi.set(self, "on_variation", value)


@pulumi.input_type
class GetFeatureFlagEnvironmentFallthroughArgs:
    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 rollout_weights: Optional[Sequence[int]] = None,
                 variation: Optional[int] = None):
        """
        :param str bucket_by: Group percentage rollout by a custom attribute.
        :param Sequence[int] rollout_weights: List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        Group percentage rollout by a custom attribute.
        """
        return pulumi.get(self, "bucket_by")

    @bucket_by.setter
    def bucket_by(self, value: Optional[str]):
        pulumi.set(self, "bucket_by", value)

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[Sequence[int]]:
        """
        List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        """
        return pulumi.get(self, "rollout_weights")

    @rollout_weights.setter
    def rollout_weights(self, value: Optional[Sequence[int]]):
        pulumi.set(self, "rollout_weights", value)

    @property
    @pulumi.getter
    def variation(self) -> Optional[int]:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: Optional[int]):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class GetFeatureFlagEnvironmentPrerequisiteArgs:
    def __init__(__self__, *,
                 flag_key: str,
                 variation: int):
        """
        :param str flag_key: The prerequisite feature flag's `key`.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        pulumi.set(__self__, "flag_key", flag_key)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="flagKey")
    def flag_key(self) -> str:
        """
        The prerequisite feature flag's `key`.
        """
        return pulumi.get(self, "flag_key")

    @flag_key.setter
    def flag_key(self, value: str):
        pulumi.set(self, "flag_key", value)

    @property
    @pulumi.getter
    def variation(self) -> int:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: int):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class GetFeatureFlagEnvironmentRuleArgs:
    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 clauses: Optional[Sequence['GetFeatureFlagEnvironmentRuleClauseArgs']] = None,
                 rollout_weights: Optional[Sequence[int]] = None,
                 variation: Optional[int] = None):
        """
        :param str bucket_by: Group percentage rollout by a custom attribute.
        :param Sequence['GetFeatureFlagEnvironmentRuleClauseArgs'] clauses: List of nested blocks specifying the logical clauses evaluated. To learn more, read Nested Clauses Blocks.
        :param Sequence[int] rollout_weights: List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        Group percentage rollout by a custom attribute.
        """
        return pulumi.get(self, "bucket_by")

    @bucket_by.setter
    def bucket_by(self, value: Optional[str]):
        pulumi.set(self, "bucket_by", value)

    @property
    @pulumi.getter
    def clauses(self) -> Optional[Sequence['GetFeatureFlagEnvironmentRuleClauseArgs']]:
        """
        List of nested blocks specifying the logical clauses evaluated. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @clauses.setter
    def clauses(self, value: Optional[Sequence['GetFeatureFlagEnvironmentRuleClauseArgs']]):
        pulumi.set(self, "clauses", value)

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[Sequence[int]]:
        """
        List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        """
        return pulumi.get(self, "rollout_weights")

    @rollout_weights.setter
    def rollout_weights(self, value: Optional[Sequence[int]]):
        pulumi.set(self, "rollout_weights", value)

    @property
    @pulumi.getter
    def variation(self) -> Optional[int]:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: Optional[int]):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class GetFeatureFlagEnvironmentRuleClauseArgs:
    def __init__(__self__, *,
                 attribute: str,
                 op: str,
                 values: Sequence[str],
                 negate: Optional[bool] = None,
                 value_type: Optional[str] = None):
        """
        :param str attribute: The user attribute operated on.
        :param str op: The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param bool negate: Whether the rule clause is negated.
        :param str value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The user attribute operated on.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: str):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether the rule clause is negated.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[bool]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[str]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class GetFeatureFlagEnvironmentTargetArgs:
    def __init__(__self__, *,
                 values: Sequence[str],
                 variation: int):
        """
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def variation(self) -> int:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: int):
        pulumi.set(self, "variation", value)


@pulumi.input_type
class GetFeatureFlagVariationArgs:
    def __init__(__self__, *,
                 value: str,
                 description: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str value: The list of custom property value strings.
        :param str description: The variation's description.
        :param str name: The name of the custom property.
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The list of custom property value strings.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The variation's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GetFlagTriggerInstructionsArgs:
    def __init__(__self__, *,
                 kind: str):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: str):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class GetMetricUrlArgs:
    def __init__(__self__, *,
                 kind: str,
                 pattern: Optional[str] = None,
                 substring: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str kind: The metric type. Available choices are `click`, `custom`, and `pageview`.
        """
        pulumi.set(__self__, "kind", kind)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if substring is not None:
            pulumi.set(__self__, "substring", substring)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The metric type. Available choices are `click`, `custom`, and `pageview`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: str):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[str]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def substring(self) -> Optional[str]:
        return pulumi.get(self, "substring")

    @substring.setter
    def substring(self, value: Optional[str]):
        pulumi.set(self, "substring", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class GetRelayProxyConfigurationPolicyArgs:
    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: Either `allow` or `deny`. This argument defines whether the rule policy allows or denies access to the named resources and actions.
        :param Sequence[str] not_resources: The list of resource specifiers defining the resources to which the rule policy does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param Sequence[str] resources: The list of resource specifiers defining the resources to which the rule policy applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Either `allow` or `deny`. This argument defines whether the rule policy allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: str):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the rule policy does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the rule policy applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class GetSegmentRuleArgs:
    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 clauses: Optional[Sequence['GetSegmentRuleClauseArgs']] = None,
                 weight: Optional[int] = None):
        """
        :param str bucket_by: The attribute by which to group users together.
        :param Sequence['GetSegmentRuleClauseArgs'] clauses: List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        :param int weight: The integer weight of the rule (between 0 and 100000).
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        The attribute by which to group users together.
        """
        return pulumi.get(self, "bucket_by")

    @bucket_by.setter
    def bucket_by(self, value: Optional[str]):
        pulumi.set(self, "bucket_by", value)

    @property
    @pulumi.getter
    def clauses(self) -> Optional[Sequence['GetSegmentRuleClauseArgs']]:
        """
        List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @clauses.setter
    def clauses(self, value: Optional[Sequence['GetSegmentRuleClauseArgs']]):
        pulumi.set(self, "clauses", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The integer weight of the rule (between 0 and 100000).
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class GetSegmentRuleClauseArgs:
    def __init__(__self__, *,
                 attribute: str,
                 op: str,
                 values: Sequence[str],
                 negate: Optional[bool] = None,
                 value_type: Optional[str] = None):
        """
        :param str attribute: The user attribute operated on.
        :param str op: The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param bool negate: Whether the rule clause is negated.
        :param str value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The user attribute operated on.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: str):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: str):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether the rule clause is negated.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[bool]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[str]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class GetWebhookStatementArgs:
    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] not_resources: The list of resource specifiers defining the resources to which the statement does not apply. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param Sequence[str] resources: The list of resource specifiers defining the resources to which the statement applies. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: str):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "not_actions")

    @not_actions.setter
    def not_actions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "not_actions", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement does not apply. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement applies. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "resources", value)


