# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessTokenArgs', 'AccessToken']

@pulumi.input_type
class AccessTokenArgs:
    def __init__(__self__, *,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_api_version: Optional[pulumi.Input[int]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 inline_roles: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AccessToken resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: A list of custom role IDs to use as access limits for the access token
        :param pulumi.Input[int] default_api_version: The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        :param pulumi.Input[int] expire: An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        :param pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]] inline_roles: An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
               of a built-in or custom role.
        :param pulumi.Input[str] name: A human-friendly name for the access token.
        :param pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]] policy_statements: Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        :param pulumi.Input[str] role: A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        :param pulumi.Input[bool] service_token: Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        """
        if custom_roles is not None:
            pulumi.set(__self__, "custom_roles", custom_roles)
        if default_api_version is not None:
            pulumi.set(__self__, "default_api_version", default_api_version)
        if expire is not None:
            warnings.warn("""'expire' is deprecated and will be removed in the next major release of the LaunchDarkly provider""", DeprecationWarning)
            pulumi.log.warn("""expire is deprecated: 'expire' is deprecated and will be removed in the next major release of the LaunchDarkly provider""")
        if expire is not None:
            pulumi.set(__self__, "expire", expire)
        if inline_roles is not None:
            pulumi.set(__self__, "inline_roles", inline_roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_statements is not None:
            warnings.warn("""'policy_statements' is deprecated in favor of 'inline_roles'. This field will be removed in the next major release of the LaunchDarkly provider""", DeprecationWarning)
            pulumi.log.warn("""policy_statements is deprecated: 'policy_statements' is deprecated in favor of 'inline_roles'. This field will be removed in the next major release of the LaunchDarkly provider""")
        if policy_statements is not None:
            pulumi.set(__self__, "policy_statements", policy_statements)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_token is not None:
            pulumi.set(__self__, "service_token", service_token)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of custom role IDs to use as access limits for the access token
        """
        return pulumi.get(self, "custom_roles")

    @custom_roles.setter
    def custom_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_roles", value)

    @property
    @pulumi.getter(name="defaultApiVersion")
    def default_api_version(self) -> Optional[pulumi.Input[int]]:
        """
        The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        """
        return pulumi.get(self, "default_api_version")

    @default_api_version.setter
    def default_api_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_api_version", value)

    @property
    @pulumi.getter
    def expire(self) -> Optional[pulumi.Input[int]]:
        """
        An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        """
        return pulumi.get(self, "expire")

    @expire.setter
    def expire(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire", value)

    @property
    @pulumi.getter(name="inlineRoles")
    def inline_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]]]:
        """
        An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
        of a built-in or custom role.
        """
        return pulumi.get(self, "inline_roles")

    @inline_roles.setter
    def inline_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]]]):
        pulumi.set(self, "inline_roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-friendly name for the access token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]]]:
        """
        Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        """
        return pulumi.get(self, "policy_statements")

    @policy_statements.setter
    def policy_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]]]):
        pulumi.set(self, "policy_statements", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        """
        return pulumi.get(self, "service_token")

    @service_token.setter
    def service_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "service_token", value)


@pulumi.input_type
class _AccessTokenState:
    def __init__(__self__, *,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_api_version: Optional[pulumi.Input[int]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 inline_roles: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessToken resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: A list of custom role IDs to use as access limits for the access token
        :param pulumi.Input[int] default_api_version: The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        :param pulumi.Input[int] expire: An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        :param pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]] inline_roles: An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
               of a built-in or custom role.
        :param pulumi.Input[str] name: A human-friendly name for the access token.
        :param pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]] policy_statements: Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        :param pulumi.Input[str] role: A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        :param pulumi.Input[bool] service_token: Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        :param pulumi.Input[str] token: The access token used to authorize usage of the LaunchDarkly API.
        """
        if custom_roles is not None:
            pulumi.set(__self__, "custom_roles", custom_roles)
        if default_api_version is not None:
            pulumi.set(__self__, "default_api_version", default_api_version)
        if expire is not None:
            warnings.warn("""'expire' is deprecated and will be removed in the next major release of the LaunchDarkly provider""", DeprecationWarning)
            pulumi.log.warn("""expire is deprecated: 'expire' is deprecated and will be removed in the next major release of the LaunchDarkly provider""")
        if expire is not None:
            pulumi.set(__self__, "expire", expire)
        if inline_roles is not None:
            pulumi.set(__self__, "inline_roles", inline_roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_statements is not None:
            warnings.warn("""'policy_statements' is deprecated in favor of 'inline_roles'. This field will be removed in the next major release of the LaunchDarkly provider""", DeprecationWarning)
            pulumi.log.warn("""policy_statements is deprecated: 'policy_statements' is deprecated in favor of 'inline_roles'. This field will be removed in the next major release of the LaunchDarkly provider""")
        if policy_statements is not None:
            pulumi.set(__self__, "policy_statements", policy_statements)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_token is not None:
            pulumi.set(__self__, "service_token", service_token)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of custom role IDs to use as access limits for the access token
        """
        return pulumi.get(self, "custom_roles")

    @custom_roles.setter
    def custom_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_roles", value)

    @property
    @pulumi.getter(name="defaultApiVersion")
    def default_api_version(self) -> Optional[pulumi.Input[int]]:
        """
        The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        """
        return pulumi.get(self, "default_api_version")

    @default_api_version.setter
    def default_api_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_api_version", value)

    @property
    @pulumi.getter
    def expire(self) -> Optional[pulumi.Input[int]]:
        """
        An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        """
        return pulumi.get(self, "expire")

    @expire.setter
    def expire(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire", value)

    @property
    @pulumi.getter(name="inlineRoles")
    def inline_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]]]:
        """
        An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
        of a built-in or custom role.
        """
        return pulumi.get(self, "inline_roles")

    @inline_roles.setter
    def inline_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenInlineRoleArgs']]]]):
        pulumi.set(self, "inline_roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-friendly name for the access token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]]]:
        """
        Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        """
        return pulumi.get(self, "policy_statements")

    @policy_statements.setter
    def policy_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessTokenPolicyStatementArgs']]]]):
        pulumi.set(self, "policy_statements", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        """
        return pulumi.get(self, "service_token")

    @service_token.setter
    def service_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "service_token", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The access token used to authorize usage of the LaunchDarkly API.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class AccessToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_api_version: Optional[pulumi.Input[int]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 inline_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenInlineRoleArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenPolicyStatementArgs']]]]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        The resource must contain either a `role`, `custom_role` or an `inline_roles` (previously `policy_statements`) block. As of v1.7.0, `policy_statements` has been deprecated in favor of `inline_roles`.

        With a built-in role

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        reader_token = launchdarkly.AccessToken("readerToken", role="reader")
        ```

        With a custom role

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        custom_role_token = launchdarkly.AccessToken("customRoleToken", custom_roles=["ops"])
        ```

        With an inline custom role (policy statements)

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        token_with_policy_statements = launchdarkly.AccessToken("tokenWithPolicyStatements",
            inline_roles=[launchdarkly.AccessTokenInlineRoleArgs(
                actions=["*"],
                effect="deny",
                resources=["proj/*:env/production"],
            )],
            service_token=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: A list of custom role IDs to use as access limits for the access token
        :param pulumi.Input[int] default_api_version: The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        :param pulumi.Input[int] expire: An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenInlineRoleArgs']]]] inline_roles: An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
               of a built-in or custom role.
        :param pulumi.Input[str] name: A human-friendly name for the access token.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenPolicyStatementArgs']]]] policy_statements: Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        :param pulumi.Input[str] role: A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        :param pulumi.Input[bool] service_token: Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccessTokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        The resource must contain either a `role`, `custom_role` or an `inline_roles` (previously `policy_statements`) block. As of v1.7.0, `policy_statements` has been deprecated in favor of `inline_roles`.

        With a built-in role

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        reader_token = launchdarkly.AccessToken("readerToken", role="reader")
        ```

        With a custom role

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        custom_role_token = launchdarkly.AccessToken("customRoleToken", custom_roles=["ops"])
        ```

        With an inline custom role (policy statements)

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        token_with_policy_statements = launchdarkly.AccessToken("tokenWithPolicyStatements",
            inline_roles=[launchdarkly.AccessTokenInlineRoleArgs(
                actions=["*"],
                effect="deny",
                resources=["proj/*:env/production"],
            )],
            service_token=True)
        ```

        :param str resource_name: The name of the resource.
        :param AccessTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_api_version: Optional[pulumi.Input[int]] = None,
                 expire: Optional[pulumi.Input[int]] = None,
                 inline_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenInlineRoleArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenPolicyStatementArgs']]]]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service_token: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessTokenArgs.__new__(AccessTokenArgs)

            __props__.__dict__["custom_roles"] = custom_roles
            __props__.__dict__["default_api_version"] = default_api_version
            if expire is not None and not opts.urn:
                warnings.warn("""'expire' is deprecated and will be removed in the next major release of the LaunchDarkly provider""", DeprecationWarning)
                pulumi.log.warn("""expire is deprecated: 'expire' is deprecated and will be removed in the next major release of the LaunchDarkly provider""")
            __props__.__dict__["expire"] = expire
            __props__.__dict__["inline_roles"] = inline_roles
            __props__.__dict__["name"] = name
            if policy_statements is not None and not opts.urn:
                warnings.warn("""'policy_statements' is deprecated in favor of 'inline_roles'. This field will be removed in the next major release of the LaunchDarkly provider""", DeprecationWarning)
                pulumi.log.warn("""policy_statements is deprecated: 'policy_statements' is deprecated in favor of 'inline_roles'. This field will be removed in the next major release of the LaunchDarkly provider""")
            __props__.__dict__["policy_statements"] = policy_statements
            __props__.__dict__["role"] = role
            __props__.__dict__["service_token"] = service_token
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AccessToken, __self__).__init__(
            'launchdarkly:index/accessToken:AccessToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            default_api_version: Optional[pulumi.Input[int]] = None,
            expire: Optional[pulumi.Input[int]] = None,
            inline_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenInlineRoleArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenPolicyStatementArgs']]]]] = None,
            role: Optional[pulumi.Input[str]] = None,
            service_token: Optional[pulumi.Input[bool]] = None,
            token: Optional[pulumi.Input[str]] = None) -> 'AccessToken':
        """
        Get an existing AccessToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_roles: A list of custom role IDs to use as access limits for the access token
        :param pulumi.Input[int] default_api_version: The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        :param pulumi.Input[int] expire: An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenInlineRoleArgs']]]] inline_roles: An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
               of a built-in or custom role.
        :param pulumi.Input[str] name: A human-friendly name for the access token.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccessTokenPolicyStatementArgs']]]] policy_statements: Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        :param pulumi.Input[str] role: A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        :param pulumi.Input[bool] service_token: Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        :param pulumi.Input[str] token: The access token used to authorize usage of the LaunchDarkly API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessTokenState.__new__(_AccessTokenState)

        __props__.__dict__["custom_roles"] = custom_roles
        __props__.__dict__["default_api_version"] = default_api_version
        __props__.__dict__["expire"] = expire
        __props__.__dict__["inline_roles"] = inline_roles
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_statements"] = policy_statements
        __props__.__dict__["role"] = role
        __props__.__dict__["service_token"] = service_token
        __props__.__dict__["token"] = token
        return AccessToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of custom role IDs to use as access limits for the access token
        """
        return pulumi.get(self, "custom_roles")

    @property
    @pulumi.getter(name="defaultApiVersion")
    def default_api_version(self) -> pulumi.Output[int]:
        """
        The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
        """
        return pulumi.get(self, "default_api_version")

    @property
    @pulumi.getter
    def expire(self) -> pulumi.Output[Optional[int]]:
        """
        An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions.
        """
        return pulumi.get(self, "expire")

    @property
    @pulumi.getter(name="inlineRoles")
    def inline_roles(self) -> pulumi.Output[Optional[Sequence['outputs.AccessTokenInlineRole']]]:
        """
        An array of statements represented as config blocks with 3 attributes: effect, resources, actions. May be used in place
        of a built-in or custom role.
        """
        return pulumi.get(self, "inline_roles")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A human-friendly name for the access token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> pulumi.Output[Optional[Sequence['outputs.AccessTokenPolicyStatement']]]:
        """
        Define inline custom roles. An array of statements represented as config blocks with three attributes: effect, resources, actions. May be used in place of a built-in or custom role. May be specified more than once. This field argument is **deprecated**. Update your config to use `inline_role` to maintain compatibility with future versions.
        """
        return pulumi.get(self, "policy_statements")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="serviceToken")
    def service_token(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
        """
        return pulumi.get(self, "service_token")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        The access token used to authorize usage of the LaunchDarkly API.
        """
        return pulumi.get(self, "token")

