# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeatureFlagArgs', 'FeatureFlag']

@pulumi.input_type
class FeatureFlagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 project_key: pulumi.Input[str],
                 variation_type: pulumi.Input[str],
                 archived: Optional[pulumi.Input[bool]] = None,
                 client_side_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]]] = None,
                 custom_properties: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]]] = None,
                 defaults: Optional[pulumi.Input['FeatureFlagDefaultsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 temporary: Optional[pulumi.Input[bool]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]]] = None):
        """
        The set of arguments for constructing a FeatureFlag resource.
        :param pulumi.Input[str] key: The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] project_key: The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] variation_type: The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        :param pulumi.Input[bool] archived: Whether to archive the flag
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]] client_side_availabilities: A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]] custom_properties: List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        :param pulumi.Input['FeatureFlagDefaultsArgs'] defaults: A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        :param pulumi.Input[str] description: The feature flag's description.
        :param pulumi.Input[bool] include_in_snippet: **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently set maintainer
        :param pulumi.Input[str] name: The human-readable name of the feature flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of feature flag tags.
        :param pulumi.Input[bool] temporary: Specifies whether the flag is a temporary flag.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]] variations: List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "variation_type", variation_type)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if client_side_availabilities is not None:
            pulumi.set(__self__, "client_side_availabilities", client_side_availabilities)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if include_in_snippet is not None:
            warnings.warn("""'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""", DeprecationWarning)
            pulumi.log.warn("""include_in_snippet is deprecated: 'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""")
        if include_in_snippet is not None:
            pulumi.set(__self__, "include_in_snippet", include_in_snippet)
        if maintainer_id is not None:
            pulumi.set(__self__, "maintainer_id", maintainer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temporary is not None:
            pulumi.set(__self__, "temporary", temporary)
        if variations is not None:
            pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[str]:
        """
        The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="variationType")
    def variation_type(self) -> pulumi.Input[str]:
        """
        The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        """
        return pulumi.get(self, "variation_type")

    @variation_type.setter
    def variation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "variation_type", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to archive the flag
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="clientSideAvailabilities")
    def client_side_availabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]]]:
        """
        A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        """
        return pulumi.get(self, "client_side_availabilities")

    @client_side_availabilities.setter
    def client_side_availabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]]]):
        pulumi.set(self, "client_side_availabilities", value)

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]]]:
        """
        List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        """
        return pulumi.get(self, "custom_properties")

    @custom_properties.setter
    def custom_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]]]):
        pulumi.set(self, "custom_properties", value)

    @property
    @pulumi.getter
    def defaults(self) -> Optional[pulumi.Input['FeatureFlagDefaultsArgs']]:
        """
        A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        """
        return pulumi.get(self, "defaults")

    @defaults.setter
    def defaults(self, value: Optional[pulumi.Input['FeatureFlagDefaultsArgs']]):
        pulumi.set(self, "defaults", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The feature flag's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> Optional[pulumi.Input[bool]]:
        """
        **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        """
        return pulumi.get(self, "include_in_snippet")

    @include_in_snippet.setter
    def include_in_snippet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_in_snippet", value)

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
        associated with your Terraform API key or the most recently set maintainer
        """
        return pulumi.get(self, "maintainer_id")

    @maintainer_id.setter
    def maintainer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the feature flag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of feature flag tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def temporary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the flag is a temporary flag.
        """
        return pulumi.get(self, "temporary")

    @temporary.setter
    def temporary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporary", value)

    @property
    @pulumi.getter
    def variations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]]]:
        """
        List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        return pulumi.get(self, "variations")

    @variations.setter
    def variations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]]]):
        pulumi.set(self, "variations", value)


@pulumi.input_type
class _FeatureFlagState:
    def __init__(__self__, *,
                 archived: Optional[pulumi.Input[bool]] = None,
                 client_side_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]]] = None,
                 custom_properties: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]]] = None,
                 defaults: Optional[pulumi.Input['FeatureFlagDefaultsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 temporary: Optional[pulumi.Input[bool]] = None,
                 variation_type: Optional[pulumi.Input[str]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]]] = None):
        """
        Input properties used for looking up and filtering FeatureFlag resources.
        :param pulumi.Input[bool] archived: Whether to archive the flag
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]] client_side_availabilities: A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]] custom_properties: List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        :param pulumi.Input['FeatureFlagDefaultsArgs'] defaults: A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        :param pulumi.Input[str] description: The feature flag's description.
        :param pulumi.Input[bool] include_in_snippet: **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        :param pulumi.Input[str] key: The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently set maintainer
        :param pulumi.Input[str] name: The human-readable name of the feature flag.
        :param pulumi.Input[str] project_key: The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of feature flag tags.
        :param pulumi.Input[bool] temporary: Specifies whether the flag is a temporary flag.
        :param pulumi.Input[str] variation_type: The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]] variations: List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if client_side_availabilities is not None:
            pulumi.set(__self__, "client_side_availabilities", client_side_availabilities)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if include_in_snippet is not None:
            warnings.warn("""'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""", DeprecationWarning)
            pulumi.log.warn("""include_in_snippet is deprecated: 'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""")
        if include_in_snippet is not None:
            pulumi.set(__self__, "include_in_snippet", include_in_snippet)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if maintainer_id is not None:
            pulumi.set(__self__, "maintainer_id", maintainer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temporary is not None:
            pulumi.set(__self__, "temporary", temporary)
        if variation_type is not None:
            pulumi.set(__self__, "variation_type", variation_type)
        if variations is not None:
            pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to archive the flag
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="clientSideAvailabilities")
    def client_side_availabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]]]:
        """
        A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        """
        return pulumi.get(self, "client_side_availabilities")

    @client_side_availabilities.setter
    def client_side_availabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagClientSideAvailabilityArgs']]]]):
        pulumi.set(self, "client_side_availabilities", value)

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]]]:
        """
        List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        """
        return pulumi.get(self, "custom_properties")

    @custom_properties.setter
    def custom_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagCustomPropertyArgs']]]]):
        pulumi.set(self, "custom_properties", value)

    @property
    @pulumi.getter
    def defaults(self) -> Optional[pulumi.Input['FeatureFlagDefaultsArgs']]:
        """
        A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        """
        return pulumi.get(self, "defaults")

    @defaults.setter
    def defaults(self, value: Optional[pulumi.Input['FeatureFlagDefaultsArgs']]):
        pulumi.set(self, "defaults", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The feature flag's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> Optional[pulumi.Input[bool]]:
        """
        **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        """
        return pulumi.get(self, "include_in_snippet")

    @include_in_snippet.setter
    def include_in_snippet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_in_snippet", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
        associated with your Terraform API key or the most recently set maintainer
        """
        return pulumi.get(self, "maintainer_id")

    @maintainer_id.setter
    def maintainer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the feature flag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[str]]:
        """
        The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of feature flag tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def temporary(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the flag is a temporary flag.
        """
        return pulumi.get(self, "temporary")

    @temporary.setter
    def temporary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporary", value)

    @property
    @pulumi.getter(name="variationType")
    def variation_type(self) -> Optional[pulumi.Input[str]]:
        """
        The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        """
        return pulumi.get(self, "variation_type")

    @variation_type.setter
    def variation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "variation_type", value)

    @property
    @pulumi.getter
    def variations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]]]:
        """
        List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        return pulumi.get(self, "variations")

    @variations.setter
    def variations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagVariationArgs']]]]):
        pulumi.set(self, "variations", value)


class FeatureFlag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 client_side_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagClientSideAvailabilityArgs']]]]] = None,
                 custom_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagCustomPropertyArgs']]]]] = None,
                 defaults: Optional[pulumi.Input[pulumi.InputType['FeatureFlagDefaultsArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 temporary: Optional[pulumi.Input[bool]] = None,
                 variation_type: Optional[pulumi.Input[str]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagVariationArgs']]]]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly feature flag resource.

        This resource allows you to create and manage feature flags within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        building_materials = launchdarkly.FeatureFlag("buildingMaterials",
            project_key=launchdarkly_project["example"]["key"],
            key="building-materials",
            description="this is a multivariate flag with string variations.",
            variation_type="string",
            variations=[
                launchdarkly.FeatureFlagVariationArgs(
                    value="straw",
                    name="Straw",
                    description="Watch out for wind.",
                ),
                launchdarkly.FeatureFlagVariationArgs(
                    value="sticks",
                    name="Sticks",
                    description="Sturdier than straw",
                ),
                launchdarkly.FeatureFlagVariationArgs(
                    value="bricks",
                    name="Bricks",
                    description="The strongest variation",
                ),
            ],
            defaults=launchdarkly.FeatureFlagDefaultsArgs(
                on_variation=2,
                off_variation=0,
            ),
            tags=[
                "example",
                "terraform",
                "multivariate",
                "building-materials",
            ])
        ```

        ```python
        import pulumi
        import json
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        json_example = launchdarkly.FeatureFlag("jsonExample",
            project_key="example-project",
            key="json-example",
            variation_type="json",
            variations=[
                launchdarkly.FeatureFlagVariationArgs(
                    name="Single foo",
                    value=json.dumps({
                        "foo": "bar",
                    }),
                ),
                launchdarkly.FeatureFlagVariationArgs(
                    name="Multiple foos",
                    value=json.dumps({
                        "foos": [
                            "bar1",
                            "bar2",
                        ],
                    }),
                ),
            ],
            defaults=launchdarkly.FeatureFlagDefaultsArgs(
                on_variation=1,
                off_variation=0,
            ))
        ```

        ## Import

        You can import a feature flag using the feature flag's ID in the format `project_key/flag_key`. For example

        ```sh
         $ pulumi import launchdarkly:index/featureFlag:FeatureFlag building_materials example-project/building-materials
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] archived: Whether to archive the flag
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagClientSideAvailabilityArgs']]]] client_side_availabilities: A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagCustomPropertyArgs']]]] custom_properties: List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        :param pulumi.Input[pulumi.InputType['FeatureFlagDefaultsArgs']] defaults: A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        :param pulumi.Input[str] description: The feature flag's description.
        :param pulumi.Input[bool] include_in_snippet: **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        :param pulumi.Input[str] key: The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently set maintainer
        :param pulumi.Input[str] name: The human-readable name of the feature flag.
        :param pulumi.Input[str] project_key: The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of feature flag tags.
        :param pulumi.Input[bool] temporary: Specifies whether the flag is a temporary flag.
        :param pulumi.Input[str] variation_type: The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagVariationArgs']]]] variations: List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureFlagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly feature flag resource.

        This resource allows you to create and manage feature flags within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        building_materials = launchdarkly.FeatureFlag("buildingMaterials",
            project_key=launchdarkly_project["example"]["key"],
            key="building-materials",
            description="this is a multivariate flag with string variations.",
            variation_type="string",
            variations=[
                launchdarkly.FeatureFlagVariationArgs(
                    value="straw",
                    name="Straw",
                    description="Watch out for wind.",
                ),
                launchdarkly.FeatureFlagVariationArgs(
                    value="sticks",
                    name="Sticks",
                    description="Sturdier than straw",
                ),
                launchdarkly.FeatureFlagVariationArgs(
                    value="bricks",
                    name="Bricks",
                    description="The strongest variation",
                ),
            ],
            defaults=launchdarkly.FeatureFlagDefaultsArgs(
                on_variation=2,
                off_variation=0,
            ),
            tags=[
                "example",
                "terraform",
                "multivariate",
                "building-materials",
            ])
        ```

        ```python
        import pulumi
        import json
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        json_example = launchdarkly.FeatureFlag("jsonExample",
            project_key="example-project",
            key="json-example",
            variation_type="json",
            variations=[
                launchdarkly.FeatureFlagVariationArgs(
                    name="Single foo",
                    value=json.dumps({
                        "foo": "bar",
                    }),
                ),
                launchdarkly.FeatureFlagVariationArgs(
                    name="Multiple foos",
                    value=json.dumps({
                        "foos": [
                            "bar1",
                            "bar2",
                        ],
                    }),
                ),
            ],
            defaults=launchdarkly.FeatureFlagDefaultsArgs(
                on_variation=1,
                off_variation=0,
            ))
        ```

        ## Import

        You can import a feature flag using the feature flag's ID in the format `project_key/flag_key`. For example

        ```sh
         $ pulumi import launchdarkly:index/featureFlag:FeatureFlag building_materials example-project/building-materials
        ```

        :param str resource_name: The name of the resource.
        :param FeatureFlagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureFlagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 client_side_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagClientSideAvailabilityArgs']]]]] = None,
                 custom_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagCustomPropertyArgs']]]]] = None,
                 defaults: Optional[pulumi.Input[pulumi.InputType['FeatureFlagDefaultsArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 temporary: Optional[pulumi.Input[bool]] = None,
                 variation_type: Optional[pulumi.Input[str]] = None,
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagVariationArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureFlagArgs.__new__(FeatureFlagArgs)

            __props__.__dict__["archived"] = archived
            __props__.__dict__["client_side_availabilities"] = client_side_availabilities
            __props__.__dict__["custom_properties"] = custom_properties
            __props__.__dict__["defaults"] = defaults
            __props__.__dict__["description"] = description
            if include_in_snippet is not None and not opts.urn:
                warnings.warn("""'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""", DeprecationWarning)
                pulumi.log.warn("""include_in_snippet is deprecated: 'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""")
            __props__.__dict__["include_in_snippet"] = include_in_snippet
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["maintainer_id"] = maintainer_id
            __props__.__dict__["name"] = name
            if project_key is None and not opts.urn:
                raise TypeError("Missing required property 'project_key'")
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["tags"] = tags
            __props__.__dict__["temporary"] = temporary
            if variation_type is None and not opts.urn:
                raise TypeError("Missing required property 'variation_type'")
            __props__.__dict__["variation_type"] = variation_type
            __props__.__dict__["variations"] = variations
        super(FeatureFlag, __self__).__init__(
            'launchdarkly:index/featureFlag:FeatureFlag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archived: Optional[pulumi.Input[bool]] = None,
            client_side_availabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagClientSideAvailabilityArgs']]]]] = None,
            custom_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagCustomPropertyArgs']]]]] = None,
            defaults: Optional[pulumi.Input[pulumi.InputType['FeatureFlagDefaultsArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            include_in_snippet: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            maintainer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_key: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            temporary: Optional[pulumi.Input[bool]] = None,
            variation_type: Optional[pulumi.Input[str]] = None,
            variations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagVariationArgs']]]]] = None) -> 'FeatureFlag':
        """
        Get an existing FeatureFlag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] archived: Whether to archive the flag
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagClientSideAvailabilityArgs']]]] client_side_availabilities: A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagCustomPropertyArgs']]]] custom_properties: List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        :param pulumi.Input[pulumi.InputType['FeatureFlagDefaultsArgs']] defaults: A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        :param pulumi.Input[str] description: The feature flag's description.
        :param pulumi.Input[bool] include_in_snippet: **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        :param pulumi.Input[str] key: The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently set maintainer
        :param pulumi.Input[str] name: The human-readable name of the feature flag.
        :param pulumi.Input[str] project_key: The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of feature flag tags.
        :param pulumi.Input[bool] temporary: Specifies whether the flag is a temporary flag.
        :param pulumi.Input[str] variation_type: The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagVariationArgs']]]] variations: List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeatureFlagState.__new__(_FeatureFlagState)

        __props__.__dict__["archived"] = archived
        __props__.__dict__["client_side_availabilities"] = client_side_availabilities
        __props__.__dict__["custom_properties"] = custom_properties
        __props__.__dict__["defaults"] = defaults
        __props__.__dict__["description"] = description
        __props__.__dict__["include_in_snippet"] = include_in_snippet
        __props__.__dict__["key"] = key
        __props__.__dict__["maintainer_id"] = maintainer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["temporary"] = temporary
        __props__.__dict__["variation_type"] = variation_type
        __props__.__dict__["variations"] = variations
        return FeatureFlag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def archived(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to archive the flag
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="clientSideAvailabilities")
    def client_side_availabilities(self) -> pulumi.Output[Sequence['outputs.FeatureFlagClientSideAvailability']]:
        """
        A block describing whether this flag should be made available to the client-side JavaScript SDK using the client-side Id, mobile key, or both. This value gets its default from your project configuration if not set. To learn more, read Nested Client-Side Availability Block.
        """
        return pulumi.get(self, "client_side_availabilities")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> pulumi.Output[Optional[Sequence['outputs.FeatureFlagCustomProperty']]]:
        """
        List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter
    def defaults(self) -> pulumi.Output['outputs.FeatureFlagDefaults']:
        """
        A block containing the indices of the variations to be used as the default on and off variations in all new environments. Flag configurations in existing environments will not be changed nor updated if the configuration block is removed. To learn more, read Nested Defaults Blocks.
        """
        return pulumi.get(self, "defaults")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The feature flag's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> pulumi.Output[bool]:
        """
        **Deprecated** (Optional) Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatability.
        """
        return pulumi.get(self, "include_in_snippet")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> pulumi.Output[str]:
        """
        The LaunchDarkly id of the user who will maintain the flag. If not set, the API will automatically apply the member
        associated with your Terraform API key or the most recently set maintainer
        """
        return pulumi.get(self, "maintainer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-readable name of the feature flag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[str]:
        """
        The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of feature flag tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def temporary(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the flag is a temporary flag.
        """
        return pulumi.get(self, "temporary")

    @property
    @pulumi.getter(name="variationType")
    def variation_type(self) -> pulumi.Output[str]:
        """
        The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        """
        return pulumi.get(self, "variation_type")

    @property
    @pulumi.getter
    def variations(self) -> pulumi.Output[Sequence['outputs.FeatureFlagVariation']]:
        """
        List of nested blocks describing the variations associated with the feature flag. You must specify at least two variations. To learn more, read Nested Variations Blocks.
        """
        return pulumi.get(self, "variations")

