# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFeatureFlagResult',
    'AwaitableGetFeatureFlagResult',
    'get_feature_flag',
    'get_feature_flag_output',
]

@pulumi.output_type
class GetFeatureFlagResult:
    """
    A collection of values returned by getFeatureFlag.
    """
    def __init__(__self__, archived=None, client_side_availabilities=None, custom_properties=None, defaults=None, description=None, id=None, include_in_snippet=None, key=None, maintainer_id=None, name=None, project_key=None, tags=None, temporary=None, variation_type=None, variations=None):
        if archived and not isinstance(archived, bool):
            raise TypeError("Expected argument 'archived' to be a bool")
        pulumi.set(__self__, "archived", archived)
        if client_side_availabilities and not isinstance(client_side_availabilities, list):
            raise TypeError("Expected argument 'client_side_availabilities' to be a list")
        pulumi.set(__self__, "client_side_availabilities", client_side_availabilities)
        if custom_properties and not isinstance(custom_properties, list):
            raise TypeError("Expected argument 'custom_properties' to be a list")
        pulumi.set(__self__, "custom_properties", custom_properties)
        if defaults and not isinstance(defaults, dict):
            raise TypeError("Expected argument 'defaults' to be a dict")
        pulumi.set(__self__, "defaults", defaults)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_in_snippet and not isinstance(include_in_snippet, bool):
            raise TypeError("Expected argument 'include_in_snippet' to be a bool")
        if include_in_snippet is not None:
            warnings.warn("""'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""", DeprecationWarning)
            pulumi.log.warn("""include_in_snippet is deprecated: 'include_in_snippet' is now deprecated. Please migrate to 'client_side_availability' to maintain future compatability.""")

        pulumi.set(__self__, "include_in_snippet", include_in_snippet)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if maintainer_id and not isinstance(maintainer_id, str):
            raise TypeError("Expected argument 'maintainer_id' to be a str")
        pulumi.set(__self__, "maintainer_id", maintainer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_key and not isinstance(project_key, str):
            raise TypeError("Expected argument 'project_key' to be a str")
        pulumi.set(__self__, "project_key", project_key)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if temporary and not isinstance(temporary, bool):
            raise TypeError("Expected argument 'temporary' to be a bool")
        pulumi.set(__self__, "temporary", temporary)
        if variation_type and not isinstance(variation_type, str):
            raise TypeError("Expected argument 'variation_type' to be a str")
        pulumi.set(__self__, "variation_type", variation_type)
        if variations and not isinstance(variations, list):
            raise TypeError("Expected argument 'variations' to be a list")
        pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def archived(self) -> Optional[bool]:
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="clientSideAvailabilities")
    def client_side_availabilities(self) -> Sequence['outputs.GetFeatureFlagClientSideAvailabilityResult']:
        """
        A map describing whether this flag has been made available to the client-side JavaScript SDK. To learn more, read Nested Client-Side Availability Block.
        """
        return pulumi.get(self, "client_side_availabilities")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[Sequence['outputs.GetFeatureFlagCustomPropertyResult']]:
        """
        List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter
    def defaults(self) -> 'outputs.GetFeatureFlagDefaultsResult':
        """
        A map describing the index of the variation served when the flag is on for new environments. To learn more, read Nested Defaults Blocks.
        """
        return pulumi.get(self, "defaults")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The variation's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> bool:
        """
        **Deprecated** A boolean describing whether this flag has been made available to the client-side Javescript SDK using the client-side ID only. `include_in_snippet` is now deprecated. Please retrieve information from `client_side_availability.using_environment_id` to maintain future compatability.
        """
        return pulumi.get(self, "include_in_snippet")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The unique custom property key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> str:
        """
        The feature flag maintainer's 24 character alphanumeric team member ID.
        """
        return pulumi.get(self, "maintainer_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> str:
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Set of feature flag tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def temporary(self) -> Optional[bool]:
        """
        Whether the flag is a temporary flag.
        """
        return pulumi.get(self, "temporary")

    @property
    @pulumi.getter(name="variationType")
    def variation_type(self) -> str:
        """
        The feature flag's variation type: `boolean`, `string`, `number` or `json`.
        """
        return pulumi.get(self, "variation_type")

    @property
    @pulumi.getter
    def variations(self) -> Sequence['outputs.GetFeatureFlagVariationResult']:
        """
        List of nested blocks describing the variations associated with the feature flag. To learn more, read Nested Variations Blocks.
        """
        return pulumi.get(self, "variations")


class AwaitableGetFeatureFlagResult(GetFeatureFlagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeatureFlagResult(
            archived=self.archived,
            client_side_availabilities=self.client_side_availabilities,
            custom_properties=self.custom_properties,
            defaults=self.defaults,
            description=self.description,
            id=self.id,
            include_in_snippet=self.include_in_snippet,
            key=self.key,
            maintainer_id=self.maintainer_id,
            name=self.name,
            project_key=self.project_key,
            tags=self.tags,
            temporary=self.temporary,
            variation_type=self.variation_type,
            variations=self.variations)


def get_feature_flag(archived: Optional[bool] = None,
                     client_side_availabilities: Optional[Sequence[pulumi.InputType['GetFeatureFlagClientSideAvailabilityArgs']]] = None,
                     custom_properties: Optional[Sequence[pulumi.InputType['GetFeatureFlagCustomPropertyArgs']]] = None,
                     defaults: Optional[pulumi.InputType['GetFeatureFlagDefaultsArgs']] = None,
                     description: Optional[str] = None,
                     include_in_snippet: Optional[bool] = None,
                     key: Optional[str] = None,
                     maintainer_id: Optional[str] = None,
                     project_key: Optional[str] = None,
                     tags: Optional[Sequence[str]] = None,
                     temporary: Optional[bool] = None,
                     variations: Optional[Sequence[pulumi.InputType['GetFeatureFlagVariationArgs']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeatureFlagResult:
    """
    Provides a LaunchDarkly feature flag data source.

    This data source allows you to retrieve feature flag information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_feature_flag(key="example-flag",
        project_key="example-project")
    ```


    :param Sequence[pulumi.InputType['GetFeatureFlagClientSideAvailabilityArgs']] client_side_availabilities: A map describing whether this flag has been made available to the client-side JavaScript SDK. To learn more, read Nested Client-Side Availability Block.
    :param Sequence[pulumi.InputType['GetFeatureFlagCustomPropertyArgs']] custom_properties: List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
    :param pulumi.InputType['GetFeatureFlagDefaultsArgs'] defaults: A map describing the index of the variation served when the flag is on for new environments. To learn more, read Nested Defaults Blocks.
    :param str description: The variation's description.
    :param bool include_in_snippet: **Deprecated** A boolean describing whether this flag has been made available to the client-side Javescript SDK using the client-side ID only. `include_in_snippet` is now deprecated. Please retrieve information from `client_side_availability.using_environment_id` to maintain future compatability.
    :param str key: The unique feature flag key that references the flag in your application code.
    :param str maintainer_id: The feature flag maintainer's 24 character alphanumeric team member ID.
    :param str project_key: The feature flag's project key.
    :param Sequence[str] tags: Set of feature flag tags.
    :param bool temporary: Whether the flag is a temporary flag.
    :param Sequence[pulumi.InputType['GetFeatureFlagVariationArgs']] variations: List of nested blocks describing the variations associated with the feature flag. To learn more, read Nested Variations Blocks.
    """
    __args__ = dict()
    __args__['archived'] = archived
    __args__['clientSideAvailabilities'] = client_side_availabilities
    __args__['customProperties'] = custom_properties
    __args__['defaults'] = defaults
    __args__['description'] = description
    __args__['includeInSnippet'] = include_in_snippet
    __args__['key'] = key
    __args__['maintainerId'] = maintainer_id
    __args__['projectKey'] = project_key
    __args__['tags'] = tags
    __args__['temporary'] = temporary
    __args__['variations'] = variations
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getFeatureFlag:getFeatureFlag', __args__, opts=opts, typ=GetFeatureFlagResult).value

    return AwaitableGetFeatureFlagResult(
        archived=__ret__.archived,
        client_side_availabilities=__ret__.client_side_availabilities,
        custom_properties=__ret__.custom_properties,
        defaults=__ret__.defaults,
        description=__ret__.description,
        id=__ret__.id,
        include_in_snippet=__ret__.include_in_snippet,
        key=__ret__.key,
        maintainer_id=__ret__.maintainer_id,
        name=__ret__.name,
        project_key=__ret__.project_key,
        tags=__ret__.tags,
        temporary=__ret__.temporary,
        variation_type=__ret__.variation_type,
        variations=__ret__.variations)


@_utilities.lift_output_func(get_feature_flag)
def get_feature_flag_output(archived: Optional[pulumi.Input[Optional[bool]]] = None,
                            client_side_availabilities: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFeatureFlagClientSideAvailabilityArgs']]]]] = None,
                            custom_properties: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFeatureFlagCustomPropertyArgs']]]]] = None,
                            defaults: Optional[pulumi.Input[Optional[pulumi.InputType['GetFeatureFlagDefaultsArgs']]]] = None,
                            description: Optional[pulumi.Input[Optional[str]]] = None,
                            include_in_snippet: Optional[pulumi.Input[Optional[bool]]] = None,
                            key: Optional[pulumi.Input[str]] = None,
                            maintainer_id: Optional[pulumi.Input[Optional[str]]] = None,
                            project_key: Optional[pulumi.Input[str]] = None,
                            tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            temporary: Optional[pulumi.Input[Optional[bool]]] = None,
                            variations: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFeatureFlagVariationArgs']]]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFeatureFlagResult]:
    """
    Provides a LaunchDarkly feature flag data source.

    This data source allows you to retrieve feature flag information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_feature_flag(key="example-flag",
        project_key="example-project")
    ```


    :param Sequence[pulumi.InputType['GetFeatureFlagClientSideAvailabilityArgs']] client_side_availabilities: A map describing whether this flag has been made available to the client-side JavaScript SDK. To learn more, read Nested Client-Side Availability Block.
    :param Sequence[pulumi.InputType['GetFeatureFlagCustomPropertyArgs']] custom_properties: List of nested blocks describing the feature flag's [custom properties](https://docs.launchdarkly.com/home/connecting/custom-properties). To learn more, read Nested Custom Properties.
    :param pulumi.InputType['GetFeatureFlagDefaultsArgs'] defaults: A map describing the index of the variation served when the flag is on for new environments. To learn more, read Nested Defaults Blocks.
    :param str description: The variation's description.
    :param bool include_in_snippet: **Deprecated** A boolean describing whether this flag has been made available to the client-side Javescript SDK using the client-side ID only. `include_in_snippet` is now deprecated. Please retrieve information from `client_side_availability.using_environment_id` to maintain future compatability.
    :param str key: The unique feature flag key that references the flag in your application code.
    :param str maintainer_id: The feature flag maintainer's 24 character alphanumeric team member ID.
    :param str project_key: The feature flag's project key.
    :param Sequence[str] tags: Set of feature flag tags.
    :param bool temporary: Whether the flag is a temporary flag.
    :param Sequence[pulumi.InputType['GetFeatureFlagVariationArgs']] variations: List of nested blocks describing the variations associated with the feature flag. To learn more, read Nested Variations Blocks.
    """
    ...
