# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSegmentResult',
    'AwaitableGetSegmentResult',
    'get_segment',
    'get_segment_output',
]

@pulumi.output_type
class GetSegmentResult:
    """
    A collection of values returned by getSegment.
    """
    def __init__(__self__, creation_date=None, description=None, env_key=None, excludeds=None, id=None, includeds=None, key=None, name=None, project_key=None, rules=None, tags=None):
        if creation_date and not isinstance(creation_date, int):
            raise TypeError("Expected argument 'creation_date' to be a int")
        pulumi.set(__self__, "creation_date", creation_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if env_key and not isinstance(env_key, str):
            raise TypeError("Expected argument 'env_key' to be a str")
        pulumi.set(__self__, "env_key", env_key)
        if excludeds and not isinstance(excludeds, list):
            raise TypeError("Expected argument 'excludeds' to be a list")
        pulumi.set(__self__, "excludeds", excludeds)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if includeds and not isinstance(includeds, list):
            raise TypeError("Expected argument 'includeds' to be a list")
        pulumi.set(__self__, "includeds", includeds)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_key and not isinstance(project_key, str):
            raise TypeError("Expected argument 'project_key' to be a str")
        pulumi.set(__self__, "project_key", project_key)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> int:
        """
        The segment's creation date represented as a UNIX epoch timestamp.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the segment's purpose.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> str:
        return pulumi.get(self, "env_key")

    @property
    @pulumi.getter
    def excludeds(self) -> Optional[Sequence[str]]:
        """
        List of user keys excluded from the segment.
        """
        return pulumi.get(self, "excludeds")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def includeds(self) -> Optional[Sequence[str]]:
        """
        List of user keys included in the segment.
        """
        return pulumi.get(self, "includeds")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The human-friendly name for the segment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> str:
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.GetSegmentRuleResult']]:
        """
        List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Set of tags for the segment.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSegmentResult(GetSegmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSegmentResult(
            creation_date=self.creation_date,
            description=self.description,
            env_key=self.env_key,
            excludeds=self.excludeds,
            id=self.id,
            includeds=self.includeds,
            key=self.key,
            name=self.name,
            project_key=self.project_key,
            rules=self.rules,
            tags=self.tags)


def get_segment(description: Optional[str] = None,
                env_key: Optional[str] = None,
                excludeds: Optional[Sequence[str]] = None,
                includeds: Optional[Sequence[str]] = None,
                key: Optional[str] = None,
                project_key: Optional[str] = None,
                rules: Optional[Sequence[pulumi.InputType['GetSegmentRuleArgs']]] = None,
                tags: Optional[Sequence[str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSegmentResult:
    """
    Provides a LaunchDarkly segment data source.

    This data source allows you to retrieve segment information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_segment(env_key="example-env",
        key="example-segment",
        project_key="example-project")
    ```


    :param str description: The description of the segment's purpose.
    :param str env_key: The segment's environment key.
    :param Sequence[str] excludeds: List of user keys excluded from the segment.
    :param Sequence[str] includeds: List of user keys included in the segment.
    :param str key: The unique key that references the segment.
    :param str project_key: The segment's project key.
    :param Sequence[pulumi.InputType['GetSegmentRuleArgs']] rules: List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
    :param Sequence[str] tags: Set of tags for the segment.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['envKey'] = env_key
    __args__['excludeds'] = excludeds
    __args__['includeds'] = includeds
    __args__['key'] = key
    __args__['projectKey'] = project_key
    __args__['rules'] = rules
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getSegment:getSegment', __args__, opts=opts, typ=GetSegmentResult).value

    return AwaitableGetSegmentResult(
        creation_date=__ret__.creation_date,
        description=__ret__.description,
        env_key=__ret__.env_key,
        excludeds=__ret__.excludeds,
        id=__ret__.id,
        includeds=__ret__.includeds,
        key=__ret__.key,
        name=__ret__.name,
        project_key=__ret__.project_key,
        rules=__ret__.rules,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_segment)
def get_segment_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                       env_key: Optional[pulumi.Input[str]] = None,
                       excludeds: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       includeds: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       key: Optional[pulumi.Input[str]] = None,
                       project_key: Optional[pulumi.Input[str]] = None,
                       rules: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSegmentRuleArgs']]]]] = None,
                       tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSegmentResult]:
    """
    Provides a LaunchDarkly segment data source.

    This data source allows you to retrieve segment information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_segment(env_key="example-env",
        key="example-segment",
        project_key="example-project")
    ```


    :param str description: The description of the segment's purpose.
    :param str env_key: The segment's environment key.
    :param Sequence[str] excludeds: List of user keys excluded from the segment.
    :param Sequence[str] includeds: List of user keys included in the segment.
    :param str key: The unique key that references the segment.
    :param str project_key: The segment's project key.
    :param Sequence[pulumi.InputType['GetSegmentRuleArgs']] rules: List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
    :param Sequence[str] tags: Set of tags for the segment.
    """
    ...
