# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricArgs', 'Metric']

@pulumi.input_type
class MetricArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 kind: pulumi.Input[str],
                 project_key: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 event_key: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 is_numeric: Optional[pulumi.Input[bool]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 success_criteria: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]]] = None):
        """
        The set of arguments for constructing a Metric resource.
        :param pulumi.Input[str] key: The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] kind: The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] project_key: The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] description: The description of the metric's purpose.
        :param pulumi.Input[str] event_key: The event key to watch for `custom` metrics.
        :param pulumi.Input[bool] is_active: Whether the metric is active
        :param pulumi.Input[bool] is_numeric: Whether the metric is numeric
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently-set maintainer
        :param pulumi.Input[str] name: The human-friendly name for the metric.
        :param pulumi.Input[str] selector: The CSS selector for `click` metrics.
        :param pulumi.Input[str] success_criteria: The success criteria for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the metric.
        :param pulumi.Input[str] unit: The unit for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]] urls: A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "project_key", project_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_key is not None:
            pulumi.set(__self__, "event_key", event_key)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if is_numeric is not None:
            pulumi.set(__self__, "is_numeric", is_numeric)
        if maintainer_id is not None:
            pulumi.set(__self__, "maintainer_id", maintainer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if success_criteria is not None:
            pulumi.set(__self__, "success_criteria", success_criteria)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[str]:
        """
        The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the metric's purpose.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventKey")
    def event_key(self) -> Optional[pulumi.Input[str]]:
        """
        The event key to watch for `custom` metrics.
        """
        return pulumi.get(self, "event_key")

    @event_key.setter
    def event_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_key", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the metric is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="isNumeric")
    def is_numeric(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the metric is numeric
        """
        return pulumi.get(self, "is_numeric")

    @is_numeric.setter
    def is_numeric(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_numeric", value)

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
        associated with your Terraform API key or the most recently-set maintainer
        """
        return pulumi.get(self, "maintainer_id")

    @maintainer_id.setter
    def maintainer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-friendly name for the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        The CSS selector for `click` metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        The success criteria for numeric `custom` metrics.
        """
        return pulumi.get(self, "success_criteria")

    @success_criteria.setter
    def success_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "success_criteria", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags for the metric.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit for numeric `custom` metrics.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]]]:
        """
        A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]]]):
        pulumi.set(self, "urls", value)


@pulumi.input_type
class _MetricState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 event_key: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 is_numeric: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 success_criteria: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]]] = None):
        """
        Input properties used for looking up and filtering Metric resources.
        :param pulumi.Input[str] description: The description of the metric's purpose.
        :param pulumi.Input[str] event_key: The event key to watch for `custom` metrics.
        :param pulumi.Input[bool] is_active: Whether the metric is active
        :param pulumi.Input[bool] is_numeric: Whether the metric is numeric
        :param pulumi.Input[str] key: The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] kind: The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently-set maintainer
        :param pulumi.Input[str] name: The human-friendly name for the metric.
        :param pulumi.Input[str] project_key: The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] selector: The CSS selector for `click` metrics.
        :param pulumi.Input[str] success_criteria: The success criteria for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the metric.
        :param pulumi.Input[str] unit: The unit for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]] urls: A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_key is not None:
            pulumi.set(__self__, "event_key", event_key)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if is_numeric is not None:
            pulumi.set(__self__, "is_numeric", is_numeric)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if maintainer_id is not None:
            pulumi.set(__self__, "maintainer_id", maintainer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if success_criteria is not None:
            pulumi.set(__self__, "success_criteria", success_criteria)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the metric's purpose.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventKey")
    def event_key(self) -> Optional[pulumi.Input[str]]:
        """
        The event key to watch for `custom` metrics.
        """
        return pulumi.get(self, "event_key")

    @event_key.setter
    def event_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_key", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the metric is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="isNumeric")
    def is_numeric(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the metric is numeric
        """
        return pulumi.get(self, "is_numeric")

    @is_numeric.setter
    def is_numeric(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_numeric", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
        associated with your Terraform API key or the most recently-set maintainer
        """
        return pulumi.get(self, "maintainer_id")

    @maintainer_id.setter
    def maintainer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-friendly name for the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[str]]:
        """
        The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        The CSS selector for `click` metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        The success criteria for numeric `custom` metrics.
        """
        return pulumi.get(self, "success_criteria")

    @success_criteria.setter
    def success_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "success_criteria", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags for the metric.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit for numeric `custom` metrics.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]]]:
        """
        A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricUrlArgs']]]]):
        pulumi.set(self, "urls", value)


class Metric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_key: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 is_numeric: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 success_criteria: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricUrlArgs']]]]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly metric resource.

        This resource allows you to create and manage metrics within your LaunchDarkly organization.

        To learn more about metrics and experimentation, read [Experimentation Documentation](https://docs.launchdarkly.com/home/experimentation).

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.Metric("example",
            project_key=launchdarkly_project["example"]["key"],
            key="example-metric",
            description="Metric description.",
            kind="pageview",
            tags=["example"],
            urls=[launchdarkly.MetricUrlArgs(
                kind="substring",
                substring="foo",
            )])
        ```

        ## Import

        LaunchDarkly metrics can be imported using the metric's ID in the form `project_key/metric_key`, e.g.

        ```sh
         $ pulumi import launchdarkly:index/metric:Metric example example-project/example-metric-key
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the metric's purpose.
        :param pulumi.Input[str] event_key: The event key to watch for `custom` metrics.
        :param pulumi.Input[bool] is_active: Whether the metric is active
        :param pulumi.Input[bool] is_numeric: Whether the metric is numeric
        :param pulumi.Input[str] key: The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] kind: The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently-set maintainer
        :param pulumi.Input[str] name: The human-friendly name for the metric.
        :param pulumi.Input[str] project_key: The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] selector: The CSS selector for `click` metrics.
        :param pulumi.Input[str] success_criteria: The success criteria for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the metric.
        :param pulumi.Input[str] unit: The unit for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricUrlArgs']]]] urls: A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly metric resource.

        This resource allows you to create and manage metrics within your LaunchDarkly organization.

        To learn more about metrics and experimentation, read [Experimentation Documentation](https://docs.launchdarkly.com/home/experimentation).

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.Metric("example",
            project_key=launchdarkly_project["example"]["key"],
            key="example-metric",
            description="Metric description.",
            kind="pageview",
            tags=["example"],
            urls=[launchdarkly.MetricUrlArgs(
                kind="substring",
                substring="foo",
            )])
        ```

        ## Import

        LaunchDarkly metrics can be imported using the metric's ID in the form `project_key/metric_key`, e.g.

        ```sh
         $ pulumi import launchdarkly:index/metric:Metric example example-project/example-metric-key
        ```

        :param str resource_name: The name of the resource.
        :param MetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_key: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 is_numeric: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 maintainer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 success_criteria: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricUrlArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricArgs.__new__(MetricArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["event_key"] = event_key
            __props__.__dict__["is_active"] = is_active
            __props__.__dict__["is_numeric"] = is_numeric
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["maintainer_id"] = maintainer_id
            __props__.__dict__["name"] = name
            if project_key is None and not opts.urn:
                raise TypeError("Missing required property 'project_key'")
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["selector"] = selector
            __props__.__dict__["success_criteria"] = success_criteria
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unit"] = unit
            __props__.__dict__["urls"] = urls
        super(Metric, __self__).__init__(
            'launchdarkly:index/metric:Metric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            event_key: Optional[pulumi.Input[str]] = None,
            is_active: Optional[pulumi.Input[bool]] = None,
            is_numeric: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            kind: Optional[pulumi.Input[str]] = None,
            maintainer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_key: Optional[pulumi.Input[str]] = None,
            selector: Optional[pulumi.Input[str]] = None,
            success_criteria: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            unit: Optional[pulumi.Input[str]] = None,
            urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricUrlArgs']]]]] = None) -> 'Metric':
        """
        Get an existing Metric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the metric's purpose.
        :param pulumi.Input[str] event_key: The event key to watch for `custom` metrics.
        :param pulumi.Input[bool] is_active: Whether the metric is active
        :param pulumi.Input[bool] is_numeric: Whether the metric is numeric
        :param pulumi.Input[str] key: The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] kind: The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] maintainer_id: The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
               associated with your Terraform API key or the most recently-set maintainer
        :param pulumi.Input[str] name: The human-friendly name for the metric.
        :param pulumi.Input[str] project_key: The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] selector: The CSS selector for `click` metrics.
        :param pulumi.Input[str] success_criteria: The success criteria for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the metric.
        :param pulumi.Input[str] unit: The unit for numeric `custom` metrics.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricUrlArgs']]]] urls: A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricState.__new__(_MetricState)

        __props__.__dict__["description"] = description
        __props__.__dict__["event_key"] = event_key
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["is_numeric"] = is_numeric
        __props__.__dict__["key"] = key
        __props__.__dict__["kind"] = kind
        __props__.__dict__["maintainer_id"] = maintainer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["selector"] = selector
        __props__.__dict__["success_criteria"] = success_criteria
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unit"] = unit
        __props__.__dict__["urls"] = urls
        return Metric(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the metric's purpose.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventKey")
    def event_key(self) -> pulumi.Output[Optional[str]]:
        """
        The event key to watch for `custom` metrics.
        """
        return pulumi.get(self, "event_key")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the metric is active
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="isNumeric")
    def is_numeric(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the metric is numeric
        """
        return pulumi.get(self, "is_numeric")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The unique key that references the metric. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        The metric type. Available choices are `click`, `custom`, and `pageview`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> pulumi.Output[str]:
        """
        The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member
        associated with your Terraform API key or the most recently-set maintainer
        """
        return pulumi.get(self, "maintainer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-friendly name for the metric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[str]:
        """
        The metrics's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Output[Optional[str]]:
        """
        The CSS selector for `click` metrics.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> pulumi.Output[Optional[str]]:
        """
        The success criteria for numeric `custom` metrics.
        """
        return pulumi.get(self, "success_criteria")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of tags for the metric.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Output[Optional[str]]:
        """
        The unit for numeric `custom` metrics.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Output[Optional[Sequence['outputs.MetricUrl']]]:
        """
        A block determining which URLs the metric watches. To learn more, read Nested Urls Blocks.
        """
        return pulumi.get(self, "urls")

