# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RelayProxyConfigurationArgs', 'RelayProxyConfiguration']

@pulumi.input_type
class RelayProxyConfigurationArgs:
    def __init__(__self__, *,
                 policies: pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RelayProxyConfiguration resource.
        :param pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]] policies: The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        :param pulumi.Input[str] name: The human-readable name for your Relay Proxy configuration.
        """
        pulumi.set(__self__, "policies", policies)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]]:
        """
        The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name for your Relay Proxy configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RelayProxyConfigurationState:
    def __init__(__self__, *,
                 display_key: Optional[pulumi.Input[str]] = None,
                 full_key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]]] = None):
        """
        Input properties used for looking up and filtering RelayProxyConfiguration resources.
        :param pulumi.Input[str] display_key: The last 4 characters of the Relay Proxy configuration's unique key.
        :param pulumi.Input[str] full_key: The Relay Proxy configuration's unique key. Because the `full_key` is only exposed upon creation, it will not be available if the resource is imported.
        :param pulumi.Input[str] name: The human-readable name for your Relay Proxy configuration.
        :param pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]] policies: The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        if display_key is not None:
            pulumi.set(__self__, "display_key", display_key)
        if full_key is not None:
            pulumi.set(__self__, "full_key", full_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter(name="displayKey")
    def display_key(self) -> Optional[pulumi.Input[str]]:
        """
        The last 4 characters of the Relay Proxy configuration's unique key.
        """
        return pulumi.get(self, "display_key")

    @display_key.setter
    def display_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_key", value)

    @property
    @pulumi.getter(name="fullKey")
    def full_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Relay Proxy configuration's unique key. Because the `full_key` is only exposed upon creation, it will not be available if the resource is imported.
        """
        return pulumi.get(self, "full_key")

    @full_key.setter
    def full_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name for your Relay Proxy configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]]]:
        """
        The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RelayProxyConfigurationPolicyArgs']]]]):
        pulumi.set(self, "policies", value)


class RelayProxyConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelayProxyConfigurationPolicyArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.RelayProxyConfiguration("example", policies=[launchdarkly.RelayProxyConfigurationPolicyArgs(
            actions=["*"],
            effect="allow",
            resources=["proj/*:env/*"],
        )])
        ```

        ## Import

        Relay Proxy configurations can be imported using the configuration's unique 24 character ID, e.g.

        ```sh
         $ pulumi import launchdarkly:index/relayProxyConfiguration:RelayProxyConfiguration example 51d440e30c9ff61457c710f6
        ```

         The unique relay proxy ID can be found in the relay proxy edit page URL, which you can locate by clicking the three dot menu on your relay proxy item in the UI and selecting 'Edit configuration'https://app.launchdarkly.com/settings/relay/THIS_IS_YOUR_RELAY_PROXY_ID/edit

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The human-readable name for your Relay Proxy configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelayProxyConfigurationPolicyArgs']]]] policies: The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RelayProxyConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.RelayProxyConfiguration("example", policies=[launchdarkly.RelayProxyConfigurationPolicyArgs(
            actions=["*"],
            effect="allow",
            resources=["proj/*:env/*"],
        )])
        ```

        ## Import

        Relay Proxy configurations can be imported using the configuration's unique 24 character ID, e.g.

        ```sh
         $ pulumi import launchdarkly:index/relayProxyConfiguration:RelayProxyConfiguration example 51d440e30c9ff61457c710f6
        ```

         The unique relay proxy ID can be found in the relay proxy edit page URL, which you can locate by clicking the three dot menu on your relay proxy item in the UI and selecting 'Edit configuration'https://app.launchdarkly.com/settings/relay/THIS_IS_YOUR_RELAY_PROXY_ID/edit

        :param str resource_name: The name of the resource.
        :param RelayProxyConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RelayProxyConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelayProxyConfigurationPolicyArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RelayProxyConfigurationArgs.__new__(RelayProxyConfigurationArgs)

            __props__.__dict__["name"] = name
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["display_key"] = None
            __props__.__dict__["full_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["fullKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RelayProxyConfiguration, __self__).__init__(
            'launchdarkly:index/relayProxyConfiguration:RelayProxyConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_key: Optional[pulumi.Input[str]] = None,
            full_key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelayProxyConfigurationPolicyArgs']]]]] = None) -> 'RelayProxyConfiguration':
        """
        Get an existing RelayProxyConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_key: The last 4 characters of the Relay Proxy configuration's unique key.
        :param pulumi.Input[str] full_key: The Relay Proxy configuration's unique key. Because the `full_key` is only exposed upon creation, it will not be available if the resource is imported.
        :param pulumi.Input[str] name: The human-readable name for your Relay Proxy configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RelayProxyConfigurationPolicyArgs']]]] policies: The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RelayProxyConfigurationState.__new__(_RelayProxyConfigurationState)

        __props__.__dict__["display_key"] = display_key
        __props__.__dict__["full_key"] = full_key
        __props__.__dict__["name"] = name
        __props__.__dict__["policies"] = policies
        return RelayProxyConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayKey")
    def display_key(self) -> pulumi.Output[str]:
        """
        The last 4 characters of the Relay Proxy configuration's unique key.
        """
        return pulumi.get(self, "display_key")

    @property
    @pulumi.getter(name="fullKey")
    def full_key(self) -> pulumi.Output[str]:
        """
        The Relay Proxy configuration's unique key. Because the `full_key` is only exposed upon creation, it will not be available if the resource is imported.
        """
        return pulumi.get(self, "full_key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-readable name for your Relay Proxy configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.RelayProxyConfigurationPolicy']]:
        """
        The Relay Proxy configuration's rule policy block. This determines what content the Relay Proxy receives. To learn more, read [Understanding policies](https://docs.launchdarkly.com/home/members/role-policies#understanding-policies).
        """
        return pulumi.get(self, "policies")

