#!/usr/bin/env python
import numpy as np
import os
infile="all.gro"
coords=False
head=[]
elem=[]
box=[]
outfile="out.gro"
if os.path.isfile(outfile):
    os.remove(outfile)
for line in open(infile):
    ls=line.split()
    if "Frame" in line:
        head.append(line)
    if len(ls)==6:
        elem.append(ls[:])
    if len(ls)==3:
        box.append(ls[:])
out=open(outfile, 'a+')
out.write("Georgetown Riga Oslo Madrid Amsterdam Chisinau Stockholm\n")
for i in xrange(0,576):
    out.write("   36\n")
    for t in xrange(0,36):
        out.write("    {0:>4}   {1:>4}   {2:>2}  {3:>6.3f}  {4:>6.3f}  {5:>6.3f}\n".format(elem[t][0],elem[t][1],elem[t][2],float(elem[t][3]),float(elem[t][4]),float(elem[t][5])))
    del elem[0:36]
    out.write("    {0:11}   {1:11}   {2:11}\n".format(box[i][0],box[i][1],box[i][2]))
    if i != 575:
        out.write("{}".format(head[i]))
    
