# sourcery skip: use-fstring-for-concatenation
import re

characters = {
    "ك": "ک",
    "دِ": "د",
    "بِ": "ب",
    "زِ": "ز",
    "ذِ": "ذ",
    "شِ": "ش",
    "سِ": "س",
    "ى": "ی",
    "ي": "ی",
    "ؤ": "و",
    "ے": "ی",
    "ۀ": "ه",
    "ﭘ": "پ",
    "ﮐ": "ک",
    "ﯽ": "ی",
    "ﺎ": "ا",
    "ﺑ": "ب",
    "ﺘ": "ت",
    "ﺧ": "خ",
    "ﺩ": "د",
    "ﺱ": "س",
    "ﻀ": "ض",
    "ﻌ": "ع",
    "ﻟ": "ل",
    "ﻡ": "م",
    "ﻢ": "م",
    "ﻪ": "ه",
    "ﻮ": "و",
    "ﺍ": "ا",
    "ة": "ه",
    "ﯾ": "ی",
    "ﯿ": "ی",
    "ﺒ": "ب",
    "ﺖ": "ت",
    "ﺪ": "د",
    "ﺮ": "ر",
    "ﺴ": "س",
    "ﺷ": "ش",
    "ﺸ": "ش",
    "ﻋ": "ع",
    "ﻤ": "م",
    "ﻥ": "ن",
    "ﻧ": "ن",
    "ﻭ": "و",
    "ﺭ": "ر",
    "ﮔ": "گ",
    "إ": "ا",
    "ٕ": " ",
    "ھ": "ه",
    "...": ".",
    "…": ".",
    "-": " - ",
    "هٔ": "ه",
    "ﻯ": "ی",
    "ﻛ": "ک",
    "ﭼ": "چ",
    "ﺓ": "ه",
    "ﻴ": "ی",
    "ﻊ": "ع",
    "ﮬ": "ه",
    "ﺟ": "ج",
    "ﺳ": "س",
    "ﻦ": "ن",
    "ﺬ": "ذ",
    "ﺋ": "ئ",
    "ﷲ": "لله",
    "ﺞ": "ج",
    "ﺙ": "ث",
    "ﻗ": "ق",
    "ﮪ": "ه",
    "ﺰ": "ز",
    "ﯼ": "ی",
    "ٺ": "ت",
    "ﺻ": "ص",
    "ﻂ": "ط",
    "ﻣ": "م",
    "ﻈ": "ظ",
    "ﺐ": "ب",
    "ﻍ": "غ",
    "ݸ": "و",
    "ﻨ": "ن",
    "ﻝ": "ل",
    "ﻩ": "ه",
    "ﻲ": "ی",
    "ﻐ": "غ",
    "ﺲ": "س",
    "ﺁ": "آ",
    "ڔ": "ر",
    "ﺫ": "ذ",
    "ﭻ": "چ",
    "ﺠ": "ج",
    "ﯙ": "و",
    "ﮏ": "ک",
    "ﺣ": "ح",
    "ﺝ": "ج",
    "ﺼ": "ص",
    "ﻳ": "ی",
    "ﻘ": "ق",
    "ﺨ": "خ",
    "ﻔ": "ف",
    "ﻎ": "غ",
    "ئ": "ی",
    "ﻓ": "ف",
    "ﻕ": "ق",
    "ﮋ": "ژ",
    "ﺗ": "ت",
    "ﻁ": "ط",
    "ﺯ": "ز",
    "ﮕ": "گ",
    "ﺌ": "ئ",
    "ﺵ": "ش",
    "ۮ": "د",
    "ﻫ": "ه",
    "ﻬ": "ه",
    "ﻏ": "غ",
    "ﻰ": "ی",
    "﷼": "ریال",
    "ﺿ": "ض",
    "ﺛ": "ث",
    "ݐ": "پ",
    "ﺏ": "ب",
    "ﭙ": "پ",
    "ﭽ": "چ",
    "ﺜ": "ث",
    "ﻃ": "ط",
    "ۂ": "ه",
    "ﻑ": "ف",
    "ﺕ": "ت",
    "ﻞ": "ل",
}

words_map = {
    "Leave a comment": "",
    "[…]": "",
    "[.]": "",
}

strange_double_quotes = [
    "«",
    "‹",
    "»",
    "›",
    "„",
    "“",
    "‟",
    "”",
    "❝",
    "❞",
    "❮",
    "❯",
    "〝",
    "〞",
    "〟",
    "＂",
]

hamze = {'ارایه': 'ارائه',
         'سیو': 'سئو',
         'مسیله': 'مسئله',
         'مسیولیت': 'مسئولیت',
         'مسایل': 'مسائل',
         'ریوف': 'رئوف',
         'مسیول': 'مسئول',
         'زیوس': 'زئوس',
         'کاکایو': 'کاکائو',
         'ناپلیون': 'ناپلئون',
         'نیون': 'نئون',
         'کلیوپاترا': 'کلئوپاترا',
         'ژیوفیزیک': 'ژئوفیزیک',
         'تیودور': 'تئودور',
         'مصایب': 'مصائب',
         'قایل': 'قائل',
         'ایتلاف': 'ائتلاف',
         'هییت': 'هیئت',
         'تیاتر': 'تئاتر',
         'توطیه': 'توطئه',
         'جریت': 'جرئت',
         'قرایت': 'قرائت',
         'دنایت': 'دنائت',
         'ژوین': 'ژوئن',
         'پنگوین': 'پنگوئن',
         'رسایل': 'رسائل',
         'علایم': 'علائم',
         'ملایک': 'ملائک',
         'نویل': 'نوئل',
         'سوید': 'سوئد'}

strange_single_quotes = ["‘", "‛", "’", "❛", "❜", "`", "´", "‘", "’"]

DOUBLE_QUOTE_REGEX = re.compile("|".join(strange_double_quotes))
SINGLE_QUOTE_REGEX = re.compile("|".join(strange_single_quotes))

PERSIAN_ALPHA = "ءآئابتثجحخدذرزسشصضطظعغفقلمنهوپچژکگیە"  # noqa: E501
PERSIAN_DIGIT = "۰۱۲۳۴۵۶۷۸۹"

ZWNJ = "\u200c"
PUNK = '\!\"\#\$\%\&\'\(\)\*\+\,\-\.\/\:\;\<\=\>\?\@\[\]\^\_\`\{\|\}\~\«\»\؟\:\×\٬\٫\﷼\٪\،'

PERSIAN = (
        "a-zA-Z0-9" +
        PERSIAN_ALPHA +
        PERSIAN_DIGIT +
        ZWNJ +
        PUNK
)

PERSIAN_REGEX = r"[^" + PERSIAN + "+]"
