#!/usr/bin/env python3
#
# GlobalChem - Emerging PerfluoroAlkyls
#
# -------------------------------------

class EmergingPerFluoroAlkyls(object):

    def __init__(self):

        self.name = 'emerging_perfluoroalkyls'

    @staticmethod
    def get_smiles():

        '''

        Missing Entries:
             '8:2 chlorinated polyfluorinated ether sulfonic acid': '',

        '''

        smiles = {
            'perfluorohexanoic acid': 'C(=O)(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            'perfluoroheptanoic acid': 'C(=O)(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            'perfluorononanoic acid': 'C(=O)(C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            'perfluorodecanoic acid': 'C(=O)(C(C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            'perfluorobutanesulfonic acid': 'C(C(C(F)(F)S(=O)(=O)O)(F)F)(C(F)(F)F)(F)F',
            'perfluorohexanesulfonic acid': 'C(C(C(C(F)(F)S(=O)(=O)O)(F)F)(F)F)(C(C(F)(F)F)(F)F)(F)F',
            'perfluoroundecanoic acid': 'C(=O)(C(C(C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            '2-(N-ethyl-perfluorooctane sulfanamido) acetic acid': 'CCN(CC(=O)O)S(=O)(=O)C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F',
            '2-(N-Methyl-perfluorooctane sulfanamido) acetic acid': 'CN(CC(=O)O)S(=O)(=O)C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F',
            'hexafluoropropylene Oxide Dimer Acid': 'C1(C(O1)(F)F)(C(F)(F)F)F',
            'perfluorotetradecanoic acid': 'C(=O)(C(C(C(C(C(C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            'perfluorotridecanoic acid': 'C(=O)(C(C(C(C(C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            '4,8-dioxa-3H-perfluorononanoic': 'C(C(C(=O)O)(F)F)(OC(C(C(OC(F)(F)F)(F)F)(F)F)(F)F)F',
            '6:2 chlorinated polyfluorinated ether sulfonic acid': 'FC(Cl)(C(F)(C(F)(F)C(F)(F)C(F)(F)OC(F)(F)C(F)(S(=O)(O[K])=O)F)F)F',
            'perfluorobutanoic acid': 'FC(F)(C(F)(C(O)=O)F)C(F)(F)F',
            'perfluoro-n-pentanoic acid': 'C(=O)(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)O',
            'nafion byproduct 2': 'C(C(F)(F)F)(OC(C(C(F)(F)F)(OC(C(F)(F)S(=O)(=O)O)(F)F)F)(F)F)F',
            'perfluoro-3,5,7,9-tetraoxadecanoic acid': 'C(=O)(C(OC(OC(OC(OC(F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            'perfluoro-3,5,7,9,11-pentaoxadodecanoic acid': 'C(=O)(C(OC(OC(OC(OC(OC(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)O',
            '2,2,3,3-tetrafluoro-3-((1,1,1,2,3,3-hexafluoro-3-(1,2,2,2-tetrafluoroethoxy)propan-2-yl)oxy)propanoic acid': 'C(=O)(C(C(F)(F)F)(OC(C(OC(C(C(F)(F)F)(F)F)(F)F)(F)F)(C(F)(F)F)F)F)O',
            'h,1h,2h,2h-perfluorooctanesulfonic acid': 'C(C(C(C(C(F)(F)S(=O)(=O)O)(F)F)(F)F)(F)F)(C(C(C(F)(F)F)(F)F)(F)F)(F)F',
            '2-(perfluorooctyl)ethane-1-sulfonic acid': 'C(CS(=O)(=O)O)C(C(C(C(C(C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F)(F)F',
            'perfluoropentanesulfonic acid': 'C(C(C(F)(F)F)(F)F)(C(C(F)(F)S(=O)(=O)O)(F)F)(F)F',
            'perfluoroheptanesulfonic acid': 'C(C(C(C(F)(F)F)(F)F)(F)F)(C(C(C(F)(F)S(=O)(=O)O)(F)F)(F)F)(F)F',
            'perfluorononanesulfonic acid': 'C(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(C(C(C(C(F)(F)S(=O)(=O)O)(F)F)(F)F)(F)F)(F)F',
            'perfluorodecanesulfonic acid': 'C(C(C(C(C(C(F)(F)S(=O)(=O)O)(F)F)(F)F)(F)F)(F)F)(C(C(C(C(F)(F)F)(F)F)(F)F)(F)F)(F)F',
            'hexafluoropropylene-oxide-trimer-acid': 'C(=O)(C(C(F)(F)F)(OC(C(C(F)(F)F)(OC(C(C(F)(F)F)(F)F)(F)F)F)(F)F)F)F',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'perfluorohexanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'perfluoroheptanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'perfluorononanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'perfluorodecanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'perfluorobutanesulfonic acid': '[#6](-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'perfluorohexanesulfonic acid': '[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'perfluoroundecanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            '2-(N-ethyl-perfluorooctane sulfanamido) acetic acid': '[#6]-[#6]-[#7](-[#6]-[#6](=[#8])-[#8])-[#16](=[#8])(=[#8])-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            '2-(N-Methyl-perfluorooctane sulfanamido) acetic acid': '[#6]-[#7](-[#6]-[#6](=[#8])-[#8])-[#16](=[#8])(=[#8])-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'hexafluoropropylene Oxide Dimer Acid': '[#6]1(-[#6](-[#8]-1)(-[#9])-[#9])(-[#6](-[#9])(-[#9])-[#9])-[#9]',
            'perfluorotetradecanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'perfluorotridecanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            '4,8-dioxa-3H-perfluorononanoic': '[#6](-[#6](-[#6](=[#8])-[#8])(-[#9])-[#9])(-[#8]-[#6](-[#6](-[#6](-[#8]-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#9]',
            '6:2 chlorinated polyfluorinated ether sulfonic acid': '[#9]-[#6](-[#17])(-[#6](-[#9])(-[#6](-[#9])(-[#9])-[#6](-[#9])(-[#9])-[#6](-[#9])(-[#9])-[#8]-[#6](-[#9])(-[#9])-[#6](-[#9])(-[#16](=[#8])(-[#8]-[K])=[#8])-[#9])-[#9])-[#9]',
            'perfluorobutanoic acid': '[#9]-[#6](-[#9])(-[#6](-[#9])(-[#6](-[#8])=[#8])-[#9])-[#6](-[#9])(-[#9])-[#9]',
            'perfluoro-n-pentanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'nafion byproduct 2': '[#6](-[#6](-[#9])(-[#9])-[#9])(-[#8]-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#8]-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])-[#9])(-[#9])-[#9])-[#9]',
            'perfluoro-3,5,7,9-tetraoxadecanoic acid': '[#6](=[#8])(-[#6](-[#8]-[#6](-[#8]-[#6](-[#8]-[#6](-[#8]-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            'perfluoro-3,5,7,9,11-pentaoxadodecanoic acid': '[#6](=[#8])(-[#6](-[#8]-[#6](-[#8]-[#6](-[#8]-[#6](-[#8]-[#6](-[#8]-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#8]',
            '2,2,3,3-tetrafluoro-3-((1,1,1,2,3,3-hexafluoro-3-(1,2,2,2-tetrafluoroethoxy)propan-2-yl)oxy)propanoic acid': '[#6](=[#8])(-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#8]-[#6](-[#6](-[#8]-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#9])(-[#9])-[#9])-[#9])-[#9])-[#8]',
            'h,1h,2h,2h-perfluorooctanesulfonic acid': '[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            '2-(perfluorooctyl)ethane-1-sulfonic acid': '[#6](-[#6]-[#16](=[#8])(=[#8])-[#8])-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'perfluoropentanesulfonic acid': '[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#9])-[#9]',
            'perfluoroheptanesulfonic acid': '[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'perfluorononanesulfonic acid': '[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'perfluorodecanesulfonic acid': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#16](=[#8])(=[#8])-[#8])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#6](-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9]',
            'hexafluoropropylene oxide trimer acid': '[#6](=[#8])(-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#8]-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#8]-[#6](-[#6](-[#6](-[#9])(-[#9])-[#9])(-[#9])-[#9])(-[#9])-[#9])-[#9])(-[#9])-[#9])-[#9])-[#9]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'perfluorohexanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            'perfluoroheptanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            'perfluorononanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            'perfluorodecanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            'perfluorobutanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000000000000000000000000000000000000000000000000000000000',
            'perfluorohexanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'perfluoroundecanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            '2-(N-ethyl-perfluorooctane sulfanamido) acetic acid': '00000000000000000000000000010000010000000000000000000000000100000100000000000000100000000000010000001000000000000010000000001000000000000010000000000000000000000000001000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000001000000100000000000000000000000000000000000000100000000000000000010000100000010000000100100100000000100000000000000010000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            '2-(N-Methyl-perfluorooctane sulfanamido) acetic acid': '00000000000000000000000000010000010000000000000000000000000100000100010000000000100000000000010000000000000000000010000000000000000000000011000000000000000000000000001000000010000000000000000000000000010000000000010000000000000000000100000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000010000100000010000000100100100000000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'hexafluoropropylene Oxide Dimer Acid': '00000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000010000000000000000000000000000000010100000000000000100000000000000000000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000010000000000000000000000100000000000000000000000000000000000001000000000000000000000',
            'perfluorotetradecanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            'perfluorotridecanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000001000000000000001000000000000000000000000000000000000',
            '4,8-dioxa-3H-perfluorononanoic': '01000000001000000000000000100000000000100000000000000000000000000000000000000000000000000100000000000000000000000010000000000000000000000010000000000000000000000000000000000000000000010000000000000000000000000000000001000100000000000000000000000001000001000000000000000000000000100000000010000001000001000000100000000000000000000000000000001000000000000000000000000000000000100000010001000100100000000000001000000000000000000100010000000000010000000000000000000000000000000000000000000000000000000000000000000000',
            '6:2 chlorinated polyfluorinated ether sulfonic acid': '00000000000000000000000000010000000000000000000000000000000000000000000000001000000000000000000000000000000000000010001000000000000000000010000000010000000000000000000000000000000010011000010000000000000000000100000001000000000000000000000000000001000000000000001000000000000000100000000000010010000000000000000000000000000000000000000000000000000010100000000000100000000000100000000000000000100000000000000000000000000000000000010100000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'perfluorobutanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000000000000000000000000000010000000000010000000000000000000000000000000001000000000000000000000000000000000000',
            'perfluoro-n-pentanoic acid': '00000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000010000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000000000100000000000000000000000010000000000010000000000000000000000000000000001000000000000000000000000000000000000',
            'nafion byproduct 2': '01100000000000000000000000110000000000000000000000000000001100000000000000000000100000000000000000000000000000000110000000000000000000001010000000000000000000000000001000000000000000010000000000000000100000000000000000000000000000010000000000000001000000000000000000100000000000100000000000000001000001000000000000000000100000000000000000001000000010100000000000000000000000000000000000000000100000100000001000000000000000000000010000000000000000000000100000000000000000000000000000000000000000000000000000000000',
            'perfluoro-3,5,7,9-tetraoxadecanoic acid': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000010000000000000000000001000001000000000000000010000000000000000000000000000000000000100000000000000001000000000000000000000000000000000000000100000000000000001000000001000000000000000000000000000000000000000000000000000000000010000000001000000010101000100100000000000000000000000000000100000010000000000010000000000000000000000000000000000000000000000000000000000000000000000',
            'perfluoro-3,5,7,9,11-pentaoxadodecanoic acid': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000010000000000000000000001000001000000000000000010000000000000000000000000000000000000100000000000000001000000000000000000000000000000000000000100000000000000001000000001000000000000000000000000000000000000000000000000000000000010000000001000000010101000100100000000000000000000000000000100000010000000000010000000000000000000000000000000000000000000000000000000000000000000000',
            '2,2,3,3-tetrafluoro-3-((1,1,1,2,3,3-hexafluoro-3-(1,2,2,2-tetrafluoroethoxy)propan-2-yl)oxy)propanoic acid': '00000000000000000000000000010000000000000000000000000000001100000000000000000000000000000000000000000000000000100010000000000000000000000010000000000000000000000000010000000000000000010000000010000000000000000000000001000000000000000001000000000001000000000000001000110000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000100100000100000000000000000000000000000010000000000010000000000000000000000000000000000000000000000000000000000000100000000',
            'h,1h,2h,2h-perfluorooctanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            '2-(perfluorooctyl)ethane-1-sulfonic acid': '00000000000000000000000000001000000000000000000000000000000100000000000001000000100000000000000000000000000000000010000000000000000000001010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000100000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000100000000100000000000100000000000000000000000010000000000000000000000100000001000000000000000000001000000000000000000000000001000',
            'perfluoropentanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'perfluoroheptanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'perfluorononanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'perfluorodecanesulfonic acid': '00000000000000000000000000010000000000000000000000000000000100000000000000000000100000000000000000000000000000000010000000000000000000010010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000100000100000100000000000000000000000010000000000000000000000100000001000000000000000000000000000000000000000000000000000',
            'hexafluoropropylene-oxide-trimer-acid': '00000000000000000000000000010000000000000000000000000000001100000000000000000000000000000000000000000000000000001110000000000000000000000010000000001000000000000000000000000000000000010000000010000000000000000000000001000000000000000001000000000001000000000010000000110000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000000100000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000001000000000000000100001000',
        }

        return bit_vector